SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/WFDB/Sp/cvsp_drop_fkeys.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/WFDB/Sp/cvsp_drop_fkeys.sp,v $ $Id: cvsp_drop_fkeys.sp,v 1.2 2015/02/11 17:56:12 chandru Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_fkeys()
--  |
--  | Description:  Stored procedure to drop table foreign key
--  |
--  |       Input:  fromTable, fromColumn, ToTable
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_fkeys <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_fkeys')
	drop procedure cvsp_drop_fkeys
IF EXISTS (select * from GxQscripts where name='cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO
print '... Creating Procedure: cvsp_drop_fkeys'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_drop_fkeys
  @fromTable varchar(40),
  @fromColumn varChar(40),
  @ToTable varchar(40)
AS
declare @fkName     varchar (255)
declare @execString nvarchar (255)
declare @errCode    int
set	@errCode = 0
IF object_id('tempdb.dbo.#ffk') is not null DROP TABLE #ffk
CREATE TABLE #ffk
(
	PKTABLE_QUALIFIER		varchar(255),
	PKTABLE_OWNER	varchar(255),
	PKTABLE_NAME	varchar(255),
	PKCOLUMN_NAME	varchar(255),
	FKTABLE_QUALIFIER	varchar(255),
	FKTABLE_OWNER	varchar(255),
	FKTABLE_NAME	varchar(255),
	FKCOLUMN_NAME	varchar(255),
	KEY_SEQ		int,
	UPDATE_RULE	int,
	DELETE_RULE	int,
	FK_NAME	varchar(255),
	PK_NAME	varchar(255),
	DEFERRABILITY	varchar(255)
)
INSERT INTO  #ffk
EXEC  sp_fkeys @fktable_name=@fromTable
DECLARE fkCursor CURSOR FOR
	select distinct  FK_NAME from #ffk
	where PKTABLE_NAME = @ToTable
	AND FKCOLUMN_NAME = @fromColumn
OPEN fkCursor
FETCH	NEXT FROM fkCursor INTO @fkName
WHILE	@@FETCH_STATUS = 0
BEGIN
		--print 'Dropping constraint [' + @fkName + '] from table [' + @fromTable + '] to table [' + @ToTable + '].'
		set @execString = 'alter table ' + @fromTable +' drop ' + @fkName
		exec sp_executesql @execString
		set @errCode = @@error
		IF @errCode <> 0
			break;
		FETCH	NEXT FROM fkCursor INTO @fkName
END
CLOSE fkCursor
DEALLOCATE fkCursor
drop table #ffk
IF @errCode <> 0
	return @errCode
ELSE
	return 0
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO

insert into GXDBVersions values(2, 'cvsp_drop_fkeys',  '00010002000000000000', 'cvsp_drop_fkeys', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/WFDB/Sp/cvsp_drop_pk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/WFDB/Sp/cvsp_drop_pk.sp,v $ $Id: cvsp_drop_pk.sp,v 1.2 2015/02/11 17:56:12 chandru Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_pk()
--  |
--  | Description:  First drop all foreign keys referenced to the primary key
--  |				of the given table then drop the primary key
--  |
--  |       Input:  tblName
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_pk <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_pk')
	drop procedure cvsp_drop_pk
IF EXISTS (select * from GxQscripts where name='cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO
print '... Creating Procedure: cvsp_drop_pk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvsp_drop_pk
  @tblName varchar(40)
AS
DECLARE	@fkTable	varchar (40)
DECLARE @keyName	varchar (255)
DECLARE @execString	nvarchar(255)
DECLARE @errCode    int
SET	@errCode = 0
DECLARE fkCursor CURSOR FOR
	SELECT	DISTINCT object_name(constid), object_name(fkeyid)
	FROM	sysforeignkeys
	WHERE	rkeyid = object_id(@tblName)
OPEN	fkCursor
FETCH	NEXT FROM fkCursor INTO @keyName, @fkTable
WHILE	@@FETCH_STATUS = 0
BEGIN
		SET	@execString = 'ALTER TABLE ' + @fkTable +' DROP CONSTRAINT ' + @keyName
		EXEC sp_executesql @execString
		SET	@errCode = @@error
		IF	@errCode <> 0
			BREAK
		FETCH NEXT FROM fkCursor INTO @keyName, @fkTable
END
CLOSE		fkCursor
DEALLOCATE	fkCursor
IF	@errCode <> 0
	return @errCode
SELECT @keyName = name FROM sysobjects WHERE parent_obj = object_id(@tblName) AND xtype = 'PK'
IF (@keyName IS NOT null)
BEGIN
	SET @execString = 'ALTER TABLE ' + @tblName +' DROP CONSTRAINT ' + @keyName
	EXEC sp_executesql @execString
END
RETURN @errCode
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO

insert into GXDBVersions values(2, 'cvsp_drop_pk',  '00010002000000000000', 'cvsp_drop_pk', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/WFDB/Sp/GetCompletionPercentage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/WFDB/Sp/GetCompletionPercentage.sp,v $ $Id: GetCompletionPercentage.sp,v 1.2 2012/04/02 07:33:34 pbuilder Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/23/2011
-- Description:	returns the percent complete for a job
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetCompletionPercentage <<<'

IF EXISTS (select * from sysobjects where name='GetCompletionPercentage')
	drop procedure GetCompletionPercentage
IF EXISTS (select * from GxQscripts where name='GetCompletionPercentage')
	delete from GxQscripts where name = 'GetCompletionPercentage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCompletionPercentage')
	delete from GXDBVersions where aliasname = 'GetCompletionPercentage'
GO
print '... Creating Procedure: GetCompletionPercentage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetCompletionPercentage
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_jobId bigint,
  @i_commCellId int
AS
  DECLARE @percentComplete float
	DECLARE @stepCount float
	DECLARE @compCount float
	Select @stepCount = COUNT(*)
	From WF_Steps
	Where DeploymentId = (SELECT DeploymentId FROM WF_Process Where jobId = @i_jobId And commCellId = @i_commCellId)
	AND WorkflowStart = 0
	Select @compCount = COUNT(Distinct StepId)
	From WF_ProcessSteps
	Where jobId = @i_jobId
	And commCellId = @i_commCellId
	And Status = 4
	AND WorkflowStart = 0
	IF (@stepCount > 0)
		SET @percentComplete = (@compCount / @stepCount)
	ELSE
		SET @percentComplete = 0
	SELECT @percentComplete
GO

IF EXISTS (select * from GxQscripts where name = 'GetCompletionPercentage')
	delete from GxQscripts where name = 'GetCompletionPercentage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCompletionPercentage')
	delete from GXDBVersions where aliasname = 'GetCompletionPercentage'
GO

insert into GXDBVersions values(2, 'GetCompletionPercentage',  '00010002000000000000', 'GetCompletionPercentage', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/WFDB/Sp/WFCleanDeployments.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/WFDB/Sp/WFCleanDeployments.sp,v $ $Id: WFCleanDeployments.sp,v 1.1 2012/03/19 23:43:29 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets workflow process
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFCleanDeployments <<<'

IF EXISTS (select * from sysobjects where name='WFCleanDeployments')
	drop procedure WFCleanDeployments
IF EXISTS (select * from GxQscripts where name='WFCleanDeployments')
	delete from GxQscripts where name = 'WFCleanDeployments'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFCleanDeployments')
	delete from GXDBVersions where aliasname = 'WFCleanDeployments'
GO
print '... Creating Procedure: WFCleanDeployments'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFCleanDeployments
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
SET NOCOUNT ON
BEGIN
DELETE d
FROM WF_Deployments d
INNER JOIN
(
SELECT WorkflowId, MAX(DeploymentId) As LatestDeployment
FROM WF_Deployments GROUP BY WorkflowId
) l ON d.WorkflowId = l.WorkflowId AND d.DeploymentId < l.LatestDeployment
WHERE d.DeploymentId not in (SELECT DeploymentId FROM WF_Process)
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFCleanDeployments')
	delete from GxQscripts where name = 'WFCleanDeployments'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFCleanDeployments')
	delete from GXDBVersions where aliasname = 'WFCleanDeployments'
GO

insert into GXDBVersions values(2, 'WFCleanDeployments',  '00010001000000000000', 'WFCleanDeployments', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/WFDB/Sp/WFGetProcessDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/WFDB/Sp/WFGetProcessDetails.sp,v $ $Id: WFGetProcessDetails.sp,v 1.6 2014/02/24 13:39:08 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets workflow process
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetProcessDetails <<<'

IF EXISTS (select * from sysobjects where name='WFGetProcessDetails')
	drop procedure WFGetProcessDetails
IF EXISTS (select * from GxQscripts where name='WFGetProcessDetails')
	delete from GxQscripts where name = 'WFGetProcessDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetProcessDetails')
	delete from GXDBVersions where aliasname = 'WFGetProcessDetails'
GO
print '... Creating Procedure: WFGetProcessDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetProcessDetails
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @jobId bigint,
  @commCellId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
SET @o_xmlText = '<Workflow_GetWorkflowExecutionResp />'
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetProcessDetails')
	delete from GxQscripts where name = 'WFGetProcessDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetProcessDetails')
	delete from GXDBVersions where aliasname = 'WFGetProcessDetails'
GO

insert into GXDBVersions values(2, 'WFGetProcessDetails',  '00010006000000000000', 'WFGetProcessDetails', '00010006000000000000')
GO

