

--  ------------  Generated from [../../../Source/CommServer/WFDB/Sp/GetCompletionPercentage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/WFDB/Sp/GetCompletionPercentage.sp,v $ $Id: GetCompletionPercentage.sp,v 1.2.200.1 2016/03/22 18:52:58 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/23/2011
-- Description:	returns the percent complete for a job
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetCompletionPercentage <<<'

IF EXISTS (select * from sysobjects where name='GetCompletionPercentage')
	drop procedure GetCompletionPercentage
IF EXISTS (select * from GxQscripts where name='GetCompletionPercentage')
	delete from GxQscripts where name = 'GetCompletionPercentage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCompletionPercentage')
	delete from GXDBVersions where aliasname = 'GetCompletionPercentage'
GO
print '... Creating Procedure: GetCompletionPercentage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetCompletionPercentage
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_jobId bigint,
  @i_commCellId int
AS
  DECLARE @percentComplete float
	DECLARE @stepCount float
	DECLARE @compCount float
	Select @stepCount = COUNT(*)
	From WF_Steps
	Where DeploymentId = (SELECT DeploymentId FROM WF_Process Where jobId = @i_jobId And commCellId = @i_commCellId)
	Select @compCount = COUNT(Distinct StepId)
	From WF_ProcessSteps
	Where jobId = @i_jobId
	And commCellId = @i_commCellId
	And Status = 4
	IF (@stepCount > 0)
		SET @percentComplete = (@compCount / @stepCount)
	ELSE
		SET @percentComplete = 0
	SELECT @percentComplete
GO

IF EXISTS (select * from GxQscripts where name = 'GetCompletionPercentage')
	delete from GxQscripts where name = 'GetCompletionPercentage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCompletionPercentage')
	delete from GXDBVersions where aliasname = 'GetCompletionPercentage'
GO

insert into GXDBVersions values(2, 'GetCompletionPercentage',  '00010002020000010000', 'GetCompletionPercentage', '00010002020000010000')
GO

