SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/WFDB/Function/GetUnixTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUnixTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUnixTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUnixTime]
  delete from GXDBVersions where name = 'GetUnixTime' and type = 5
END
GO

	CREATE FUNCTION GetUnixTime (@DateTimeArg datetime)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @dateTimeBase DATETIME
    DECLARE @unixtime int
    set @dateTimeBase = '01/01/1970'
	if (@DateTimeArg < @dateTimeBase)
	  set @unixtime = 0
	ELSE
	  set @unixtime =  datediff(second, '01/01/1970', @DateTimeArg)
	return @unixtime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUnixTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUnixTime' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetUnixTime',  '1.1', 'GetUnixTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/WFDB/Function/GetDateTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTime]
  delete from GXDBVersions where name = 'GetDateTime' and type = 5
END
GO

	CREATE FUNCTION GetDateTime (@UnixTimeArg integer)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
	 	return dateadd(second, @UnixTimeArg, '01/01/1970')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTime' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetDateTime',  '1.1', 'GetDateTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/WFDB/Function/splitStringToTable.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: splitStringToTable'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[splitStringToTable]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[splitStringToTable]
  delete from GXDBVersions where name = 'splitStringToTable' and type = 5
END
GO

	CREATE FUNCTION dbo.splitStringToTable (@StringInput VARCHAR(MAX))
	RETURNS @OutputTable TABLE (ID VARCHAR(256))
	WITH ENCRYPTION
	AS
	BEGIN
	    DECLARE @StrValue    VARCHAR(256)
	    WHILE LEN(@StringInput) > 0
	    BEGIN
	        SET @StrValue = LEFT(@StringInput, ISNULL(NULLIF(CHARINDEX(';', @StringInput) - 1, -1), LEN(@StringInput)))
	        SET @StringInput = SUBSTRING(@StringInput, ISNULL(NULLIF(CHARINDEX(';', @StringInput), 0), LEN(@StringInput)) + 1, LEN(@StringInput))
	        INSERT INTO @OutputTable (ID) VALUES (@StrValue)
	    END
	    RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [splitStringToTable]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'splitStringToTable' AND revision = '1.1')

  insert into GXDBVersions values(5, 'splitStringToTable',  '1.1', 'splitStringToTable', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/WFDB/Function/GetLocalTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLocalTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLocalTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLocalTime]
  delete from GXDBVersions where name = 'GetLocalTime' and type = 5
END
GO

	CREATE FUNCTION GetLocalTime (  @DateTimeInput DateTime )
	RETURNS DateTime
	AS
	BEGIN

	DECLARE @minuteDiff INT
	SET @minuteDiff = DATEDIFF(MI, getutcdate(), getdate())
	RETURN DateAdd(MI, @minuteDiff, @DateTimeInput)

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLocalTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLocalTime' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetLocalTime',  '1.1', 'GetLocalTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/WFDB/Function/split.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: split'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[split]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[split]
  delete from GXDBVersions where name = 'split' and type = 5
END
GO

	CREATE FUNCTION split (@RowData nvarchar(2000), @SplitBy nvarchar(5))
	RETURNS @RtnValue table
	(
		Id int identity(1,1),
		Data nvarchar(100)
	)
	WITH ENCRYPTION
	AS
	BEGIN
		Declare @Cnt int
		Set @Cnt = 1
		While (Charindex(@SplitBy,@RowData)>0)
		Begin
			Insert Into @RtnValue (data)
			Select
				Data = ltrim(rtrim(Substring(@RowData,1,Charindex(@SplitBy,@RowData)-1)))
			Set @RowData = Substring(@RowData,Charindex(@SplitBy,@RowData)+1,len(@RowData))
			Set @Cnt = @Cnt + 1
		End
		Insert Into @RtnValue (data)
		Select Data = ltrim(rtrim(@RowData))
		Return
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [split]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'split' AND revision = '1.1')

  insert into GXDBVersions values(5, 'split',  '1.1', 'split', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/WFDB/Function/fnContextPath.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fnContextPath'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fnContextPath]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fnContextPath]
  delete from GXDBVersions where name = 'fnContextPath' and type = 5
END
GO

	CREATE FUNCTION fnContextPath (@ContextId int)
	RETURNS @ThreadPath table
	(
		ContextId int
	)
	WITH ENCRYPTION
	AS
	BEGIN
	WITH ctx(ContextId, ParentId) AS
	(
		SELECT c.ContextId, c.ParentId
		FROM WF_Context c
		WHERE c.ContextId = @ContextId
		UNION ALL
		SELECT c.ContextId, c.ParentId
		FROM WF_Context c
		INNER JOIN ctx t ON c.ContextId = t.ParentId
	)
	INSERT INTO @ThreadPath SELECT ContextId FROM ctx
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fnContextPath]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fnContextPath' AND revision = '1.2')

  insert into GXDBVersions values(5, 'fnContextPath',  '1.2', 'fnContextPath', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
