SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
	DECLARE @FuncNameCursorFlag 	INTEGER
	SET 		@FuncNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 		@errorCode	= 0
	
	DECLARE	@FuncName		nvarchar(256)
		
	DECLARE	FuncNameListCursor CURSOR STATIC FOR
	SELECT DISTINCT name
	FROM sysobjects
	WHERE	xtype IN ('FN', 'TF', 'FS', 'FT')
		AND OBJECTPROPERTY(id, N'IsInlineFunction') = 0
		AND name NOT LIKE '%_CUSTOMOBJ'
		
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@FuncNameCursorFlag = 1
	OPEN	FuncNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM FuncNameListCursor
	INTO @FuncName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all functions
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		print '>>> Drop Function: ' + @FuncName + ' <<<'
					
		IF EXISTS (select * from sysobjects where name = @FuncName and OBJECTPROPERTY(id, N'IsInlineFunction') = 0)
			EXEC ('DROP FUNCTION [' + @FuncName + ']')

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
					
		IF EXISTS (select * from GXDBVersions where aliasname = @FuncName AND type = 5)
			DELETE FROM GXDBVersions WHERE aliasname = @FuncName AND type = 5
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM FuncNameListCursor
		INTO @FuncName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @FuncNameCursorFlag = 1
	BEGIN
			CLOSE				FuncNameListCursor
			DEALLOCATE	FuncNameListCursor
	END
END	

RETURN
GO
