

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/QS_GetQscriptInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/QS_GetQscriptInfo.sp,v $ $Id: QS_GetQscriptInfo.sp,v 1.1.2.2 2018/03/15 23:34:54 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetQscriptInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetQscriptInfo')
	drop procedure QS_GetQscriptInfo
IF EXISTS (select * from GxQscripts where name='QS_GetQscriptInfo')
	delete from GxQscripts where name = 'QS_GetQscriptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptInfo')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptInfo'
GO
print '... Creating Procedure: QS_GetQscriptInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetQscriptInfo
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_name varchar(1024)=''
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @tblQscriptList TABLE
	(
		QscriptName varchar(64),
		AuditLevel	int,
		TimeCreated	datetime,
		TimeExpires	datetime
	)
	INSERT INTO @tblQscriptList
	SELECT name, auditLevel, timeCreated, timeExpires
	FROM GxQscripts
	WHERE  name not like '%_CVupdate_%'
	AND   ( @i_name = '' OR
			name like @i_name OR
			name like 'QS_' + @i_name )
	IF @@ROWCOUNT = 0
	BEGIN
		SET @localErrorMsg = 'Error: Qscript not found!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	SELECT * FROM @tblQscriptList
	ORDER BY QscriptName, TimeCreated desc
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetQscriptInfo')
	delete from GxQscripts where name = 'QS_GetQscriptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptInfo')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptInfo'
GO

insert into GXDBVersions values(2, 'QS_GetQscriptInfo',  '00010001000200020000', 'QS_GetQscriptInfo', '00010001000200020000')
GO

insert into GxQscripts values(2,'QS_GetQscriptInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn getQscriptInfo -si @i_name=''script_name''
'
 + CHAR(10) + '	qoperation execscript -sn getQscriptInfo -si ''script_name''
'
 + CHAR(10) + '-- 	script_name: Full script name or name with wild card ''%''. If no name is inputed, then all scripts will be returned.'
)
GO

