

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/MMPerformanceHistoryUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/MMPerformanceHistoryUpdate.sp,v $ $Id: MMPerformanceHistoryUpdate.sp,v 1.1.2.3 2018/11/09 23:31:06 dnavaneethan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMPerformanceHistoryUpdate')
BEGIN
	print '>>> Drop Stored Procedure: MMPerformanceHistoryUpdate <<<'
	drop procedure MMPerformanceHistoryUpdate
END
IF EXISTS (select * from GxQscripts where name='MMPerformanceHistoryUpdate')
	delete from GxQscripts where name = 'MMPerformanceHistoryUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPerformanceHistoryUpdate')
	delete from GXDBVersions where aliasname = 'MMPerformanceHistoryUpdate'
GO
print '... Creating Procedure: MMPerformanceHistoryUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMPerformanceHistoryUpdate
  @i_ClientId INT,
  @i_PerfLogName NVARCHAR(2048)
AS
  DECLARE @o_errorXML XML;
DECLARE @o_errorCode		INTEGER;
DECLARE @o_errorString		nvarchar(512);
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#mmperfhistory') is not null drop table #mmperfhistory
CREATE TABLE #mmperfhistory
(
	creationDate datetime,
	creationTime datetime,
	cpuUsage  float,
	physicalMemoryKB integer,
	percentFreePhysicalMemory integer,
	virtualMemoryKB integer,
	percentFreeVirtualMemory integer,
	events  integer,
	mutexes  integer,
	processes integer,
	semaphores integer,
	threads  integer
)
DECLARE @intervalDays INT = 90
SELECT @intervalDays = CONVERT(INT, CONVERT(NVARCHAR(100), value)) FROM CommServ..GXGlobalParam WHERE name = 'MMPerfHistoryUpdateIntervalDays'
SELECT @o_errorCode = 0
DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #mmperfhistory FROM ''' + @i_PerfLogName + ''' WITH ( FIRSTROW = 2, FIELDTERMINATOR = '','', ROWTERMINATOR = ''\n'' )';
BEGIN TRY
	EXEC(@sql);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = @@ERROR
	SET @o_errorString = 'Failed to update performance history information in MMPerformanceHistory'
END CATCH
IF @o_errorCode = 0
BEGIN
	DECLARE @lastUpdateTime DATETIME
	SELECT @lastUpdateTime = MAX(creationDate) FROM MMPerformanceHistory WHERE clientId = @i_ClientId
	--Discard values older than MMPerfHistoryUpdateIntervalDays and those that are already saved
	DELETE FROM #mmperfhistory
	WHERE creationDate < CAST((DATEADD(DD, -@intervalDays, GETDATE())) AS DATE)
		OR (creationDate + creationTime) <= @lastUpdateTime
	INSERT INTO MMPerformanceHistory (
		clientId,
		creationDate,
		cpuUsage,
		physicalMemoryKB,
		percentFreePhysicalMemory,
		virtualMemoryKB,
		percentFreeVirtualMemory,
		events,
		mutexes,
		processes,
		semaphores,
		threads)
	SELECT
		@i_ClientId,
		creationDate+creationTime,
		cpuUsage,
		physicalMemoryKB,
		percentFreePhysicalMemory,
		virtualMemoryKB,
		percentFreeVirtualMemory,
		events,
		mutexes,
		processes,
		semaphores,
		threads
	FROM #mmperfhistory
	SET @o_errorString = 'Successfully updated performance history information in MMPerformanceHistory'
END
IF OBJECT_ID('tempdb.dbo.#mmperfhistory') is not null drop table #mmperfhistory
--Prune anything older than MMPerfHistoryUpdateIntervalDays
DELETE FROM MMPerformanceHistory WHERE creationDate < CAST((DATEADD(DD, -@intervalDays, GETDATE())) AS DATE)
SET @o_errorXML = (SELECT  @o_errorCode AS '@errorCode', @o_errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
SELECT @o_errorXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMPerformanceHistoryUpdate')
	delete from GxQscripts where name = 'MMPerformanceHistoryUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPerformanceHistoryUpdate')
	delete from GXDBVersions where aliasname = 'MMPerformanceHistoryUpdate'
GO

insert into GXDBVersions values(2, 'MMPerformanceHistoryUpdate',  '00010001000200030000', 'MMPerformanceHistoryUpdate', '00010001000200030000')
GO

