

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/Lic_CUR_GetLicenseUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Abhinaw Kumar
--	Date:   10/22/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/Lic_CUR_GetLicenseUsage.sp,v $ $Id: Lic_CUR_GetLicenseUsage.sp,v 1.1.4.5 2019/03/30 13:33:32 lgeorge Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Lic_CUR_GetLicenseUsage')
BEGIN
	print '>>> Drop Stored Procedure: Lic_CUR_GetLicenseUsage <<<'
	drop procedure Lic_CUR_GetLicenseUsage
END
IF EXISTS (select * from GxQscripts where name='Lic_CUR_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CUR_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CUR_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CUR_GetLicenseUsage'
GO
print '... Creating Procedure: Lic_CUR_GetLicenseUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Lic_CUR_GetLicenseUsage
  @option INT, 	
  @i_userId INT,
  @GUID VARCHAR(100) = NULL,
  @capacityType INT = NULL,
  @timezone VARCHAR(20) = '00:00'
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @userHasRights INT = 0
	EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '1,2', @userHasRights OUTPUT, 1, 2
	IF @userHasRights = 0
		RETURN
	DECLARE @orgGUID UNIQUEIDENTIFIER = TRY_CAST(@GUID AS UNIQUEIDENTIFIER)
	IF @option = 1  -- Get License Summary Usage for Capacity
	BEGIN
		DECLARE @commvaultComplete INT = 0, @completeUsed BIGINT = 0
		IF EXISTS (SELECT 1 FROM Lic_LicenseInfo WITH(NOLOCK) WHERE lictype=205) AND EXISTS (SELECT 1 FROM Lic_LicenseInfo LiB INNER JOIN Lic_LicenseInfo LiA ON LiA.LicType=100004 AND LiB.PermTotal=LiA.PermTotal AND LiB.EvalTotal=LiA.EvalTotal AND LiB.TermDate=LiA.TermDate WHERE LiB.LicType=100002)
		BEGIN
			SET @commvaultComplete=1
			SELECT @completeUsed=SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage ELSE 0 END) FROM Lic_CUR_UsageSummary_vw WHERE LicUsageType IN (100002,100004)
		END
		SELECT CASE WHEN @commvaultComplete=1 AND LicUsageType=100002 THEN 'Commvault Complete' ELSE LicUsageTypeName END AS Dial, Purchased, PermTotal, EvalTotal AS Eval,
		CASE WHEN @commvaultComplete=1 AND LicUsageType=100002 THEN @completeUsed/(1024.00*1024.00) ELSE SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) /(1024.00*1024.00) END AS Usage
		, ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) as TermDate,
		CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) As EvalExpiryDate
		FROM Lic_CUR_UsageSummary_vw
		WHERE (@commvaultComplete=1 AND LicUsageType IN (100002,100005,100006)) OR (@commvaultComplete=0 AND LicUsageType IN (100002,100004,100005,100006)) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100002 THEN 1 WHEN LicUsageType = 100005 THEN 2 WHEN LicUsageType = 100006 THEN 3  WHEN LicUsageType = 100004 THEN 4 END
	END
	ELSE IF @option = 2 -- Get License Usage for Backup, Snapshot, Replication and Archive
	BEGIN
		IF @capacityType = 0
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
			FROM Lic_CUR_Backups_InCapacity_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
		ELSE IF @capacityType = 1
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
			FROM Lic_CUR_Archives_InCapacity_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
		ELSE IF @capacityType = 2
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
			FROM Lic_CUR_Snapshots_InCapacity_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
		ELSE IF @capacityType = 3
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
			FROM Lic_CUR_Replications_InCapacity_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
		ELSE IF @capacityType = 4
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
			FROM Lic_CUR_Backups_InCapacity_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
			UNION
			SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
			AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
			SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
			InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
			BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
			FROM Lic_CUR_Archives_InCapacity_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 3 -- Get License Summary Usage for Virtualization
	BEGIN
		DECLARE @VSAUsage TABLE(LicUsageType INT, Dial VARCHAR(100), Purchased INT, PermTotal INT,
								Eval INT, Usage INT,  TermDate DATETIME, EvalExpiryDate VARCHAR(12), InputMsg INT)
		DECLARE @VMSocketsPurchased INT = 0
		DECLARE @ProtectedVMsPurchased INT = 0
		INSERT INTO @VSAUsage
		SELECT LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
		SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) Usage,
		ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
		CONVERT(VARCHAR(12),ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) , 106) As EvalExpiryDate, 0 AS InputMsg
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100018,100019,100027,100021)-- AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100018 THEN 1 WHEN LicUsageType = 100019 THEN 2 WHEN LicUsageType = 100027 THEN 3  WHEN LicUsageType = 100021 THEN 4 END
		SELECT @VMSocketsPurchased = Purchased FROM @VSAUsage WHERE LicUsageType = 100018
		SELECT @ProtectedVMsPurchased = Purchased FROM @VSAUsage WHERE LicUsageType = 100019
		IF @VMSocketsPurchased=0 AND @ProtectedVMsPurchased=0 --(0=not purchased, -1=unlimited purchased, >0=finite quantity purchased)
		BEGIN
			UPDATE @VSAUsage SET InputMsg = 1 WHERE LicUsageType = 100018 --		inputMsg=1;
			UPDATE @VSAUsage SET InputMsg = 1 WHERE LicUsageType = 100019 --		inputMsg=1;
		END
		ELSE
		BEGIN
			IF @VMSocketsPurchased=0
				UPDATE @VSAUsage SET InputMsg = 2 WHERE LicUsageType = 100018 --	inputMsg=2;
			ELSE IF @ProtectedVMsPurchased=0
				UPDATE @VSAUsage SET InputMsg = 2 WHERE LicUsageType = 100019 --	inputMsg=2;
		END
		SELECT * FROM @VSAUsage
	END
	ELSE IF @option = 4 -- Get License Summary Usage for End point
	BEGIN
		SELECT	LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) Usage,
				ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
				CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) As EvalExpiryDate
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100024,100025,100026, 100028) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		ORDER BY CASE WHEN LicUsageType = 100024 THEN 1 WHEN LicUsageType = 100025 THEN 2 WHEN LicUsageType = 100026 THEN 3  WHEN LicUsageType = 100028 THEN 4 END
	END
	ELSE IF @option = 6 -- Get License Summary Usage for other licenses
	BEGIN
		DECLARE @summaryTbl TABLE(LicUsageType INT, Dial NVARCHAR(50), Purchased BIGINT, PermTotal BIGINT, Eval BIGINT, Usage BIGINT, TermDate DATETIME, EvalExpiryDate VARCHAR(12))
		INSERT @summaryTbl
		SELECT LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage  ELSE 0 END) Usage,
				ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')) AS TermDate,
				CONVERT(VARCHAR(12), ISNULL(TermDate, CONVERT(DATETIME, '1970-01-01 00:00:00.000')), 106) AS EvalExpiryDate
		FROM Lic_CUR_usageSummary_vw
		WHERE LicUsageType IN (100029, 200017, 200002, 100030, 200001, 200003, 200016) --AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		INSERT @summaryTbl
		SELECT -1, 'Physical Instances', 0, 0, 0, ISNULL(SUM(Usage),0), '1970-01-01 00:00:00.000', CONVERT(VARCHAR(12), CONVERT(DATETIME, '1970-01-01 00:00:00.000'), 106)
		FROM @summaryTbl WHERE LicUsageType IN (100030, 100029)
		UNION
		SELECT -2, 'Virtual Instances', 0, 0, 0, ISNULL(SUM(Usage),0), '1970-01-01 00:00:00.000', CONVERT(VARCHAR(12), CONVERT(DATETIME, '1970-01-01 00:00:00.000'), 106)
		FROM @summaryTbl WHERE LicUsageType IN (200003, 200017, 200001)
		SELECT * FROM @summaryTbl
		ORDER BY CASE WHEN LicUsageType = 100030 THEN 1 WHEN LicUsageType = 100029 THEN 2 WHEN LicUsageType = -1 THEN 3
		WHEN LicUsageType = 200003 THEN 4 WHEN LicUsageType = 200017 THEN 5 WHEN LicUsageType = 200001 THEN 6 WHEN LicUsageType = -2 THEN 7
		WHEN LicUsageType = 200002 THEN 8 WHEN LicUsageType = 200016 THEN 9 END
	END
	ELSE IF @option = 7 -- Get License Usage for VM Sockets
	BEGIN
		SELECT HypervisorHost AS "Hypervisor Host", Sockets, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_VMSockets_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 8 -- Get License Usage for VM Sockets, Protected VMs Excluded from Capacity
	BEGIN
		--no need to show VSA exclusions if corresponding license is not purchased
		DECLARE @vmSockFlag INT = 0, @protVmFlag INT = 0
		SELECT @vmSockFlag=ISNULL(Purchased,0) FROM Lic_CUR_UsageSummary_vw WHERE LicUsageType=100018
		SELECT @protVmFlag=ISNULL(Purchased,0) FROM Lic_CUR_UsageSummary_vw WHERE LicUsageType=100019
		--capacityType variable will be reused for getting input here
		IF @capacityType=0--call is coming from VM socket details page. Hence show VSA details only if VMSockets license is purchased
		BEGIN
			IF @vmSockFlag<>-1 AND @vmSockFlag<=0
				RETURN
		END
		ELSE IF @capacityType=1--call is coming from protected VM details page. Hence show VSA details only if ProtectedVM license is purchased
		BEGIN
			IF @protVmFlag<>-1 AND @protVmFlag<=0
				RETURN
		END
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_VSAJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 9 -- Get License Usage for Protected VMs
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_ProtectedVMs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 10  -- Get License Summary Usage for Other Licenses
	BEGIN
		SELECT LicUsageType, LicUsageTypeName As Dial, Purchased, ISNULL(PermTotal, 0) AS PermTotal, ISNULL(EvalTotal, 0)  AS Eval,
				 ROUND(CASE WHEN LicUsageType = 100017 THEN SUM(Usage)/(1000.00*1000.00) ELSE SUM(Usage)/(1024.00*1024.00) END, 2) AS Usage,
				 TermDate, CASE WHEN TermDate =  CONVERT(DATE, '01-01-1970') THEN 'N/A' ELSE CONVERT(VARCHAR(12), TermDate, 106) END As EvalExpiryDate,
				 OrgGUID "Organization ID", Organization
		FROM Lic_CUR_usageSummary_vw where LicUsageType IN (100015,100016,100017,100031)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal, OrgGUID, Organization
		ORDER BY CASE WHEN LicUsageType = 100031 THEN 1 WHEN LicUsageType = 100016 THEN 2 WHEN LicUsageType = 100015 THEN 3  WHEN LicUsageType = 200001 THEN 4 WHEN LicUsageType = 100017 THEN 5 END
	END
	ELSE IF @option = 11 -- Get License Usage for ACV Licenses
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", Package, isVMProtected "Is VM Protected", VMProtectionJob "VM Protection Job",
			ProtectedVMSize "Protected VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_ACVs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 12 -- Get License Usage for ACVs excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_ACVJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 13 -- Get License Usage for Archived VMs
	BEGIN
		SELECT  VMId	"VM ID", VMName "Virtual Machine", VMArchiveJob "VM Archived Job",
			ArchivedVMSize "Archived VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_ArchivedVMs_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 14 -- Get License Usage for Archived VMs excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_ArchviedVMJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 15 -- Get License Usage for End point Users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_EpUsers_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 16 -- Get License Usage for DLP excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_DLPJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 17 -- Get License Usage for Endpoint Sharing users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_EpSharingUsers_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 19 -- Get License Usage for EDiscovery USers
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_EpEDiscoveryUsers_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 21 -- Get License Usage for File Systems Only Server without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan", LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License
		FROM Lic_CUR_FSonlyServersWithoutUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 22  -- Get License Usage for File System Only servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ActualLicType "Actual License ID", CASE WHEN ActualLicType < 1 THEN 'N/A' ELSE ActualLicName END "Actual License",
				ClientId "Client ID", ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_FSonlyServersWithUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 23  -- Get License Usage for DL Only with Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_DLOsWithoutUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 24   -- Get License Usage for DL Only without Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_DLOsWithUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 25  -- Get License Usage for Application Servers without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_AppServersWithoutUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 26 -- Get License Usage for Application Servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_AppServersWithUsage_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 27  -- Get License Usage for VM Only
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_VMOnly_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 28  -- Get License Usage for Advanced VMs
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", Package, VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_VMWithApps_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 29 -- Get License Usage for Application Users
	BEGIN
		DECLARE @enablerTable TABLE (SMTP NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, enabler INT)
		INSERT INTO @enablerTable
		SELECT DISTINCT Smtp, OrgGUID, ISNULL(SUM(DISTINCT p),0)
		FROM Lic_CUR_ApplicationUsers_vw Usage
		OUTER APPLY
		(SELECT p FROM
			(SELECT POWER(2,n) FROM
				(VALUES (0),(1),(2)) Nos(n)
			)Powers(p)
			WHERE p&Usage.VMFlag = p
		)Bitmask
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
		GROUP BY Smtp,OrgGUID
		SELECT Smtp AS SMTP, OrgGUID "Organization ID", Organization, "Plan", CASE WHEN [Exchange Mailbox] > 0 THEN 1 ELSE 0 END "Exchange Mailbox",
		CASE WHEN [Exchange OnePass] > 0 THEN 1 ELSE 0 END "Exchange OnePass", CASE WHEN [SharePoint Online] > 0 THEN 1 ELSE 0 END "SharePoint Online",
		CASE WHEN [Gmail] > 0 THEN 1 ELSE 0 END "Gmail", CASE WHEN [GDrive] > 0 THEN 1 ELSE 0 END "GDrive", CASE WHEN [OneDrive] > 0 THEN 1 ELSE 0 END "OneDrive",
		CASE WHEN [Salesforce] > 0 THEN 1 ELSE 0 END "Salesforce", CASE WHEN [Notes] > 0 THEN 1 ELSE 0 END "Notes",
		CASE WHEN Checker&1>0 THEN 1 ELSE 0 END AS 'CI Enabled', CASE WHEN Checker&2>0 THEN 1 ELSE 0 END AS 'CM Enabled', CASE WHEN Checker&4>0 THEN 1 ELSE 0 END AS 'CS Enabled'
		FROM (
			SELECT Usage.Smtp, Usage.OrgGUID, Organization, PlanName AS "Plan", LicName, E.enabler AS Checker
			FROM Lic_CUR_ApplicationUsers_vw Usage
			LEFT JOIN
			@enablerTable E ON Usage.Smtp = E.SMTP AND (Usage.OrgGUID = E.OrgGUID OR (Usage.OrgGUID IS NULL and E.OrgGUID IS NULL))
			WHERE @orgGUID IS NULL OR Usage.OrgGUID = @orgGUID
		) AS SourceTable
		PIVOT
		(
			COUNT(LicName)
			FOR LicName IN ([Exchange Mailbox],[Exchange OnePass],[SharePoint Online],[Gmail],[GDrive],[OneDrive],[Salesforce],[Notes])
		) AS PivotTable
	END
	ELSE IF @option = 30 -- Get License Usage for Application Users not in Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_AppUserJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 31 -- Get License Usage for Edge drive excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CUR_EdgeDriveJobs_NotInCapacity_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
	ELSE IF @option = 32  -- Get License Usage for Agent and Features Licenses
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, PermTotal "Permanent Total", PermUsed "Permanent Used", EvalTotal "Evaluation Total",
				EvalUsed "Evaluation Used", CASE WHEN TermDate =  CONVERT(DATE, '01-01-1970') THEN NULL ELSE TermDate END "Term End Date",
				ClientId "Client ID", ClientName "Client", AppTypeId "Agent ID", CASE WHEN AppTypeId<=0 THEN '' ELSE ApptypeName END "Agent",
				CASE WHEN InstallDate = CONVERT(DATE, '01-01-1970') THEN NULL ELSE InstallDate END "Install Date"
		FROM Lic_CUR_AgentfeatureLicenses_vw
	END
	ELSE IF @option = 33  -- Get Organization name and GUID
	BEGIN
		SELECT '-1' AS OrgGUID, 'All' AS Organization, 0 AS RowID
		UNION ALL
		SELECT OrgGUID, Organization,  ROW_NUMBER() OVER(ORDER BY Organization) AS RowID FROM
		(SELECT DISTINCT CONVERT(VARCHAR(100),OrgGUID) OrgGUID, Organization FROM Lic_CurrentUsage WITH(NOLOCK) WHERE OrgGUID IS NOT NULL)T
		ORDER BY RowID
	END
	ELSE IF @option = 34 -- Get Last Collection Timestamp
	BEGIN
		DECLARE @expiry DATETIME = '1970-01-01 00:00:00.000'
		SELECT TOP 1 @expiry=ExpiryDate FROM Lic_CUR_AgentfeatureLicenses_vw
		SELECT CONVERT(DATETIME, SWITCHOFFSET(CONVERT(DATETIMEOFFSET, commserv.dbo.GetDateTimeBig(value)), @timezone)) 'Last Collection Time'
		, CASE WHEN @expiry=CONVERT(DATE, '01-01-1970') THEN 'N/A' ELSE FORMAT(@expiry, 'MMM dd, yyyy') END AS 'License Expiry'
		FROM commserv.dbo.GXGlobalParam WITH(NOLOCK) WHERE name='LicCurrentUsageCollectionTime'
	END
	ELSE IF @option = 35 -- Get License Summary for File Systems Only Servers & VMs
	BEGIN
		DECLARE @fsonlyTbl TABLE(LicType INT, LicName VARCHAR(32), Used INT)
		INSERT INTO @fsonlyTbl VALUES (100029, 'File System only Server',0), (200017, 'File System only VM',0)
		UPDATE T SET T.Used=F.Used
		FROM @fsonlyTbl T
		INNER JOIN
		(
			SELECT LicType, COUNT(DISTINCT ClientId) Used
			FROM Lic_CUR_FSonlyServers_vw
			WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
			GROUP BY LicType
		)F ON F.LicType=T.LicType
		SELECT LicType "License ID", LicName "License", Used FROM @fsonlyTbl
	END
	ELSE IF @option = 36 -- Get Live Sync pairs for VMs
	BEGIN
		SELECT SourceClientId "Source ID", SourceClientName "Source Name", SourceGUID "Source GUID", DestinationName "Destination Name",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CUR_LiveSyncForVM_vw
		WHERE @orgGUID IS NULL OR OrgGUID = @orgGUID
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'Lic_CUR_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CUR_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CUR_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CUR_GetLicenseUsage'
GO

insert into GXDBVersions values(2, 'Lic_CUR_GetLicenseUsage',  '00010001000400050000', 'Lic_CUR_GetLicenseUsage', '00010001000400050000')
GO

