

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/AUTOAddStaticList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: spakhare
--	Date:   11/08/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/AUTOAddStaticList.sp,v $ $Id: AUTOAddStaticList.sp,v 1.1.2.5 2020/04/22 06:28:14 spakhare Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AUTOAddStaticList')
BEGIN
	print '>>> Drop Stored Procedure: AUTOAddStaticList <<<'
	drop procedure AUTOAddStaticList
END
IF EXISTS (select * from GxQscripts where name='AUTOAddStaticList')
	delete from GxQscripts where name = 'AUTOAddStaticList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AUTOAddStaticList')
	delete from GXDBVersions where aliasname = 'AUTOAddStaticList'
GO
print '... Creating Procedure: AUTOAddStaticList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AUTOAddStaticList
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_FileName nvarchar(max)
-----------------------------------------------------------
AS
SET NOCOUNT ON
--DECLARE @i_FileName		nvarchar(max)
DECLARE @errorCode INTEGER = 0
BEGIN TRY
	BEGIN TRANSACTION
	IF OBJECT_ID('tempdb.dbo.#AutomationDB') IS NOT NULL
		DROP TABLE #AutomationDB
	CREATE TABLE #AutomationDB (XmlCol XML)
	DECLARE @SQLString nvarchar(max) = N'INSERT INTO #AutomationDB(XmlCol) SELECT * FROM OPENROWSET ( BULK ''' + @i_FileName + ''', SINGLE_BLOB ) AS xmlData';
	EXECUTE CommServ.dbo.SQLAdminUtilExecQuery @SQLString,  1
	DECLARE @xml XML
	SET @xml = (SELECT XmlCol FROM #AutomationDB)
	-- Add newly included properties to AUTO_AddProp
	INSERT INTO AUTO_AddProp(AddPropID, AddPropName)
	SELECT n.value('AddPropID[1]', 'INTEGER') AS AddPropId, n.value('AddPropName[1]', 'nvarchar(256)') AS AddPropName
	FROM @xml.nodes('/AutomationDatabase/AddProp/entity') r(n)
	LEFT OUTER JOIN AUTO_AddProp ap ON ap.AddPropID = n.value('AddPropID[1]', 'INTEGER')
	WHERE ap.AddPropID IS NULL
	-- Add newly included features to AUTO_Feature
	INSERT INTO AUTO_Feature(FeatureID, DisplayName, DocLink)
	SELECT DISTINCT n.value('FeatureID[1]', 'INTEGER') AS FeatureID, n.value('DisplayName[1]', 'nvarchar(512)') AS DisplayName, n.value('DocLink[1]', 'nvarchar(MAX)') AS DocLink
	FROM @xml.nodes('/AutomationDatabase/Feature/entity') r(n)
	LEFT OUTER JOIN AUTO_Feature f ON f.FeatureID = n.value('FeatureID[1]', 'INTEGER')
	WHERE f.FeatureID IS NULL
	-- Add newly included mappings to AUTO_FeatureAppTypeMap
	INSERT INTO AUTO_FeatureAppTypeMap(MappingID, FeatureID, AppTypeID)
	SELECT n.value('MappingID[1]', 'int') AS MappingID, n.value('FeatureID[1]', 'int') AS FeatureID, n.value('AppTypeID[1]', 'int') AS AppTypeID
	FROM @xml.nodes('/AutomationDatabase/FeatureAppTypeMap/entity') r(n)
	LEFT OUTER JOIN AUTO_FeatureAppTypeMap fm ON fm.FeatureID = n.value('FeatureID[1]', 'int')
	AND fm.AppTypeID = n.value('AppTypeID[1]', 'int')
	WHERE fm.AppTypeID IS NULL OR fm.FeatureID IS NULL
	-- Add newly included instance types to AUTO_InstanceType
	INSERT INTO AUTO_InstanceType(iDAInstanceID, iDAInstanceName, iDAInstanceCategory, iDAInstanceValue)
	SELECT DISTINCT n.value('iDAInstanceID[1]', 'int') AS iDAInstanceID, n.value('iDAInstanceName[1]', 'nvarchar(256)') AS iDAInstanceName,
	n.value('iDAInstanceCategory[1]', 'nvarchar(256)') AS iDAInstanceCategory, n.value('iDAInstanceValue[1]', 'nvarchar(256)') AS iDAInstanceValue
	FROM @xml.nodes('/AutomationDatabase/InstanceType/entity') r(n)
	LEFT OUTER JOIN AUTO_InstanceType i ON i.iDAInstanceID = n.value('iDAInstanceID[1]', 'INT')
	WHERE i.iDAInstanceID IS NULL
	-- Add newly included testcases to AUTO_Testcase
	INSERT INTO AUTO_Testcase(TestcaseID, TestcaseName, Flag)
	SELECT DISTINCT n.value('TestcaseID[1]', 'int') AS TestcaseID, n.value('TestcaseName[1]', 'nvarchar(2048)') AS TestcaseName,
	n.value('Flag[1]', 'int') AS Flag
	FROM @xml.nodes('/AutomationDatabase/Testcase/entity') r(n)
	LEFT OUTER JOIN AUTO_Testcase t ON t.TestcaseID = n.value('TestcaseID[1]', 'INT')
	WHERE t.TestcaseID IS NULL
	-- Add newly included application versions to AUTO_AppVersion
	INSERT INTO AUTO_AppVersion(AppVersionID, AppVersionName)
	SELECT DISTINCT n.value('AppVersionID[1]', 'int') AS AppVersionID, n.value('AppVersionName[1]', 'nvarchar(256)') AS AppVersionName
	FROM @xml.nodes('/AutomationDatabase/AppVersion/entity') r(n)
	LEFT OUTER JOIN AUTO_AppVersion app ON app.AppVersionID = n.value('AppVersionID[1]', 'int')
	WHERE app.AppVersionID IS NULL
	-- Add newly included os to AUTO_TestsetOS
	INSERT INTO AUTO_TestsetOS(OSID, OSName)
	SELECT DISTINCT n.value('OSID[1]', 'int') AS OSID, n.value('OSName[1]', 'nvarchar(256)') AS OSName
	FROM @xml.nodes('/AutomationDatabase/TestsetOS/entity') r(n)
	LEFT OUTER JOIN AUTO_TestsetOS os ON os.OSID = n.value('OSID[1]', 'int')
	WHERE os.OSID IS NULL
	-- Add newly included to AUTO_Testset
	INSERT INTO AUTO_Testset(TestsetID, FeatureID, OSID, AddPropID, AppVersionID, DisplayName, Active)
	SELECT DISTINCT n.value('TestsetID[1]', 'int') AS TestsetID, n.value('FeatureID[1]', 'int') AS FeatureID,
	n.value('OSID[1]', 'int') AS OSID, n.value('AddPropID[1]', 'int') AS AddPropID, n.value('AppVersionID[1]', 'int') AS AppVersionID,
	n.value('DisplayName[1]', 'nvarchar(512)') AS DisplayName, n.value('Active[1]', 'int') AS Active
	FROM @xml.nodes('/AutomationDatabase/Testset/entity') r(n)
	LEFT OUTER JOIN AUTO_Testset ts ON ts.TestsetID = n.value('TestsetID[1]', 'int')
	WHERE ts.TestsetID IS NULL
	--Add newly including mappings to AUTO_SimOsTsMap
	INSERT INTO AUTO_SimOsTsMap(SimOSID, OSID)
	SELECT n.value('SimOSID[1]', 'int') AS SimOSID, n.value('OSID[1]', 'int') AS OSID
	FROM @xml.nodes('/AutomationDatabase/SimOsTsMap/entity') r(n)
	LEFT OUTER JOIN AUTO_SimOsTsMap sim ON sim.SimOSID = OSID
	WHERE sim.SimOSID IS NULL
	-- Remove old and add newly included mappings to AUTO_TestsetSPMap
	UPDATE tsm
	SET ReleaseString = T.ReleaseString
	FROM AUTO_TestsetSPMap tsm
	INNER JOIN (
		SELECT n.value('TestsetID[1]', 'int') AS TestsetID, n.value('ReleaseString[1]', 'nvarchar(256)') AS ReleaseString
		FROM @xml.nodes('/AutomationDatabase/TestsetSPMap/entity') r(n)
		INNER JOIN AUTO_TestsetSPMap tsm ON tsm.TestsetID = n.value('TestsetID[1]', 'int')
		AND tsm.ReleaseString <> n.value('ReleaseString[1]', 'nvarchar(256)')
	) T ON T.TestsetID = tsm.TestsetID
	UPDATE m
	SET m.ReleaseString = 'NA'
	FROM
	AUTO_TestsetSPMap m
	LEFT OUTER JOIN (
		SELECT n.value('TestsetID[1]', 'int') AS TestsetID, n.value('ReleaseString[1]', 'nvarchar(256)') AS ReleaseString
		FROM @xml.nodes('/AutomationDatabase/TestsetSPMap/entity') r(n)
		INNER JOIN AUTO_TestsetSPMap tsm ON tsm.TestsetID = n.value('TestsetID[1]', 'int')
		AND tsm.ReleaseString = n.value('ReleaseString[1]', 'nvarchar(256)')
	) T ON T.TestsetID = m.TestsetID AND T.ReleaseString = m.ReleaseString AND m.ReleaseString <> 'NA'
	WHERE T.TestsetID IS NULL OR T.ReleaseString IS NULL
	INSERT INTO AUTO_TestsetSPMap(TestsetID, ReleaseString)
	SELECT n.value('TestsetID[1]', 'int') AS TestsetID, n.value('ReleaseString[1]', 'nvarchar(256)') AS ReleaseString
	FROM @xml.nodes('/AutomationDatabase/TestsetSPMap/entity') r(n)
	LEFT OUTER JOIN AUTO_TestsetSPMap tsm ON tsm.TestsetID = n.value('TestsetID[1]', 'int')
	WHERE tsm.TestsetID IS NULL
	-- Remove old and add newly included mappings to AUTO_TcTsMap
	UPDATE m
	SET m.Flag = 2
	FROM AUTO_TcTsMap m
	LEFT OUTER JOIN (
		SELECT n.value('TcTsInstanceID[1]', 'int') AS TcTsInstanceID
		FROM @xml.nodes('/AutomationDatabase/TcTsMap/entity') r(n)
	) T ON T.TcTsInstanceID = m.TcTsInstanceID AND m.Flag <> 2
	WHERE T.TcTsInstanceID IS NULL
	INSERT INTO AUTO_TcTsMap(TcTsInstanceID, TestcaseID, TestsetID, Flag)
	SELECT n.value('TcTsInstanceID[1]', 'int') AS TcTsInstanceID, n.value('TestcaseID[1]', 'int') AS TestcaseID,
	n.value('TestsetID[1]', 'int') AS TestsetID, n.value('Flag[1]', 'int') AS Flag
	FROM @xml.nodes('/AutomationDatabase/TcTsMap/entity') r(n)
	LEFT OUTER JOIN AUTO_TcTsMap m ON m.TcTsInstanceID = n.value('TcTsInstanceID[1]', 'int')
	WHERE m.TcTsInstanceID IS NULL
	-- Add newly included mappings to AUTO_FeatureInstanceTypeMap
	INSERT INTO AUTO_FeatureInstanceTypeMap(MappingID, FeatureID, iDAInstanceID)
	SELECT n.value('MappingID[1]', 'int') AS MappingID, n.value('FeatureID[1]', 'int') AS FeatureID, n.value('iDAInstanceID[1]', 'int') AS iDAInstanceID
	FROM @xml.nodes('/AutomationDatabase/FeatureInstanceTypeMap/entity') r(n)
	LEFT OUTER JOIN AUTO_FeatureInstanceTypeMap fm ON fm.FeatureID = n.value('FeatureID[1]', 'int')
	AND fm.iDAInstanceID = n.value('iDAInstanceID[1]', 'int')
	WHERE fm.FeatureID IS NULL OR fm.iDAInstanceID IS NULL
	-- Remove old and add newly included steps to AUTO_TestcaseSteps
	DELETE ts FROM AUTO_TestcaseSteps ts
	LEFT OUTER JOIN (
		SELECT n.value('TestcaseID[1]', 'int') AS TestcaseID, n.value('StepOrder[1]', 'int') AS StepOrder,
		n.value('DesignStep[1]', 'nvarchar(MAX)') AS DesignStep, n.value('ExpectedResult[1]', 'nvarchar(MAX)') AS ExpectedResult
		FROM @xml.nodes('/AutomationDatabase/TestcaseSteps/entity') r(n)
	) T ON T.TestcaseID = ts.TestcaseID AND T.DesignStep = ts.DesignStep
	AND T.ExpectedResult = ts.ExpectedResult AND T.StepOrder = ts.StepOrder
	WHERE T.TestcaseID IS NULL OR T.DesignStep IS NULL OR T.ExpectedResult IS NULL OR T.StepOrder IS NULL
	INSERT INTO AUTO_TestcaseSteps(TestcaseID, StepOrder, DesignStep, ExpectedResult)
	SELECT n.value('TestcaseID[1]', 'int') AS TestcaseID, n.value('StepOrder[1]', 'int') AS StepOrder,
	n.value('DesignStep[1]', 'nvarchar(MAX)') AS DesignStep, n.value('ExpectedResult[1]', 'nvarchar(MAX)') AS ExpectedResult
	FROM @xml.nodes('/AutomationDatabase/TestcaseSteps/entity') r(n)
	LEFT OUTER JOIN AUTO_TestcaseSteps ts
	ON ts.TestcaseID = n.value('TestcaseID[1]', 'int') AND ts.DesignStep = n.value('DesignStep[1]', 'nvarchar(MAX)')
	AND ts.ExpectedResult = n.value('ExpectedResult[1]', 'nvarchar(MAX)') AND ts.StepOrder = n.value('StepOrder[1]', 'int')
	WHERE ts.TestcaseID IS NULL OR ts.DesignStep IS NULL OR ts.ExpectedResult IS NULL OR ts.StepOrder IS NULL
	-- Add newly added inputs to AUTO_TestcaseInputs
	INSERT INTO AUTO_TestcaseInputs(InputName, InputType)
	SELECT n.value('InputName[1]', 'nvarchar(256)') AS InputName, n.value('InputType[1]', 'nvarchar(256)') AS InputType
	FROM @xml.nodes('/AutomationDatabase/TestcaseInputs/entity') r(n)
	LEFT OUTER JOIN AUTO_TestcaseInputs i ON i.InputName = n.value('InputName[1]', 'nvarchar(256)')
	WHERE i.InputName IS NULL
	-- Remove and add newly included inputs to AUTO_TCInputs
	DELETE tc
	FROM AUTO_TCInputs tc
	LEFT OUTER JOIN
	(
		SELECT n.value('TestcaseID[1]', 'int') AS TestcaseID, tcIn.InputID FROM
	@xml.nodes('/AutomationDatabase/TCInputs/entity') r(n)
	INNER JOIN AUTO_TestcaseInputs tcIn ON tcIn.InputName = n.value('InputName[1]', 'nvarchar(256)')
	) T ON T.InputID = tc.InputID AND T.TestcaseID = tc.TestcaseID
	WHERE T.TestcaseID IS NULL
	INSERT INTO AUTO_TCInputs(Flag, TestcaseID, InputID, InputValue)
	SELECT n.value('Flag[1]', 'int') AS Flag, n.value('TestcaseID[1]', 'int') AS TestcaseID,
	tcInputs.InputID AS InputID, n.value('InputValue[1]', 'nvarchar(256)') AS InputValue
	FROM @xml.nodes('/AutomationDatabase/TCInputs/entity') r(n)
	INNER JOIN AUTO_TestcaseInputs tcInputs ON tcInputs.InputName = n.value('InputName[1]', 'nvarchar(256)') COLLATE Latin1_General_CS_AS
	LEFT OUTER JOIN AUTO_TCInputs tcIn ON tcIn.InputID = tcInputs.InputID AND tcIn.TestcaseID = n.value('TestcaseID[1]', 'int')
	WHERE tcIn.InputID IS NULL
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	IF @@TRANCOUNT > 0
		ROLLBACK TRANSACTION
END CATCH
SELECT @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AUTOAddStaticList')
	delete from GxQscripts where name = 'AUTOAddStaticList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AUTOAddStaticList')
	delete from GXDBVersions where aliasname = 'AUTOAddStaticList'
GO

insert into GXDBVersions values(2, 'AUTOAddStaticList',  '00010001000200050000', 'AUTOAddStaticList', '00010001000200050000')
GO

