

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/CSView/Lic_CUR_UsageSummary_vw.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: Lic_CUR_UsageSummary_vw"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Lic_CUR_UsageSummary_vw]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Lic_CUR_UsageSummary_vw]
GO

delete from GXDBVersions where name = 'Lic_CUR_UsageSummary_vw' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'Lic_CUR_UsageSummary_vw', '1.1.2.3', 'Lic_CUR_UsageSummary_vw', '')
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW Lic_CUR_UsageSummary_vw
AS
    SELECT R.LicUsageType,R.LicUsageTypeName,ISNULL(U.Usage,0) AS Usage,U.OrgGUID,U.Organization,
	CASE WHEN R.LicUsageType IN (100002,100004,100005,100006,100015,100016,100031) THEN
		CASE WHEN (ISNULL(L.PermTotal,0)>=0 AND ISNULL(L.EvalTotal,0)>=0) THEN (ISNULL(L.PermTotal,0)/1024+ISNULL(L.EvalTotal,0)/1024)
		ELSE CASE WHEN (ISNULL(L.PermTotal,0)=-1 OR ISNULL(L.EvalTotal,0)=-1) THEN -1
		ELSE 0
		END
	END
	ELSE
		CASE WHEN (ISNULL(L.PermTotal,0)>0 OR ISNULL(L.PermTotal,0)=-1) THEN ISNULL(L.PermTotal,0)
		WHEN (ISNULL(L.EvalTotal,0)>0 OR ISNULL(L.EvalTotal,0)=-1) THEN ISNULL(L.EvalTotal,0)
		ELSE 0
		END
	END AS Purchased,
	CASE WHEN R.LicUsageType IN (100002,100004,100005,100006) THEN ISNULL(L.PermTotal,0)/1024 ELSE L.PermTotal END AS PermTotal,
	CASE WHEN R.LicUsageType IN (100002,100004,100005,100006) THEN ISNULL(L.EvalTotal,0)/1024 ELSE L.EvalTotal END AS EvalTotal,
	L.TermDate AS TermDate
	FROM
	(
		SELECT 100002 AS LicUsageType, 'Backup' AS LicUsageTypeName, 1 AS UsageType
		UNION
		SELECT 100004 AS LicUsageType, 'Archive' AS LicUsageTypeName, 2 AS UsageType
		UNION
		SELECT 100005 AS LicUsageType, 'Snapshot' AS LicUsageTypeName, 3 AS UsageType
		UNION
		SELECT 100006 AS LicUsageType, 'Replication' AS LicUsageTypeName, 4 AS UsageType
		UNION
		SELECT 100018 AS LicUsageType, 'VM Sockets' AS LicUsageTypeName, 20 AS UsageType
		UNION
		SELECT 100019 AS LicUsageType, 'Protected VMs' AS LicUsageTypeName, 19 AS UsageType
		UNION
		SELECT 100027 AS LicUsageType, 'Application Class Virtual' AS LicUsageTypeName, -1 AS UsageType
		UNION
		SELECT 100021 AS LicUsageType, 'Archived VMs' AS LicUsageTypeName, 21 AS UsageType
		UNION
		SELECT 100024 AS LicUsageType, 'Endpoint Users' AS LicUsageTypeName, 22 AS UsageType
		UNION
		SELECT 100025 AS LicUsageType, 'Sharing Users' AS LicUsageTypeName, 23 AS UsageType
		UNION
		SELECT 100026 AS LicUsageType, 'eDiscovery Users' AS LicUsageTypeName, 24 AS UsageType
		UNION
		SELECT 100028 AS LicUsageType, 'Application Users' AS LicUsageTypeName, 18 AS UsageType
		UNION
		SELECT 100029 AS LicUsageType, 'File System only Server' AS LicUsageTypeName, 29 AS UsageType
		UNION
		SELECT 200017 AS LicUsageType, 'File System only VM' AS LicUsageTypeName, -4 AS UsageType
		UNION
		SELECT 200002 AS LicUsageType, 'Desktop & Laptop only' AS LicUsageTypeName, 28 AS UsageType
		UNION
		SELECT 100030 AS LicUsageType, 'Application Server' AS LicUsageTypeName, 27 AS UsageType
		UNION
		SELECT 200001 AS LicUsageType, 'VM only' AS LicUsageTypeName, -2 AS UsageType
		UNION
		SELECT 200003 AS LicUsageType, 'Advanced VM' AS LicUsageTypeName, -3 AS UsageType
		UNION
		SELECT 100031 AS LicUsageType, 'Appliance Store Usage (TB)' AS LicUsageTypeName, 8 AS UsageType
		UNION
		SELECT 100016 AS LicUsageType, 'Dedupe Store Space (TB)' AS LicUsageTypeName, 5 AS UsageType
		UNION
		SELECT 100015 AS LicUsageType, 'Disk Library Space (TB)' AS LicUsageTypeName, 9 AS UsageType
		UNION
		SELECT 100017 AS LicUsageType, 'Content Indexed Objects (In Millions)' AS LicUsageTypeName, 25 AS UsageType
		UNION
        SELECT 200016 AS LicUsageType, 'Live Sync for VM' AS LicUsageTypeName, 26 AS UsageType
	)R
	LEFT JOIN
	(
		SELECT UsageType,
		CASE WHEN UsageType IN (18) THEN COUNT(DISTINCT ObjectName) WHEN UsageType IN (19,21,22,23,24) THEN COUNT(DISTINCT ObjectId) WHEN UsageType IN (27,28,29) THEN COUNT(DISTINCT ClientId) WHEN UsageType IN (26) THEN COUNT(ClientName) ELSE SUM(ISNULL(AppSizeMB,0)) END AS Usage, OrgGUID, Organization
		FROM dbo.Lic_CurrentUsage WITH(NOLOCK)
		WHERE (UsageType in (1,2,3,4) AND CapacityFlag=0) OR UsageType IN (5,8,9,18,20,21,22,23,24,25,26,27,28) OR (UsageType=19 AND VMFlag IN (2,3)) OR (UsageType = 29 AND LicType=100029) GROUP BY UsageType, OrgGUID, Organization
		UNION
		SELECT -1, COUNT(DISTINCT ObjectId) AS Usage, OrgGUID, Organization
		FROM dbo.Lic_CurrentUsage WITH(NOLOCK)
		WHERE (UsageType=19 AND VMFlag IN (3,4)) GROUP BY OrgGUID, Organization
		UNION
		SELECT -2, COUNT(DISTINCT ObjectId) AS Usage, OrgGUID, Organization
		FROM dbo.Lic_CurrentUsage WITH(NOLOCK)
		WHERE (UsageType=19 AND VMFlag=2) GROUP BY OrgGUID, Organization
		UNION
		SELECT -3, COUNT(DISTINCT ObjectId) AS Usage, OrgGUID, Organization
		FROM dbo.Lic_CurrentUsage WITH(NOLOCK)
		WHERE (UsageType=19 AND VMFlag=3) GROUP BY OrgGUID, Organization
		UNION
		SELECT -4, COUNT(DISTINCT ClientId) AS Usage, OrgGUID, Organization
		FROM dbo.Lic_CurrentUsage WITH(NOLOCK)
		WHERE (UsageType=29 AND LicType = 200017) GROUP BY OrgGUID, Organization
	)U ON R.UsageType=U.UsageType
	LEFT JOIN
	(
		SELECT LicType, PermTotal, EvalTotal, TermDate FROM dbo.Lic_LicenseInfo WITH(NOLOCK) WHERE LicType > 1000
	) L ON L.LicType=R.LicUsageType
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [Lic_CUR_UsageSummary_vw]'
END
GO

