

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/MMCollectPruningStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: anarulkar
--	Date:   03/06/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/MMCollectPruningStatus.sp,v $ $Id: MMCollectPruningStatus.sp,v 1.1.2.1 2018/08/17 08:26:15 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMCollectPruningStatus <<<'

IF EXISTS (select * from sysobjects where name='MMCollectPruningStatus')
	drop procedure MMCollectPruningStatus
IF EXISTS (select * from GxQscripts where name='MMCollectPruningStatus')
	delete from GxQscripts where name = 'MMCollectPruningStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCollectPruningStatus')
	delete from GXDBVersions where aliasname = 'MMCollectPruningStatus'
GO
print '... Creating Procedure: MMCollectPruningStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMCollectPruningStatus
  @i_reserve integer
AS
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_MountPathId INTEGER
  DECLARE @o_CreateTime INTEGER
  DECLARE @o_ErrorCode INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ErrVal INTEGER = 0
DECLARE @RowCount INTEGER = 0
DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
DECLARE @lastRunTime INT = 0
DECLARE @nextRunTime INT = 0
DECLARE @collectionIntervalInHrs INT = 0
DECLARE @MountPathId INT = 0
if object_id('tempdb.dbo.#tempPruningStatus') is not null DROP TABLE #tempPruningStatus
CREATE TABLE #tempPruningStatus(
		SIDBStoreId	integer,
		MountPathId	integer,
		CreateTime	bigint,
		DeleteAFTotal	integer,
		DeletedCountTotal integer,
		TopErrorCode	integer
		)
if object_id('tempdb.dbo.#tempErr') is not null DROP TABLE #tempErr
CREATE TABLE #tempErr(
		RetCode	integer,
		RetStr	varchar(10)
		)
SELECT @lastRunTime = intVal,
@nextRunTime = longlongVal
FROM CommServ..MMEntityProp WITH (READUNCOMMITTED)
WHERE EntityType = 14
AND propertyName = 'CollectionTime'
SELECT @collectionIntervalInHrs = intVal
FROM CommServ..MMEntityProp WITH (READUNCOMMITTED)
WHERE EntityType = 15
AND propertyName = 'CollectionTimeIntervalHours'
IF ((@now < @nextRunTime) AND (@nextRunTime > 0)) OR (@nextRunTime = 0)
BEGIN
	-- We have not elapsed enough time interval or no need to collect this info (nextRunTime = 0). exit
	GOTO CX_EXIT
END
INSERT INTO #tempPruningStatus
SELECT D.SIDBStoreId, D.MountPathId, @now, COUNT(DISTINCT archFileId), COUNT(*), 0
FROM CommServ..MMDeletedAF D WITH (READUNCOMMITTED)
WHERE D.archFileId > 0 OR D.ArchChunkId > 0
GROUP BY D.SIDBStoreId, D.MountPathId
SET @ErrVal = @@ERROR
IF @ErrVal != 0
	GOTO CX_EXIT
DECLARE MP_Cursor CURSOR LOCAL FORWARD_ONLY FOR
SELECT DISTINCT MountPathId
FROM #tempPruningStatus
WHERE MountPathId > 0
OPEN MP_Cursor
FETCH NEXT FROM MP_Cursor INTO @MountPathId
WHILE (@@FETCH_STATUS = 0)
BEGIN
	INSERT INTO #tempErr
	EXEC CommServ..MMSetErrorCodeForPruningFailures @MountPathId, 0, ''
	FETCH NEXT FROM MP_Cursor INTO @MountPathId
END
UPDATE #tempPruningStatus
SET TopErrorCode = Tmp.FailureErrorCode
FROM #tempPruningStatus T,
(
  SELECT SIDBStoreId, MountPathId, FailureErrorCode, ROW_NUMBER() OVER (Partition by SIDBStoreId, MountPathId Order by cn desc) rn
  FROM
    (SELECT SIDBStoreId, MOuntPathId, FailureErrorCode, COUNT(*) cn
     FROM CommServ..MMDeletedAF WITH (READUNCOMMITTED)
     GROUP BY SIDBStoreId, MountPathId, FailureErrorCode
     ) T1
) Tmp
WHERE T.SIDBStoreId = Tmp.SIDBStoreId
AND T.MountPathId = Tmp.MountPathId
AND Tmp.rn = 1
INSERT INTO MMPruningStatusHistory (SIDBStoreId, MountPathId, CreateTime, DeleteAFTotal, DeletedCountTotal, ErrorCode, ErrorString, flags)
SELECT SIDBStoreId, MountPathId, CreateTime, DeleteAFTotal, DeletedCountTotal, TopErrorCode, '', 0
FROM #tempPruningStatus
-- Compute the next run time based on how may hours in the config
SET @nextRunTime = (@nextRunTime + (@collectionIntervalInHrs * 60 * 60))
WHILE (@nextRunTime < @now)
BEGIN
	SET @nextRunTime = (@nextRunTime + (@collectionIntervalInHrs * 60 * 60))
END
-- Update the next collection time in entityProp
UPDATE CommServ..MMEntityProp
SET intVal = @now,
longlongVal = @nextRunTime
WHERE EntityType = 14
AND propertyName = 'CollectionTime'
CX_EXIT:
--First row is information. Resultset is next row to convert errorCode to errorstring.
SELECT	@ErrVal, @nextRunTime, 0, 0
UNION
SELECT SIDBStoreId, MountPathId, CreateTime, TopErrorCode
FROM #tempPruningStatus
if object_id('tempdb.dbo.#tempPruningStatus') is not null DROP TABLE #tempPruningStatus
if object_id('tempdb.dbo.#tempErr') is not null DROP TABLE #tempErr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMCollectPruningStatus')
	delete from GxQscripts where name = 'MMCollectPruningStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCollectPruningStatus')
	delete from GXDBVersions where aliasname = 'MMCollectPruningStatus'
GO

insert into GXDBVersions values(2, 'MMCollectPruningStatus',  '00010001000200010000', 'MMCollectPruningStatus', '00010001000200010000')
GO

