

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/Lic_CCL_GetLicenseUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Abhinaw Kumar
--	Date:   10/22/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/Lic_CCL_GetLicenseUsage.sp,v $ $Id: Lic_CCL_GetLicenseUsage.sp,v 1.1.4.5 2019/03/30 13:33:23 lgeorge Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Lic_CCL_GetLicenseUsage')
BEGIN
	print '>>> Drop Stored Procedure: Lic_CCL_GetLicenseUsage <<<'
	drop procedure Lic_CCL_GetLicenseUsage
END
IF EXISTS (select * from GxQscripts where name='Lic_CCL_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CCL_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CCL_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CCL_GetLicenseUsage'
GO
print '... Creating Procedure: Lic_CCL_GetLicenseUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Lic_CCL_GetLicenseUsage
  @option INT, 	
  @i_userId INT,
  @monthString VARCHAR(20) = NULL,
  @timezone VARCHAR(20) = '00:00'
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @i_UMDSProviderId INT = NULL
	DECLARE @orgGUID UNIQUEIDENTIFIER = NULL
	DECLARE @userHasRights INT = 0
	DECLARE @isUserAdmin INT = 0
	EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '1,2', @userHasRights OUTPUT, 1, 2
	IF @userHasRights = 0
	BEGIN
		SELECT @i_UMDSProviderId = UMDS.id, @orgGUID = UMDS.GUID
		FROM commserv.dbo.UMDSProviders UMDS JOIN commserv.dbo.UMUsers U
			ON U.umDSproviderId = UMDS.id AND UMDS.serviceType = 5 --- for Company
		WHERE U.id = @i_userId
		SET @userHasRights = 0
		IF @i_UMDSProviderId IS NOT NULL
			EXEC commserv.dbo.sec_checkPermissionOnEntity @i_userId, '1,2', @userHasRights OUTPUT, 61, @i_UMDSProviderId
		IF @userHasRights = 0 OR @orgGUID IS NULL
			RETURN
	END
	ELSE
		SET @isUserAdmin = 1
	DECLARE @month DATETIME
	SET @month=CONVERT(DATE,@monthString)
	IF @month=NULL OR @month > GETDATE()
	BEGIN
		SET @month=DATEADD(DAY,-DAY(GETDATE())+1, CAST(GETDATE() AS DATE))
	END
	DECLARE @noOfMonths int =12
	DECLARE @monthStart DATETIME = GETDATE()
    DECLARE @monthTable TABLE (MonthStart DATETIME)
    DECLARE @cnt INT = @noOfMonths
    WHILE @cnt > 0
    BEGIN
        INSERT @monthTable
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStart), 0)
        SET @monthStart=DATEADD(month, -1, @monthStart)
        SET @cnt=@cnt-1
    END
	IF @option = 1  -- Get License Peak Usage for Capacity
	BEGIN
		SELECT  M.MonthStart AS Month, ISNULL([CCLBackup]/(1024.0*1024.0), 0) AS 'CCLBackup', ISNULL([CCLArchive]/(1024.0*1024.0), 0) AS 'CCLArchive'
		, ISNULL([CCLSnapshot]/(1024.0*1024.0), 0) AS 'CCLSnapshot', ISNULL([CCLReplication]/(1024.0*1024.0), 0) AS 'CCLReplication', ISNULL(([CCLBackup]+[CCLArchive])/(1024.0*1024.0), 0) AS 'CCLComplete' FROM
		(SELECT  *	FROM
		(SELECT  MonthStart, 'CCLBackup' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB  FROM Lic_CCL_Backups_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION
			SELECT  MonthStart, 'CCLSnapshot' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Snapshots_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION
			SELECT  MonthStart, 'CCLReplication' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Replications_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
			UNION
			SELECT  MonthStart, 'CCLArchive' BackupType, ISNULL(AppSiZeMB, 0) AS AppSiZeMB FROM Lic_CCL_Archives_InCapacity_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		) AS SourceTable
		PIVOT
		(
			SUM(AppSiZeMB)
			FOR BackupType IN ([CCLBackup], [CCLSnapshot], [CCLReplication], [CCLArchive])
		) AS PivotTable) T
		RIGHT JOIN @monthTable M
			ON M.MonthStart = T.MonthStart
	END
	ELSE IF @option = 2  -- Get License Peak Usage for Virtualization, Application Users, Endpoint Users and other licenses
	BEGIN
		SELECT T1.Month As Month, ISNULL([VMSockets], 0) AS 'VMSockets', ISNULL([ProtectedVMs], 0) AS 'ProtectedVMs', ISNULL([AcvVMs], 0) AS 'AcvVMs',
			   ISNULL([ArchivedVMs], 0) AS 'ArchivedVMs', ISNULL([MSimUsers], '') AS 'MSimUsers', ISNULL([EpUsers], 0) AS 'EpUsers',
			   ISNULL([EpSharingUsers], 0) AS 'EpSharingUsers', ISNULL([EpEdiscoveryUsers], 0) AS 'EpEdiscoveryUsers',
			   ISNULL([FSOnlyServer], 0) AS 'FSOnlyServer', ISNULL([FSOnlyVM], 0) AS 'FSOnlyVM', ISNULL([DLO], 0) AS 'DLO' , ISNULL([AppServer], 0) AS 'AppServer',
			   ISNULL([VMonly], 0) AS 'VMonly', ISNULL([AdvancedVM], 0) AS 'AdvancedVM', ISNULL([LiveSyncVM], 0) AS 'LiveSyncVM'
		FROM
		(SELECT  M.MonthStart AS Month, ISNULL([VMSockets], 0) AS 'VMSockets' FROM
		(SELECT  *	FROM
		(SELECT MonthStart, 'VMSockets' BackupType, ISNULL(Sockets, 0) AS AppSiZeMB  FROM Lic_CCL_VMSockets_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)) AS SourceTable
		PIVOT
		(
			SUM(AppSiZeMB) FOR BackupType IN ([VMSockets])
		) AS PivotTable) T
			RIGHT JOIN @monthTable M
					ON M.MonthStart = T.MonthStart) T1
		LEFT JOIN
			(SELECT  M.MonthStart AS Month, ISNULL([MSimUsers], '') AS 'MSimUsers'
			FROM
			(SELECT  *	FROM
			(SELECT DISTINCT MonthStart, 'MSimUsers' BackupType, ISNULL(Smtp, '') AS Data  FROM Lic_CCL_ApplicationUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)) AS SourceTable
			PIVOT
			(COUNT(Data) FOR BackupType IN ([MSimUsers])) AS PivotTable)T
				RIGHT JOIN @monthTable M
					ON M.MonthStart = T.MonthStart) T2
			ON MONTH(T1.Month) = MONTH(T2.Month) AND  YEAR(T1.Month) = YEAR(T2.Month)
		LEFT JOIN
		(SELECT  M.MonthStart AS Month, ISNULL([ProtectedVMs], 0) AS 'ProtectedVMs'
		, ISNULL([AcvVMs], 0) AS 'AcvVMs', ISNULL([ArchivedVMs], 0) AS 'ArchivedVMs'
		, ISNULL([VMonly], 0) AS 'VMonly', ISNULL([AdvancedVM], 0) AS 'AdvancedVM', ISNULL([EpUsers], 0) AS 'EpUsers'
		, ISNULL([EpSharingUsers], 0) AS 'EpSharingUsers', ISNULL([EpEdiscoveryUsers], 0) AS 'EpEdiscoveryUsers'
		, ISNULL([FSOnlyServer], 0) AS 'FSOnlyServer', ISNULL([FSOnlyVM], 0) AS 'FSOnlyVM', ISNULL([DLO], 0) AS 'DLO' , ISNULL([AppServer], 0) AS 'AppServer', ISNULL([LiveSyncVM], 0) AS 'LiveSyncVM'
		FROM
			(SELECT  *	FROM
				(SELECT DISTINCT MonthStart, 'ProtectedVMs' BackupType, VMId AS Data FROM Lic_CCL_ProtectedVMs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT DISTINCT MonthStart, 'AcvVMs' BackupType, VMId AS Data FROM Lic_CCL_ACVs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT DISTINCT MonthStart, 'ArchivedVMs' BackupType, VMId AS Data FROM Lic_CCL_ArchivedVMs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT DISTINCT MonthStart, 'VMonly' BackupType, VMId AS Data FROM Lic_CCL_VMOnly_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT DISTINCT MonthStart, 'AdvancedVM' BackupType, VMId AS Data FROM Lic_CCL_VMWithApps_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT  DISTINCT MonthStart, 'EpUsers' BackupType, UserId AS Data FROM Lic_CCL_EpUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT  DISTINCT MonthStart, 'EpSharingUsers' BackupType, UserId AS Data FROM Lic_CCL_EpSharingUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT  DISTINCT MonthStart, 'EpEdiscoveryUsers' BackupType, UserId AS Data FROM Lic_CCL_EpEDiscoveryUsers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT  DISTINCT MonthStart, 'FSOnlyServer' BackupType, ClientId AS Data  FROM Lic_CCL_FSonlyServers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND LicType=100029
				UNION
				SELECT  DISTINCT MonthStart, 'FSOnlyVM' BackupType, ClientId AS Data  FROM Lic_CCL_FSonlyServers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND LicType=200017
				UNION
				SELECT DISTINCT MonthStart, 'DLO' BackupType, ClientId AS Data FROM Lic_CCL_DLOs_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT DISTINCT MonthStart, 'AppServer' BackupType, ClientId AS Data FROM Lic_CCL_AppServers_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				UNION
				SELECT DISTINCT MonthStart, 'LiveSyncVM' BackupType, SourceClientId AS Data FROM Lic_CCL_LiveSyncForVM_vw WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID)
				) AS SourceTable
				PIVOT
				(COUNT(Data) FOR BackupType IN ([ProtectedVMs],[AcvVMs],[ArchivedVMs], [VMonly], [AdvancedVM], [EpUsers],
												[EpSharingUsers], [EpEdiscoveryUsers], [FSOnlyServer], [FSOnlyVM], [DLO], [AppServer], [LiveSyncVM])) AS PivotTable
			)T	RIGHT JOIN @monthTable M
					ON M.MonthStart = T.MonthStart) T3
			ON MONTH(T2.Month) = MONTH(T3.Month) AND  YEAR(T2.Month) = YEAR(T3.Month)
	END
	ELSE IF @option = 3   -- Get License Summary Usage
	BEGIN
		DECLARE @commvaultComplete INT = 0, @completeUsed BIGINT = 0
		SELECT @completeUsed=SUM(CASE WHEN @orgGUID IS NULL OR OrgGUID = @orgGUID THEN Usage ELSE 0 END) FROM Lic_CUR_usageSummary_vw WHERE LicUsageType IN (100002,100004)
		IF EXISTS (SELECT 1 FROM Lic_LicenseInfo WITH(NOLOCK) WHERE lictype=205) AND EXISTS (SELECT 1 FROM Lic_LicenseInfo LiB INNER JOIN Lic_LicenseInfo LiA ON LiA.LicType=100004 AND LiB.PermTotal=LiA.PermTotal AND LiB.EvalTotal=LiA.EvalTotal AND LiB.TermDate=LiA.TermDate WHERE LiB.LicType=100002)
		BEGIN
			SET @commvaultComplete=1
		END
		SELECT CASE WHEN LicUsageType = 100002 THEN 'complete'
		WHEN LicUsageType = 100005 THEN 'snapshot'
		WHEN LicUsageType = 100006 THEN 'replication'
		WHEN LicUsageType = 100018 THEN 'vmSockets'
		WHEN LicUsageType = 100019 THEN 'protectedVMs'
		WHEN LicUsageType = 100027 THEN 'appClassVirtual'
		WHEN LicUsageType = 100021 THEN 'archivedVMs'
		WHEN LicUsageType = 100024 THEN 'epUser'
		WHEN LicUsageType = 100025 THEN 'epSharingUser'
		WHEN LicUsageType = 100026 THEN 'epEDiscoveryUser'
		WHEN LicUsageType = 100028 THEN 'mbArchivedSolution'
		WHEN LicUsageType = 100029 THEN 'FSonlyServer'
		WHEN LicUsageType = 200017 THEN 'FSonlyVM'
		WHEN LicUsageType = 200002 THEN 'DLO'
		WHEN LicUsageType = 100030 THEN 'appServer'
		WHEN LicUsageType = 200001 THEN 'vmOnly'
		WHEN LicUsageType = 200003 THEN 'advancedVM'
		WHEN LicUsageType = 200016 THEN 'liveSyncVM' END AS Dial,
		CASE WHEN LicUsageType=100002 AND @commvaultComplete=1 THEN -1 ELSE LicUsageType END AS "License ID",
		ISNULL(Purchased, 0) AS Purchased, ISNULL(PermTotal, 0) AS "Permanent Total", ISNULL(EvalTotal, 0) AS evaluationTotal,
		ISNULL(CASE WHEN LicUsageType IN (100002) THEN CEILING(@completeUsed)
				WHEN LicUsageType IN (100005,100006) THEN CEILING(SUM( Usage))
				WHEN LicUsageType IN (100018,100019,100027,100021, 100024,100025,100026, 100028, 100029, 100030, 200002, 200001, 200003, 200016, 200017) THEN SUM(Usage) END, 0) AS Used,
		ISNULL(CONVERT(VARCHAR(25),CASE WHEN TermDate = CONVERT(DATE, '01-01-1970') THEN NULL ELSE TermDate END, 121), 'N/A') AS "Term End Date", @isUserAdmin As isUserAdmin, @commvaultComplete AS CommvaultComplete
		FROM Lic_CUR_usageSummary_vw
		WHERE ((@commvaultComplete=1 AND LicUsageType=100002) OR LicUsageType IN (100005,100006,100018, 100019, 100027, 100021,100024,
								100025, 100026, 100028, 100029, 100030, 200002, 200001, 200003, 200016, 200017)) AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
		GROUP BY LicUsageType,LicUsageTypeName, Purchased, EvalTotal, TermDate, PermTotal
		UNION
		SELECT DISTINCT 'complete' AS Dial, LicUsageType AS "License ID", -1 AS Purchased, -1 AS "Permanent Total", -1 AS evaluationTotal, ISNULL(CEILING(@completeUsed),0) AS Used,
		'N/A' AS "Term End Date", @isUserAdmin As isUserAdmin, @commvaultComplete AS CommvaultComplete
		FROM Lic_CUR_usageSummary_vw
		WHERE @commvaultComplete=0 AND LicUsageType=100002 AND (@orgGUID IS NULL OR OrgGUID = @orgGUID)
	END
	ELSE IF @option = 4   -- Get License Peak Usage for Backup in Capacity
	BEGIN
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
		FROM Lic_CCL_Backups_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF  @option = 5  -- Get License Peak Usage for Archive in Capacity
	BEGIN
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
		FROM Lic_CCL_Archives_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF @option = 6  -- Get License Peak Usage for Snapshot in Capacity
	BEGIN
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
		FROM Lic_CCL_Snapshots_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF @option = 7  -- Get License Peak Usage for Replication in Capacity
	BEGIN
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
		FROM Lic_CCL_Replications_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF @option = 8   -- Get Last Collection Time
	BEGIN
		SELECT CONVERT(DATETIME, SWITCHOFFSET(CONVERT(DATETIMEOFFSET, commserv.dbo.GetDateTimeBig(value)), @timezone)) 'Last Collection Time'
		FROM commserv.dbo.GXGlobalParam WITH(NOLOCK) WHERE name='LicCurrentUsageCollectionTime'
	END
	ELSE IF @option= 9 --Get list of past N months for peak usages
	BEGIN
		DECLARE @dateTable TABLE (monthValue VARCHAR(20), monthLabel VARCHAR(20))
		DECLARE @date DATETIME = GETDATE()
		DECLARE @counter INT = @noOfMonths
		--default month to be diplayed in list
		INSERT INTO @dateTable VALUES('9999-01-01','Current Month')
		WHILE @counter > 0
		BEGIN
			INSERT @dateTable
			SELECT CAST(DATEADD(DAY,-DAY(@date)+1, CAST(@date AS DATE)) AS DATE), CONVERT(VARCHAR(10),DATENAME(month, @date))+', '+CONVERT(VARCHAR(4),YEAR(@date))
			SET @date=DATEADD(month, -1, @date)
			SET @counter=@counter-1
		END
		SELECT monthValue, monthLabel FROM @dateTable
	END
	ELSE IF @option = 10  -- Get License Peak Usage for VM Sockets
	BEGIN
		SELECT HypervisorHost AS "Hypervisor Host", Sockets, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_VMSockets_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 11 -- Get License Usage for VM Sockets, Protected VMs Excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_VSAJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 12 -- Get License Usage for Protected VMs
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_ProtectedVMs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 13 -- Get License Usage for ACV Licenses
	BEGIN
		SELECT VMId	"VM ID", VMName "Virtual Machine", Package, isVMProtected "Is VM Protected", VMProtectionJob "VM Protection Job",
			ProtectedVMSize "Protected VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_ACVs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 14 -- Get License Usage for ACVs excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_ACVJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 15 -- Get License Usage for Archived VMs
	BEGIN
		SELECT  VMId	"VM ID", VMName "Virtual Machine", VMArchiveJob "VM Archived Job",
			ArchivedVMSize "Archived VM Size",OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_ArchivedVMs_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 16 -- Get License Usage for Archived VMs excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_ArchviedVMJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 17 -- Get License Usage for End point Users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_EpUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 18 -- Get License Usage for DLP excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_DLPJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 19 -- Get License Usage for Endpoint Sharing users
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_EpSharingUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 20 -- Get License Usage for EDiscovery USers
	BEGIN
		SELECT UserId "User ID", UserName "User Name", UserLogin "User Login", UserEmail "E Mail", Associations, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_EpEDiscoveryUsers_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 21 -- Get License Usage for File Systems Only Server without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan", LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License
		FROM Lic_CCL_FSonlyServersWithoutUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 22  -- Get License Usage for File System Only servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ActualLicType "Actual License ID", CASE WHEN ActualLicType < 1 THEN 'N/A' ELSE ActualLicName END "Actual License",
				ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_FSonlyServersWithUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 23  -- Get License Usage for DL Only with Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_DLOsWithoutUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 24   -- Get License Usage for DL Only without Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_DLOsWithUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 25  -- Get License Usage for Application Servers without Usage
	BEGIN
		SELECT ClientId "Client ID", ClientName Client, OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_AppServersWithoutUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 26 -- Get License Usage for Application Servers with Usage
	BEGIN
		SELECT  LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_AppServersWithUsage_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 27  -- Get License Usage for VM Only
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_VMOnly_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 28  -- Get License Usage for Advanced VMs
	BEGIN
		SELECT   VMId "VM ID", VMName "Virtual Machine", Package, VMProtectionJob "VM Protection Job",	ProtectedVMSize "Protected VM Size",
				OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_VMWithApps_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 29 -- Get License Usage for Application Users
	BEGIN
		DECLARE @enablerTable TABLE (SMTP NVARCHAR(1024), OrgGUID UNIQUEIDENTIFIER, enabler INT)
		INSERT INTO @enablerTable
		SELECT DISTINCT Smtp, OrgGUID, ISNULL(SUM(DISTINCT p),0)
		FROM Lic_CCL_ApplicationUsers_vw Usage
		OUTER APPLY
		(SELECT p FROM
			(SELECT POWER(2,n) FROM
				(VALUES (0),(1),(2)) Nos(n)
			)Powers(p)
			WHERE p&Usage.VMFlag = p
		)Bitmask
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
		GROUP BY Smtp,OrgGUID
		SELECT Smtp AS SMTP, OrgGUID "Organization ID", Organization, "Plan", CASE WHEN [Exchange Mailbox] > 0 THEN 1 ELSE 0 END "Exchange Mailbox",
		CASE WHEN [Exchange OnePass] > 0 THEN 1 ELSE 0 END "Exchange OnePass", CASE WHEN [SharePoint Online] > 0 THEN 1 ELSE 0 END "SharePoint Online",
		CASE WHEN [Gmail] > 0 THEN 1 ELSE 0 END "Gmail", CASE WHEN [GDrive] > 0 THEN 1 ELSE 0 END "GDrive", CASE WHEN [OneDrive] > 0 THEN 1 ELSE 0 END "OneDrive",
		CASE WHEN [Salesforce] > 0 THEN 1 ELSE 0 END "Salesforce", CASE WHEN [Notes] > 0 THEN 1 ELSE 0 END "Notes",
		CASE WHEN Checker&1>0 THEN 1 ELSE 0 END AS 'CI Enabled', CASE WHEN Checker&2>0 THEN 1 ELSE 0 END AS 'CM Enabled', CASE WHEN Checker&4>0 THEN 1 ELSE 0 END AS 'CS Enabled'
		FROM (
			SELECT Usage.Smtp, Usage.OrgGUID, Organization, PlanName AS "Plan", LicName, E.enabler AS Checker
			FROM Lic_CCL_ApplicationUsers_vw Usage
			LEFT JOIN
			@enablerTable E ON Usage.Smtp = E.SMTP AND (Usage.OrgGUID = E.OrgGUID OR (Usage.OrgGUID IS NULL and E.OrgGUID IS NULL))
			WHERE (@orgGUID IS NULL OR Usage.OrgGUID = @orgGUID) AND Usage.MonthStart = @month
		) AS SourceTable
		PIVOT
		(
			COUNT(LicName)
			FOR LicName IN ([Exchange Mailbox],[Exchange OnePass],[SharePoint Online],[Gmail],[GDrive],[OneDrive],[Salesforce],[Notes])
		) AS PivotTable
	END
	ELSE IF @option = 30 -- Get License Usage for Application Users not in Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_AppUserJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 31 -- Get License Usage for Edge drive excluded from Capacity
	BEGIN
		SELECT LicType "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END License, ClientId "Client ID",	ClientName Client, AppTypeId "Agent ID", AppTypeName Agent, SubclientId "Subclient ID", SubclientName Subclient,
				SPId "Storage Policy ID", SPName "Storage Policy", BackupSetName "Backupset", InstanceName "Instance", JobType "Job Type", JobId "Job ID",
				AppSizeMB "Usage", OrgGUID "Organization ID", Organization, PlanName "Plan", BackupSetId "Backupset ID", InstanceId "Instance ID"
		FROM Lic_CCL_EdgeDriveJobs_NotInCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
	END
	ELSE IF @option = 32  -- Get License Peak Usage for Commvault Complete
	BEGIN
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
		FROM Lic_CCL_Backups_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
		UNION
		SELECT  LicType AS "License ID", CASE WHEN Lictype < 1 THEN 'N/A' ELSE LicName END AS License, ClientId AS "Client ID", ClientName AS Client,
		AppTypeId AS "Agent ID", CASE WHEN AppTypeId < 1 THEN 'N/A' ELSE AppTypeName END AS Agent,
		SubclientId AS "Subclient ID", SubclientName AS Subclient, SPId AS "Storage Policy ID", SPName AS "Storage Policy", BackupSetName AS Backupset,
		InstanceName AS Instance, JobType AS "Job Type", JobId AS "Job ID", AppSizeMB AS Usage, Organization, OrgGUID AS "Organization ID", PlanName As "Plan",
		BackupsetId AS "Backupset ID", InstanceId AS "Instance ID"
		FROM Lic_CCL_Archives_InCapacity_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
	ELSE IF @option = 33 -- Get License Peak summary for File Systems Only Servers & VMs
	BEGIN
		DECLARE @fsonlyTbl TABLE(LicType INT, LicName VARCHAR(32), Used INT)
		INSERT INTO @fsonlyTbl VALUES (100029, 'File System only Server',0), (200017, 'File System only VM',0)
		UPDATE T SET T.Used=F.Used
		FROM @fsonlyTbl T
		INNER JOIN
		(
			SELECT LicType, COUNT(DISTINCT ClientId) Used
			FROM Lic_CCL_FSonlyServers_vw
			WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart = @month
			GROUP BY LicType
		)F ON F.LicType=T.LicType
		SELECT LicType "License ID", LicName "License", Used FROM @fsonlyTbl
	END
	ELSE IF @option = 34 -- Get Peak Usage of Live Sync pairs for VMs
	BEGIN
		SELECT SourceClientId "Source ID", SourceClientName "Source Name", SourceGUID "Source GUID", DestinationName "Destination Name",
		OrgGUID "Organization ID", Organization, PlanName "Plan"
		FROM Lic_CCL_LiveSyncForVM_vw
		WHERE (@orgGUID IS NULL OR OrgGUID = @orgGUID) AND MonthStart=@month
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'Lic_CCL_GetLicenseUsage')
	delete from GxQscripts where name = 'Lic_CCL_GetLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Lic_CCL_GetLicenseUsage')
	delete from GXDBVersions where aliasname = 'Lic_CCL_GetLicenseUsage'
GO

insert into GXDBVersions values(2, 'Lic_CCL_GetLicenseUsage',  '00010001000400050000', 'Lic_CCL_GetLicenseUsage', '00010001000400050000')
GO

