

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/JMGetFinishedJobList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/JMGetFinishedJobList.sp,v $ $Id: JMGetFinishedJobList.sp,v 1.1.2.5 2019/04/19 11:17:09 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetFinishedJobList')
BEGIN
	print '>>> Drop Stored Procedure: JMGetFinishedJobList <<<'
	drop procedure JMGetFinishedJobList
END
IF EXISTS (select * from GxQscripts where name='JMGetFinishedJobList')
	delete from GxQscripts where name = 'JMGetFinishedJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetFinishedJobList')
	delete from GXDBVersions where aliasname = 'JMGetFinishedJobList'
GO
print '... Creating Procedure: JMGetFinishedJobList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetFinishedJobList
  @i_filter INT
AS
  DECLARE @o_jobId int;
  DECLARE @o_commCellId int;
  DECLARE @o_rstTaskId int;
  DECLARE @o_flags int;
  DECLARE @o_SIDBStoreId int;
  DECLARE @o_state int;
  DECLARE @o_createTime int;
  DECLARE @o_RowCount int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb..#lt_JobHistory') IS NOT NULL DROP TABLE #lt_JobHistory
CREATE TABLE #lt_JobHistory
(
	jobId			integer,
	commCellId		integer,
	rstTaskId		integer,
	flags			integer,
	SIDBStoreId		integer,
	state			integer,
	createTime		integer
)
IF @i_filter = 1
BEGIN
	DECLARE @l_MaxJobsToProcessInBatch  INT = ISNULL((SELECT value FROM CommServ..MMConfigs WITH(READUNCOMMITTED)
											WHERE name = 'MM_CONFIG_MAX_JOBS_ENC_KEYS_TO_CLEANUP_IN_BATCH'), 1000)
	DECLARE @l_LastProcessedTime INT = ISNULL((select max(createTime) from JMJobInfoHistory WITH(READUNCOMMITTED)
where (flags & 1) > 0), 0)
	INSERT 	INTO #lt_JobHistory
	SELECT 	TOP (@l_MaxJobsToProcessInBatch) JobId, CommCellId, rstTaskId, flags, SIDBStoreId, state, createTime
	FROM	JMJobInfoHistory WITH(READUNCOMMITTED)
WHERE	(flags & 1) = 0
			AND createTime > @l_LastProcessedTime
	--We need rowCount to allocation memory for jobList so return rowCount in first row
	SELECT 	0, 0, 0, 0, 0, 0, 0, @@ROWCOUNT
	UNION ALL
	SELECT 	JobId, CommCellId, rstTaskId, flags, SIDBStoreId, state, createTime, 0
	FROM	#lt_JobHistory
END
IF @i_filter = 2
BEGIN
	INSERT 	INTO #lt_JobHistory
	SELECT 	JobId, CommCellid, rstTaskId, flags, SIDBStoreId, state, createTime
	FROM 	JMJobInfoHistory WITH(READUNCOMMITTED)
WHERE	(((flags & 2) > 0
				AND OpType in (31, 106)) --DV2
OR ((flags & 4) > 0
				AND OpType = 80)) --Recon
			AND SIDBStoreId > 0
	ORDER BY SIDBStoreId, createTime
	SELECT 	JobId, CommCellId, rstTaskid, flags, SIDBStoreId, state, createTime, 0
	FROM	#lt_JobHistory
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetFinishedJobList')
	delete from GxQscripts where name = 'JMGetFinishedJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetFinishedJobList')
	delete from GXDBVersions where aliasname = 'JMGetFinishedJobList'
GO

insert into GXDBVersions values(2, 'JMGetFinishedJobList',  '00010001000200050000', 'JMGetFinishedJobList', '00010001000200050000')
GO

