

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/AddAutoScaleClient.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/HistoryDB/Sp/AddAutoScaleClient.sp,v $ $Id: AddAutoScaleClient.sp,v 1.1.2.1 2019/04/30 03:03:30 ssanur Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AddAutoScaleClient"
--	|	Adds information about the given Auto Scale client into the History DB
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AddAutoScaleClient')
BEGIN
	print '>>> Drop Stored Procedure: AddAutoScaleClient <<<'
	drop procedure AddAutoScaleClient
END
IF EXISTS (select * from GxQscripts where name='AddAutoScaleClient')
	delete from GxQscripts where name = 'AddAutoScaleClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddAutoScaleClient')
	delete from GXDBVersions where aliasname = 'AddAutoScaleClient'
GO
print '... Creating Procedure: AddAutoScaleClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AddAutoScaleClient
-- Input arguments
  @i_clientId INT
AS
  DECLARE @o_xml XML
BEGIN TRY
	declare @errorCode   int = 0
    declare @errorString  nvarchar(1024) = 'Success'
	-------------Constansts as per Common.x ---------
    declare @WIN_OS int = 1
    declare @LINUX_OS int = 2
	-------------------------------------------------
	declare @instanceId int
	declare @osType int
	declare @osName nvarchar(255)
	declare @clientName nvarchar(1024)
	declare @creationTime dateTime
	-- First check if we already have recorded an entry for the given AutoScale client in the history table.
	-- If we have, just update the removal time. Otherwise insert a new entry into the history table
	if exists (select 1 from AutoScaleHistory where clientId = @i_clientId)
	begin
		update AutoScaleHistory set removalTime = GETUTCDATE() where clientId = @i_clientId
		goto ERROR_EXIT
	end
	select @clientName = name, @creationTime = CommServ.dbo.GetDateTime(refTime) from CommServ..App_client where id = @i_clientId
	if(@clientName is null)
	begin
		set @errorCode = -1
		set @errorString = 'Invalid client id ' + CAST(@i_clientId AS VARCHAR(16))
		goto ERROR_EXIT
	end
	select @instanceId = cast(CP.attrVal as int) from CommServ..APP_ClientProp CP
	inner join CommServ..App_client C on C.id = CP.componentNameId and CP.attrName = 'Virtual Machine Instance ID' and CP.modified = 0
	and C.id = @i_clientId
	set @osType = ( select case when OS.type = 'Windows' then  @WIN_OS else @LINUX_OS end
					from CommServ..App_client C
					inner join CommServ..simOperatingSystem OS on C.simOperatingSystemId = OS.id
					and C.id = @i_clientId)
	insert into AutoScaleHistory values (@i_clientId, @clientName, @instanceId, @osType, @creationTime, GETUTCDATE(), '')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
BEGIN
	SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                            FOR XML PATH('Ida_GenericResp'), TYPE)
END
select @o_xml as 'o_xml'
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AddAutoScaleClient')
	delete from GxQscripts where name = 'AddAutoScaleClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AddAutoScaleClient')
	delete from GXDBVersions where aliasname = 'AddAutoScaleClient'
GO

insert into GXDBVersions values(2, 'AddAutoScaleClient',  '00010001000200010000', 'AddAutoScaleClient', '00010001000200010000')
GO

