

--  ------------  Generated from [../../../Source/CommServer/HistoryDB/Sp/AUTOGetTestSets.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: spakhare
--	Date:   12/10/2018
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AUTOGetTestSets')
BEGIN
	print '>>> Drop Stored Procedure: AUTOGetTestSets <<<'
	drop procedure AUTOGetTestSets
END
IF EXISTS (select * from GxQscripts where name='AUTOGetTestSets')
	delete from GxQscripts where name = 'AUTOGetTestSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AUTOGetTestSets')
	delete from GXDBVersions where aliasname = 'AUTOGetTestSets'
GO
print '... Creating Procedure: AUTOGetTestSets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AUTOGetTestSets
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @appTypeId INT				= 0,
  @clientOSId INT				= 0,
  @releaseString nvarchar(256)	= NULL,
  @featureName nvarchar(256) 	= NULL,
  @addPropName nvarchar(256)	= NULL,
  @appVerName nvarchar(256)	= NULL,
  @idaInstanceType nvarchar(256)	= NULL,
  @idaInstanceVal INT				= 0
-----------------------------------------------------------
AS
SET NOCOUNT ON
	DECLARE @addPropId		INT = ISNULL((SELECT DISTINCT AddPropID FROM AUTO_AddProp WHERE AddPropName = @addPropName), 0)
	DECLARE @appVerID		INT = ISNULL((SELECT DISTINCT AppVersionID FROM AUTO_AppVersion WHERE AppVersionName = @appVerName), 0)
	IF object_id('tempdb.dbo.#testsetInfo') is not null
		DROP TABLE #testsetInfo
	CREATE TABLE #testsetInfo(TestsetID INT, DisplayName nvarchar(512), FeatureID INT, FeatureName nvarchar(512), AddPropID INT, AddPropName nvarchar(256),
	AppVersionID INT, AppVersionName nvarchar(256), OSID INT, OsName nvarchar(256))
	INSERT INTO #testsetInfo (TestsetID, DisplayName, FeatureID, FeatureName, AddPropID, AppVersionID, OSID, OsName)
	SELECT ts.TestsetID AS TestsetID, ts.DisplayName AS DisplayName, ts.FeatureID AS FeatureID, f.DisplayName AS FeatureName,
	ts.AddPropID AS AddPropID,  ts.AppVersionID AS AppVersionID, ts.OSID AS OSID, os.OSName AS OsName
	FROM AUTO_Testset ts
	INNER JOIN AUTO_TestsetSPMap tsm ON tsm.TestsetID = ts.TestsetID
	INNER JOIN AUTO_Feature f ON f.FeatureID = ts.FeatureID
	INNER JOIN AUTO_TestsetOS os ON os.OSID = ts.OSID
	WHERE (@appVerID = 0 OR ts.AppVersionID = @appVerID)
	AND (@addPropId = 0 OR ts.AddPropID = @addPropId)
	AND (COALESCE(tsm.ReleaseString, '') LIKE '%' + COALESCE(@releaseString, '') + '%')
	AND (COALESCE(f.DisplayName, '') LIKE '%' + COALESCE(@featureName, '') + '%')
	AND tsm.ReleaseString <> 'NA'
	IF (@clientOSId <> 0)
	BEGIN
		DELETE ts FROM #testsetInfo ts WHERE ts.OSID NOT IN (SELECT DISTINCT OSID FROM AUTO_SimOsTsMap WHERE SimOSID = @clientOSId)
	END
	UPDATE  ts
	SET ts.AddPropName = addProp.AddPropName
	FROM #testsetInfo ts
	INNER JOIN AUTO_AddProp addProp ON ts.AddPropID = addProp.AddPropID
	UPDATE  ts
	SET ts.AppVersionName = appVer.AppVersionName
	FROM #testsetInfo ts
	INNER JOIN AUTO_AppVersion appVer ON ts.AddPropID = appVer.AppVersionID
	IF (@appTypeId > 0)
	BEGIN
		DELETE ts FROM #testsetInfo ts WHERE ts.FeatureID NOT IN
		(SELECT DISTINCT FeatureID FROM AUTO_FeatureAppTypeMap WHERE AppTypeID = @appTypeId AND FeatureID = ts.FeatureID)
	END
	IF (@idaInstanceType IS NOT NULL)
	BEGIN
		DECLARE @idaInstanceId	INT = ISNULL((SELECT iDAInstanceID FROM AUTO_InstanceType WHERE iDAInstanceCategory = @idaInstanceType AND
											(iDAInstanceValue = @idaInstanceVal OR @idaInstanceVal = 0)), 0)
		DELETE ts FROM #testsetInfo ts WHERE ts.FeatureID NOT IN
		(SELECT DISTINCT FeatureID FROM AUTO_FeatureInstanceTypeMap WHERE FeatureID = ts.FeatureID AND iDAInstanceID = @idaInstanceId)
	END
	SELECT * FROM #testsetInfo ORDER BY DisplayName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AUTOGetTestSets')
	delete from GxQscripts where name = 'AUTOGetTestSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AUTOGetTestSets')
	delete from GXDBVersions where aliasname = 'AUTOGetTestSets'
GO

insert into GXDBVersions values(2, 'AUTOGetTestSets',  '00000000000000000000', 'AUTOGetTestSets', '00000000000000000000')
GO

