
DECLARE @errorMsg nvarchar(max) = 'Success'
DECLARE @errCode INT = 0, @rowCount INT

DECLARE @t INT =0, @param INT =0

IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DMCommand]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	SET @t = (select COUNT(*) from DMCommand WITH (NOLOCK) )
END

IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DMCommandParams]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	SET @param = (select COUNT(*) from DMCommandParams WITH (NOLOCK) )
END

PRINT 'Total rows in DMCommand '+ Convert(nvarchar(10),@t)
PRINT 'Total rows in DMCommandParams '+ Convert(nvarchar(10), @param)

IF @t = 0 GOTO _EXIT

DECLARE @CommandTbl TABLE ( oldcommandId INT, newcommandId INT)
DECLARE @ActionTbl TABLE (commandactionId INT, commandId INT)

BEGIN TRY
BEGIN TRAN
	-- insert into command table name will be command Id and actionName
	
	INSERT INTO DMCmd 
	( Name, Description, ClientType, Attribute, Status, Retention, CreateTime, ModifiedTime, CreatedBy, ModifiedBy, TaskId)
	OUTPUT Convert(INT, SUBSTRING(inserted.Name, 0, CHARINDEX('_',inserted.Name))), inserted.CommandId INTO @CommandTbl 
	SELECT CONVERT(NVARChAR(10),DC.CommandId)+'_'+DG.Name, '', DC.ClientType, DC.Attribute, 0, 
	DC.RetentionPeriod, DC.CreateTime, DC.ModifiedTime, DC.ModifiedBy, DC.ModifiedBy, 0 from DMCommand DC WITH(NOLOCK)
	INNER JOIN DMSearchCriteriaGroup DG WITH(NOLOCK) ON DG.Id = DC.ActionId

	SET @rowCount = @@ROWCOUNT
	IF ( @rowCount != @T)
	BEGIN
		SET @errorMsg = 'Failed to migrate . Only '+ Convert(nvarchar(10),@rowCount) +'migrated into command out of ' +Convert(nvarchar(10),@t)
		SET @errCode = -1
		GOTO _EXIT
	END
	PRINT 'Total inserted rows into DMCmd   ' + Convert(nvarchar(10),@rowCount )


	-- insert into command target table
	INSERT INTO DMCmdTarget 
	(CommandId, EntityID, EntityType, Attribute)
	SELECT CT.newcommandId, DC.OwnerId, DC.OwnerIdType, 0 from DMCommand DC WITH(NOLOCK)
	INNER JOIN @CommandTbl CT ON CT.oldcommandId = DC.CommandId

	SET @rowCount = @@ROWCOUNT
	IF ( @rowCount != @T)
	BEGIN
		SET @errorMsg = 'Failed to migrate . Only '+ Convert(nvarchar(10),@rowCount )+'migrated into DMCmdTarget out of ' +Convert(nvarchar(10),@t)
		SET @errCode = -1
		GOTO _EXIT
	END
	PRINT 'Total inserted rows into DMCmdTarget  ' + Convert(nvarchar(10),@rowCount )


	-- insert into command action table
	INSERT INTO DMCmdAction 
	(CommandId, ActionId, Attribute, Priority)
	OUTPUT INSERTED.CommandActionId, INSERTED.CommandId INTO @ActionTbl 
	SELECT CT.newcommandId, DC.ActionId, 0, 0 from DMCommand DC WITH(NOLOCK)
	INNER JOIN @CommandTbl CT ON CT.oldcommandId = DC.CommandId
	
	SET @rowCount = @@ROWCOUNT
	IF ( @rowCount != @T)
	BEGIN
		SET @errorMsg = 'Failed to migrate . Only '+ Convert(nvarchar(10),@rowCount) +'migrated into DMCmdAction out of ' +Convert(nvarchar(10),@t)
		SET @errCode = -1
		GOTO _EXIT
	END	
	PRINT 'Total inserted rows into DMCmdAction  ' + Convert(nvarchar(10),@rowCount )


	-- insert into command params table
	INSERT INTO DMCmdParams 
	(CommandActionId, ParamGuid, ParamValue, SavedTime)
	select A.commandactionId, DP.ParamGuid, DP.ParamValue, DC.ModifiedTime from DMCommandParams DP WITH(NOLOCK)
	INNER JOIN DMCommand DC WITH(NOLOCK) ON DC.CommandId = DP.CommandId
	INNER JOIN @CommandTbl CT ON CT.oldcommandId = DC.CommandId
	INNER JOIN @ActionTbl A ON A.commandId = CT.newcommandId
	
	SET @rowCount = @@ROWCOUNT
	IF ( @rowCount != @param)
	BEGIN
		SET @errorMsg = 'Failed to migrate . Only '+Convert(nvarchar(10), @rowCount) +'migrated into DMCmdParams out of ' +Convert(nvarchar(10),@param)
		SET @errCode = -1
		GOTO _EXIT
	END
	PRINT 'Total inserted rows into DMCmdParam  ' + Convert(nvarchar(10),@rowCount )

	-- insert into DMCmdRun table
	
	INSERT INTO DMCmdRun 
	(CommandId, RunTime, JobId, Status)
	SELECT CT.newcommandId, dbo.GetUnixTime(DC.ModifiedTime), 0, 0 from DMCommand DC WITH(NOLOCK)
	INNER JOIN @CommandTbl CT ON CT.oldcommandId = DC.CommandId

	SET @rowCount = @@ROWCOUNT
	IF ( @rowCount != @T)
	BEGIN
		SET @errorMsg = 'Failed to migrate . Only '+ Convert(nvarchar(10),@rowCount )+'migrated into DMCmdRun out of ' +Convert(nvarchar(10),@t)
		SET @errCode = -1
		GOTO _EXIT
	END
	PRINT 'Total inserted rows into DMCmdRun ' + Convert(nvarchar(10),@rowCount )
	
	delete from DMCommand
	delete from DMCommandParams
	
COMMIT TRAN
END TRY


BEGIN CATCH
	
	SET @errorMsg = ERROR_MESSAGE()
	ROLLBACK TRAN
END CATCH


_EXIT:
IF @errCode<> 0 
ROLLBACK TRAN

SELECT @errorMsg