-- Context needs to be set to DM2 by caller.

IF NOT EXISTS (SELECT * FROM sys.server_principals WHERE name = 'sqlexec_cv')
BEGIN
	PRINT 'Skip creation of sqlexec_cv user as login doesn''t exist'
	RETURN
END

IF EXISTS (SELECT * FROM sys.database_principals WHERE name = 'sqlexec_cv')
	DROP USER sqlexec_cv
IF EXISTS (SELECT * FROM sys.database_principals WHERE name = 'db_cvexecutor')
	DROP ROLE db_cvexecutor

CREATE ROLE db_cvexecutor
EXEC sp_addrolemember 'db_datareader', 'db_cvexecutor'
EXEC sp_addrolemember 'db_datawriter', 'db_cvexecutor'
GRANT EXECUTE on schema::dbo TO db_cvexecutor
	
CREATE USER sqlexec_cv FOR LOGIN sqlexec_cv
EXEC sp_addrolemember 'db_cvexecutor', 'sqlexec_cv'
EXEC sp_addrolemember 'db_ddladmin', 'sqlexec_cv'
