

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Upgrade/DMResultSet.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: DMResultSet.upg,v 1.23.2.3 2017/06/16 16:38:34 nramalingam Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'DMResultSet')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'DMResultSet')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'DMResultSet'							
  END																			
  IF (@oldRev = '1.16')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'DMResultSet' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'DMResultSet' +'].'							
  END--	 Get @oldRev, compare to '1.16'. Chk for work to do.

--+-----------------------------------+
--| Know we have to do an update,		|
--| ea. one has it's own rules!		|
--+-----------------------------------+
	IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DMResultSet]') and OBJECTPROPERTY(id, N'IsTable') = 1)

	BEGIN


IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DMResultSet]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	EXECUTE cvsp_drop_pk 'DMResultSet'
	DROP TABLE DMResultSet
END
IF EXISTS (SELECT * FROM GXDBVersions WHERE name = 'DMResultSet')
BEGIN
	DELETE FROM GXDBVersions where name = 'DMResultSet' and type = 1
END
    



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Tbl/DMResultSet.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Tbl/DMResultSet.tbl,v $ $Id: DMResultSet.tbl,v 1.15.2.1 2017/06/16 16:38:40 nramalingam Exp $";

print '... Creating Table: DMResultSet'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table DMResultSet (

	ResultSetID 					char(36)	NOT NULL,

	CommCellNumber 				int	NOT NULL,

	aFileID 							bigint	NOT NULL,

	aFileOffset 					bigint	NOT NULL,

	aFileLength 					bigint	NOT NULL,

	AppType 							int	NOT NULL,

	FileSizeKB 						bigint	NOT NULL,

	ModifiedTime 					datetime,

	JobId 								int	NOT NULL,

	OriginalFullPath				nvarchar(max) NOT NULL,

	DestinationPath				nvarchar(max) NOT NULL,

	CreateTime 						datetime,

	RestoreUserGUID 			char(36)	NOT NULL,

	RestoreCommCellNumber int	NOT NULL,

	RestoreJobID 					int	NOT NULL,

	RestoreStatus 				int	NOT NULL,

	RestoreTime 					datetime null,

	Attribute 						int	NOT NULL,

	PruneRequestTime 			datetime null,

	PruneUpdateTime 			datetime null,

	PruneStatus 					int null,

	OrigResultSetID 			char(36) null,

	documentID 						varchar(256)	NOT NULL,

	ClientID							int	NOT NULL,

	ERMStatus							int	NOT NULL,

	OwnerField				nvarchar(max)null,

	FromField				nvarchar(max)null,

	FolderPath				nvarchar(max)null,

	IndexGUID	varchar(128)	null,

	ID  int IDENTITY(1,1)NOT NULL,

	Title	nvarchar(1024) null,

	AppId	int 	DEFAULT 0	NOT NULL,





CONSTRAINT [PK_DMResultSet] PRIMARY KEY NONCLUSTERED(

[ResultSetID] ASC

)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]

 

 )  ON [PRIMARY]





create index IDX_DMResultSet_1 ON DMResultSet(aFileID, aFileOffset, CommCellNumber)

 

create index IDX_DMResultSet_2 ON DMResultSet(RestoreJobID)

 

CREATE NONCLUSTERED INDEX IDX_DMResultSet_6 ON DMResultSet([AppType]);



CREATE UNIQUE CLUSTERED INDEX IDX_DMResultSet_7_ID_CLUSTERED ON DMResultSet(ID);



CREATE NONCLUSTERED INDEX IDX_DMResultSet_IndexGUID ON DMResultSet(IndexGUID);



IF NOT EXISTS (SELECT * FROM systypes where name = ''DM2RestoreFileUpdateV2'')



BEGIN



CREATE TYPE DM2RestoreFileUpdateV2 AS TABLE



(



CCId int,



AFId bigint NULL,



mtime int,



turboGUID varchar(128) NULL,



OPath nvarchar(max) NULL,



DPath nvarchar(max) NULL,



status int



)



END



insert into GXDBVersions values(1, ''DMResultSet'',  ''1.15.2.1'', ''DMResultSet'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

-------------------------------------------------------------




')

	END

	ELSE

	BEGIN

		IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'ResultSet')

		BEGIN

			IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DMResultSetInfo]') and OBJECTPROPERTY(id, N'IsTable') = 1)

			BEGIN

				EXEC ('INSERT INTO DMResultSetInfo

						SELECT ResultSetID, ResultSet

						FROM DMResultSet'

					)

			END

			EXEC ('ALTER TABLE DMResultSet DROP COLUMN ResultSet')

		END

		dbcc dbreindex ('DMResultSet') 

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'OrigResultSetID')   

		BEGIN  

			ALTER TABLE DMResultSet ADD OrigResultSetID char(36) NULL

		END

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'documentID')   

		BEGIN  

			ALTER TABLE DMResultSet ADD documentID varchar(256) NOT NULL DEFAULT ''

		END

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'ClientID')   

		BEGIN  

			ALTER TABLE DMResultSet ADD ClientID int NOT NULL DEFAULT 0

		END

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'ERMStatus')   

		BEGIN  

			ALTER TABLE DMResultSet ADD ERMStatus int NOT NULL DEFAULT 0

		END

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'OwnerField')   

		BEGIN  

			ALTER TABLE DMResultSet ADD OwnerField NVARCHAR(MAX) NULL

		END

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'FromField')   

		BEGIN  

			ALTER TABLE DMResultSet ADD FromField NVARCHAR(MAX) NULL

		END

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'FolderPath')   

		BEGIN  

			ALTER TABLE DMResultSet ADD FolderPath NVARCHAR(MAX) NULL

		END

		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'IndexGUID')   

		BEGIN  

			ALTER TABLE DMResultSet ADD IndexGUID varchar(128) NULL

		END

		IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DMResultSet' AND COLUMN_NAME = 'IndexGUID' and CHARACTER_MAXIMUM_LENGTH = 36)

		BEGIN

			ALTER TABLE DMResultSet ALTER COLUMN IndexGUID varchar(128) NULL

		END

		IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IDX_DMResultSet_1') 

			DROP INDEX DMResultSet.IDX_DMResultSet_1

		CREATE INDEX IDX_DMResultSet_1 ON DMResultSet(aFileID, aFileOffset, CommCellNumber)

		IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IDX_DMResultSet_2') 

			DROP INDEX DMResultSet.IDX_DMResultSet_2

		CREATE INDEX IDX_DMResultSet_2 ON DMResultSet(RestoreJobID)

		IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IDX_DMResultSet_4') 

			DROP INDEX DMResultSet.IDX_DMResultSet_4		

		IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IDX_DMResultSet_5') 

			DROP INDEX DMResultSet.IDX_DMResultSet_5		

		IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IDX_DMResultSet_6') 

			DROP INDEX DMResultSet.IDX_DMResultSet_6

		CREATE NONCLUSTERED INDEX IDX_DMResultSet_6 ON DMResultSet([AppType]);

--new change to remove resultsetid as clustered primary key
--now unbound all foreign key with resultset, drop primary key , recreate as non-clustered primary key and rebound foreign keys
		IF NOT EXISTS(SELECT * FROM sys.columns where Name = N'ID'  

			and Object_ID = Object_ID(N'DMResultSet'))

		BEGIN

			IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS 

			    WHERE CONSTRAINT_NAME ='DMResultSetInfo_ResultSetID_FK')

			BEGIN

				ALTER TABLE dbo.DMResultSetInfo

				DROP CONSTRAINT DMResultSetInfo_ResultSetID_FK

			END

			IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS 

			    WHERE CONSTRAINT_NAME ='FK_DMContainerItem_DMResultSet')

			BEGIN

				ALTER TABLE dbo.DMContainerItem

				DROP CONSTRAINT FK_DMContainerItem_DMResultSet

			END

			IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS 

			    WHERE CONSTRAINT_NAME ='FK_DMUserItemTags_DMResultSet')

			BEGIN

				ALTER TABLE dbo.DMUserItemTags

				DROP CONSTRAINT FK_DMUserItemTags_DMResultSet

			END

			IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS 

			    WHERE CONSTRAINT_NAME ='FK_DMDownloadResultSet_DMResultSet')

			BEGIN

				ALTER TABLE dbo.DMDownloadResultSet

				DROP CONSTRAINT FK_DMDownloadResultSet_DMResultSet

			END

--drop primary key constraint
			IF EXISTS (SELECT * FROM sys.key_constraints WHERE type = 'PK'  AND name = 'PK_DMResultSet')

			BEGIN

				ALTER TABLE DMResultSet DROP CONSTRAINT PK_DMResultSet

			END

--ADD new column
			ALTER TABLE DMResultSet ADD ID  int IDENTITY(1,1) NOT NULL

			IF NOT EXISTS(SELECT * FROM sysindexes WHERE name = 'IDX_DMResultSet_7_ID_CLUSTERED')

				CREATE UNIQUE CLUSTERED INDEX IDX_DMResultSet_7_ID_CLUSTERED ON DMResultSet(ID)			

--create non-clustered primary key on resultsetID
			IF NOT EXISTS (SELECT * FROM sys.key_constraints WHERE type = 'PK'  AND name = 'PK_DMResultSet')

			BEGIN

				ALTER TABLE DMResultSet ADD CONSTRAINT PK_DMResultSet PRIMARY KEY NONCLUSTERED ([ResultSetID]) ON [PRIMARY] 

			END			

----rebuild foreign key index DMResultSEtinfo
			IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS 

				WHERE CONSTRAINT_NAME ='DMResultSetInfo_ResultSetID_FK')

			BEGIN

				ALTER TABLE DMResultSetInfo  ADD CONSTRAINT DMResultSetInfo_ResultSetID_FK  

				FOREIGN KEY (ResultSetId) REFERENCES DMResultSet (ResultSetId) on delete cascade

			END			

		END		

		IF NOT EXISTS(SELECT * FROM sys.columns where Name = N'Title'  

		    and Object_ID = Object_ID(N'DMResultSet'))

		BEGIN

			ALTER TABLE DMResultSet ADD Title nvarchar(1024) NULL

		END		

		IF NOT EXISTS(SELECT * FROM sys.columns where Name = N'AppId' and Object_ID = Object_ID(N'DMResultSet'))

		BEGIN

			ALTER TABLE DMResultSet ADD AppId int NOT NULL DEFAULT 0

		END	

		/*

		IF NOT EXISTS(SELECT * FROM sys.columns where Name = N'ComputedColumn'  

		    and Object_ID = Object_ID(N'DMResultSet'))

		BEGIN

			ALTER TABLE DMResultSet ADD ComputedColumn  AS CHECKSUM(aFileID,ISNULL(OriginalFullPath,'')) PERSISTED		

			IF NOT EXISTS(SELECT * FROM sysindexes WHERE name = 'IDX_DMResultSet_8')

				CREATE INDEX IDX_DMResultSet_8 ON DMResultSet(ComputedColumn)		

		END

		*/

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'DMResultSet' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'IDX_DMResultSet_IndexGUID')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'IDX_DMResultSet_IndexGUID' +']' + 'ON [' + 'DMResultSet' +']  (' + 'IndexGUID' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

--
--****** Remove duplicate entries (resultsetIds having the same index guid by keeping the row having latest arch file id ******
--execute other than 9.0
        IF EXISTS (SELECT status FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' AND status != 14)

			BEGIN

			if OBJECT_ID('tempdb..#DuplicateIndexGuids') IS NOT NULL 

				DROP TABLE #DuplicateIndexGuids

			CREATE TABLE #DuplicateIndexGuids

			(

				IndexGUID VARCHAR(128) NOT NULL,

				MaxAfileId INT NULL,

				FinalResultSetId CHAR(36) NULL,

				RowId INT IDENTITY(1,1) NOT NULL PRIMARY KEY

			);

			CREATE UNIQUE NONCLUSTERED INDEX IDX_DuplicateIndexGuids_Temp_IndexGUID on #DuplicateIndexGuids(IndexGUID)

			SET @sqlString = 'INSERT INTO #DuplicateIndexGuids (IndexGUID)

			SELECT IndexGuid FROM DMResultSet WHERE ISNULL(IndexGUID,'''') <> '''' GROUP BY IndexGUID HAVING COUNT(ResultSetID) > 1'

			SET @retCode = 0						

			EXEC sp_executesql @sqlString			

			SET @sqlError = @@error					

			IF (@sqlError <> 0)						

			BEGIN									

				PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						

				RETURN							

			END			

IF EXISTS (SELECT TOP 1 RowID FROM #DuplicateIndexGuids)--Dedupe if at least one duplicate exists
			BEGIN

--Delete all index from DMContainerItem so that we create temporary non unique index for ContainerID+ResultSetID combination
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'DMContainerItem' AND xType = 'U')				
  	IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'IDX_DMContainerItem_1')						
  	BEGIN																								
  	SET @sqlString = 'DROP INDEX [' + 'DMContainerItem' +'].[' + 'IDX_DMContainerItem_1' +']'							
  	IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'DMContainerItem' AND xType = 'U')				
  	IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'IDX_DMContainerItem_ContainerID_ResultSetID')						
  	BEGIN																								
  	SET @sqlString = 'DROP INDEX [' + 'DMContainerItem' +'].[' + 'IDX_DMContainerItem_ContainerID_ResultSetID' +']'							
  	IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'DMContainerItem' AND xType = 'U')				
  	IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'IDX_UQ_DMContainerItem_ContainerID_ResultSetID')						
  	BEGIN																								
  	SET @sqlString = 'DROP INDEX [' + 'DMContainerItem' +'].[' + 'IDX_UQ_DMContainerItem_ContainerID_ResultSetID' +']'							
  	IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'DMContainerItem' AND xType = 'U')				
  	IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'IDX_TMP_DMContainerItem_ContainerID_ResultSetID')						
  	BEGIN																								
  	SET @sqlString = 'DROP INDEX [' + 'DMContainerItem' +'].[' + 'IDX_TMP_DMContainerItem_ContainerID_ResultSetID' +']'							
  	IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

				CREATE NONCLUSTERED INDEX IDX_TMP_DMContainerItem_ContainerID_ResultSetID ON DMContainerItem([ContainerID], [ResultSetID]) 

				UPDATE #DuplicateIndexGuids 

				SET MaxAfileId = T.MaxAFID, FinalResultSetId = T2.ResultSetID

				FROM #DuplicateIndexGuids g 

				INNER JOIN 

				(

					select g1.IndexGUID as IndexGUID, max(r.aFileID) as MaxAFID from DMResultSet r 

					inner join #DuplicateIndexGuids g1 on r.IndexGUID = g1.IndexGUID 

					group by g1.IndexGUID

				) T

				on T.IndexGUID = g.IndexGUID

				inner join DMResultSet T2 on T2.IndexGUID = T.IndexGUID and T2.aFileID = T.MaxAFID;

				if OBJECT_ID('tempdb..#ResultSetIdsToDelete') is not null 

				drop table #ResultSetIdsToDelete

				create table #ResultSetIdsToDelete

				(

					ResultSetID char(36) not null primary key,	

					AfId bigint null,

					AfOf bigint null,

					DocId varchar(256) null,

					IndexGUID varchar(128) not null

				);

				SET @sqlString = ' insert into #ResultSetIdsToDelete(ResultSetID, AfId, AfOf, DocId, IndexGUID)

									select r.ResultSetID, r.aFileID, r.aFileOffset, r.documentID, r.IndexGUID from DMResultSet r

									inner join #DuplicateIndexGuids d on d.IndexGUID = r.IndexGUID and ((r.aFileID < d.MaxAfileId) or (r.aFileID = d.MaxAFileId and r.ResultSetID != d.FinalResultSetID))'

				SET @retCode = 0						

				EXEC sp_executesql @sqlString			

				SET @sqlError = @@error					

				IF (@sqlError <> 0)						

				BEGIN									

					PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						

					RETURN							

				END	

--Audit the actions before we delete anything else we wont have the data in the table to audit
				DECLARE @rowId bigint

				DECLARE @maxRowId bigint

				DECLARE @eventType int = 8

				DECLARE @paramId int = 17

				DECLARE @increment int = 1000

				select @rowId = 1, @maxRowId = max(RowId) from  #DuplicateIndexGuids

				while (@rowId <  @maxRowId)

				begin

					declare @auditInfo xml		

					set @auditInfo = 

					(

					select ResultSet.*, RootResultSet.FinalResultSetId as ReplacedByResultSetId, Container.ContainerID  from #ResultSetIdsToDelete ResultSet

					inner join #DuplicateIndexGuids RootResultSet on RootResultSet.IndexGUID = ResultSet.IndexGUID

					left outer join DMContainerItem Container on Container.ResultSetID = ResultSet.ResultSetID		

					where 	

					ResultSet.ResultSetID <> RootResultSet.FinalResultSetId and

					RootResultSet.RowId >= @rowId and RootResultSet.RowId < (@rowId + @increment)

					for xml auto

					);

					if @auditInfo is not null 

					begin	

						declare @timestamp datetime = GetUtcDate();

						insert into DMAction(EventType, UserGuid, UserName, ContainerGuid, CreateTime, Attribute, reuseRequestId)

						select @eventType, '00000000-0000-0000-0000-000000000000', 'Upgrade', null, @timestamp, 0, null  

						declare @eventId bigint = @@IDENTITY

						insert into DMActionParam(refEventId, ParamId, ParamValue)

						select @eventId, @paramId, cast(@auditInfo as nvarchar(max))

					end

					set @rowId = @rowId + @increment;	

				end	

				delete DMEmailResult from DMEmailResult i inner join #ResultSetIdsToDelete d on d.ResultSetId = i.ResultSetId

				delete DMUserItemTags from DMUserItemTags i inner join #ResultSetIdsToDelete d on d.ResultSetId = i.ResultSetId

--if the turbo guids are the same per container, we update rows in DMContainerItemStates table
--with the one that we leave behind in DMContainerItem table
				update DMContainerItemStates set ResultSetID = d.FinalResultSetId from DMContainerItemStates i

				inner join DMResultSet r on r.ResultSetID = i.ResultSetID

				inner join #DuplicateIndexGuids d on d.IndexGUID = r.IndexGUID;

--We want to keep just one row per container if they are duplicates.
				update DMContainerItem set ResultSetID = d.FinalResultSetId from DMContainerItem i

				inner join DMResultSet r on r.ResultSetID = i.ResultSetID

				inner join #DuplicateIndexGuids d on d.IndexGUID = r.IndexGUID;

				SET @sqlString = 'DELETE dt

								FROM (SELECT

									ROW_NUMBER() OVER (PARTITION BY ContainerID, ResultSetID ORDER BY ID ASC) AS ''RowNumber''

									FROM DMContainerItem) dt

								WHERE RowNumber > 1'			

				SET @retCode = 0						

				EXEC sp_executesql @sqlString			

				SET @sqlError = @@error					

				IF (@sqlError <> 0)						

				BEGIN									

					PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						

					RETURN							

				END	

--We will update with recent most item by turboGUID, this can contain duplicates and it wont be cleanedup now.
				update DMDownloadResultSet set ResultSetID = d.FinalResultSetId from DMDownloadResultSet i

				inner join DMResultSet r on r.ResultSetID = i.ResultSetID

				inner join #DuplicateIndexGuids d on d.IndexGUID = r.IndexGUID;

--Clean up of child tables
				delete DMResultSetInfo from DMResultSetInfo i inner join #ResultSetIdsToDelete d on d.ResultSetId = i.ResultSetId			

				delete DMActionItemMap from DMActionItemMap i inner join #ResultSetIdsToDelete d on d.ResultSetId = i.ResultSetId			

				delete DMResultSet from DMResultSet r inner join #ResultSetIdsToDelete d on d.ResultSetId = r.ResultSetId

--Dropping temporary non unique index.
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'DMContainerItem' AND xType = 'U')				
  	IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'IDX_TMP_DMContainerItem_ContainerID_ResultSetID')						
  	BEGIN																								
  	SET @sqlString = 'DROP INDEX [' + 'DMContainerItem' +'].[' + 'IDX_TMP_DMContainerItem_ContainerID_ResultSetID' +']'							
  	IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

--if this file is patched separately, and this index would get deleted but not created by DMContainerItem(since it wont be part of the form). so we create it here
				IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IDX_UQ_DMContainerItem_ContainerID_ResultSetID')					

				BEGIN																								

					CREATE UNIQUE NONCLUSTERED INDEX IDX_UQ_DMContainerItem_ContainerID_ResultSetID ON DMContainerItem([ContainerID], [ResultSetID])

					INCLUDE ([CreateTime],[Attribute])

				END

			end

		END

--****** Finish duplicate row removal ******
		dbcc dbreindex ('DMResultSet') 

		IF NOT EXISTS (SELECT * FROM systypes where name = 'DM2RestoreFileUpdateV2')

		BEGIN

			CREATE TYPE DM2RestoreFileUpdateV2 AS TABLE

			(			

			  CCId int,

			  AFId bigint NULL,

			  mtime int,

			  turboGUID varchar(128) NULL,

			  OPath nvarchar(max) NULL,

			  DPath nvarchar(max) NULL,

			  status int

			)

		END

	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'DMResultSet')			
  			insert into GXDBVersions VALUES(1, 'DMResultSet', '0.0', 'DMResultSet', '')	
  			UPDATE GXDBVersions SET revision = '1.16' WHERE name = 'DMResultSet'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'DMResultSet' + '] upgraded successfully to '			+ ' revision [' + '1.16' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'DMResultSet' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return

END

GO
IF @@error <> 0 RETURN
GO
