SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSetting.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSetting.script,v $ $Id: DMSetting.script,v 1.36 2015/06/15 10:35:05 pankajkumar Exp $";
-- TABLENAME DMSetting

print '... inserting Table: DMSetting'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSetting

DECLARE @IsReleaseUpgrade INT = 0

DECLARE @isUpgradeFromRel9 integer = 0

SELECT @isUpgradeFromRel9  = (CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END) FROM DBUpgradeSteps 

WHERE Step = "UpgradeFromRelease" AND CAST(Status AS INTEGER) IN (14) 

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = "UpgradeType" AND CAST(Status AS INTEGER) = 1)

BEGIN

	SET @IsReleaseUpgrade = 1

END

IF @IsReleaseUpgrade = 1

BEGIN

	IF NOT EXISTS (SELECT TOP 1 * FROM DMSetting WHERE SettingName = (SELECT TOP 1 'IS_UPGRADE_TO_'+release FROM simAllGalaxyRel ORDER BY id desc))

	BEGIN
		INSERT INTO DMSetting 


		SELECT TOP 1 'IS_UPGRADE_TO_'+release as SettingName, 'True', getDate() FROM simAllGalaxyRel

		ORDER BY id desc

	END

END

--With release upgrade from 9.0 then we will have search by tags option assuming that they could have FAST engine where search by tags feature is needed.

--Upgrading from 10.0, if the customer upgraded from 9.0, then anyway they would have that entry already and need not worry.

IF @isUpgradeFromRel9 = 1

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SEARCH_BY_TAGS')

	BEGIN
		INSERT INTO DMSetting VALUES ('SEARCH_BY_TAGS', 'True', getDate())


	END

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_EXPORT_TO_PST_FOR_ENDUSER')

BEGIN

	DELETE FROM DMSetting WHERE SettingName = 'ALLOW_EXPORT_TO_PST_FOR_ENDUSER'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Queries_retention_in_days_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Queries_retention_in_days_per_user'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Result_sets_retention_in_days_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Result_sets_retention_in_days_per_user'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disk_space_quota_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Disk_space_quota_per_user'	

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Results_retention_in_days_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName ='DEFAULT_Results_retention_in_days_per_user'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_LEGALHOLD_DELETION')

BEGIN
	INSERT INTO DMSetting VALUES ('ALLOW_LEGALHOLD_DELETION', 'TRUE', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_CISERVER_TAGGING')

BEGIN
	INSERT INTO DMSetting VALUES ('ALLOW_CISERVER_TAGGING', 'TRUE', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'excludeWellKnownSids')

BEGIN
	INSERT INTO DMSetting VALUES ('excludeWellKnownSids', '64', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'InstanceName')

BEGIN
	INSERT INTO DMSetting VALUES ('InstanceName', 'Instance001', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'MAX_FILE_SIZE_FOR_DOWNLOAD')

BEGIN
	INSERT INTO DMSetting VALUES ('MAX_FILE_SIZE_FOR_DOWNLOAD', '209715200', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'MaxDynTeaserLength')

BEGIN
	INSERT INTO DMSetting VALUES ('MaxDynTeaserLength', 512, getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'MaxSubjectLineLength')

BEGIN
	INSERT INTO DMSetting VALUES ('MaxSubjectLineLength', 512, getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_queries_per_user')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Max_number_of_queries_per_user', '100', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = '100'

	WHERE SettingName = 'DEFAULT_Max_number_of_queries_per_user'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_result_sets_per_user')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Max_number_of_result_sets_per_user', '500', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = '500'

	WHERE SettingName = 'DEFAULT_Max_number_of_result_sets_per_user'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_results_per_search')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_results_per_search'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_result_set')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Number_of_results_per_page_in_result_set', 10, getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 10

	WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_result_set'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_Search_results')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Number_of_results_per_page_in_Search_results', 10, getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 10

	WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_Search_results'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Switch_to_Review_set_upon_item_add')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Switch_to_Review_set_upon_item_add', 'On', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'On'

	WHERE SettingName = 'DEFAULT_Switch_to_Review_set_upon_item_add'

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Hide_Visible_File_Advanced_search_tabs')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Show_File_Advanced_search_tabs',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Hide_Visible_File_Advanced_search_tabs'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Show_File_Advanced_search_tabs')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Show_File_Advanced_search_tabs', 'True', getDate())

	END

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Hide_Visible_Email_Advanced_search_tabs')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Show_Email_Advanced_search_tabs',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Hide_Visible_Email_Advanced_search_tabs'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Show_Email_Advanced_search_tabs')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Show_Email_Advanced_search_tabs', 'True', getDate())

	END

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_End_user_based_security')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_End_user_based_security', 'Based on recipients', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'Based on recipients'

	WHERE SettingName = 'DEFAULT_End_user_based_security'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Default_search_tab_to_show')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Default_search_tab_to_show', 'All', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'All'

	WHERE SettingName = 'DEFAULT_Default_search_tab_to_show'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_Document_Highlighting')

BEGIN
	INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) VALUES ('DEFAULT_Enable_Document_Highlighting', 'On', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'On'

	WHERE SettingName = 'DEFAULT_Enable_Document_Highlighting'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Allow_emails_export_to_PST')

BEGIN
	INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) VALUES ('DEFAULT_Allow_emails_export_to_PST', 'Off', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'Off'

	WHERE SettingName = 'DEFAULT_Allow_emails_export_to_PST'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_End_User_Setting')

BEGIN
	INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) VALUES ('DEFAULT_Disable_End_User_Setting', 'False', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'False'

	WHERE SettingName = 'DEFAULT_Disable_End_User_Setting'

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_Search_Option')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Enable_Search_Option',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Disable_Search_Option'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_Search_Option')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Enable_Search_Option', 'True', getDate())

	END

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_Browse_Option')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Enable_Browse_Option',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Disable_Browse_Option'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_Browse_Option')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Enable_Browse_Option', 'True', getDate())

	END

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_MyContents_Option')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Enable_MyContents_Option',

		SettingValue = 'False'

	WHERE SettingName = 'DEFAULT_Disable_MyContents_Option'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_MyContents_Option')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Enable_MyContents_Option', 'False', getDate())

	END

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DOC_ONLINE_URL')

BEGIN
	INSERT INTO DMSetting


	SELECT 'DOC_ONLINE_URL' AS SettingName, 'http://documentation.commvault.com/commvault/release_8_0_0//books_online_1/english_us/prod_info/ci_search.htm' AS SettingValue, GetDate()

END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'https://search.commvault.com/docsearch/searchHandler?wt=rss&release=v11'

	WHERE SettingName = 'DOC_ONLINE_URL'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'USE_ONLINE_DOC_URL')

BEGIN
	INSERT INTO DMSetting


	SELECT 'USE_ONLINE_DOC_URL' AS SettingName, 'False' AS SettingValue, GetDate()

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_SUCCESS')

BEGIN
	INSERT INTO DMSetting


	SELECT 'CI_STATE_SUCCESS' AS SettingName, '0,1,12,13,14,15,1014' AS SettingValue, GetDate()

END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = '0,1,12,13,14,15,1014' WHERE SettingName = 'CI_STATE_SUCCESS'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_DELETED')

BEGIN
	INSERT INTO DMSetting


	SELECT 'CI_STATE_DELETED' AS SettingName, '3333' AS SettingValue, GetDate()

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_FAILED')

BEGIN
	INSERT INTO DMSetting


	SELECT 'CI_STATE_FAILED' AS SettingName, '2,16,1016,2016' AS SettingValue, GetDate()

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DM2_DATABASE_ID')

BEGIN
	INSERT INTO DMSetting VALUES ('DM2_DATABASE_ID', newId(), getDate())


END

ELSE

BEGIN

	IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DM2_DATABASE_ID' AND LEN(SettingValue) <> 36)

	BEGIN

		UPDATE DMSetting SET SettingValue = newId() WHERE SettingName = 'DM2_DATABASE_ID'

	END

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CHUNK_SIZE')

BEGIN
	INSERT INTO DMSetting VALUES ('CHUNK_SIZE', '3145728', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'JOB_STATUS_PAGE_SIZE')

BEGIN
	INSERT INTO DMSetting VALUES ('JOB_STATUS_PAGE_SIZE', '25', getDate())


END

-- Number of minutes for session time out.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SESSION_TIME_OUT')

BEGIN
	INSERT INTO DMSetting VALUES ('SESSION_TIME_OUT', '30', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'PRELOGIN_BANNER_ENABLED')

BEGIN
	INSERT INTO DMSetting VALUES ('PRELOGIN_BANNER_ENABLED', 'False', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'PRELOGIN_BANNER_TEXT')

BEGIN
	INSERT INTO DMSetting VALUES ('PRELOGIN_BANNER_TEXT', '', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DISABLE_EMPTYKEYWORD_SEARCH_ENDUSER')

BEGIN
	INSERT INTO DMSetting VALUES ('DISABLE_EMPTYKEYWORD_SEARCH_ENDUSER', 'True', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DISABLE_EMPTYKEYWORD_SEARCH_COMPUSER')

BEGIN
	INSERT INTO DMSetting VALUES ('DISABLE_EMPTYKEYWORD_SEARCH_COMPUSER', 'True', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_RESULTS_GROUPING')

BEGIN
	INSERT INTO DMSetting VALUES ('ALLOW_RESULTS_GROUPING', 'True', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting SET SettingValue='True' WHERE SettingName = 'ALLOW_RESULTS_GROUPING'

END

-- -- only possible values as of now: modifiedUTCTime, rank.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_SEARCH_SORT_ORDER')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_SEARCH_SORT_ORDER', 'modifiedUTCTime', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'PERFORM_DATETIME_LOCAL_SORT')

BEGIN
	INSERT INTO DMSetting VALUES ('PERFORM_DATETIME_LOCAL_SORT', 'False', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SIZE_IN_GB')

BEGIN
	INSERT INTO DMSetting VALUES ('SIZE_IN_GB', '4', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'AUTO_EDRM_UPON_DOWNLOAD')

BEGIN
	INSERT INTO DMSetting VALUES ('AUTO_EDRM_UPON_DOWNLOAD', 'False', getDate())


END

-- VALUES CAN BE SYNC_ONLY_TURBO, SYNC_ALL, SYNC_FORCE_ALL or SYNC_NEVER. Default will be SYNC_ONLY_TURBO as the feature is now (Jun18-2012) integrated.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'RESTORE_OFFSET_SYNC_OPTION')

BEGIN
	INSERT INTO DMSetting VALUES ('RESTORE_OFFSET_SYNC_OPTION', 'SYNC_ONLY_TURBO', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_SKIPPED')

BEGIN
	INSERT INTO DMSetting VALUES ('CI_STATE_SKIPPED','17', getDate())


END

--Number of hours after which we decide to sync with indexing layer again if needed for turbo.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'INDEX_SYNC_INTERVAL')

BEGIN
	INSERT INTO DMSetting VALUES ('INDEX_SYNC_INTERVAL','24', getDate())


END

--IF solr is slow on returning aFileId facets, then we can set this True. This way, instead of finding facets on entire search request, we will take distinct aFileId in each page of results and check if it is marked for pruning

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SKIP_SEARCH_SYNC_PREP_PHASE')

BEGIN
	INSERT INTO DMSetting VALUES ('SKIP_SEARCH_SYNC_PREP_PHASE','False', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'EmailQueryWithCopyField')

BEGIN
	INSERT INTO DMSetting VALUES ('EmailQueryWithCopyField','True', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting 

	SET SettingValue = 'True'

	WHERE SettingName = 'EmailQueryWithCopyField'

END

IF NOT EXISTS(SELECT * FROM DMSETTING WHERE settingname = 'ENABLE_TURBO_GUID_CHECK_IN_RESTORE')

BEGIN
    INSERT INTO DMSETTING VALUES ('ENABLE_TURBO_GUID_CHECK_IN_RESTORE', 'True', GETDATE())


END 

GO



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSearchView.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSearchView.script,v $ $Id: DMSearchView.script,v 1.4 2014/04/09 06:26:42 jjindal Exp $";
-- TABLENAME DMSearchView

print '... inserting Table: DMSearchView'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSearchView

IF NOT EXISTS (SELECT * FROM DMSearchView WHERE ViewName = 'EndUser') 

BEGIN
	INSERT INTO DMSearchView VALUES('63DE0B7A-890A-400D-B3A2-A6630FA362BC', '1', 'EndUser', NULL)


END

IF NOT EXISTS (SELECT * FROM DMSearchView WHERE ViewName = 'Compliance') 

BEGIN
	INSERT INTO DMSearchView VALUES('E2E3732B-3887-4C49-A23B-EBCCDDD25D9C', '2', 'Compliance', NULL)


END

IF NOT EXISTS (SELECT * FROM DMSearchView WHERE ViewName = 'Admin') 

BEGIN
	INSERT INTO DMSearchView VALUES('F616F34C-EE57-4B2B-926D-FFF77A34DA00', '4', 'Admin', NULL)


END

IF NOT EXISTS (SELECT * FROM DMSearchView WHERE ViewName = 'WebConsole') 

BEGIN                       
    INSERT INTO DMSearchView VALUES('71A330BD-598F-4E64-8DCC-A60DCFA504EC', '8', 'WebConsole', NULL)


END


GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMIndexProfile.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMIndexProfile.script,v $ $Id: DMIndexProfile.script,v 1.20 2015/03/20 16:11:05 sgolla Exp $";
-- TABLENAME DMIndexProfile

print '... inserting Table: DMIndexProfile'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMIndexProfile

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'jid') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('jid', 'Integer', NULL, '8CB775C7-DCD6-442A-9654-8F76F1B81085', 'JOBID')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '6853A667-16FE-4059-9D2B-0A3EC8D55E6C') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('cijid', 'Integer', NULL, '6853A667-16FE-4059-9D2B-0A3EC8D55E6C', 'CIJOBID')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'cistate') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('cistate', 'Boolean', NULL, '51B78AEE-D39C-4211-A9A4-C13C133989B8', 'CISTATE')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'tags') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('tags', 'string', NULL, '1FD392EA-CCE8-4E2E-B5EF-4F610674A39D', 'TAGS')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'atyp') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('atyp', 'Integer', NULL, '5E485707-3B70-4E84-AC7B-57CFD0CF6BB5', 'APPTYPE')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'clid') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('clid', 'Integer', NULL, '3FA3C61D-6BB9-454B-97C6-AB0296818F93', 'CLIENTID')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'ccn') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('ccn', 'Integer', NULL, '3CD8AF87-EFF2-4C1A-8CE6-6181070A5216', 'COMMCELLNO')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'from') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('from', 'string', NULL, 'B7339D34-B8CA-42F0-9F38-4F9E995D4FDD', 'EMAIL_FROM')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'to') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('to', 'string', NULL, 'D9F2BD51-6989-401F-AD4E-B90E25D55E10', 'EMAIL_TO')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'cc') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('cc', 'string', NULL, 'C42A87D5-B05F-4141-8E90-4800740F17CC', 'EMAIL_CC')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '9A77953C-5D7D-457E-A91D-F99D5B8F6B80') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('bcc_admin', 'string', NULL, '9A77953C-5D7D-457E-A91D-F99D5B8F6B80', 'EMAIL_BCC_ADMIN')

END

ELSE 

BEGIN

	UPDATE DMIndexProfile 

    SET FriendlyName = 'EMAIL_BCC_ADMIN', FieldName = 'bcc_admin'

    WHERE FieldId = '9A77953C-5D7D-457E-A91D-F99D5B8F6B80'

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'conv') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('conv', 'string', NULL, '356AE1FD-2E73-452C-AEA8-F810E4B64680', 'EMAIL_SUBJECT')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '3BD0DCF2-F8C5-40DB-A885-D45AAE6058AE') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('xheader', 'string', NULL, '3BD0DCF2-F8C5-40DB-A885-D45AAE6058AE', 'EMAIL_HEADER')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'rclst') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('rclst', 'string', NULL, 'ECC4D349-EA92-496E-BFDE-E9DB1CBC24A5', 'EMAIL_RECIPIENTLIST')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'attname') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('attname', 'string', NULL, '28F07AC4-C45B-40BF-836E-0839611EA9E3', 'EMAIL_ATTACHMENTNAME')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'folder') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('folder', 'string', NULL, '308E3142-410E-4FFC-8DF6-87B7329DD2AC', 'FOLDER')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '6752A491-DD0A-4E7F-88BB-E0F34D2F64D2') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName)  


	VALUES ('mtm', 'Time', NULL, '6752A491-DD0A-4E7F-88BB-E0F34D2F64D2', 'MODIFIEDTIME')

END

ELSE

BEGIN

	UPDATE DMIndexProfile SET FriendlyName = 'MODIFIEDTIME' WHERE FieldId = '6752A491-DD0A-4E7F-88BB-E0F34D2F64D2'

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'szkb') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('szkb', 'Integer', NULL, 'E78FDA34-00A0-45FB-BD6C-C0858538338F', 'SIZEINKB')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'cvowner') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('cvowner', 'string', NULL, 'C4BF316A-13A4-4BBD-91A4-BA7FA8A81AD0', 'OWNER')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldName = 'bktm') 

BEGIN
	INSERT INTO DMIndexProfile (FieldId, FieldName, FriendlyName, DataType, Description)


	VALUES( 'B0B07085-AC4D-4871-A842-983262C48460', 'bktm', 'BACKUPTIME', 'Time', 'Job backup date time')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '5300188A-991E-4B23-A135-EA022C95EE7C')

BEGIN
	INSERT INTO DMIndexProfile (FieldId, FieldName, FriendlyName, DataType, Description)


	SELECT '5300188A-991E-4B23-A135-EA022C95EE7C' AS FieldId,'idxLemma','ENABLE_LEMMATIZATION','string' as DataType, NULL as Description

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '81AAA9A8-1856-4F74-8466-719C38F3ADB4')

BEGIN
	INSERT INTO DMIndexProfile (FieldId, FieldName, FriendlyName, DataType, Description)


	SELECT '81AAA9A8-1856-4F74-8466-719C38F3ADB4' AS FieldId,'duplicates','ENABLEDUPLICATEITEMREMOVAL','string' as DataType, NULL as Description

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '366B534E-3AB2-4AC4-971E-24A69530C555')

BEGIN
	INSERT INTO DMIndexProfile (FieldId, FieldName, FriendlyName, DataType, Description)


	SELECT '366B534E-3AB2-4AC4-971E-24A69530C555' AS FieldId,'idxLang','LANGUAGE','string' as DataType, NULL as Description

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '2B18B200-CC46-45C5-A0B8-491374CF0865')

BEGIN
	INSERT INTO DMIndexProfile (FieldId, FieldName, FriendlyName, DataType, Description)


	SELECT '2B18B200-CC46-45C5-A0B8-491374CF0865' AS FieldId,'idxSynonym','ENABLE_SYNONYM','string' as DataType, NULL as Description

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '32155C68-736D-4421-94EC-988E3A66B24F') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName)  


	VALUES ('mtm', 'Time', NULL, '32155C68-736D-4421-94EC-988E3A66B24F', 'EMAIL_RECEIVED_TIME')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '5064AEBE-8904-4509-A1F7-0D8A63B3C4EF') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName)  


	VALUES ('url', 'string', NULL, '5064AEBE-8904-4509-A1F7-0D8A63B3C4EF', 'CI_URL')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = 'EC83FD66-559A-4FD7-93CD-7D8CB335B835') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName) 


	VALUES ('idxSortBy', 'string', NULL, 'EC83FD66-559A-4FD7-93CD-7D8CB335B835', 'SORT_BY')

END

IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '2E4FAEF2-4D45-40BD-B434-079760098D7C') 

BEGIN
	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName)


	VALUES ('idxSrtOdr', 'string', NULL, '2E4FAEF2-4D45-40BD-B434-079760098D7C', 'SORT_ORDER')

END

-- This is reservation for Freddie Mac customer Delivered Time requirement of email grid (Do not remove this)

--IF NOT EXISTS (SELECT * FROM DMIndexProfile WHERE FieldId = '8CB3016B-1782-4338-A07D-F794FE2473E0') 

--BEGIN

--	INSERT INTO DMIndexProfile (FieldName, DataType, Description, FieldId, FriendlyName)  

--	VALUES ('emailmtm', 'Time', 'Email delivered time', '8CB3016B-1782-4338-A07D-F794FE2473E0', 'DELIVEREDTIME')

--END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSearchCriteriaGroup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSearchCriteriaGroup.script,v $ $Id: DMSearchCriteriaGroup.script,v 1.23 2012/10/10 17:45:48 sgolla Exp $";
-- TABLENAME DMSearchCriteriaGroup

print '... inserting Table: DMSearchCriteriaGroup'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSearchCriteriaGroup

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 3) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup VALUES('3', 'Common', 'AND', 'AND', '3', 'F394578D-E453-44A9-BD22-90BE4178E607', 13)


END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET InterFieldOperators = 'AND', DisplayOrder = 13

	WHERE Id = 3

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 1) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup VALUES('1', 'Email', 'AND,OR', 'AND,OR', '3', 'FEE4731E-E25C-4008-B11B-9DDE89225721', 1)


END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET InterFieldOperators = 'AND,OR', DisplayOrder = 1

	WHERE Id = 1

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 2) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup VALUES('2', 'File', 'AND,OR', 'AND,OR', '3', '49400BBD-7756-4D08-905A-ADA4CFBC0A55', 3)


END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET InterFieldOperators = 'AND,OR', DisplayOrder = 3

	WHERE Id = 2

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 4) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup VALUES('4', 'Discovery', 'AND,OR', 'OR,AND', '2', 'B18CDAC0-0B35-4DEE-A541-20A5524D95D0', 5)


END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET IntraGroupOperators = 'AND,OR', InterFieldOperators = 'OR,AND', BitVisibility = 2, DisplayOrder = 5

	WHERE Id = 4

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 5) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup VALUES('5', 'Client', 'OR', 'AND', '3', '28B61FB6-51C8-4D98-A7CC-FF3684B626E1', 7)


END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 7

	WHERE Id = 5

END	

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 6)

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)


	SELECT 6 as Id, 'Search Options' as Name, '' AS IntraGroupOperators, '' AS InterFieldOperators, 3 AS BitVisibility, '118B733C-5414-46AB-92F3-944ACB22839F' AS GroupGuid, 17 AS DisplayOrder

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 17

	WHERE Id = 6

END	

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 7)

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)


	SELECT 7 as Id, 'Summary' as Name, '' AS IntraGroupOperators, '' AS InterFieldOperators, 3 AS BitVisibility, '0888A786-3E6B-4853-B2C2-37843FE0C98E' AS GroupGuid, 19 AS DisplayOrder

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 19

	WHERE Id = 7

END	

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 8)

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)


	SELECT 8 as Id, 'Entities' as Name, '' AS IntraGroupOperators, '' AS InterFieldOperators, 0 AS BitVisibility, '16C14E98-406F-4EE4-8B66-377D59605626' AS GroupGuid, 15 AS DisplayOrder

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET IntraGroupOperators = '', InterFieldOperators = '', DisplayOrder = 8, BitVisibility = 0

	WHERE Id = 15

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 9) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)  


        VALUES ('9', 'AdminPreference', '', '', '4', 'C6141918-E852-4A67-801E-43E8F8A88309',0)

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 0

	WHERE Id = 9

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 10) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)


	SELECT '10' as Id, 'Views' as Name, '' AS IntraGroupOperators, '' AS InterFieldOperators, '0' AS BitVisibility, 'FA11518C-31DD-48F6-A2F5-A007EFC8CE25' AS GroupGuid,0 AS DisplayOrder

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 0

	WHERE Id = 10

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 11) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid,DisplayOrder)


	VALUES ('11','CustomPreference','','','4','099205CC-1014-46EE-8AD3-09FF1514B236',0)

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 0

	WHERE Id = 11

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 12) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)


	VALUES ('12','Keyword','','','3','7CA2D750-4D33-4DFF-B9BA-1DD79644EDCA', 9)

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 9

	WHERE Id = 12

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 13) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)


	VALUES('13', 'Query Builder', '', '', '2', 'A6CD6CFC-01D8-4FA0-8559-FCB47C5983A9', 11)

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 11

	WHERE Id = 13

END

IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Id = 14) 

BEGIN
	INSERT INTO DMSearchCriteriaGroup (Id, Name, IntraGroupOperators, InterFieldOperators, BitVisibility, GroupGuid, DisplayOrder)


	VALUES (14,'Delegates','','',1,'6B435DF7-613B-4343-BA97-31F27CE8518C', 14)

END

ELSE

BEGIN

	UPDATE DMSearchCriteriaGroup 

	SET DisplayOrder = 14, Name = 'Delegates'

	WHERE Id = 14

END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSearchGroupAssociation.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSearchGroupAssociation.script,v $ $Id: DMSearchGroupAssociation.script,v 1.9 2009/11/30 10:45:48 sgolla Exp $";
-- TABLENAME DMSearchGroupAssociation

print '... inserting Table: DMSearchGroupAssociation'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSearchGroupAssociation

IF EXISTS (SELECT TOP 1 * FROM DMSearchGroupAssociation)

BEGIN

	DELETE FROM DMSearchGroupAssociation

END

IF NOT EXISTS (SELECT * FROM DMSearchGroupAssociation WHERE ViewName = 'Compliance' AND GroupId = '1') 

BEGIN
	INSERT INTO DMSearchGroupAssociation VALUES('262642B7-4D41-466C-AAB3-00D66A8B9DC6', '1', '3', 'Compliance')


END

IF NOT EXISTS (SELECT * FROM DMSearchGroupAssociation WHERE ViewName = 'Compliance' AND GroupId = '2') 

BEGIN
	INSERT INTO DMSearchGroupAssociation VALUES('7859BC66-3C77-4889-81DC-BF502950F1B2', '2', '3', 'Compliance')


END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSearchCriteriaField.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSearchCriteriaField.script,v $ $Id: DMSearchCriteriaField.script,v 1.82 2015/05/08 22:35:07 sgolla Exp $";
-- TABLENAME DMSearchCriteriaField

print '... inserting Table: DMSearchCriteriaField'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSearchCriteriaField

DECLARE @IsFreshInstall INT = 0 

IF NOT EXISTS (SELECT TOP 1 * FROM DMSearchCriteriaField)

BEGIN

	SET @IsFreshInstall = 1

END

DECLARE @IsReleaseUpgrade INT = 0

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = "UpgradeType" AND CAST(Status AS INTEGER) = 1)

BEGIN

	SET @IsReleaseUpgrade = 1

END

-- start section for either release upgrade or fresh install 

IF @IsReleaseUpgrade = 1 OR @IsFreshInstall = 1

BEGIN

	IF  EXISTS (SELECT * FROM DMSearchCriteriaField WHERE FieldLabel = 'Disk_space_quota_per_user') 

	BEGIN

		DELETE DMSearchCriteriaField WHERE FieldLabel = 'Disk_space_quota_per_user'

	END

	IF  EXISTS (SELECT * FROM DMSearchCriteriaField WHERE FieldLabel = 'Result_sets_retention_in_days_per_user') 

	BEGIN

		DELETE DMSearchCriteriaField WHERE FieldLabel = 'Result_sets_retention_in_days_per_user'

	END

	IF EXISTS (SELECT * FROM DMSearchCriteriaField WHERE FieldLabel = 'Results_retention_in_days_per_user') 

	BEGIN

		DELETE DMSearchCriteriaField   WHERE FieldLabel = 'Results_retention_in_days_per_user'

	END

	IF  EXISTS (SELECT * FROM DMSearchCriteriaField WHERE FieldLabel = 'Queries_retention_in_days_per_user') 

	BEGIN

		DELETE DMSearchCriteriaField WHERE FieldLabel = 'Queries_retention_in_days_per_user'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '3' AND IdxFieldId = '8CB775C7-DCD6-442A-9654-8F76F1B81085') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('59AD18BC-2A37-4BA9-A9FE-CE1CEEBA8DCF', '3', '8CB775C7-DCD6-442A-9654-8F76F1B81085', 'Jobs', 'Integer', 'list', 'OR', 'Text box', '', '2')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '3' AND IdxFieldId = '51B78AEE-D39C-4211-A9A4-C13C133989B8') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('97B2F346-250B-4F1F-82DB-08C81E13A049', '3', '51B78AEE-D39C-4211-A9A4-C13C133989B8', 'CI State', 'string', 'Simple', 'None', 'Dropdown', 'Success,Failed,Both', '2')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '3' AND IdxFieldId = '1FD392EA-CCE8-4E2E-B5EF-4F610674A39D') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('0E419A91-0BCC-47CA-A2DE-57770C9AAAF1', '3', '1FD392EA-CCE8-4E2E-B5EF-4F610674A39D', 'Tags', 'string', 'list', 'OR,AND,NOT', 'Drop down with check box', '', '2')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,AND,NOT' WHERE Id = '0E419A91-0BCC-47CA-A2DE-57770C9AAAF1'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '3' AND IdxFieldId = '6853A667-16FE-4059-9D2B-0A3EC8D55E6C') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('EE8A6CAF-FFF8-4E8E-AA18-5691766AC641', '3', '6853A667-16FE-4059-9D2B-0A3EC8D55E6C', 'CI Job', 'Integer', 'list', 'OR', 'Text box', '', '2')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'ED4F3286-45C3-4AA3-8D3D-C8673C5A25CE') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


	VALUES ('ED4F3286-45C3-4AA3-8D3D-C8673C5A25CE', '1', 'B7339D34-B8CA-42F0-9F38-4F9E995D4FDD', 'From', 'string', 'list', 'OR,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,NOT' WHERE Id = 'ED4F3286-45C3-4AA3-8D3D-C8673C5A25CE'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '1' AND IdxFieldId = 'D9F2BD51-6989-401F-AD4E-B90E25D55E10') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES 	('B6855BA3-4519-4A0B-8E02-CDE75523196B', '1', 'D9F2BD51-6989-401F-AD4E-B90E25D55E10', 'To', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,AND,NOT' WHERE Id = 'B6855BA3-4519-4A0B-8E02-CDE75523196B'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '1' AND IdxFieldId = 'C42A87D5-B05F-4141-8E90-4800740F17CC') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('200B4CE4-7DD3-4C6D-A864-2620F9698503', '1', 'C42A87D5-B05F-4141-8E90-4800740F17CC', 'CC', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,AND,NOT' WHERE Id = '200B4CE4-7DD3-4C6D-A864-2620F9698503'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '1' AND IdxFieldId = '9A77953C-5D7D-457E-A91D-F99D5B8F6B80') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('183CC322-FD76-4EA2-8CC6-358B0EF0FDDC', '1', '9A77953C-5D7D-457E-A91D-F99D5B8F6B80', 'BCC', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '2')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,AND,NOT' WHERE Id = '183CC322-FD76-4EA2-8CC6-358B0EF0FDDC'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '1' AND IdxFieldId = '356AE1FD-2E73-452C-AEA8-F810E4B64680') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('C42B8149-84A1-47C4-8DEF-46A21C87E6C0', '1', '356AE1FD-2E73-452C-AEA8-F810E4B64680', 'Subject', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,AND,NOT' WHERE Id = 'C42B8149-84A1-47C4-8DEF-46A21C87E6C0'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '1' AND IdxFieldId = 'ECC4D349-EA92-496E-BFDE-E9DB1CBC24A5') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('E45CFABE-F946-4A33-9EFF-3A0A4A28CC4D', '1', 'ECC4D349-EA92-496E-BFDE-E9DB1CBC24A5', 'Email Address', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,AND,NOT' WHERE Id = 'E45CFABE-F946-4A33-9EFF-3A0A4A28CC4D'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '1' AND IdxFieldId = '28F07AC4-C45B-40BF-836E-0839611EA9E3') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('E17A8DA3-62A1-48D8-A94B-7175BBD55495', '1', '28F07AC4-C45B-40BF-836E-0839611EA9E3', 'Attachement Name', 'string', 'list', 'OR,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,NOT' WHERE Id = 'E17A8DA3-62A1-48D8-A94B-7175BBD55495'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '4BAD6033-DAEA-4F33-8253-6CC265FF2709') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('4BAD6033-DAEA-4F33-8253-6CC265FF2709', '1', '3BD0DCF2-F8C5-40DB-A885-D45AAE6058AE', 'Header', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '0')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET BitVisibility = 0, IntraFieldOperators = 'OR,AND,NOT' WHERE Id = '4BAD6033-DAEA-4F33-8253-6CC265FF2709'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '18112F1D-4A89-4393-9084-15C8A6DE4563')

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('18112F1D-4A89-4393-9084-15C8A6DE4563', '2', '5064AEBE-8904-4509-A1F7-0D8A63B3C4EF', 'Folder', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET IntraFieldOperators = 'OR,AND,NOT' , FieldLabel = 'File Path' 

		WHERE Id = '18112F1D-4A89-4393-9084-15C8A6DE4563'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'B1A719BA-7C02-4DC6-B3F7-C3604D1ED121') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('B1A719BA-7C02-4DC6-B3F7-C3604D1ED121', '2', '6752A491-DD0A-4E7F-88BB-E0F34D2F64D2', 'Modified Time', 'Time', 'Range', 'None', 'Date Time', '', '3')


	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IdxFieldId = '6752A491-DD0A-4E7F-88BB-E0F34D2F64D2' WHERE Id = 'B1A719BA-7C02-4DC6-B3F7-C3604D1ED121'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '2' AND IdxFieldId = '356AE1FD-2E73-452C-AEA8-F810E4B64680') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('BF619260-5E85-4807-BA81-7AC1B5217110', '2', '356AE1FD-2E73-452C-AEA8-F810E4B64680', 'File name part', 'string', 'list', 'OR,NOT', 'Text box', '', '3')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,NOT' WHERE Id = 'BF619260-5E85-4807-BA81-7AC1B5217110'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'B957099A-CC91-4F86-B7B4-A878968240F6') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		SELECT 'B957099A-CC91-4F86-B7B4-A878968240F6', '2', 'E78FDA34-00A0-45FB-BD6C-C0858538338F', 'Size_in_KB', 'integer', 'Range', 'None', 'Text box', '', '3'

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldLabel = 'Size_in_KB'

		WHERE Id = 'B957099A-CC91-4F86-B7B4-A878968240F6'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'CF3CDDFB-8574-4144-A0A2-10E3380E336B') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('CF3CDDFB-8574-4144-A0A2-10E3380E336B', '4', NULL, 'Domain users', 'string', 'list', 'OR,NOT', 'Text box', '', '2')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,NOT' WHERE Id = 'CF3CDDFB-8574-4144-A0A2-10E3380E336B'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '5' AND IdxFieldId = '5E485707-3B70-4E84-AC7B-57CFD0CF6BB5') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('A8B7BF69-BE02-421D-BE28-2051F4C7821D', '5', '5E485707-3B70-4E84-AC7B-57CFD0CF6BB5', 'App Type', 'integer', 'list', 'OR', 'Drop down with check box', 'Queried from CS', '3')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '5' AND IdxFieldId = '3FA3C61D-6BB9-454B-97C6-AB0296818F93') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('92B681CE-D5FC-41B3-9D90-A6748500259A', '5', '3FA3C61D-6BB9-454B-97C6-AB0296818F93', 'Clients', 'integer', 'list', 'OR', 'Drop down with check box', 'Queried from CS', '3')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE GroupId = '5' AND IdxFieldId = '3CD8AF87-EFF2-4C1A-8CE6-6181070A5216') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('CDB75F51-CF9D-4D05-A3AF-9EA2918DF327', '5', '3CD8AF87-EFF2-4C1A-8CE6-6181070A5216', 'Commcell number', 'integer', 'list', 'OR', 'Drop down with check box', 'Queried from CS', '3')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '08903755-8984-4D75-9F19-C88A8F1CD82B') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('08903755-8984-4D75-9F19-C88A8F1CD82B', '3', 'B0B07085-AC4D-4871-A842-983262C48460', 'Backup Job Date', 'Date Time', 'Range', 'None', 'Date Time', '', '3')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'D9316FB1-92EB-4257-8B67-AF2F97AA9C27') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('D9316FB1-92EB-4257-8B67-AF2F97AA9C27', '14', '308E3142-410E-4FFC-8DF6-87B7329DD2AC', 'Delegates', 'string', 'list', 'OR', 'Drop down with check box', '', '1')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET 

			GroupId = 14,

			IntraFieldOperators = 'OR',

			IdxFieldId = '308E3142-410E-4FFC-8DF6-87B7329DD2AC'

			WHERE Id = 'D9316FB1-92EB-4257-8B67-AF2F97AA9C27'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '519E8D71-E296-4CDA-A423-24E79E36A325') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,FieldDisplayOrder)  


		VALUES ('519E8D71-E296-4CDA-A423-24E79E36A325', '1', '308E3142-410E-4FFC-8DF6-87B7329DD2AC', 'Folder', 'string', 'list', 'OR', 'Text box', '', '1', 10)

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '27F813D3-BCBC-4291-ADA7-197AA4F901BD') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  


		VALUES ('27F813D3-BCBC-4291-ADA7-197AA4F901BD', '4', NULL, 'User Groups', 'string', 'list', 'OR,NOT', 'Text box', '', '2')

	END

	ELSE

	BEGIN

			UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,NOT' WHERE Id = '27F813D3-BCBC-4291-ADA7-197AA4F901BD'

	END

	-- Synonym, No Duplicates, Lemmatization not supported yet in 10.0 BETA, blocking them by making BitVisibility for new installs in 10.0

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '9852D0A9-44CE-4E1B-A0FD-5ACF159CBC86')

	BEGIN
	INSERT INTO DMSearchCriteriaField (Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)


	SELECT '9852D0A9-44CE-4E1B-A0FD-5ACF159CBC86' AS Id, '6' AS GroupId, '2B18B200-CC46-45C5-A0B8-491374CF0865' AS IdxField, 'Synonym' AS FieldLabel, 'string' AS DataType, 'list' AS Container, 'None' AS IntraFieldOperators, 'Dropdown' AS UIControlType, 'On,Off' AS DefaultValues, '0' AS BitVisibility

	END

	ELSE

	BEGIN

	UPDATE DMSearchCriteriaField 

	SET IntraFieldOperators = 'None'

	WHERE Id = '9852D0A9-44CE-4E1B-A0FD-5ACF159CBC86'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'B403F766-B520-41C1-AA45-351EE866724C')

	BEGIN
	INSERT INTO DMSearchCriteriaField (Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)


	SELECT 'B403F766-B520-41C1-AA45-351EE866724C' AS Id, '6' AS GroupId, '81AAA9A8-1856-4F74-8466-719C38F3ADB4' AS IdxField, 'Remove Duplicates' AS FieldLabel, 'string' AS DataType, 'list' AS Container, 'None' AS IntraFieldOperators, 'Dropdown' AS UIControlType, 'On,Off' AS DefaultValues, '0' AS BitVisibility

	END

	ELSE

	BEGIN

	UPDATE DMSearchCriteriaField 

	SET IntraFieldOperators = 'None'

	WHERE Id = 'B403F766-B520-41C1-AA45-351EE866724C'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '471139B6-C89A-490D-86A7-8ABEAAAAFCD5')

	BEGIN
	INSERT INTO DMSearchCriteriaField (Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)


	SELECT '471139B6-C89A-490D-86A7-8ABEAAAAFCD5' AS Id, '6' AS GroupId, NULL AS IdxField, 'CI Server' AS FieldLabel, 'string' AS DataType, 'list' AS Container, 'None' AS IntraFieldOperators, 'Dropdown' AS UIControlType, '' AS DefaultValues, '3' AS BitVisibility

	END

	ELSE

	BEGIN

	UPDATE DMSearchCriteriaField 

	SET IntraFieldOperators = 'None'

	WHERE Id = '471139B6-C89A-490D-86A7-8ABEAAAAFCD5'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'B74102B6-21EE-4C5A-BD5E-65421459D637')

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)


		SELECT 'B74102B6-21EE-4C5A-BD5E-65421459D637' AS Id, '6' AS GroupId, '5300188A-991E-4B23-A135-EA022C95EE7C' AS IdxField, 'Lemmatization' AS FieldLabel, 'string' AS DataType, 'list' AS Container, 'None' AS IntraFieldOperators, 'Dropdown' AS UIControlType, 'On,Off' AS DefaultValues, '0' AS BitVisibility

	END

	ELSE

	BEGIN

	UPDATE DMSearchCriteriaField 

	SET IntraFieldOperators = 'None'

	WHERE Id = 'B74102B6-21EE-4C5A-BD5E-65421459D637'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'D1BF8762-C449-4967-8F8C-E0A779BAB206')

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)


		SELECT 'D1BF8762-C449-4967-8F8C-E0A779BAB206' AS Id, '6' AS GroupId, '366B534E-3AB2-4AC4-971E-24A69530C555' AS IdxField, 'LANGUAGE' AS FieldLabel, 'string' AS DataType, 'list' AS Container, 'None' AS IntraFieldOperators, 'Dropdown' AS UIControlType, 'ENGLISH,CHINESE SIMPLIFIED,JAPANESE,KOREAN' AS DefaultValues, '3' AS BitVisibility

	END

	ELSE

	BEGIN

	UPDATE DMSearchCriteriaField 

		SET IntraFieldOperators = 'None', DefaultValues = 'ENGLISH,CHINESE SIMPLIFIED,JAPANESE,KOREAN', BitVisibility = 3

	WHERE Id = 'D1BF8762-C449-4967-8F8C-E0A779BAB206'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '47C01BEA-26F1-41E6-8DCA-33CA0E6A407B') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('47C01BEA-26F1-41E6-8DCA-33CA0E6A407B', '1', '32155C68-736D-4421-94EC-988E3A66B24F', 'Received Time', 'Date Time', 'Range', 'None', 'Date Time', '', '3')


	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '71EF2955-47BA-4DFA-B55C-BB2D73466515') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  VALUES ('71EF2955-47BA-4DFA-B55C-BB2D73466515', '8', NULL, 'Entity', 'string', 'Simple', 'None', 'Text box', '', '2')


	END

	--sort by and sort order options removed as per arun prasad comments by email (and related MR is 41581) and if it is needed again, we can get it back from version 1.28 of DMSearchCriteriaField.script

	--The email is dated Thu 12/17/2009 11:53 PM with subject RE: 9.0-B50 - Sort by options does not work once we select sort by relevance

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '7E71249A-583F-4EF4-B570-5243B6261A92') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('7E71249A-583F-4EF4-B570-5243B6261A92', '9',

			NULL, 'Number_of_results_per_page_in_result_set', 'Integer', 'Simple', 'None', 'DropDown', '10,20,30,50,100', '0','50')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET InitialDefaultValue = 50 WHERE Id = '7E71249A-583F-4EF4-B570-5243B6261A92'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '88C58603-0420-46A4-A51A-0B964EE3B8B9') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('88C58603-0420-46A4-A51A-0B964EE3B8B9', '9',

			NULL, 'Number_of_results_per_page_in_Search_results', 'Integer', 'Simple', 'None', 'DropDown', '10,20,30,50,100', '0','50')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET InitialDefaultValue = 50 WHERE Id = '88C58603-0420-46A4-A51A-0B964EE3B8B9'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '2001672B-5603-4ECC-89E7-CB9307A8F3B3') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('2001672B-5603-4ECC-89E7-CB9307A8F3B3', '9',

			NULL, 'Max_number_of_queries_per_user', 'Integer', 'Simple', 'None', 'DropDown', '10,20,30,50,100', '4','100')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'F17DB830-6A6B-4FB8-B0B3-25DD53E90FF2') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('F17DB830-6A6B-4FB8-B0B3-25DD53E90FF2', '9',

			NULL, 'Max_number_of_result_sets_per_user', 'Integer', 'Simple', 'None', 'TextBox', '', '4','500')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'D0C47B86-78DE-4B8E-A082-663929FE8C76') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('D0C47B86-78DE-4B8E-A082-663929FE8C76', '9',

			NULL, 'Switch_to_Review_set_upon_item_add', 'String', 'Simple', 'None', 'DropDown', 'On,Off', '4','On')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '08E2AD59-A908-4389-9BBA-A31AAD4798A6') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue) 


		VALUES('08E2AD59-A908-4389-9BBA-A31AAD4798A6', '9',

			NULL, 'Show_File_Advanced_search_tabs', 'String', 'Simple', 'None', 'DropDown', 'True,False', '4','True')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET FieldLabel = 'Show_File_Advanced_search_tabs',

			InitialDefaultValue = 'True'

		WHERE Id = '08E2AD59-A908-4389-9BBA-A31AAD4798A6'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'FC18C2D3-6086-4988-8987-0BCB8A251457') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('FC18C2D3-6086-4988-8987-0BCB8A251457', '9',

			NULL, 'Show_Email_Advanced_search_tabs', 'String', 'Simple', 'None', 'DropDown', 'True,False', '4','True')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET FieldLabel = 'Show_Email_Advanced_search_tabs',

			InitialDefaultValue = 'True'

		WHERE Id = 'FC18C2D3-6086-4988-8987-0BCB8A251457'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'AD4CA164-2541-44AF-98DF-BF40AFA81BD1') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('AD4CA164-2541-44AF-98DF-BF40AFA81BD1', '9',

			NULL, 'End_user_based_security', 'String', 'Simple', 'None', 'DropDown', 'Mailbox ownership,Based on recipients', '2','Mailbox ownership')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField

		SET InitialDefaultValue = 'Mailbox ownership', BitVisibility = 2

		WHERE Id = 'AD4CA164-2541-44AF-98DF-BF40AFA81BD1'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'A705F99D-57A5-4620-B9E8-79ADA2FA8E22') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)  


		VALUES('A705F99D-57A5-4620-B9E8-79ADA2FA8E22', '9',

			NULL, 'Default_search_tab_to_show', 'String', 'Simple', 'None', 'DropDown', 'All_File_Email,Email,File', '7','All_File_Email')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'C4F15272-77BF-4946-BE6C-3F956F6946EF') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('C4F15272-77BF-4946-BE6C-3F956F6946EF', '9',

			 'Allow_emails_export_to_PST', 'String', 'Simple', 'None', 'DropDown', 'On,Off', '4','Off')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '2D248F58-9B68-46ec-B46E-D0D561963A51') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('2D248F58-9B68-46ec-B46E-D0D561963A51', '9',

			 'Enable_Document_Highlighting', 'String', 'Simple', 'None', 'DropDown', 'On,Off', '0','On')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField

		SET BitVisibility = 0

		WHERE Id = '2D248F58-9B68-46ec-B46E-D0D561963A51'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'F5D29123-9954-489D-958A-CF690564ADEF') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue) 


		VALUES('F5D29123-9954-489D-958A-CF690564ADEF', '9',

			NULL, 'Enable_Search_Option', 'String', 'Simple', 'None', 'DropDown', 'True,False', '0','True')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET FieldLabel = 'Enable_Search_Option',

			InitialDefaultValue = 'True',

			BitVisibility = 0

		WHERE Id = 'F5D29123-9954-489D-958A-CF690564ADEF'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '7A8DCA38-8021-4886-A672-AD8C7E682891') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue) 


		VALUES('7A8DCA38-8021-4886-A672-AD8C7E682891', '9',

			NULL, 'Enable_Browse_Option', 'String', 'Simple', 'None', 'DropDown', 'True,False', '0','True')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET FieldLabel = 'Enable_Browse_Option',

			InitialDefaultValue = 'True',

			BitVisibility = 0

		WHERE Id = '7A8DCA38-8021-4886-A672-AD8C7E682891'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'EC1FC6C0-A012-4E8E-BD40-361457F0AFF2') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue) 


		VALUES('EC1FC6C0-A012-4E8E-BD40-361457F0AFF2', '9',

			NULL, 'Enable_MyContents_Option', 'String', 'Simple', 'None', 'DropDown', 'True,False', '0','False')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET FieldLabel = 'Enable_MyContents_Option',

			InitialDefaultValue = 'False',

			BitVisibility = 0

		WHERE Id = 'EC1FC6C0-A012-4E8E-BD40-361457F0AFF2'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'F115D475-0A3E-4C14-ACCF-E3E4D582AA35') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,


						Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue) 

		VALUES('F115D475-0A3E-4C14-ACCF-E3E4D582AA35', '9',NULL, 'Display_Original_Email_Fields_Option', 'String', 

						'Simple', 'None', 'DropDown', 'True,False', '0','False')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField

		SET BitVisibility = 0

		WHERE Id = 'F115D475-0A3E-4C14-ACCF-E3E4D582AA35'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '665394D8-290D-44F8-8A06-0DE2B10B4F35') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,


						Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue, FieldDisplayOrder) 

		VALUES('665394D8-290D-44F8-8A06-0DE2B10B4F35', '9',NULL, 'Default_Reading_Pane_Position', 'String', 

						'Simple', 'None', 'DropDown', 'Right,Bottom,Hidden', '3','Right', 1)

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'A5960B22-19B2-47F9-8B28-10D717A27FD3')

	BEGIN
		INSERT INTO DMSearchCriteriaField 


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)

		SELECT 'A5960B22-19B2-47F9-8B28-10D717A27FD3' AS Id, '10' AS GroupId, NULL AS IdxField, 'Content Type' AS FieldLabel, 'string' AS DataType, 

		'list' AS Container,  '' AS IntraFieldOperators, 'DropDown' AS UIControlType, '1^Email,2^File,0^All' AS DefaultValues, '3' AS BitVisibility

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField SET DefaultValues = '1^Email,2^File,0^All' 

		WHERE Id = 'A5960B22-19B2-47F9-8B28-10D717A27FD3'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '17F863C7-8602-49C8-9936-F1CE43A6FA61')

	BEGIN
		INSERT INTO DMSearchCriteriaField 


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)

		SELECT '17F863C7-8602-49C8-9936-F1CE43A6FA61' AS Id, '10' AS GroupId, NULL AS IdxField, 'File Name' AS FieldLabel, 'string' AS DataType, 

		'Simple' AS Container,  '' AS IntraFieldOperators, 'Text box' AS UIControlType, '' AS DefaultValues, '3' AS BitVisibility

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '652DDC92-6BC7-4D92-A421-E5A6C6E90286')

	BEGIN
		INSERT INTO DMSearchCriteriaField   


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)  

		SELECT '652DDC92-6BC7-4D92-A421-E5A6C6E90286' AS Id, '10' AS GroupId, NULL AS IdxFieldId, 'Item Created' AS FieldLabel, 'Time' AS DataType, 'Range' AS Container, 

		'' AS IntraFieldOperators, 'Date Time' AS UIControlType, '' AS DefaultValues, '3' AS BitVisibility

	END

	IF EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '30F982E6-F0C2-4575-B6A4-8A564BCE8CB6') 

	BEGIN

		DELETE FROM DMSearchCriteriaField WHERE Id = '30F982E6-F0C2-4575-B6A4-8A564BCE8CB6'

	END

	BEGIN
		INSERT INTO DMSearchCriteriaField   


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)  

		SELECT '30F982E6-F0C2-4575-B6A4-8A564BCE8CB6' AS Id, '10' AS GroupId, NULL AS IdxFieldId, 'Modified Time' AS FieldLabel, 'Time' AS DataType, 'Range' AS Container, 

		'' AS IntraFieldOperators, 'Date Time' AS UIControlType, '', '3'AS BitVisibility

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '6E93548D-83C4-4926-871D-172714329023')

	BEGIN
		INSERT INTO DMSearchCriteriaField 


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility, InitialDefaultValue) 

		SELECT '6E93548D-83C4-4926-871D-172714329023' AS Id, '10' AS GroupId, NULL AS IdxField, 'Annotated' AS FieldLabel, 'string' AS DataType, 'list' AS Container,  

		'' AS IntraFieldOperators, 'DropDown' AS UIControlType, '1^Yes,2^No,0^Any' AS DefaultValues, '3' AS BitVisibility, 'Yes' AS InitialDefaultValue

	END 

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldLabel = 'Annotated', InitialDefaultValue = 'Yes', DefaultValues = '1^Yes,2^No,0^Any'

		WHERE Id = '6E93548D-83C4-4926-871D-172714329023'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '7E4EE992-33A4-47B9-AE45-2A5102E5FBF3')

	BEGIN
		INSERT INTO DMSearchCriteriaField 


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility, InitialDefaultValue) 

		SELECT '7E4EE992-33A4-47B9-AE45-2A5102E5FBF3' AS Id, '10' AS GroupId, NULL AS IdxField, 'Legally Held' AS FieldLabel, 'string' AS DataType, 'list' AS Container,  

		'' AS IntraFieldOperators, 'DropDown' AS UIControlType, '1^Yes,2^No,0^Any' AS DefaultValues, '2' AS BitVisibility, 'Yes' AS InitialDefaultValue

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldLabel = 'Legally Held', InitialDefaultValue = 'Yes', DefaultValues = '1^Yes,2^No,0^Any'

		WHERE Id = '7E4EE992-33A4-47B9-AE45-2A5102E5FBF3'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '04AE3265-0A02-448F-B919-5BEAD6A620BC')

	BEGIN
		INSERT INTO DMSearchCriteriaField 


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility) 

		SELECT '04AE3265-0A02-448F-B919-5BEAD6A620BC' AS Id, '10' AS GroupId, NULL AS IdxField, 'Tags' AS FieldLabel, 'string' AS DataType, 'list' AS Container,  

		'OR,NOT' AS IntraFieldOperators, 'Drop down with check box' AS UIControlType, '' AS DefaultValues, '2' AS BitVisibility

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '245B72FF-187E-492B-897D-1BA2EF8C177D')

	BEGIN
		INSERT INTO DMSearchCriteriaField 


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility) 

		SELECT '245B72FF-187E-492B-897D-1BA2EF8C177D' AS Id, '10' AS GroupId, NULL AS IdxField, 'ReviewSets' AS FieldLabel, 'string' AS DataType, 'list' AS Container,  

		'' AS IntraFieldOperators, 'Drop down with check box' AS UIControlType, '' AS DefaultValues, '3' AS BitVisibility

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '086BC036-BE6A-4A49-8D2C-3E7CCF468139')

	BEGIN
		INSERT INTO DMSearchCriteriaField 


		(Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, 

		IntraFieldOperators, UIControlType, DefaultValues, BitVisibility, InitialDefaultValue) 

		SELECT '086BC036-BE6A-4A49-8D2C-3E7CCF468139' AS Id, '10' AS GroupId, NULL AS IdxField, 'Has Tags' AS FieldLabel, 'string' AS DataType, 'list' AS Container,  

		'' AS IntraFieldOperators, 'DropDown' AS UIControlType, '1^Yes,2^No,0^Any' AS DefaultValues, '2' AS BitVisibility, 'Yes' AS InitialDefaultValue

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldLabel = 'Has Tags', InitialDefaultValue = 'Yes', DefaultValues = '1^Yes,2^No,0^Any'

		WHERE Id = '086BC036-BE6A-4A49-8D2C-3E7CCF468139'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '7933D7DE-1FD8-48EF-9C54-FF58DBA40C46') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('7933D7DE-1FD8-48EF-9C54-FF58DBA40C46', '11',

			 'Custom_Image_File_Path', 'String', 'Simple', '', 'TextBox', '', '4','')		 

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'C4FD61F7-957E-41E6-9F43-BA86A63330CA') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


			VALUES('C4FD61F7-957E-41E6-9F43-BA86A63330CA', '9',

			 'Search_Timeout', 'Integer', 'Simple', 'None', 'DropDown', '30,60,120,180', '4','60')	

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '4ACCA03B-6BF8-43EB-8486-B7C5143CCBE6') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


			VALUES('4ACCA03B-6BF8-43EB-8486-B7C5143CCBE6', '9',

			 'Results_Polling_Interval', 'Integer', 'Simple', 'None', 'DropDown', '30,60,120,180', '4','30')	

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '1101DAFE-43CF-4162-A771-1179D24F165B') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   


			(Id,GroupId,IdxFieldId,FieldLabel,

			DataType,Container,IntraFieldOperators,UIControlType,

			DefaultValues,

			BitVisibility,InitialDefaultValue) 

		VALUES('1101DAFE-43CF-4162-A771-1179D24F165B', '9',NULL, 'Default_Query_Language', 

			'String', 'Simple', 'None', 'DropDown', 

			'ENGLISH,CHINESE SIMPLIFIED,JAPANESE,KOREAN', 

			'3','ENGLISH')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '64AFBDB5-9783-4F33-B265-D4D12AFECD86') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   


			(Id,GroupId,IdxFieldId,FieldLabel,

			DataType,Container,IntraFieldOperators,UIControlType,

			DefaultValues,BitVisibility,InitialDefaultValue) 

		VALUES('64AFBDB5-9783-4F33-B265-D4D12AFECD86', '9',NULL, 'Default_Search_Engine', 

			'String', 'Simple', 'None', 'DropDown', 

			'', '7','0')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField

		SET DefaultValues = 'ENGLISH,CHINESE SIMPLIFIED,JAPANESE,KOREAN', BitVisibility = 3

		WHERE id = '1101DAFE-43CF-4162-A771-1179D24F165B'

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 1 AND ID = 'E45CFABE-F946-4A33-9EFF-3A0A4A28CC4D'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 1 where Id = 'E45CFABE-F946-4A33-9EFF-3A0A4A28CC4D' -- Email Address field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 2 AND ID = 'C42B8149-84A1-47C4-8DEF-46A21C87E6C0'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 2 where Id = 'C42B8149-84A1-47C4-8DEF-46A21C87E6C0' -- Subject field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 3 AND ID = 'ED4F3286-45C3-4AA3-8D3D-C8673C5A25CE'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 3 where Id = 'ED4F3286-45C3-4AA3-8D3D-C8673C5A25CE' -- From field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 4 AND ID = 'B6855BA3-4519-4A0B-8E02-CDE75523196B'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 4 where Id = 'B6855BA3-4519-4A0B-8E02-CDE75523196B' -- To field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 5 AND ID = '200B4CE4-7DD3-4C6D-A864-2620F9698503'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 5 where Id = '200B4CE4-7DD3-4C6D-A864-2620F9698503' -- CC field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 6 AND ID = '183CC322-FD76-4EA2-8CC6-358B0EF0FDDC'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 6 where Id = '183CC322-FD76-4EA2-8CC6-358B0EF0FDDC' -- BCC field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 7 AND ID = 'E17A8DA3-62A1-48D8-A94B-7175BBD55495'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 7 where Id = 'E17A8DA3-62A1-48D8-A94B-7175BBD55495' -- Attachment field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 8 AND ID = '47C01BEA-26F1-41E6-8DCA-33CA0E6A407B'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 8 where Id = '47C01BEA-26F1-41E6-8DCA-33CA0E6A407B' -- Received Time field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 9 AND ID = '4BAD6033-DAEA-4F33-8253-6CC265FF2709'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 9 where Id = '4BAD6033-DAEA-4F33-8253-6CC265FF2709' -- Header Time field in email group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 1 AND ID = '18112F1D-4A89-4393-9084-15C8A6DE4563'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 1 where Id = '18112F1D-4A89-4393-9084-15C8A6DE4563' -- Folder field in file group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 2 AND ID = 'B1A719BA-7C02-4DC6-B3F7-C3604D1ED121'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 2 where Id = 'B1A719BA-7C02-4DC6-B3F7-C3604D1ED121' -- Modified Time field in file group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 3 AND ID = 'BF619260-5E85-4807-BA81-7AC1B5217110'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 3 where Id = 'BF619260-5E85-4807-BA81-7AC1B5217110' -- File name part field in file group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 4 AND ID = 'B957099A-CC91-4F86-B7B4-A878968240F6'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 4 where Id = 'B957099A-CC91-4F86-B7B4-A878968240F6' -- Size field in file group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 1 AND ID = '59AD18BC-2A37-4BA9-A9FE-CE1CEEBA8DCF'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 1 where Id = '59AD18BC-2A37-4BA9-A9FE-CE1CEEBA8DCF' -- Jobs field in Common group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 2 AND ID = 'EE8A6CAF-FFF8-4E8E-AA18-5691766AC641'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 2 where Id = 'EE8A6CAF-FFF8-4E8E-AA18-5691766AC641' -- CI Job field in Common group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 3 AND ID = '08903755-8984-4D75-9F19-C88A8F1CD82B'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 3 where Id = '08903755-8984-4D75-9F19-C88A8F1CD82B' -- Backup Job Date field in Common group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 4 AND ID = '97B2F346-250B-4F1F-82DB-08C81E13A049'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 4 where Id = '97B2F346-250B-4F1F-82DB-08C81E13A049' -- CI State field in Common group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 5 AND ID = '0E419A91-0BCC-47CA-A2DE-57770C9AAAF1'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 5 where Id = '0E419A91-0BCC-47CA-A2DE-57770C9AAAF1' -- CI State field in Common group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 1 AND ID = 'CF3CDDFB-8574-4144-A0A2-10E3380E336B'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 1 where Id = 'CF3CDDFB-8574-4144-A0A2-10E3380E336B' -- Domain users field in Discovery group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 2 AND ID = '27F813D3-BCBC-4291-ADA7-197AA4F901BD'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 2 where Id = '27F813D3-BCBC-4291-ADA7-197AA4F901BD' -- User Groups field in Discovery group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 1 AND ID = '471139B6-C89A-490D-86A7-8ABEAAAAFCD5'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 1 where Id = '471139B6-C89A-490D-86A7-8ABEAAAAFCD5' -- CI Server field in Search Options group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 2 AND ID = 'B403F766-B520-41C1-AA45-351EE866724C'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 2 where Id = 'B403F766-B520-41C1-AA45-351EE866724C' -- Remove Duplicates field in Search Options group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 3 AND ID = 'D1BF8762-C449-4967-8F8C-E0A779BAB206'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 3 where Id = 'D1BF8762-C449-4967-8F8C-E0A779BAB206' -- LANGUAGE field in Search Options group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 4 AND ID = '9852D0A9-44CE-4E1B-A0FD-5ACF159CBC86'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 4 where Id = '9852D0A9-44CE-4E1B-A0FD-5ACF159CBC86' -- Synonym field in Search Options group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 5 AND ID = 'B74102B6-21EE-4C5A-BD5E-65421459D637'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 5 where Id = 'B74102B6-21EE-4C5A-BD5E-65421459D637' -- Lemmatization field in Search Options group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 1 AND ID = '245B72FF-187E-492B-897D-1BA2EF8C177D'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 1 where Id = '245B72FF-187E-492B-897D-1BA2EF8C177D' --  ReviewSets field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 2 AND ID = 'A5960B22-19B2-47F9-8B28-10D717A27FD3'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 2 where Id = 'A5960B22-19B2-47F9-8B28-10D717A27FD3' --  Content Type field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 3 AND ID = '17F863C7-8602-49C8-9936-F1CE43A6FA61'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 3 where Id = '17F863C7-8602-49C8-9936-F1CE43A6FA61' --  File Name field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 4 AND ID = '30F982E6-F0C2-4575-B6A4-8A564BCE8CB6'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 4 where Id = '30F982E6-F0C2-4575-B6A4-8A564BCE8CB6' --  Modified Time field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 5 AND ID = '652DDC92-6BC7-4D92-A421-E5A6C6E90286'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 5 where Id = '652DDC92-6BC7-4D92-A421-E5A6C6E90286' --  Item Created field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 6 AND ID = '6E93548D-83C4-4926-871D-172714329023'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 6 where Id = '6E93548D-83C4-4926-871D-172714329023' --  Annotated field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 7 AND ID = '7E4EE992-33A4-47B9-AE45-2A5102E5FBF3'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 7 where Id = '7E4EE992-33A4-47B9-AE45-2A5102E5FBF3' --  Legally Held field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 8 AND ID = '086BC036-BE6A-4A49-8D2C-3E7CCF468139'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 8 where Id = '086BC036-BE6A-4A49-8D2C-3E7CCF468139' --  Has Tags field in Filters group

	END

	IF EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ISNULL(FieldDisplayOrder, 0) <> 9 AND ID = '04AE3265-0A02-448F-B919-5BEAD6A620BC'

	)

	BEGIN

		UPDATE DMSearchCriteriaField SET FieldDisplayOrder = 9 where Id = '04AE3265-0A02-448F-B919-5BEAD6A620BC' --  Tags field in Filters group

	END

	--IF NOT EXISTS (

	--	SELECT ID FROM DMSearchCriteriaField WHERE ID = '41119FFD-F8FF-46E6-9B88-22F3BD6303A7'

	--)

	--BEGIN

	--	INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue,FieldDisplayOrder)  

	--	VALUES ('41119FFD-F8FF-46E6-9B88-22F3BD6303A7', '4', NULL, 'Expand User Groups', 'string', 'Simple', 'None', 'Dropdown', '1^Yes,2^No', '2', 'No', 3)

	--END

	IF NOT EXISTS (

		SELECT ID FROM DMSearchCriteriaField WHERE ID = '85088604-CA49-4B88-A940-4066C1A19780'

	)

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue,FieldDisplayOrder)  


		VALUES ('85088604-CA49-4B88-A940-4066C1A19780', '4', NULL, 'Files Accessible by', 'string', 'list', 'OR,AND,NOT', 'Text box', '', '2', 'No', 4)

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField SET IntraFieldOperators = 'OR,AND,NOT'

		WHERE ID = '85088604-CA49-4B88-A940-4066C1A19780'

	END

	IF EXISTS (

		SELECT TOP 1 ID  FROM DMSearchCriteriaField

		WHERE GroupId = 10 AND ISNULL(IntraFieldOperators, '') = ''

	)

	BEGIN

		UPDATE DMSearchCriteriaField

		SET IntraFieldOperators = 'None' 

		WHERE GroupId = 10 AND ISNULL(IntraFieldOperators, '') = ''

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'A329047F-66E9-4A57-8A88-A47B412C04D1') 

	BEGIN
		INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue) 


		VALUES('A329047F-66E9-4A57-8A88-A47B412C04D1', '9',

			NULL, 'Default_Advanced_search_tabs', 'String', 'Simple', 'None', 'DropDown', '', '3','1')

	END

	--Preference / Setting for changing lemmatization beahvior during search by default.

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'A911831B-26D9-4CE0-AE0F-D13ACDEC3D3D') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id, GroupId, FieldLabel, DataType, Container, 


			IntraFieldOperators, UIControlType, DefaultValues, BitVisibility, InitialDefaultValue)

		VALUES('A911831B-26D9-4CE0-AE0F-D13ACDEC3D3D',  '9', 'Enable_Lemmatization',  'String',  'Simple',  

			'None',  'DropDown',  'Yes, No',  '4', 'Yes')

	END

	--Preference / Setting to show / hide SET nodes such as Review Set, Legal Hold etc.

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '4A75360B-BFEB-4E80-BB6A-69AB5D540C44') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('4A75360B-BFEB-4E80-BB6A-69AB5D540C44', '9',

			 'Show_Review_Set', 'String', 'Simple', 'None', 'DropDown', 'Yes,No', '4','Yes')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '23AD7C3E-81E7-4746-9C3F-B88834C83EF3') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('23AD7C3E-81E7-4746-9C3F-B88834C83EF3', '9',

			 'Show_Legal_Hold', 'String', 'Simple', 'None', 'DropDown', 'Yes,No', '4','Yes')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '8C397542-85A3-499B-9630-E67A71D78503') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('8C397542-85A3-499B-9630-E67A71D78503', '9',

			 'Show_Query_Set', 'String', 'Simple', 'None', 'DropDown', 'Yes,No', '4','Yes')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '8A90EDF0-DD59-4BE6-B02B-D72597B1AE77') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('8A90EDF0-DD59-4BE6-B02B-D72597B1AE77', '9',

			 'Show_Export_Set', 'String', 'Simple', 'None', 'DropDown', 'Yes,No', '4','Yes')

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'F1FF4CDE-1CCD-497A-8050-3943056E390A') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('F1FF4CDE-1CCD-497A-8050-3943056E390A', '9',

			 'Show_Filters', 'String', 'Simple', 'None', 'DropDown', 'Yes,No', '0','No')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField

		SET BitVisibility = 0

		WHERE Id = 'F1FF4CDE-1CCD-497A-8050-3943056E390A'

	END	

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '9EB939D1-9EB3-4BD1-B10A-F4A82A062573') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('9EB939D1-9EB3-4BD1-B10A-F4A82A062573', '9',

			 'Show_Tag_Set', 'String', 'Simple', 'None', 'DropDown', 'Yes,No', '4', 'Yes')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField

		SET BitVisibility = 4, InitialDefaultValue = 'Yes'

		WHERE Id = '9EB939D1-9EB3-4BD1-B10A-F4A82A062573'

	END	

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '8C5B77D9-1F02-4CEB-B7B7-B12953D3E471') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('8C5B77D9-1F02-4CEB-B7B7-B12953D3E471', '9',

			 'Show_ERM', 'String', 'Simple', 'None', 'DropDown', 'Yes,No', '0','No')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField

		SET BitVisibility = 0

		WHERE Id = '8C5B77D9-1F02-4CEB-B7B7-B12953D3E471'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '58B497D6-0DE7-4D9F-B359-DCE153450B31') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('58B497D6-0DE7-4D9F-B359-DCE153450B31','9','Printer_Orientation', 'String', 'Simple', 'None', 'Drop down with check box', 'Portrait,Landscape', '8','Portrait')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET FieldLabel='Printer_Orientation'

		WHERE Id='58B497D6-0DE7-4D9F-B359-DCE153450B31'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '8289AD6A-D1AF-45C3-A2A8-678A45C663EC') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('8289AD6A-D1AF-45C3-A2A8-678A45C663EC','9','Number_of_Copies', 'integer', 'Simple', 'None', 'Text box', '', '8',1)

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'CBDA6A5D-1B12-40B2-B40D-7DA722BB3D91') 

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id,GroupId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility,InitialDefaultValue)


		VALUES('CBDA6A5D-1B12-40B2-B40D-7DA722BB3D91','9','Printer_Duplex_state', 'String', 'Simple', 'None', 'Drop down with check box', 'Simplex,Short Edge,Long Edge', '8','Simplex')

	END

	ELSE

	BEGIN

		UPDATE DMSearchCriteriaField 

		SET DefaultValues='Simplex,Short Edge,Long Edge' where Id = 'CBDA6A5D-1B12-40B2-B40D-7DA722BB3D91'

	END

	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = 'EB92AD96-38D7-44FA-A8ED-E4C8BA85A1D1')

	BEGIN
		INSERT INTO DMSearchCriteriaField (Id, GroupId, IdxFieldId, FieldLabel, DataType, Container, IntraFieldOperators, UIControlType, DefaultValues, BitVisibility)


		SELECT 'EB92AD96-38D7-44FA-A8ED-E4C8BA85A1D1' AS Id, '6' AS GroupId, NULL AS IdxField, 'Sampling Rate' AS FieldLabel, 'Integer' AS DataType, 

		'Simple' AS Container, 'None' AS IntraFieldOperators, 'Dropdown' AS UIControlType, 

		'1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100' AS DefaultValues, 

		'2' AS BitVisibility

	END

	-- This is reservation for Freddie Mac customer Delivered Time requirement of email grid (Do not remove this)

	--IF NOT EXISTS (SELECT * FROM DMSearchCriteriaField WHERE Id = '8556C487-FA04-48E1-A790-9E01D48262BB') 

	--BEGIN

	--	INSERT INTO DMSearchCriteriaField   (Id,GroupId,IdxFieldId,FieldLabel,DataType,Container,IntraFieldOperators,UIControlType,DefaultValues,BitVisibility)  

	--	VALUES ('8556C487-FA04-48E1-A790-9E01D48262BB', '1', '8CB3016B-1782-4338-A07D-F794FE2473E0', 'Delivered Time', 'Time', 'Range', 'None', 'Date Time', '', '3')

	--END

END

-- end section for either release upgrade or fresh install 

-- start section patchable via updates and runs always no matter what: such as service pack install, loose update install, fresh install, release upgrade etc.

-- This was opened up in V10 using Install.sql and we forgot to open it up in v11

-- Now no matter which install it is, we want this option to be available. 

-- Changes for MR 133360

UPDATE DMSearchCriteriaField

SET InitialDefaultValue = 'Mailbox ownership', BitVisibility = 4

WHERE Id = 'AD4CA164-2541-44AF-98DF-BF40AFA81BD1'



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSearchParameter.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSearchParameter.script,v $ $Id: DMSearchParameter.script,v 1.1 2009/05/18 13:00:08 sgupta Exp $";
-- TABLENAME DMSearchParameter

print '... inserting Table: DMSearchParameter'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSearchParameter

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Language') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('1', 'Language', '6', ';', 'AFRIKAANS;ALBANIAN;ARABIC;ARMENIAN;AZERI;BANGLA;BASQUE;BOSNIAN;BRETON;BULGARIAN;BYELORUSSIAN;CATALAN;CHINESE_SIMPLIFIED;CHINESE_TRADITIONAL;CROATIAN;CZECH;DANISH;DUTCH;ENGLISH;ESPERANTO;ESTONIAN;FAEROESE;FARSI;FILIPINO;FINNISH;FRENCH;FRISIAN;GALICIAN;GEORGIAN;GERMAN;GREEK;GREENLANDIC;HAUSA;HEBREW;HINDI;HUNGARIAN;ICELANDIC;INDONESIAN;IRISH_GAELIC;ITALIAN;JAPANESE;KAZAKH;KIRGHIZ;KOREAN;KURDISH;LATIN;LATVIAN;LETZEBURGESCH;LITHUANIAN;MACEDONIAN;MALAY;MALTESE;MAORI;MONGOLIAN;NORWEGIAN_BOKMAAL;NORWEGIAN_NYNORSK;POLISH;PORTUGUESE;RHAETO_ROMANCE;ROMANIAN;RUSSIAN;SAMI_NORTHERN;SERBIAN;SLOVAK;SLOVENIAN;SPANISH;SWAHILI;SWEDISH;TAMIL;THAI;TURKISH;UKRAINIAN;URDU;UZBEK;VIETNAMESE;WELSH;YIDDISH;ZULU', 'ENGLISH')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Version') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('2', 'Version', '0', ';', 'All version;latest version', 'All version')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Lemmatization') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('3', 'Lemmatization', '0', ';', 'On;Off', 'Off')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Synonym') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('4', 'Synonym', '0', ';', 'On;Off', 'Off')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Search engine') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('5', 'Search engine', '1', NULL, NULL, NULL)


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Sort') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('6', 'Sort', '6', ';', 'URL;Rank;Modified Time', 'URL')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Sort direction') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('7', 'Sort direction', '6', ';', 'Ascending;Descending', 'Ascending')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Navigator support') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('8', 'Navigator support', '0', ';', 'On;Off', 'Off')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Number of results per page') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('9', 'Number of results per page', '1', NULL, NULL, NULL)


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Search within results') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('10', 'Search within results', '0', ';', 'True;False', 'False')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Search file data only') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('11', 'Search file data only', '0', ';', 'True;False', 'False')


END

IF NOT EXISTS (SELECT * FROM DMSearchParameter WHERE Name = 'Search email data only') 

BEGIN
	INSERT INTO DMSearchParameter VALUES('12', 'Search email data only', '0', ';', 'True;False', 'False')


END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSearchParamPreference.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSearchParamPreference.script,v $ $Id: DMSearchParamPreference.script,v 1.1 2009/05/18 12:59:58 sgupta Exp $";
-- TABLENAME DMSearchParamPreference

print '... inserting Table: DMSearchParamPreference'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSearchParamPreference



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMUIAppTypeGroup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMUIAppTypeGroup.script,v $ $Id: DMUIAppTypeGroup.script,v 1.6 2010/02/19 07:06:57 ksundaram Exp $";
-- TABLENAME DMUIAppTypeGroup

print '... inserting Table: DMUIAppTypeGroup'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMUIAppTypeGroup

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 1) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(1, 'BACKEDUP FILES', 'APPGRP_BACKEDUP_FILES')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 2) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(2, 'SHAREPOINT ARCHIVED DOCUMENTS', 'APPGRP_ARCHIVE_DOCS')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 3) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(3, 'SHAREPOINT BACKEDUP DOCUMENTS', 'APPGRP_BACKEDUP_DOCS')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 5) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(5, 'ARCHIVED FILES', 'APPGRP_ARCHIVED_FILES')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 6) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(6, 'EXCHANGE BACKEDUP EMAIL', 'APPGRP_BACKEDUP_MAILS')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 7) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(7, 'EXCHANGE ARCHIVED EMAIL', 'APPGRP_ARCHIVED_MAILS')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 8) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(8, 'EXCHANGE JOURNALED EMAIL', 'APPGRP_JOURNALED_MAILS')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 14) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(14, 'EXCHANGE DATABASE', 'APPGRP_XCHANGEDB')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 17) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(17, 'PROXY', 'APPGRP_PROXYAPPTYPE')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 26) 

BEGIN
	INSERT INTO DMUIAppTypeGroup (Id, FriendlyName, GroupNameResourceKey) VALUES(26, 'LOTUS NOTES DOCUMENTS', 'APPGRP_NOTESDOC')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 27) 

BEGIN
INSERT INTO DMUIAppTypeGroup(Id, FriendlyName, GroupNameResourceKey) VALUES(27, 'ONLINE FILESYSTEM', 'APPGRP_ONLINE_FS')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 28) 

BEGIN
INSERT INTO DMUIAppTypeGroup(Id,FriendlyName,GroupNameResourceKey) VALUES(28, 'ONLINE EMAIL', 'APPGRP_ONLINE_MAIL')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 29) 

BEGIN
INSERT INTO DMUIAppTypeGroup(Id,FriendlyName,GroupNameResourceKey) VALUES(29, 'ONLINE SHAREPOINT', 'APPGRP_ONLINE_SHAREPOINT')


END

IF NOT EXISTS (SELECT * FROM DMUIAppTypeGroup WHERE Id = 30) 

BEGIN
INSERT INTO DMUIAppTypeGroup(Id,FriendlyName,GroupNameResourceKey) VALUES(30, 'LOTUS NOTES ARCHIVED MAIL', 'APPGRP_LN_ARCHIVEDMAIL')


END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMUIAppTypeMap.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMUIAppTypeMap.script,v $ $Id: DMUIAppTypeMap.script,v 1.14 2011/10/13 13:28:38 sgolla Exp $";
-- TABLENAME DMUIAppTypeMap

print '... inserting Table: DMUIAppTypeMap'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMUIAppTypeMap

-- --Moved app types 58,66,73,83 which were in archived files group (5) to Files group with groupid (1)

-- --Moved app type 89 which was in sharepoint archived documents groupid - 2 to Sharepoint backedup Documents - 3

-- --Moved app types 45,56,57,82 which were in exchange archived documents groupid - 7 to Sharepoint backedup Documents - 6

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 1)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (1 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 9)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (9 , 14 , 1 , 0 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 11)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (11 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 13)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (13 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 14)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (14 , 6 , 1 , 0 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 17)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (17 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 18)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (18 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 19)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (19 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 20)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (20 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 21)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (21 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 29)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (29 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 33)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (33 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 34)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (34 , 1 , 0 , 1 , 0 , 1)


END 

ELSE

BEGIN 

IF EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 34 AND (IsEmailAppType = 1 OR IsFileAppType = 0))

UPDATE DMUIAppTypeMap SET IsEmailAppType = 0, IsFileAppType = 1 WHERE AppTypeId = 34

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 35)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (35 , 6 , 1 , 0 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 36)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (36 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 38)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (38 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 39)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (39 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 40)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (40 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 42)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (42 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 43)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (43 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 45)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (45 , 6 , 1 , 0 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 6 WHERE AppTypeId = 45

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 46)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (46 , 3 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 52)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (52 , 26 , 1 , 0 , 0 , 1)


END 

ELSE

BEGIN

IF EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 52 AND AppTypeGroupId <> 26)

UPDATE DMUIAppTypeMap SET

	AppTypeGroupId = 26

	WHERE AppTypeId = 52

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 54)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (54 , 6 , 1 , 0 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 55)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (55 , 6 , 1 , 0 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 56)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (56 , 6 , 1 , 0 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 6 WHERE AppTypeId = 56

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 57)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (57 , 6 , 1 , 0 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 6 WHERE AppTypeId = 57

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 58)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (58 , 1 , 0 , 1 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 1 WHERE AppTypeId = 58

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 63)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (63 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 64)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (64 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 66)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (66 , 1 , 0 , 1 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 1 WHERE AppTypeId = 66

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 67)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (67 , 8 , 1 , 0 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 68)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (68 , 8 , 1 , 0 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 73)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (73 , 1 , 0 , 1 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 1 WHERE AppTypeId = 73

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 74)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (74 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 78)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (78 , 3 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 82)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (82 , 6 , 1 , 0 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 6 WHERE AppTypeId = 82

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 83)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (83 , 1 , 0 , 1 , 0 , 1)


END 

ELSE

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 1 WHERE AppTypeId = 83

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 86)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (86 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 89)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (89 , 3 , 0 , 1 , 0 , 1)


END 

BEGIN

UPDATE DMUIAppTypeMap SET AppTypeGroupId = 3 WHERE AppTypeId = 89

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 90)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (90 , 30 , 1 , 0 , 0 , 1)


END 

ELSE 

BEGIN

IF EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 90 AND (IsEmailAppType = 0 OR IsFileAppType = 1 OR AppTypeGroupId <> 30))

UPDATE DMUIAppTypeMap 

	SET IsEmailAppType = 1,

	    IsFileAppType = 0,

            AppTypeGroupId = 30

		WHERE AppTypeId = 90

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 106)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (106 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 107)

BEGIN
INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) VALUES (107 , 1 , 0 , 1 , 0 , 1)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 105)

BEGIN
INSERT INTO DMUIAppTypeMap(AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType)VALUES(105 , 28 , 1 , 0 , 1 , 0)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 93)

BEGIN
INSERT INTO DMUIAppTypeMap(AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType)VALUES(93 , 27 , 0 , 1 , 1 , 0)


END 

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 1110)

BEGIN
INSERT INTO DMUIAppTypeMap(AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType)VALUES(1110 , 29 , 0 , 1 , 1 , 0)


END 

ELSE

BEGIN

IF EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 1110 AND (IsEmailAppType = 1 OR IsFileAppType = 0))

UPDATE DMUIAppTypeMap SET IsEmailAppType = 0, IsFileAppType = 1 WHERE AppTypeId = 1110

END

GO

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 128)

BEGIN
	INSERT INTO DMUIAppTypeMap(AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType)


	VALUES		(128 , 1 , 0 , 1 , 0 , 1)

END 

GO

--Content Store

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 124)

BEGIN
	INSERT INTO DMUIAppTypeMap(AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType)


	VALUES		(124 , 1 , 0 , 1 , 0 , 1)

END 

GO

--CV_APPTYPE_DPM_AGENT = 91

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 91)

BEGIN
	INSERT INTO DMUIAppTypeMap(AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType)


	VALUES		(91 , 1 , 0 , 1 , 0 , 1)

END 

GO

--CV_APPTYPE_MSEXCHANGE_MAILBOX = 8;

IF NOT EXISTS (SELECT AppTypeId FROM DMUIAppTypeMap WHERE AppTypeId = 8)

BEGIN
	INSERT INTO DMUIAppTypeMap (AppTypeId, AppTypeGroupId, IsEmailAppType, IsFileAppType, IsOnlineAppType, IsOfflineAppType) 


	VALUES (8 , 6 , 1 , 0 , 0 , 1)

END 

GO


GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMConnectionConfig.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMConnectionConfig.script,v $ $Id: DMConnectionConfig.script,v 1.2 2009/07/30 14:53:19 sgolla Exp $";
-- TABLENAME DMConnectionConfig

print '... inserting Table: DMConnectionConfig'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMConnectionConfig

IF NOT EXISTS (SELECT * FROM DMConnectionConfig WHERE Id = '1') 

BEGIN
	INSERT INTO DMConnectionConfig VALUES('1', '23', 'DM280CS\COMMVAULT', 'CommServ', '2GAgRllgRlliglliRllmYllmRllmzllm8llmJllmnllabllmgllimllgmllgRllmYllmallgJllaLllamllglllmillaEllEcllgallgbllgTllgRllgRlliqllgTllmNllaKllgEll')


END

IF NOT EXISTS (SELECT * FROM DMConnectionConfig WHERE Id = '2') 

BEGIN
	INSERT INTO DMConnectionConfig VALUES('2', '2', 'FAST4\COMMVAULTQINETIX', 'CommServ', '2hAMp99Mp99sM99sp99Dm99Dp99DP99Di99D099Do99yB99DM99sD99MD99Mp99DG99Dy99M099yh99yD99M999Ds99yd99dz99My99MB99Mk99Mp99Mp99sm99Mk99DB99y699Md99')


END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMUIColumns.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMUIColumns.script,v $ $Id: DMUIColumns.script,v 1.52 2014/12/24 16:15:52 sgolla Exp $";
-- TABLENAME DMUIColumns

print '... inserting Table: DMUIColumns'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMUIColumns

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'File Name') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('1', 'File Name', 'File_Name_ResourceKey', 'actualFileName', 200, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'File Path') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('2', 'File Path', 'File_Path_ResourceKey', 'folderPathAndFileName', 300, '')

END

--This will be shown by default and is for ALL / FILES Results Grid of search and review set, another column id 80 is being introduced which is hidden by default for sake of Email Results Grid.

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Size') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('3', 'Size', '4^Size_ResourceKey', 'sizeString', 60, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Client Name') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('4', 'Client Name', 'ClientName_ResourceKey', 'clientName', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Modified Time') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('5', 'Modified Time', 'Modified_Time_ResourceKey', 'modifiedUTCTime', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Backup Time') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('6', 'Backup Time', 'BackUP_Time_ResourceKey', 'backupUTCTime', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Rank') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('7', 'Rank', 'Rank_ResourceKey', 'rank', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 8) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('8', '', 'MIME_Type_ResourceKey', 'imageforMimeType', 24, 'RIGHT')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'ViewSource URL') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('9', 'ViewSource URL', 'ViewSource_URL_ResourceKey', 'viewsourceurl', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Subject') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('10', 'Subject', 'AppSpecific_EMail_Subject_ResourceKey', 'emailSubject', 200, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'From') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('11', 'From', 'AppSpecific_EMail_From_ResourceKey', 'emailFrom', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'To') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('12', 'To', 'AppSpecific_EMail_To_ResourceKey', 'emailTo', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Cc') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('13', 'Cc', 'AppSpecific_EMail_Cc_ResourceKey', 'emailCc', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Bcc') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('14', 'Bcc', 'AppSpecific_EMail_Bcc_ResourceKey', 'emailBcc', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 15) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('15', 'Name', 'QueryName_ResourceKey', 'queryName', 140, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 16) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('16', 'Keyword', 'SearchTerms_ResourceKey', 'searchTerms', 140, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 17) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES (17, 'Download Name', 'Download_Name_ResourceKey', N'description', 250, '')

END

--This is for Download Set Items Grid.

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 18) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES (18, 'File Size', 'File_Size_ResourceKey', N'fileSizeKB', 75, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 19) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES (19, 'Creation Time', 'Create_Time_ResourceKey', N'createTime', 110, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 20) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES (20, 'File Type', 'File_Type_ResourceKey', N'fileType', 75, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 21) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES (21, 'Restore Job ID', 'RestoreJob_ID_ResourceKey', N'restoreJobID', 110, 'CENTER')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 22) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES (22, 'Status', 'status_ResourceKey', N'status', 140, '')

END

ELSE

BEGIN

	UPDATE DMUIColumns SET Alignment = '', Width = 140

	WHERE Id = 22

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 23) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES (23, '', 'export_XML_ResourceKey', N'xmlLink', 100, 'CENTER')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 24) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('24', 'Review Set(s)', 'ReviewSets_ResourceKey', 'reviewSetNames', 140, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 25) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('25', 'Tag(s)', 'Tags_ResourceKey', 'tagNames', 140, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 26) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('26', 'Received Time', 'Received_Time_ResourceKey', 'modifiedUTCTime', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 27) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('27', 'Retrieved', 'Restore_Status_ResourceKey', 'imageForRestoreStatus', 25, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 28) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('28', 'Title', 'Common_Title_ResourceKey', 'documentTitle', 200, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 29) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('29', 'Location', 'Common_Location_ResourceKey', 'location', 200, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 31) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('31', 'CI Engine', 'CIEngine_ResourceKey', 'fastEngine', 120, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 32) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('32', 'Tag Name', 'TagName_ResourceKey', 'name', 200, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 33) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('33', 'Header', 'EmailHeader_ResourceKey', 'emailHeader', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 34) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (34, 'DB Tag(s)','DBTags_ResouceKey','dbTagNames',140,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 35) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (35, 'Description','Description_ResouceKey','description',140,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 36) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (36, 'Enabled','Enabled_ResouceKey','enabled',140,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 37) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (37, 'JobId','JobId_ResouceKey','jobId',100,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 38) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values  (38, 'JobType','JobType_ResouceKey','jobType',100,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 39) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (39, 'DestClientName','destClientName_ResouceKey','destClientName',200,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 40) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (40, 'Status','Status_ResouceKey','status',140,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 41) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (41, 'JobStartTime','JobStartTime_ResouceKey','jobStartTime',200,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 42) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (42, 'JobEndTime','JobEndTime_ResouceKey','jobEndTime',200,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 43) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (43, 'PreferenceName','PreferenceName_ResouceKey','prefName',200,'')	

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 44) 

BEGIN
	insert into DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment)


	values (44, 'PreferenceValue','PreferenceValue_ResouceKey','prefValue',200,'')	

END

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 1 AND ResourceKey <> '4^File_Name_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^File_Name_ResourceKey' 

WHERE Id = 1

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 2 AND ResourceKey <> '4^File_Path_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^File_Path_ResourceKey' 

WHERE Id = 2

--SizeKB_ResourceKey renamed as the column and value will show whether it is KB or MB. This is always shown by default.

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 3 AND ResourceKey <> '4^Size_ResourceKey') 

UPDATE DMUIColumns SET ResourceKey = '4^Size_ResourceKey' 

WHERE Id = 3

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 5 AND ResourceKey <> '4^Modified_Time_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Modified_Time_ResourceKey' 

WHERE Id = 5

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 8 AND ResourceKey <> '14^MIME_Type_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '14^MIME_Type_ResourceKey' 

WHERE Id = 8

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 10 AND ResourceKey <> '4^AppSpecific_EMail_Subject_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^AppSpecific_EMail_Subject_ResourceKey' 

WHERE Id = 10

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 14 AND ResourceKey <> 'AppSpecific_EMail_Bcc_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = 'AppSpecific_EMail_Bcc_ResourceKey' 

WHERE Id = 14

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 11 AND ResourceKey <> '4^AppSpecific_EMail_From_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^AppSpecific_EMail_From_ResourceKey' 

WHERE Id = 11

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 25 AND ResourceKey <> 'Tags_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = 'Tags_ResourceKey' 

WHERE Id = 25

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 26 AND ResourceKey <> '4^Received_Time_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Received_Time_ResourceKey' 

WHERE Id = 26

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 28 AND ResourceKey <> '4^Common_Title_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Common_Title_ResourceKey' 

WHERE Id = 28

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 29 AND ResourceKey <> '4^Common_Location_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Common_Location_ResourceKey' 

WHERE Id = 29

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 15 AND ResourceKey <> '4^QueryName_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^QueryName_ResourceKey' 

WHERE Id = 15 AND ResourceKey <> '4^QueryName_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 16 AND ResourceKey <> '4^SearchTerms_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^SearchTerms_ResourceKey' 

WHERE Id = 16 AND ResourceKey <> '4^SearchTerms_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 17 AND ResourceKey <> '4^Download_Name_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Download_Name_ResourceKey' 

WHERE Id = 17 AND ResourceKey <> '4^Download_Name_ResourceKey'

--This is for Download Set Items Grid.

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 18 AND ResourceKey <> '4^File_Size_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^File_Size_ResourceKey' 

WHERE Id = 18 AND ResourceKey <> '4^File_Size_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 19 AND ResourceKey <> '4^Create_Time_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Create_Time_ResourceKey' 

WHERE Id = 19 AND ResourceKey <> '4^Create_Time_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 20 AND ResourceKey <> '4^File_Type_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^File_Type_ResourceKey' 

WHERE Id = 20 AND ResourceKey <> '4^File_Type_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 21 AND ResourceKey <> '4^RestoreJob_ID_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^RestoreJob_ID_ResourceKey' 

WHERE Id = 21 AND ResourceKey <> '4^RestoreJob_ID_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 22 AND ResourceKey <> '4^status_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^status_ResourceKey' 

WHERE Id = 22 AND ResourceKey <> '4^status_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 23 AND ResourceKey <> '4^export_XML_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^export_XML_ResourceKey' 

WHERE Id = 23 AND ResourceKey <> '4^export_XML_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 32 AND ResourceKey <> '4^TagName_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = '4^TagName_ResourceKey' 

WHERE Id = 32 AND ResourceKey <> '4^TagName_ResourceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 35 AND ResourceKey <> '4^Description_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Description_ResouceKey' 

WHERE Id = 35 AND ResourceKey <> '4^Description_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 36 AND ResourceKey <> '4^Enabled_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Enabled_ResouceKey' 

WHERE Id = 36 AND ResourceKey <> '4^Enabled_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 37 AND ResourceKey <> '4^JobId_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^JobId_ResouceKey' 

WHERE Id = 37 AND ResourceKey <> '4^JobId_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 38 AND ResourceKey <> '4^JobType_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^JobType_ResouceKey' 

WHERE Id = 38 AND ResourceKey <> '4^JobType_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 39 AND ResourceKey <> '4^destClientName_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^destClientName_ResouceKey' 

WHERE Id = 39 AND ResourceKey <> '4^destClientName_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 40 AND ResourceKey <> '4^Status_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^Status_ResouceKey' 

WHERE Id = 40 AND ResourceKey <> '4^Status_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 41 AND ResourceKey <> '4^JobStartTime_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^JobStartTime_ResouceKey' 

WHERE Id = 41 AND ResourceKey <> '4^JobStartTime_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 42 AND ResourceKey <> '4^JobEndTime_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^JobEndTime_ResouceKey' 

WHERE Id = 42 AND ResourceKey <> '4^JobEndTime_ResouceKey'

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 27 AND Width <> 80) 

BEGIN

	UPDATE DMUIColumns SET Width = 80 WHERE Id = 27

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 46) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('46', 'Hold', 'LH_Status_ResourceKey', 'legalHoldStatus', 150, '')

END

ELSE

BEGIN

	UPDATE DMUIColumns SET ResourceKey = 'LH_Status_ResourceKey' 

	WHERE Id = 46

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 47) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('47', 'Record Center', 'RC_Status_ResourceKey', 'imageForERMStatus', 100, 'CENTER')

END

ELSE

BEGIN

	UPDATE DMUIColumns SET ResourceKey = 'RC_Status_ResourceKey' 

	WHERE Id = 47

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 45) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('45', '', '14^Comment_ResourceKey', 'imageForComments', 30, 'CENTER')

END

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 43 AND ResourceKey = 'PreferenceName_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^PreferenceName_ResouceKey'	

WHERE Id = 43

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 44 AND ResourceKey = 'PreferenceValue_ResouceKey')

UPDATE DMUIColumns SET ResourceKey = '4^PreferenceValue_ResouceKey'	

WHERE Id = 44

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 27 AND ResourceKey <> 'Restore_Status_ResourceKey')

UPDATE DMUIColumns SET ResourceKey = 'Restore_Status_ResourceKey'

WHERE Id = 27

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 48) 

BEGIN

	INSERT DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment) 

	VALUES (48,'DB Tag(s)','4^DBTags_ResouceKey_LH','dbTagNames',140,'')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 49) 

BEGIN

	INSERT DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment) 

	VALUES (49,'Custodian','EmailOwner_ResouceKey','emailOwner',140,'')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 50) 

BEGIN

	INSERT DMUIColumns (Id,ColumnName,ResourceKey,PropertyName,Width,Alignment) 

	VALUES (50,'Item Added','Item_Created','itemAddedTime',140,'')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 51) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('51', 'Attachment', '4^AppSpecific_EMail_AttachmentName_ResourceKey', 'emailAttachmentName', 200, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 52) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('52', 'Attachments', '4^AppSpecific_EMail_Attachments_ResourceKey', 'emailAttachments', 500, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 53) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('53', 'Attachment Info', 'AppSpecific_EMail_Attachment_Info_ResourceKey', 'emailAttachmentInfo', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 54) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('54', 'Folder', 'AppSpecific_EMail_Folder', 'folderPathAndFileName', 100, '')

END

-- -- Start entries for health care grid -- --

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 55) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('55', 'Acquisition Date', '4^Acquisition_Date', 'acqDate', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 56) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('56', 'Site', '4^HealthCareSite', 'site', 180, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 57) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('57', 'Patient Name', '4^Patient_Name', 'patientName', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 58) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('58', 'Patient ID', '4^Patient_ID', 'patientID', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 59) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('59', 'Date of Birth', 'Date_of_Birth', 'dobString', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 60) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('60', 'Modality', '4^Modality', 'modality', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 61) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('61', 'Image Level', 'ImageLevel', 'imageLevel', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 62) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('62', 'Exam', 'HealthCareExam', 'examDetails', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 63) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('63', 'Image', 'HealthCareImage', 'image', 110, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 64) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('64', 'Study Description', '4^StudyDescription', 'studyDescription', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 65) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('65', 'Study ID', 'StudyID', 'studyId', 80, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 66) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('66', 'Gender', 'PatientGender', 'gender', 80, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 67) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('67', 'Series Number', 'SeriesNumber', 'seriesNumber', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 68) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('68', 'Patient', 'PatientInfo', 'patientInfo', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 69) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('69', 'Institution', 'Institution', 'site', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 70) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('70', 'Content', 'ContentInfo', 'contentInfo', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 71) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('71', 'Study', 'StudyInfo', 'studyInfo', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 72) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('72', 'Manufacturer', 'ManufacturerName', 'manufacturerName', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 73) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('73', 'Win', 'Win', 'winWidth', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 74) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('74', 'Level', 'WinCenter', 'winCenter', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 75) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)  


	VALUES ('75', 'Thickness', 'Thickness', 'thickness', 90, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 76) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('76', 'Sent', 'Sent_ResourceKey', 'modifiedUTCTime', 150, '')

END

-- New entries for export set grid.

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 77) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('77', 'Total_Items_Count', 'Total_Items_Count_ResourceKey', 'totalItemsCount', 80, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 78) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('78', 'Success_Items_Count', 'Success_Items_Count_ResourceKey', 'successItemsCount', 80, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 79) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('79', 'Mailbox', '4^Mailbox_ResourceKey', 'mailBox', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 80) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('80', 'Size', 'Size_DefaultShow_ResourceKey', 'sizeString', 60, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 81) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('81', 'Case Name', '4^CaseName_ResourceKey', 'caseName', 200, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 82) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('82', 'Create Time', '4^CaseCreateTime_ResourceKey', 'caseCreateTime', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 83) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('83', 'Retain Until', '4^RetainUntil_ResourceKey', 'retention', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 84) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('84', 'Storage Policy', '4^StoragePolicy_ResourceKey', 'storagePolicyName', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 85) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('85', 'Creator', '4^Creator_ResourceKey', 'caseCreatedByName', 150, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 86) 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	VALUES ('86', 'Case Status', '4^CaseStatus_ResourceKey', 'caseStatus', 100, '')

END

-- Ensure 87 WILL BE MADE JobId column for sake of case manager job status grid

IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 87 AND PropertyName <> 'jobId') 

BEGIN

	UPDATE DMUIColumns

	SET Columnname = 'JobId', ResourceKey = '4^JobId_ResourceKey', PropertyName = 'jobId', Width = 100

	WHERE Id = 87

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 87 AND PropertyName = 'jobId') 

BEGIN
    INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


    VALUES ('87', 'JobId', '4^JobId_ResourceKey', 'jobId', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 88) 

BEGIN
    INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


    VALUES ('88', 'App_Type', '4^DataType_ResourceKey', 'dataType', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 89) 

BEGIN
    INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


    VALUES ('89', 'Job_Status', '4^JobStatusString_ResourceKey', 'jobStatusString', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 90) 

BEGIN
    INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


    VALUES ('90', 'JobStartTime', '4^JobStartTime_ResourceKey', 'startTime', 100, '')

END

ELSE IF EXISTS (SELECT * FROM DMUIColumns where Id = 90 AND PropertyName <> 'startTime')

BEGIN

	UPDATE DMUIColumns

	SET PropertyName = 'startTime'

	WHERE Id = 90

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 91) 

BEGIN
    INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


    VALUES ('91', 'JobEndTime', '4^JobEndTime_ResourceKey', 'endTime', 100, '')

END

ELSE IF EXISTS (SELECT * FROM DMUIColumns where Id = 91 AND PropertyName <> 'endTime')

BEGIN

	UPDATE DMUIColumns

	SET PropertyName = 'endTime'

	WHERE Id = 91

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 92) 

BEGIN
    INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


    VALUES ('92', 'BackupLevel', 'BackupLevel_ResourceKey', 'backupLevel', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE Id = 93) 

BEGIN
    INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


    VALUES ('93', 'Total_Items_Count', 'TotalItemsCount_ResourceKey', 'numberOfItems', 100, '')

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE PropertyName = 'itemDeliveredTime') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	SELECT MAX(ID)+1, 'Delivered Time', 'DeliveredTime_ResourceKey', 'itemDeliveredTime', 150, ''

	FROM DMUIColumns

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE PropertyName = 'contentIndexStatus') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	SELECT MAX(ID)+1, 'Content Index Status', 'CIStatus_ResourceKey', 'contentIndexStatus', 100, ''

	FROM DMUIColumns

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE PropertyName = 'duration') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	SELECT MAX(ID)+1, 'Copy Duration', 'Duration_ResourceKey', 'duration', 100, ''

	FROM DMUIColumns

END

IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE PropertyName = 'sizeOfApplication') 

BEGIN
	INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment) 


	SELECT MAX(ID)+1, 'Application Size', 'SizeOfApp_ResourceKey', 'sizeOfApplication', 100, ''

	FROM DMUIColumns

END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMUIPanelType.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMUIPanelType.script,v $ $Id: DMUIPanelType.script,v 1.13 2014/10/31 16:30:07 sgolla Exp $";
-- TABLENAME DMUIPanelType

print '... inserting Table: DMUIPanelType'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMUIPanelType

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'AllSearchResultsGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('1', 'AllSearchResultsGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'FileSearchResultsGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('2', 'FileSearchResultsGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'EmailSearchResultsGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('3', 'EmailSearchResultsGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'ReviewSetGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('4', 'ReviewSetGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'QueriesGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('5', 'QueriesGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'LegalHoldGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('6', 'LegalHoldGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'EmailResultItemPreviewHeader') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('7', 'EmailResultItemPreviewHeader')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'FileResultItemPreviewHeader') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('8', 'FileResultItemPreviewHeader')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'DownLoadSetGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES (9, 'DownLoadSetGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'TagsGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('10', 'TagsGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'BrowseGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('11', 'BrowseGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'FileSystemIDABrowseGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('12', 'FileSystemIDABrowseGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'ExchangeIDABrowseGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('13', 'ExchangeIDABrowseGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'LotusNotesIDABrowseGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('14', 'LotusNotesIDABrowseGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'AllSearchResultsGrid_LH') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('15', 'AllSearchResultsGrid_LH')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'FileSearchResultsGrid_LH') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('16', 'FileSearchResultsGrid_LH')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'EmailSearchResultsGrid_LH') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('17', 'EmailSearchResultsGrid_LH')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'JobStatusGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('18', 'JobStatusGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'PreferencesGrid') 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('19', 'PreferencesGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'FilterGrid' AND Id = 20) 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('20', 'FilterGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'HealthCareSearchGrid' AND Id = 23) 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('23', 'HealthCareSearchGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Name = 'HealthCarePreviewHeader' AND Id = 24) 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('24', 'HealthCarePreviewHeader')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Id = 25) 

BEGIN
	INSERT INTO DMUIPanelType (Id, Name) 


	VALUES ('25', 'CaseManagerGrid')

END

IF NOT EXISTS (SELECT * FROM DMUIPanelType WHERE Id = 26) 

BEGIN
    INSERT INTO DMUIPanelType (Id, Name) 


    VALUES ('26', 'CaseManagerJobsGrid')

END



GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMUIPanelColumns.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMUIPanelColumns.script,v $ $Id: DMUIPanelColumns.script,v 1.69 2014/12/24 16:15:52 sgolla Exp $";
-- TABLENAME DMUIPanelColumns

print '... inserting Table: DMUIPanelColumns'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMUIPanelColumns

--In 9.0 this table is introduced.Deleting caused problem in 9.0 to 10.0 upgrade where its not updating certain records as expected.This delete statement is of no use except to cause maintenance issue.

--IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = '1') 

--BEGIN

	--DELETE FROM DMUIPanelColumns WHERE PanelTypeId = '1'

--END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '4' AND PanelTypeId = '1') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('3', '4', '1', '3', 6)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 6 WHERE ColumnId = 4 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '5' AND PanelTypeId = '1') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('4', '5', '1', '3', 7)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 7 WHERE ColumnId = 5 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '1' AND PanelTypeId = '2') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('5', '1', '2', '3', 3)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 3 WHERE ColumnId = 1 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '2' AND PanelTypeId = '2') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('6', '2', '2', '3', 4)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 4 WHERE ColumnId = 2 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '4' AND PanelTypeId = '2') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('7', '4', '2', '3', 6)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 6 WHERE ColumnId = 4 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '5' AND PanelTypeId = '2') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('8', '5', '2', '3', 7)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 7 WHERE ColumnId = 5 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '1' AND PanelTypeId = '8') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('9', '1', '8', '3', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '2' AND PanelTypeId = '8') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('10', '2', '8', '3', 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '4' AND PanelTypeId = '8') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('11', '4', '8', '3', 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '12') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('12', '11', '7', '3', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '13') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('13', '12', '7', '3', 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '14') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('14', '13', '7', '3', 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '16') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('16', '14', '7', '2', 4)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '1') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('1', '10', '7', '3', 0)

END

--Making subject as first column in the list for email preview column config.

IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = 7 AND ColumnId = 10 AND DisplayOrder <> 0)

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 0 

	WHERE ColumnId = 10 and PanelTypeId = 7

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '15') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('15', '3', '1', '3', 5)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 5 WHERE ColumnId = 3 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '8' AND PanelTypeId = '1') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('17', '8', '1', '3', 1)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 1 WHERE ColumnId = 8 AND PanelTypeId = 1

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '20') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('20', '15', '5', '3', 0)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '21') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('21', '16', '5', '3', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '11' AND PanelTypeId = '3') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('22', '11', '3', '3', 3)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 3 WHERE ColumnId = 11 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '12' AND PanelTypeId = '3') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('23', '12', '3', '3', 4)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 4 WHERE ColumnId = 12 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '10' AND PanelTypeId = '3') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('24', '10', '3', '3', 6)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 6 WHERE ColumnId = 10 AND PanelTypeId = 3 

END

--This (Size column) will be hidden by default and is for Email Results Grid.

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '25') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('25', '80', '3', '3', 8)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 8, ColumnId = 80 WHERE Id = 25

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '4' AND PanelTypeId = '3') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('26', '4', '3', '3', 10)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 10 WHERE ColumnId = 4 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '3' AND PanelTypeId = '2') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('27', '3', '2', '3', 5)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 5 WHERE ColumnId = 3 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '17' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (28, 17, 9, 3, 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '18' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (29, 18, 9, 3, 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '19' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (30, 19, 9, 3, 3)

END	

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '20' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (31, 20, 9, 3, 4)

END	

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '21' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (32, 21, 9, 3, 5)

END	

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '22' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (33, 22, 9, 3, 6)

END	

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '23' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (34, 23, 9, 0, 7)

END	

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET BitVisibility = 0 

	WHERE ColumnId = 23 AND PanelTypeId = 9

END

-- New entries for export set grid.

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '77' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 77, 9, 3, 8

	FROM DMUIPanelColumns

END	

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '78' AND PanelTypeId = '9') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 78, 9, 3, 9

	FROM DMUIPanelColumns

END	

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '35') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('35', '24', '2', '0', 8)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 8, BitVisibility = 0 

	WHERE ColumnId = 24 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '36') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('36', '24', '3', '0', 12)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 12, BitVisibility = 0

	WHERE ColumnId = 24 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '37') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('37', '25', '2', '0', 10)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 10, BitVisibility = 0

	WHERE ColumnId = 25 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '38') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('38', '25', '3', '0', 13)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 13, BitVisibility = 0

	WHERE ColumnId = 25 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = 3 AND ColumnId = 26) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '26', '3', '3', 7 FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 7 WHERE ColumnId = 26 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '42') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('42', '28', '1', '3', 3)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 3 WHERE ColumnId = 28 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '43') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('43', '29', '1', '3', 4)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 4 WHERE ColumnId = 29 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '44') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('44', '24', '1', '0', 9)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 9, BitVisibility = 0 

	WHERE ColumnId = 24 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '45') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('45', '25', '1', '0', 10)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 10, BitVisibility = 0

	WHERE ColumnId = 25 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '47') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('47', '31', '1', '0', 8)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 8 WHERE ColumnId = 31 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '48') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('48', '31', '2', '0', 9)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 9 WHERE ColumnId = 31 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '49') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('49', '31', '3', '0', 11)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 11 WHERE ColumnId = 31 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '50') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('50', '32', '10', '2', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '51') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('51', '33', '3', '0', 15)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 15, BitVisibility = 0 WHERE ColumnId = 33 AND PanelTypeId = 3 

END

-- PanelTypeId = 7 (Email Preview)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '52') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES ('52', '33', '7', '0', 6)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns

	SET BitVisibility = 0

	WHERE Id = 52

END

-- Removing Restore Status / Retrieved column from email preview column config..

-- PanelTypeId = 7 (Email Preview)

IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = 7 AND ColumnId = 27) 

BEGIN

	DELETE FROM DMUIPanelColumns WHERE PanelTypeId = 7 AND ColumnId = 27

END

-- Removing Restore Status / Retrieved column from file preview column config..

IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = 8 AND ColumnId = 27)

BEGIN

	DELETE FROM DMUIPanelColumns WHERE PanelTypeId = 8 AND ColumnId = 27

END

--Columns for FileSystemIDABrowseGrid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '55') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('55', '12', '8', '3', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '56') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('56', '12', '1', '3', 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '57') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('57', '12', '3', '3', 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '58') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('58', '12', '5', '3', 4)

END

--Columns for ExchangeIDABrowseGrid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '59') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('59', '13', '8', '3', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '60') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('60', '13', '11', '3', 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '61') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('61', '13', '12', '3', 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '62') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('62', '13', '10', '3', 4)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '63') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('63', '13', '5', '3', 5)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '64') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('64', '13', '3', '3', 6)

END

--Columns for LotusNotesIDABrowseGrid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '65') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('65', '14', '8', '3', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '66') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('66', '14', '11', '3', 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '68') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('68', '14', '10', '3', 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '69') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('69', '14', '5', '3', 4)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '70') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('70', '14', '3', '3', 5)

END

--Columns for Default BrowseGrid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '71') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('71', '11', '8', '3', 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '72') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('72', '11', '1', '3', 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '73') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('73', '11', '3', '3', 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = '74') 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES ('74', '11', '5', '3', 4)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = 11 AND ColumnId = 27) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '11', '27', '3', 4

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = 12 AND ColumnId = 27) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '12', '27', '3', 4

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  PanelTypeId = 13 AND ColumnId = 27) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '13', '27', '3', 4

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  PanelTypeId = 14 AND ColumnId = 27) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '14', '27', '3', 4

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 79 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (79,15, 8, 2, 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 80 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (80,15, 28, 2, 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 81 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (81,15, 2, 2, 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 82 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (82,15, 3, 2, 4)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 83 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (83,15, 4, 2, 8)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 84 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (84,15, 5, 2, 11)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 86 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (86,15, 25, 2, 9)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 87 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (87,16, 1, 2, 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 88 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (88,16, 2, 2, 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 89 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (89,16, 3, 2, 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 90 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (90,16, 4, 2, 4)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 91 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (91,16, 5, 2, 5)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 93 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (93,16, 25, 2, 6)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 94 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (94,16, 31, 2, 6)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 95 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (95,17, 11, 2, 1)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 96 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (96,17, 12, 2, 2)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 97 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (97,17, 10, 2, 3)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 98 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (98,17, 3, 2, 4)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 99 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (99,17, 4, 2, 5)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 100 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (100,17, 26, 2, 7)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 101 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (101,17, 31, 2, 7)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 103 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (103,17, 25, 2, 9)

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 104 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	VALUES (104,17, 33, 0, 10)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET BitVisibility = 0 WHERE ColumnId = 33 AND PanelTypeId = 17

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 105 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (105,34,2,0,11)

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 11, BitVisibility = 2

	WHERE ColumnId = 34 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 106 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (106,34,3,0,14);

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 14, BitVisibility = 2

	WHERE ColumnId = 34 AND PanelTypeId = 3 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 107 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (107,34,1,0,11);

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 11, BitVisibility = 2

	WHERE ColumnId = 34 AND PanelTypeId = 1 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 108 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (108,48,15,2,10);

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET BitVisibility = 2

	WHERE ColumnId = 48 AND PanelTypeId = 15

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 109 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (109,48,16,2,6);

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET BitVisibility = 2

	WHERE ColumnId = 48 AND PanelTypeId = 16

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 110 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (110,48,17,2,9);

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET BitVisibility = 2

	WHERE ColumnId = 48 AND PanelTypeId = 17

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 111 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (111,35,10,2,2);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 112 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (112,36,10,2,3);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 113 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (113,37,18,3,1);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 114 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (114,38,18,3,2);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 115 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (115,39,18,3,3);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 116 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (116,40,18,3,4);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 117 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (117,41,18,3,5);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 118 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (118,42,18,3,6);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 119 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (119,43,19,3,1);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE Id = 120 ) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id,ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	VALUES (120,44,19,3,2);

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 8 AND PanelTypeId = 2) 

BEGIN
	INSERT INTO DMUIPanelColumns (id, columnid, paneltypeid, BitVisibility, DisplayOrder)


	SELECT MAX(ID) + 1 AS ID, 8 AS COLUMNID, 2 AS PANELTYPEID, 3 AS BITVISIBILITY, 1 AS DISPLAYORDER

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 1 WHERE ColumnId = 8 AND PanelTypeId = 2 

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 8 AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (id, columnid, paneltypeid, BitVisibility, DisplayOrder)


	SELECT MAX(ID) + 1 AS ID, 8 AS COLUMNID, 3 AS PANELTYPEID, 3 AS BITVISIBILITY, 1 AS DISPLAYORDER

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 1 WHERE ColumnId = 8 AND PanelTypeId = 3 

END

--Remove Retrieved for ALL Results Grid

IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '27' AND PanelTypeId = 1) 

BEGIN

	DELETE FROM DMUIPanelColumns WHERE PanelTypeId = 1 AND ColumnId = 27

END

--Remove Retrieved for File Results Grid

IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '27' AND PanelTypeId = 2) 

BEGIN

	DELETE FROM DMUIPanelColumns WHERE PanelTypeId = 2 AND ColumnId = 27

END

--Remove Retrieved for Email Results Grid

IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '27' AND PanelTypeId = 3) 

BEGIN

	DELETE FROM DMUIPanelColumns WHERE PanelTypeId = 3 AND ColumnId = 27

END

--Hold for All Results Grid (Only for compliance view)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '46' AND PanelTypeId = 1) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '46', '1', '0', 13

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 13, BitVisibility = 0

	WHERE ColumnId = 46 AND PanelTypeId = 1 

END

--Hold for File Results Grid (Only for compliance view)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '46' AND PanelTypeId = 2) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '46', '2', '0', 13

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 13, BitVisibility = 0

	WHERE ColumnId = 46 AND PanelTypeId = 2 

END

--Hold for Email Results Grid (Only for compliance view)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '46' AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '46', '3', '0', 17

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 17, BitVisibility = 0

	WHERE ColumnId = 46 AND PanelTypeId = 3 

END

--Record Center for All Results Grid (Only for compliance view)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '47' AND PanelTypeId = 1) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '47', '1', '0', 14

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 14, BitVisibility = 0 WHERE ColumnId = 47 AND PanelTypeId = 1 

END

--Record Center for File Results Grid (Only for compliance view)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '47' AND PanelTypeId = 2) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '47', '2', '0', 14

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 14, BitVisibility = 0 WHERE ColumnId = 47 AND PanelTypeId = 2 

END

--Record Center for Email Results Grid (Only for compliance view)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '47' AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '47', '3', '0', 19

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 19, BitVisibility = 0 WHERE ColumnId = 47 AND PanelTypeId = 3 

END

--Comments for Legal Hold Grid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '45' AND PanelTypeId = 15) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '45', '15', '3', 0

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 45)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 45 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 0 AS DisplayOrder 

	FROM DMUIPanelColumns --  -- imageForComments

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 8)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 8 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 1 AS DisplayOrder 

	FROM DMUIPanelColumns --  -- imageforMimeType

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 28)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 28 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 2 AS DisplayOrder 

	FROM DMUIPanelColumns -- Title -- documentTitle

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 29)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 29 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 3 AS DisplayOrder 

	FROM DMUIPanelColumns -- Location -- location

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 3)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 3 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 4 AS DisplayOrder 

	FROM DMUIPanelColumns -- Size -- sizeString

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 4)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 4 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 5 AS DisplayOrder 

	FROM DMUIPanelColumns -- Client Name -- clientName

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 5)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 5 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 6 AS DisplayOrder 

	FROM DMUIPanelColumns -- Modified Time -- modifiedUTCTime

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 31)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 31 AS ColumnId, 20 as PanelTypeId, 0 AS BitVisibility, 7 AS DisplayOrder 

	FROM DMUIPanelColumns -- CI Engine -- fastEngine

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 24)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 24 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 8 AS DisplayOrder 

	FROM DMUIPanelColumns -- Review Set(s) -- reviewSetNames

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 25)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 25 AS ColumnId, 20 as PanelTypeId, 2 AS BitVisibility, 9 AS DisplayOrder 

	FROM DMUIPanelColumns -- Tag(s) -- tagNames

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 34)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 34 AS ColumnId, 20 as PanelTypeId, 2 AS BitVisibility, 10 AS DisplayOrder 

	FROM DMUIPanelColumns -- DB Tag(s) -- dbTagNames

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 27)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 27 AS ColumnId, 20 as PanelTypeId, 3 AS BitVisibility, 15 AS DisplayOrder 

	FROM DMUIPanelColumns -- Retrieved -- imageForRestoreStatus

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 46)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 46 AS ColumnId, 20 as PanelTypeId, 2 AS BitVisibility, 16 AS DisplayOrder 

	FROM DMUIPanelColumns -- Hold -- legalHoldStatus

END

IF NOT EXISTS (SELECT Id FROM DMUIPanelColumns WHERE PanelTypeId = 20 AND ColumnId = 47)

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(Id) + 1 AS Id, 47 AS ColumnId, 20 as PanelTypeId, 0 AS BitVisibility, 17 AS DisplayOrder 

	FROM DMUIPanelColumns -- Record Center -- imageForERMStatus

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET BitVisibility = 0 WHERE PanelTypeId = 20 AND ColumnId = 47

END

--Comments for ALL results grid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '45' AND PanelTypeId = 1) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '45', '1', '3', 2

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 2 WHERE ColumnId = 45 AND PanelTypeId = 1 

END

--Comments for File results grid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '45' AND PanelTypeId = 2) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '45', '2', '3', 2

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 2 WHERE ColumnId = 45 AND PanelTypeId = 2 

END

--Comments for Email results grid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '45' AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '45', '3', '3', 2

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 2 WHERE ColumnId = 45 AND PanelTypeId = 3 

END

--CC For Email Results Grid for both compliance and end user site..

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE PanelTypeId = 3 AND ColumnId = 13) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, PanelTypeId, ColumnId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1, '3', '13', '3', 5 FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 5 WHERE ColumnId = 13 AND PanelTypeId = 3 

END

--Bcc for Email Results Grid only for compliance site

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '14' AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '14', '3', '2', 20

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 20 WHERE ColumnId = 14 AND PanelTypeId = 3 

END

--Email owner for Email Results Grid only for compliance site

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '49' AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '49', '3', '2', 9

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 9 WHERE ColumnId = 49 AND PanelTypeId = 3 

END

--Legal Hold ALL Results Tab -- Email From

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '11' AND PanelTypeId = 15) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '11', '15', '2', 5

	FROM DMUIPanelColumns

END

--Legal Hold ALL Results Tab -- Email To

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '12' AND PanelTypeId = 15) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '12', '15', '2', 6

	FROM DMUIPanelColumns

END

--Legal Hold ALL Results Tab -- Email Owner (Custodian)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '49' AND PanelTypeId = 15) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '49', '15', '2', 7

	FROM DMUIPanelColumns

END

--Item Added Date for ALL results grid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '50' AND PanelTypeId = 1) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '50', '1', '3', 15

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 15 WHERE ColumnId = 50 AND PanelTypeId = 1 

END

--Item Added Date for File results grid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '50' AND PanelTypeId = 2) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '50', '2', '3', 15

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 15 WHERE ColumnId = 50 AND PanelTypeId = 2 

END

--Item Added Date for Email results grid

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE  ColumnId = '50' AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '50', '3', '3', 21

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 21 WHERE ColumnId = 50 AND PanelTypeId = 3 

END

--Attachments Column for Email Results Grid (MR 58600)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '53' AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, '53', '3', '3', 18

	FROM DMUIPanelColumns

END

ELSE

BEGIN

	UPDATE DMUIPanelColumns SET DisplayOrder = 18 WHERE ColumnId = 53 AND PanelTypeId = 3 

END

--Folder Column for Email Results Grid (hidden by default)

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 54 AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 54, 3, 3, 22

	FROM DMUIPanelColumns

END

-- -- Start entries for health care grid -- --

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 55 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 55, 23, 2, 1

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 56 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 56, 23, 2, 2

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 57 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 57, 23, 2, 3

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 58 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 58, 23, 0, 4

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 59 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 59, 23, 2, 5

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 60 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 60, 23, 2, 6

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 61 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 61, 23, 0, 7

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 62 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 62, 23, 0, 8

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 63 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 63, 23, 2, 9

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 64 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 64, 23, 2, 10

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 65 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 65, 23, 2, 11

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 66 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 66, 23, 2, 12

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 67 AND PanelTypeId = 23) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 67, 23, 2, 13

	FROM DMUIPanelColumns

END

--Preview Panel Config for health care search item

--Patient

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  68 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 68, 24, 2, 1

	FROM DMUIPanelColumns

END

--Institution / Site

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  69 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 69, 24, 2, 2

	FROM DMUIPanelColumns

END

--Content Info

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  70 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 70, 24, 2, 3

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  71 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 71, 24, 2, 4

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  67 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 67, 24, 2, 5

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  72 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 72, 24, 2, 6

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  73 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 73, 24, 2, 7

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  74 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 74, 24, 2, 8

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  75 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 75, 24, 2, 9

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  29 AND PanelTypeId = 24) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 29, 24, 2, 10

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId =  76 AND PanelTypeId = 7) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 76, 7, 3, 7

	FROM DMUIPanelColumns

END

--Mailbox column for email results grid.

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 79 AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 79, 3, 3, 9

	FROM DMUIPanelColumns

END

--Case Manager grid columns

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 81 AND PanelTypeId = 25) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 81, 25, 2, 1

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 82 AND PanelTypeId = 25) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 82, 25, 2, 3

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 84 AND PanelTypeId = 25) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 84, 25, 2, 7

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 85 AND PanelTypeId = 25) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 85, 25, 2, 9

	FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 86 AND PanelTypeId = 25) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, 86, 25, 2, 11

	FROM DMUIPanelColumns

END

-- Ensure mapping of columnid 87 to panel type 26 (case manager job status) 

IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 87 AND PanelTypeId <> 26) 

BEGIN

	UPDATE DMUIPanelColumns

	SET PanelTypeId = 26, BitVisibility = 2, DisplayOrder = 1

	WHERE ColumnId = 87 AND PanelTypeId = 26

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 87 AND PanelTypeId = 26) 

BEGIN
    INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


    SELECT MAX(ID) + 1 AS ID, 87, 26, 2, 1

    FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 88 AND PanelTypeId = 26) 

BEGIN
    INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


    SELECT MAX(ID) + 1 AS ID, 88, 26, 2, 2

    FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 89 AND PanelTypeId = 26) 

BEGIN
    INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


    SELECT MAX(ID) + 1 AS ID, 89, 26, 2, 3

    FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 90 AND PanelTypeId = 26) 

BEGIN
    INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


    SELECT MAX(ID) + 1 AS ID, 90, 26, 2, 4

    FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 91 AND PanelTypeId = 26) 

BEGIN
    INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


    SELECT MAX(ID) + 1 AS ID, 91, 26, 2, 5

    FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 92 AND PanelTypeId = 26) 

BEGIN
    INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


    SELECT MAX(ID) + 1 AS ID, 92, 26, 2, 6

    FROM DMUIPanelColumns

END

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = 93 AND PanelTypeId = 26) 

BEGIN
    INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


    SELECT MAX(ID) + 1 AS ID, 93, 26, 2, 7

    FROM DMUIPanelColumns

END

DECLARE @ColumnId INT

SELECT @ColumnId = ID FROM DMUIColumns WHERE PropertyName = 'itemDeliveredTime'

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = @ColumnId AND PanelTypeId = 3) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, @ColumnId, 3, 0, 12

	FROM DMUIPanelColumns

END

SELECT @ColumnId = ID FROM DMUIColumns WHERE PropertyName = 'sizeOfApplication'

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = @ColumnId AND PanelTypeId = 26) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, @ColumnId, 26, 2, 8

	FROM DMUIPanelColumns

END

SELECT @ColumnId = ID FROM DMUIColumns WHERE PropertyName = 'duration'

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = @ColumnId AND PanelTypeId = 26) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, @ColumnId, 26, 2, 9

	FROM DMUIPanelColumns

END

SELECT @ColumnId = ID FROM DMUIColumns WHERE PropertyName = 'contentIndexStatus'

IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = @ColumnId AND PanelTypeId = 26) 

BEGIN
	INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder) 


	SELECT MAX(ID) + 1 AS ID, @ColumnId, 26, 2, 10

	FROM DMUIPanelColumns

END


GO


--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMMigrationContainers.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMMigrationContainers.script,v $ $Id: DMMigrationContainers.script,v 1.2 2015/05/01 19:11:06 sbarman Exp $";
-- TABLENAME DMMigrationContainers

print '... inserting Table: DMMigrationContainers'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMMigrationContainers

declare @upgradeFromRel integer = 0

SELECT @upgradeFromRel = status FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'

IF (@upgradeFromRel IN (14, 15))

BEGIN
	insert into DMMigrationContainers(ci.ContainerGuid) 


	select distinct ci.ContainerID from DMResultSetInfo ri

	inner join DMContainerItem ci on ci.ResultSetID = ri.ResultSetID

	where not exists (select * from DMMigrationContainers where ContainerGuid = ci.ContainerId)

END



GO
