SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
	DECLARE @ViewNameCursorFlag 	INTEGER
	SET 		@ViewNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 		@errorCode	= 0
	
	DECLARE	@ViewName		NVARCHAR(256)

	DECLARE @currentRel 		INTEGER
	DECLARE @relStr					NVARCHAR(128)
	DECLARE @SQLString  		NVARCHAR(500)
	DECLARE @ParamDef				NVARCHAR(500)	
	DECLARE @ParamVal				NVARCHAR(500)

	SET @currentRel = (select max(id) from simAllGalaxyrel)
	SET @relStr = (select release from simAllGalaxyrel where id=@currentRel)

	/* Build the SQL string. */
	IF @relStr = '6.1'
	BEGIN
		SET @SQLString = N'DECLARE ViewNameListCursor CURSOR STATIC FOR SELECT distinct aliasname FROM cvTable WHERE type = 4' -- (For views)
	END
	ELSE
	BEGIN
		SET @SQLString = N'DECLARE ViewNameListCursor CURSOR STATIC FOR SELECT distinct aliasname FROM GXDBVersions WHERE type = 4' -- (For views)	
	END
			
	EXECUTE sp_executesql @SQLString
			
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@ViewNameCursorFlag = 1
	OPEN	ViewNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM ViewNameListCursor
	INTO @ViewName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all views
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		print '>>> Drop View: ' + @ViewName + ' <<<'
		
		IF EXISTS (select * from sysobjects where name = @ViewName and OBJECTPROPERTY(id, N'IsView') = 1) 
			EXEC ('DROP VIEW [' + @ViewName + ']')
			
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
					
		/* Build the SQL string. */
		IF @relStr = '6.1'
		BEGIN
			SET @SQLString = N'IF EXISTS (select * from cvTable where aliasname = @VName AND type = 4) DELETE FROM cvTable WHERE aliasname = @VName AND type = 4'
		END
		ELSE
		BEGIN
			SET @SQLString = N'IF EXISTS (select * from GXDBVersions where aliasname = @VName AND type = 4) DELETE FROM GXDBVersions WHERE aliasname = @VName AND type = 4'
		END
				
		SET @ParamDef = N'@VName NVARCHAR(128)'
		SET @ParamVal = @ViewName
		EXECUTE sp_executesql @SQLString, @ParamDef, @VName = @ParamVal
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM ViewNameListCursor
		INTO @ViewName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @ViewNameCursorFlag = 1
	BEGIN
			CLOSE				ViewNameListCursor
			DEALLOCATE	ViewNameListCursor
	END
END	

RETURN
GO

