

--  ------------  Generated from [../../../Source/CommServer/DM2Db/CSView/DMResultSetStatistics.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DMResultSetStatistics"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DMResultSetStatistics]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DMResultSetStatistics]
GO

delete from GXDBVersions where name = 'DMResultSetStatistics' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DMResultSetStatistics', '1.4', 'DMResultSetStatistics', '')
GO
SET QUOTED_IDENTIFIER  ON
GO
CREATE VIEW DMResultSetStatistics WITH SCHEMABINDING
AS
	select	CI.ContainerID as ContainerID,
			RS.AppType as AppType,
			count_big(*) as TotalCount,
			sum(RS.FileSizeKB) as TotalSizeKB,
			sum(case when RS.RestoreStatus = 4 then RS.FileSizeKB else 0 end) as DiskSpaceUsedKB
	from dbo.DMResultSet RS, dbo.DMContainerItem CI
	where RS.ResultSetID = CI.ResultSetID
	and (CI.Attribute & 4) = 0
	group by CI.ContainerID, RS.AppType
GO
IF EXISTS (SELECT * FROM sysindexes WHERE name = 'DMResultSetStatistics_Idx1')
	DROP INDEX DMResultSetStatistics.DMResultSetStatistics_Idx1
GO
SET QUOTED_IDENTIFIER  OFF
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DMResultSetStatistics]'
END
GO

