

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserSessionBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserSessionBulk.sp,v $ $Id: sp_dm2_UpdateUserSessionBulk.sp,v 1.3 2014/07/31 03:55:51 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateUserSessionBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateUserSessionBulk')
	drop procedure sp_dm2_UpdateUserSessionBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateUserSessionBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserSessionBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserSessionBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserSessionBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateUserSessionBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateUserSessionBulk
  @i_inputxml VARCHAR(MAX)
AS
	BEGIN
		/**
			Based on input XML we parse and update DMUSerSession with input lastaccesstime.
			If any of the session is not found or exceeding timeoutInMin , then consider that as invalid and return that back
			NOTE: This SP assumes that Session already exists, it wont insert new entry. just update lastAccessTime, if entry is not foud. it will considered as invalid entry
			--sample XML
			<SessionMap>
				  <session id="8F6257B8-EC92-4D47-BB66-14589CA98E41" lastaccesstime="2014-07-08T07:19:52" />
				  <session id="F91273FC-4861-445A-8C8B-52BCB686B3ED" lastaccesstime="2014-07-08T07:16:52" />
				  <session id="UIOP8905-4861-445A-8C8B-52BCB686B3EW" lastaccesstime="2014-07-08T07:14:52" />
			</SessionMap>
		*/
		--constants
		DECLARE @C_TIMEOUT		INT			= 30
		DECLARE @C_CURRENT_TIME DATETIME	= GETUTCDATE()
		SELECT @C_TIMEOUT = ISNULL(SettingValue ,30) FROM DMSetting WHERE SettingName = 'SESSION_TIME_OUT'
		IF object_id('tempdb.dbo.#tmpSessionInfo') IS NOT NULL
			DROP TABLE #tmpSessionInfo
		IF object_id('tempdb.dbo.#tmpInvalidSession') IS NOT NULL
			DROP TABLE #tmpInvalidSession
		CREATE TABLE #tmpSessionInfo(
			SessionId			VARCHAR(36),
			lastAccessTime		DATETIME,
			origIsExists		BIT DEFAULT 0,	--updated to 1, if entry exists in DMUserSession Table
			origLastAccessTime	DATETIME,
			origTimeOut			INT		DEFAULT 30,
			origAttribute		INT
		)
		CREATE TABLE #tmpInvalidSession(
			SessionId VARCHAR(36)
		)
		DECLARE @l_XML XML = @i_inputxml
		--insert into temp table
		INSERT INTO #tmpSessionInfo(SessionId, lastAccessTime)
		SELECT ISNULL(T.col.value('@id','VARCHAR(36)'),0) AS SessionId,
			   T.col.value('@lastaccesstime','DATETIME')  AS lastAccessTime
		FROM @l_XML.nodes('SessionMap/session') AS T(col)
		--update temp table with lastaccesstime of the DMUserSession tab;e
		--
		UPDATE  tSI
		SET tSI.origIsExists		= 1,
			tSI.origLastAccessTime	= ISNULL(dUS.lastAccessTime,dUS.CreateTime),
			tSI.origTimeOut			= ISNULL(dUS.TimeOutInMin,@C_TIMEOUT),
			tSI.origAttribute		= dUS.Attribute
		FROM #tmpSessionInfo tSI
			INNER JOIN
			DMUserSession dUS WITH (NOLOCK)
		ON tSI.SessionId = dUS.SessionID
		/*
			Invalid SessionId Criteria Cases when
				- sessionId doesnt exists in DMUserSession
				- input time is less than table access time
				- logout happened
				- orig table access time is > input last access time
		*/
		INSERT INTO #tmpInvalidSession
		SELECT tSI.SessionId FROM #tmpSessionInfo tSI
		WHERE	tSI.origIsExists <> 1 OR
				tSI.lastAccessTime < tSI.origLastAccessTime OR -- case when input time is less than table access time
				tSI.origAttribute & 4 <> 0 OR -- case when logout happened
				DATEDIFF(minute, tSI.origLastAccessTime, tSI.lastAccessTime) > tSI.origTimeOut  -- orig table access time is > input last access time
		--now delete from temp table
		DELETE #tmpSessionInfo
		WHERE #tmpSessionInfo.SessionId IN
				(SELECT tIS.SessionId FROM #tmpInvalidSession as tIS )
		--update DMUserSession table
		UPDATE US
		SET		LastAccessTime = tSI.lastAccessTime
		FROM	DMUserSession US INNER JOIN #tmpSessionInfo tSI
			ON US.SessionID = tSI.SessionId
		--return back invalid sessionIds
		SELECT * from #tmpInvalidSession
		IF object_id('tempdb.dbo.#tmpSessionInfo') IS NOT NULL
			DROP TABLE #tmpSessionInfo
		IF object_id('tempdb.dbo.#tmpInvalidSession') IS NOT NULL
			DROP TABLE #tmpInvalidSession
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateUserSessionBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserSessionBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserSessionBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserSessionBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateUserSessionBulk',  '00010003000000000000', 'sp_dm2_UpdateUserSessionBulk', '00010003000000000000')
GO

