

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreMailsBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreMailsBulk()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreMailsBulk.sp,v $ $Id: sp_dm2_UpdateRestoreMailsBulk.sp,v 1.8.12.7 2019/05/18 13:20:55 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreMailsBulk')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreMailsBulk <<<'
	drop procedure sp_dm2_UpdateRestoreMailsBulk
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreMailsBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreMailsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreMailsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreMailsBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreMailsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreMailsBulk
  @i_jobId Integer,
  @DMrestoreTbl DM2RestoreStatusUpdate READONLY
AS
BEGIN
DECLARE @error int
DECLARE @CompPolicyId VARCHAR(36)
DECLARE @DownloadID char(36)
DECLARE @SettingVal VARCHAR(MAX) = ''
DECLARE @CcnCheckEnabled BIT = 0
DECLARE @Mark_Email_Restore_To_Xml  INTEGER = 1024
SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_CCN_CHECK_IN_RESTORE'
	IF ISNULL(@SettingVal, '') = 'True'
		SET @CcnCheckEnabled = 1
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOff="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOff="37" />
--    <file CCId="2" AFId="6" AFOff="909" />
-- </restlist>
	DECLARE @lt_AFOffsets TABLE (CCId int, AFId bigint, AFOff bigInt, DestPath nvarchar(max), status int, ResultItemID char(36))
--	INSERT INTO @lt_AFOffsets
--	SELECT T.c.value('@CCId','int'),
--		   T.c.value('@AFId', 'bigint'),
--		   T.c.value('@AFOff', 'bigint'),
--		   T.c.value('@DPath', 'nvarchar(max)'),
--		   ISNULL(T.c.value('@status', 'int'), 0), -- ERMStatus for success
--		   NULL AS ResultItemID
--	FROM   @i_xml_AFOffsets.nodes('/restlist/file') T(c)
	INSERT INTO @lt_AFOffsets (CCId,AFId,AFOff,DestPath,status,ResultItemID)
	SELECT T.CCId,T.AFId,T.AFOffset,T.DPath,ISNULL(T.status, 0), null FROM @DMrestoreTbl as T
	UPDATE tt
	SET ResultItemID = ResultSetID
	FROM @lt_AFOffsets tt,
	DMResultSet R WITH(NOLOCK)
	WHERE R.aFileID = tt.AFId AND R.aFileoffset = tt.AFOff AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId)) AND R.Attribute <> @Mark_Email_Restore_To_Xml -- - Adding code (RS.Attribute & @Mark_Email_Restore_To_Xml) = 0 (RS.Attribute <> @Mark_Email_Restore_To_Xml) so that restore to xml path won't be overwritten by regular restore jobs in case an email is restored in different format option
	if EXISTS (SELECT TOP 1 * FROM @lt_AFOffsets WHERE ISNULL(ResultItemID, '') = '')
	BEGIN
		UPDATE tt
		SET ResultItemID = s.ResultSetID
		FROM @lt_AFOffsets tt,
		DMItemsToSyncWithIndexing S  WITH(NOLOCK)
		WHERE tt.AFId = s.aFileID and tt.AFOff = s.aFileOffset AND tt.CCId = s.CommCellNumber and SyncStatus = 4 AND ISNULL(tt.ResultItemID, '') = ''
	END
	BEGIN TRANSACTION
		DECLARE @FileType int
		SELECT TOP 1 @DownloadID = DownloadID, @FileType = FileType FROM DMDownload WITH(NOLOCK) WHERE RestoreJobID = @i_jobId
		--
		-- We do not want to update DMResultSet in case of restoring to custom location as this data is not intended to be shared by any other jobs like
		-- regular download / export to cab
		--
		IF ISNULL(@FileType, 0) NOT IN (14, 15, 16) --RestoreToWebServer = 14, CustomLocationPST = 15, SharepointToCustomLocation = 16
		BEGIN
		UPDATE DMResultSet
		SET DestinationPath = tt.DestPath, RestoreStatus = 4
		FROM @lt_AFOffsets tt
		WHERE ResultSetID = tt.ResultItemID
			--
		SET @error = @@ERROR
		END
		IF @error = 0
		BEGIN
			IF ISNULL(@DownloadID, '') <> ''
			BEGIN
				-- for export to PDF, we update success status as 504 i.e Pending Post processing
				DECLARE @successRestoreStatus int
				SELECT @successRestoreStatus =  (CASE WHEN  ISNULL(@FileType, 0) NOT IN (18)  THEN 100 ELSE 504 END)
				UPDATE DMDownloadResultSet
				SET [FileName] = tt.DestPath,
				[Status] = (CASE WHEN tt.Status = 4 AND ISNULL(tt.DestPath, '') <> '' 						THEN @successRestoreStatus 	ELSE 500 END )
				FROM @lt_AFOffsets tt
				WHERE DownloadID = @DownloadID AND ResultSetID = tt.ResultItemID
							SET @error = @@ERROR
			END
			ELSE
			BEGIN
				SELECT TOP 1 @CompPolicyId = CompPolicyId FROM DMLegalHoldItemsToBackup WITH(nolock) WHERE JobId = @i_jobId
				IF ISNULL(@CompPolicyId, '') <> ''
				BEGIN
					UPDATE LH SET LH.OriginalPath = ISNULL(tt.DestPath, ''),
					BackupPath = CASE WHEN RIGHT(BackupPath, 3) = 'msg' AND RIGHT(DestPath, 3) <> 'msg'
						THEN LEFT(BackupPath, LEN(BackupPath) - 3) + 'eml'
						ELSE BackupPath END
					FROM @lt_AFOffsets tt, DMLegalHoldItemsToBackup LH
					WHERE JobId = @i_jobId AND CompPolicyId = @CompPolicyId AND tt.ResultItemID = LH.ResultSetID
				SET @error = @@ERROR
				END
			END
		END
	IF @error = 0
		COMMIT TRANSACTION
	ELSE
		ROLLBACK TRANSACTION
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreMailsBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreMailsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreMailsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreMailsBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreMailsBulk',  '00010008001200070000', 'sp_dm2_UpdateRestoreMailsBulk', '00010008001200070000')
GO

