

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreJobIDBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreJobIDBulk()
--  | Description:  Update the Restore JobId in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreJobIDBulk.sp,v $ $Id: sp_dm2_UpdateRestoreJobIDBulk.sp,v 1.2.12.7 2019/04/16 16:21:17 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreJobIDBulk')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreJobIDBulk <<<'
	drop procedure sp_dm2_UpdateRestoreJobIDBulk
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreJobIDBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreJobIDBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreJobIDBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreJobIDBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreJobIDBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreJobIDBulk
  @i_UserGUID varchar(36) = '',
  @i_RestoreJobID int = 0
AS
		declare @RestoreAsXML varchar(10) = 'emailxml'
		declare @l_delimiter	varchar(256)
		declare @SQL	varchar(2048)
		DECLARE @Mark_Email_Restore_To_Xml  INTEGER = 1024 -- this is use to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format
		set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
		IF(len(@l_delimiter ) = 0)
			SET @l_delimiter = 'CV0X12'
		IF OBJECT_ID('tempdb.dbo.#UpdateRestoreJobIDBulk') IS NULL
		begin
create table #UpdateRestoreJobIDBulk	(
	[CommCellNumber] [int] ,
	[aFileID] [bigint]  ,
	[aFileOffset] [bigint] ,
	[IndexGUID] varchar(128),
	[AppType] [int],
	[OriginalFullPath] nvarchar(1024)
)
		end
		DECLARE @tblResultSet TABLE (ResultSetId varchar(36),CommCellNumber int, aFileID bigint, aFileOffset bigint, IndexGUID varchar(128), AppType INT, OriginalFullPath nvarchar(1024))
		--
		-- Refer to TR 190129-530.. we don't have real GUIDs (they are copy of contentid) for new exchange app type 137 so we ignore them.
		-- Exception: For restore to xml feature, we need to match item by GUID as we have fabricated GUIDs for that feature to work.. Sreekanth, Anh.
		--
		INSERT INTO @tblResultSet
		SELECT distinct ' ', CommCellNumber, aFileID, aFileOffset,
CASE WHEN T.AppType = 137 AND CHARINDEX(@RestoreAsXML, ISNULL(t.IndexGUID, ''), 1) = 0 THEN ''
		ELSE IndexGUID END AS IndexGUID, AppType, OriginalFullPath FROM #UpdateRestoreJobIDBulk T
		--
		UPDATE @tblResultSet SET ResultSetId = RS.ResultSetId
		FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.IndexGUID,'') <> '' AND t.IndexGUID = RS.IndexGUID
AND t.AppType <> 106  --_CV_APPTYPE_VIRTUAL_SERVER
		UPDATE @tblResultSet SET ResultSetId = RS.ResultSetId
		FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.OriginalFullPath,'') <> '' AND t.OriginalFullPath = RS.OriginalFullPath
AND t.AppType = 106	--_CV_APPTYPE_VIRTUAL_SERVER
        AND t.aFileID = RS.aFileID
		--
		-- When data is Restored from legal hold, due to old bug of pushing wrong (source item's) turboguid to review set core
		-- first check if we can match item based on afileid, afileoffset and attribute = 16 (Legal_Restored_Item)
		-- This change is made to prevent returning wrong ResultSetID (for legal hold backed up items restored from LH to review set)
		-- We do not want to return ResultSetID of item that was added to legal hold instead of returning ID of item from it's corresponding
		-- legal hold backup.
		-- Change like this can be found in following SPs: sp_dm2_GetResultItemDetail, sp_dm2_AddResultSetBulk, sp_dm2_AddDownloadResultSetBulk
		--
		UPDATE t SET ResultSetId = RS.ResultSetId
		FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.ResultSetId,'') = '' AND
			t.CommCellNumber = RS.CommCellNumber
			and t.aFileID = RS.aFileID
			and t.aFileOffset = RS.aFileOffset
			AND RS.Attribute = 16 -- Item restored from LH to review set given high preference.
		--now update only items where resultsetid is not populated
		UPDATE t SET ResultSetId = RS.ResultSetId
		FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.ResultSetId,'') = '' AND
			t.CommCellNumber = RS.CommCellNumber
			and t.aFileID = RS.aFileID
			and t.aFileOffset = RS.aFileOffset
			AND RS.Attribute <> @Mark_Email_Restore_To_Xml -- -- D.Attribute <> @Mark_Email_Restore_To_Xml is used to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format. For this restore request, IndexGUID is always available so it won't affect its status update
	  update RS
	  set RestoreUserGUID = @i_UserGUID,
	  RestoreStatus = 1, RestoreJobID = @i_RestoreJobID, RestoreTime = GetDate(), DestinationPath = ''
	  FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK) ON
	  t.ResultSetId = RS.ResultSetId
	  IF OBJECT_ID('tempdb.dbo.#UpdateRestoreJobIDBulk') IS NOT NULL
	  	DROP TABLE #UpdateRestoreJobIDBulk
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreJobIDBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreJobIDBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreJobIDBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreJobIDBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreJobIDBulk',  '00010002001200070000', 'sp_dm2_UpdateRestoreJobIDBulk', '00010002001200070000')
GO

