
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreFilesBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreFilesBulk')
	drop procedure sp_dm2_UpdateRestoreFilesBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreFilesBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreFilesBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreFilesBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreFilesBulk'
GO

print '... Creating Procedure: sp_dm2_UpdateRestoreFilesBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreFilesBulk
  @i_jobId Integer,
  @DMrestoreTbl DM2RestoreFileUpdateV2 READONLY,
  @i_isUnixUpdate INTEGER = 0
AS
BEGIN
		DECLARE @error int
		DECLARE @DownloadID char(36)
		DECLARE @SettingVal VARCHAR(MAX) = ''
		DECLARE @CcnCheckEnabled BIT = 0
		DECLARE @TurboGuicCheckEnabled BIT = 0
		DECLARE @MtimeCheckEnabled BIT = 0
		DECLARE @CompPolicyId VARCHAR(36)

		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_CCN_CHECK_IN_RESTORE'

		IF ISNULL(@SettingVal, '') = 'True'
			SET @CcnCheckEnabled = 1
		
		SET @SettingVal = ''
		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_TURBO_GUID_CHECK_IN_RESTORE'

		IF ISNULL(@SettingVal, '') = 'True'
			SET @TurboGuicCheckEnabled = 1
		
		SET @SettingVal = ''
		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_MODIFIED_TIME_CHECK_IN_RESTORE'

		IF ISNULL(@SettingVal, '') = 'True'
			SET @MtimeCheckEnabled = 1

	BEGIN TRANSACTION
		DECLARE @lt_AFFiles TABLE (ID int IDENTITY(1,1) ,CCId int, AFId bigint, OrigPath nvarchar(max), DestPath nvarchar(max), status int, mtime int, turboGUID varchar(128))
		INSERT INTO @lt_AFFiles (CCId,AFId,OrigPath,DestPath,status, mtime, turboGUID)
		SELECT T.CCId,T.AFId,T.OPath,T.DPath,T.status, T.mtime, T.turboGUID FROM @DMrestoreTbl as T
		
		DECLARE @lt_AFFilesToResultSetId TABLE (t_id int , t_resultSetID char(36))
		
		--matching result set id WITH turbo guid
		IF @TurboGuicCheckEnabled = 1
		BEGIN
			INSERT INTO  @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMResultSet R WITH (NOLOCK)
			WHERE  ISNULL((turboGUID),'') != '' AND turboGUID = IndexGUID
		END

		--matching result set id WITH mtime		
		IF( @i_isUnixUpdate = 1)
		BEGIN			
			INSERT INTO  @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMResultSet R WITH (NOLOCK)
			WHERE aFileID = AFId AND OriginalFullPath COLLATE Latin1_General_CS_AS = OrigPath 
			AND (@MtimeCheckEnabled = 0 OR (@MtimeCheckEnabled = 1 AND mtime = dbo.GetUnixTime(ModifiedTime)))
					AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
			AND T.ID NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )

			INSERT INTO  @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMItemsToSyncWithIndexing R WITH (NOLOCK)
			WHERE ISNULL(T.OrigPath, '') <> '' AND R.aFileID = T.AFId AND R.OriginalFullPath COLLATE Latin1_General_CS_AS = T.OrigPath AND R.SyncStatus = 4 
		END
		ELSE
		BEGIN
			INSERT INTO  @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMResultSet R WITH (NOLOCK)
			WHERE aFileID = AFId AND OriginalFullPath = OrigPath 
			AND (@MtimeCheckEnabled = 0 OR (@MtimeCheckEnabled = 1 AND mtime = dbo.GetUnixTime(ModifiedTime)))
					AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
			AND T.ID NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )

			INSERT INTO @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMItemsToSyncWithIndexing R WITH (NOLOCK)
			WHERE ISNULL(T.OrigPath, '') <> '' AND T.AFId = R.aFileID AND T.OrigPath = OriginalFullPath AND R.SyncStatus = 4
		END
		
		--Case when we couldn find any matching resultSet,  then we check this flag for Lotus nous
		IF EXISTS(SELECT * FROM @lt_AFFiles as tt WHERE id NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId ))		
		BEGIN
			/*
				Issue:
						if an email has multiple attachments during backup and few of them are filtered during CI, 
					then the attachment number present in the path for each attachment within its documentID, mismatches and does not follow their sequence of number. 
			
				Fix:
						During restore update, we try to convert the db path to match with original email which doesnt have attachment number, 
					there by path would match the input index path.				
			*/
			DECLARE @enableLNPartialCheck BIT = 
					CASE WHEN ISNULL((SELECT SettingValue FROM DMSetting 
								WHERE SettingName = 'ENABLE_LN_PATH_PARTIAL_MATCH'),'false') = 'true'	--default disabled
						THEN 1 ELSE 0 END
						
			IF(@enableLNPartialCheck = 1)
			BEGIN
				UPDATE tt 
				SET tt.OrigPath = (CASE WHEN PATINDEX('%S:_:%',tt.OrigPath) = 0  THEN tt.OrigPath 
									ELSE SUBSTRING(tt.OrigPath,1,(PATINDEX('%S:_:%',tt.OrigPath)))END)
				FROM @lt_AFFiles as tt
				WHERE tt.id NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )
				
				--Since all mails and attachement have same path, delete duplicate
				DELETE FROM @lt_AFFiles
				WHERE ID NOT IN(
					SELECT MAX(ID)
					FROM @lt_AFFiles AS tt
					GROUP BY tt.AFId,tt.OrigPath
				)
				
				--For LN, compare origPath by stripping attachment.	 	
				INSERT INTO @lt_AFFilesToResultSetId
				SELECT DISTINCT tt.ID,  R.ResultSetID
				FROM @lt_AFFiles tt, DMResultSet R WITH (NOLOCK)
				WHERE  tt.id NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )
					AND tt.AFId = R.aFileID  AND 									
						tt.OrigPath =				
						(CASE WHEN PATINDEX('%S:_:%',R.OriginalFullPath) = 0  THEN R.OriginalFullPath 
							ELSE SUBSTRING(R.OriginalFullPath,1,(PATINDEX('%S:_:%',R.OriginalFullPath)))END)
					AND R.AppType IN (52, 90)			
				
								
			END
		END
			DECLARE @FileType int
			SELECT TOP 1 @DownloadID = DownloadID, @FileType = FileType FROM DMDownload WITH(NOLOCK) WHERE RestoreJobID = @i_jobId

			-- We do not want to update DMResultSet where typically the path is under WebCache directory common to all export to CAB or download jobs because
			-- for restore types 14, 15, 16, the data is restored to a customized location (such as some network path which is outside of webcache directory)
			IF ISNULL(@FileType, 0) NOT IN (14, 15, 16) --RestoreToWebServer = 14, CustomLocationPST = 15, SharepointToCustomLocation = 16
			BEGIN
				UPDATE DMResultSet
				SET DestinationPath = tt.DestPath, RestoreStatus = 4
				FROM @lt_AFFiles tt, @lt_AFFilesToResultSetId tr
				WHERE ResultSetID = tr.t_resultSetID AND tt.id = tr.t_id
			END
			SET @error = @@ERROR
			IF @error = 0
			BEGIN
				IF ISNULL(@DownloadID, '') <> ''
				BEGIN
					-- for export to PDF, we update success status as 504 i.e Pending Post processing
			
					DECLARE @successRestoreStatus int
				
					SELECT @successRestoreStatus =  (CASE WHEN  ISNULL(@FileType, 0) NOT IN (18)  THEN 100 ELSE 504 END)

					UPDATE DMDownloadResultSet
					SET [FileName] = tt.DestPath,
					[Status] = (CASE WHEN tt.Status = 4 AND ISNULL(tt.DestPath, '') <> '' THEN @successRestoreStatus ELSE 500 END)
					FROM @lt_AFFiles tt, @lt_AFFilesToResultSetId tr
					WHERE DownloadID = @DownloadID AND tt.id = tr.t_id AND ResultSetID = tr.t_resultSetID
					SET @error = @@ERROR
				END
			END
			ELSE 
			BEGIN
				SELECT TOP 1 @CompPolicyId = CompPolicyId FROM DMLegalHoldItemsToBackup WITH(nolock) WHERE JobId = @i_jobId 

				IF ISNULL(@CompPolicyId, '') <> ''
				BEGIN
					UPDATE LH SET LH.OriginalPath = ISNULL(tt.DestPath, '')
					FROM DMLegalHoldItemsToBackup LH, @lt_AFFilesToResultSetId tr, @lt_AFFiles tt
					WHERE LH.JobId = @i_jobId AND LH.CompPolicyId = @CompPolicyId AND LH.ResultSetID = tr.t_resultSetID AND TT.ID = TR.t_id 

					SET @error = @@ERROR
				END
			END
		IF @error = 0
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreFilesBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreFilesBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreFilesBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreFilesBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreFilesBulk',  '00010004000000000000', 'sp_dm2_UpdateRestoreFilesBulk', '00010004000000000000')
GO

