

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateJMRestoreStatusBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateJMRestoreStatusBulk()
--  | Description:  Update the Restore Status of jobIds in Bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateJMRestoreStatusBulk.sp,v $ $Id: sp_dm2_UpdateJMRestoreStatusBulk.sp,v 1.2 2011/04/14 12:15:32 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateJMRestoreStatusBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateJMRestoreStatusBulk')
	drop procedure sp_dm2_UpdateJMRestoreStatusBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateJMRestoreStatusBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateJMRestoreStatusBulk
  @i_xml XML
AS
BEGIN
	/***
	eg:
		<JobStatusList>
		  <JobStatus i_RestoreJobID="61" i_OldRestoreStatus="-1" i_RestoreStatus="4" i_IsJM="1" />
		  <JobStatus i_RestoreJobID="81" i_OldRestoreStatus="-1" i_RestoreStatus="4" i_IsJM="1" />
		</JobStatusList>
	*/
		--declare cursor variables
	DECLARE @i_RestoreJobID 	INT = 0,
			@i_OldRestoreStatus INT = -1,
			@i_RestoreStatus	INT = 0,
			@i_IsJM				INT = 0,
			@i_ResultSetID 		VARCHAR(MAX) = ''
			--------------Open cursor--------------
	DECLARE JobStatusCursor CURSOR FAST_FORWARD FOR
	SELECT
		ISNULL(T.list.value('@i_RestoreJobID','INT'),0),
		ISNULL(T.list.value('@i_OldRestoreStatus','INT'),-1),
		ISNULL(T.list.value('@i_RestoreStatus','INT'),0),
		ISNULL(T.list.value('@i_IsJM','INT'),0),
		ISNULL(T.list.value('@i_ResultSetID','VARCHAR(MAX)'),'')
	FROM @i_xml.nodes('JobStatusList/JobStatus') AS T(list)
	OPEN JobStatusCursor
	FETCH NEXT FROM JobStatusCursor INTO @i_RestoreJobID,@i_OldRestoreStatus,@i_RestoreStatus,@i_IsJM,@i_ResultSetID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--Call the existing store proc which updates the jobStatus
		EXEC sp_dm2_UpdateRestoreStatus @i_RestoreJobID,@i_OldRestoreStatus,@i_RestoreStatus,@i_IsJM,@i_ResultSetID
		FETCH NEXT FROM JobStatusCursor INTO @i_RestoreJobID,@i_OldRestoreStatus,@i_RestoreStatus,@i_IsJM,@i_ResultSetID
	END
	CLOSE JobStatusCursor
	DEALLOCATE JobStatusCursor
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateJMRestoreStatusBulk',  '00010002000000000000', 'sp_dm2_UpdateJMRestoreStatusBulk', '00010002000000000000')
GO

