

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDownload.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateDownload()
--  | Description:  Update Download
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDownload.sp,v $ $Id: sp_dm2_UpdateDownload.sp,v 1.7.86.3 2019/11/12 15:01:34 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateDownload')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_UpdateDownload <<<'
	drop procedure sp_dm2_UpdateDownload
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateDownload')
	delete from GxQscripts where name = 'sp_dm2_UpdateDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDownload'
GO
print '... Creating Procedure: sp_dm2_UpdateDownload'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateDownload
  @i_DownloadID varchar(36),
  @i_DestinationPath nvarchar(max) = '', 
  @i_FileSizeKB bigint = 0,
  @i_RestoreJobID int = 0, 
  @i_Status int = 0,
  @i_Attribute int = 0,
  @i_Description nvarchar(max) = '',
  @i_CabItemCount int = -1,
  @i_singleShare int = 0
AS
DECLARE @RestoredCount INT
  if @i_Description != ''
  begin
	-- need to update description, figure out if the same description has been used by the same user
	declare @DownLoadSetID varchar(36)
	select @DownLoadSetID = DownLoadSetID from DMDownload WITH (READUNCOMMITTED) where DownLoadID = @i_DownloadID
    if exists (select top 1 * from DMDownload WITH (READUNCOMMITTED)
				where DownloadID != @i_DownloadID
				and Description = @i_Description
				and DownLoadSetID = @DownLoadSetID)
		return 1
  end
  --Even if one item is not succcesful, then we have to report it as partial..
  IF EXISTS(SELECT DownloadID FROM DMDownload WHERE @i_Status = 100 AND FileType in (2,18) AND DownloadID = @i_DownloadID)
  BEGIN
	BEGIN
		IF EXISTS(SELECT TOP 1 ResultSetID FROM DMDownloadResultSet WHERE [Status] <> 100 AND DownloadID = @i_DownloadID)
		BEGIN
			SET @i_Status = 101
		END
		--Some times everything gets restored, but everything may be not zipped, in that case also we have to mark it as partial
		IF @i_Status = 100 AND @i_CabItemCount > -1
		BEGIN
			SELECT @RestoredCount = COUNT(ResultSetID) FROM DMDownloadResultSet WHERE [Status] = 100 AND DownloadID = @i_DownloadID
			IF @RestoredCount <> @i_CabItemCount
				SET @i_Status = 101
		END
	END
  END
  IF @i_singleShare = 1
  BEGIN
		select @i_DestinationPath = DestinationPath From DMResultSet A, DMDownloadResultSet B Where A.ResultSetID = B.ResultSetID and B.DownloadID = @i_DownloadID
  END
  update DMDownload
  set
	DestinationPath = (case len(@i_DestinationPath) when 0 then DestinationPath else @i_DestinationPath end),
	FileSizeKB = (case @i_FileSizeKB when 0 then FileSizeKB else @i_FileSizeKB end),
	RestoreJobID = (case @i_RestoreJobID when 0 then RestoreJobID else @i_RestoreJobID end),
	Status = (case @i_Status when 0 then Status else @i_Status end),
	Attribute = (Attribute | @i_Attribute),
	DownloadTime = (case (@i_Attribute & 1) when 1 then getutcdate() else DownloadTime end),
	Description = (case len(@i_Description) when 0 then Description else @i_Description end)
  where DownloadID = @i_DownloadID
  return 0
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateDownload')
	delete from GxQscripts where name = 'sp_dm2_UpdateDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDownload'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateDownload',  '00010007008600030000', 'sp_dm2_UpdateDownload', '00010007008600030000')
GO

