

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_ReviewSetSummary.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_ReviewSetSummary.sp,v $ $Id: sp_dm2_ReviewSetSummary.sp,v 1.6 2014/08/25 21:24:11 sbarman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_ReviewSetSummary <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_ReviewSetSummary')
	drop procedure sp_dm2_ReviewSetSummary
IF EXISTS (select * from GxQscripts where name='sp_dm2_ReviewSetSummary')
	delete from GxQscripts where name = 'sp_dm2_ReviewSetSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ReviewSetSummary')
	delete from GXDBVersions where aliasname = 'sp_dm2_ReviewSetSummary'
GO
print '... Creating Procedure: sp_dm2_ReviewSetSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_ReviewSetSummary
  @i_ContainerID char(36),
  @i_computeRestoreOnly int = 0
AS
SET NOCOUNT ON
	DECLARE @totalSize BIGINT = 0
	DECLARE @totalFileSize BIGINT = 0
	DECLARE @totalEmailSize BIGINT = 0
	DECLARE @totalFiles INT = 0
	DECLARE @totalEmails INT = 0
	DECLARE @totalItems INT = 0
	--
	if @i_computeRestoreOnly = 0
	begin
		--Get the file details
		SELECT @totalEmailSize = ISNULL(SUM(FileSizeKB),0),@totalEmails =ISNULL(COUNT(*),0) FROM DMResultSet WITH (NOLOCK) WHERE ResultSetID IN
			(SELECT DISTINCT ResultSetID FROM DMContainerItem WITH (NOLOCK) WHERE ContainerID = @i_ContainerID AND
				(Attribute & 4)= 0 AND
			AppType IN (SELECT AppTypeId FROM DMUIAppTypeMap WITH (NOLOCK) WHERE IsFileAppType = 0))
	end
	if @i_computeRestoreOnly = 0
	begin
		SELECT @totalFileSize = ISNULL(SUM(FileSizeKB),0),@totalFiles = ISNULL(COUNT(*),0) FROM DMResultSet WITH (NOLOCK) WHERE ResultSetID IN
			(SELECT DISTINCT ResultSetID FROM DMContainerItem WITH (NOLOCK) WHERE ContainerID = @i_ContainerID AND
			(Attribute & 4)= 0 AND
			AppType IN (SELECT AppTypeId FROM DMUIAppTypeMap WITH (NOLOCK) WHERE IsFileAppType = 1))
	end
	SET @totalItems = @totalEmails + @totalFiles
	SET @totalSize = @totalEmailSize + @totalFileSize
	SELECT
		@totalItems AS 'TotalItems',
		@totalSize AS 'TotalSize',
		@totalEmails AS 'TotalEmails',
		@totalEmailSize AS 'TotalEmailSize',
		@totalFiles AS 'TotalFiles',
		@totalFileSize AS 'TotalFileSize',
	[0] as [Not_Submitted],
	[1] as [Submitted_for_viewing],
	[4] as [Restore_completed],
	[5]+[7] as [Restore_Failed]
	FROM
	(
	SELECT RestoreStatus from DMResultSet  WITH (NOLOCK)
	WHERE ResultSetID IN (SELECT DISTINCT ResultSetID From DMContainerItem WITH (NOLOCK) WHERE ContainerID = @i_ContainerID)
	) AS RC
	PIVOT
	(
	COUNT(RestoreStatus)
	FOR
	RestoreStatus
	IN ( [0], [1], [4], [5], [7])
	) AS PVT
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_ReviewSetSummary')
	delete from GxQscripts where name = 'sp_dm2_ReviewSetSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ReviewSetSummary')
	delete from GXDBVersions where aliasname = 'sp_dm2_ReviewSetSummary'
GO

insert into GXDBVersions values(2, 'sp_dm2_ReviewSetSummary',  '00010006000000000000', 'sp_dm2_ReviewSetSummary', '00010006000000000000')
GO

