

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_RenewUserSession.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_RenewUserSession.sp,v $ $Id: sp_dm2_RenewUserSession.sp,v 1.2 2014/02/24 21:58:20 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_RenewUserSession <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_RenewUserSession')
	drop procedure sp_dm2_RenewUserSession
IF EXISTS (select * from GxQscripts where name='sp_dm2_RenewUserSession')
	delete from GxQscripts where name = 'sp_dm2_RenewUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RenewUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_RenewUserSession'
GO
print '... Creating Procedure: sp_dm2_RenewUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_RenewUserSession
  @i_CurSessionId varchar(36),
  @i_DeviceId nvarchar(max),
  @i_Attribute int,
  @i_NewSessionId varchar(36) OUTPUT,
  @i_errorCode int output
AS
BEGIN
	DECLARE @deviceId nvarchar(max)
	DECLARE @ExSessionId nvarchar(36)
	SET @i_errorCode = 0
	SELECT @ExSessionId = U.SessionID, @deviceId = DeviceID FROM DMUserSession U
	JOIN DMUserSessionDetail D ON U.SessionID = D.SessionID
	WHERE U.SessionID = @i_CurSessionId
	IF ISNULL(@ExSessionId, '') = ''
		 SET @i_errorCode = 1143 -- SESSION_NOT_FOUND_FOR_SESSION_RENEWAL
	ELSE IF ISNULL(@deviceId, '') = '' OR @deviceId <> @i_DeviceId
		SET @i_errorCode =  1138 -- DEVICE_ID_MISMATCH_FOR_SESSION_RENEWAL
	IF @i_errorCode = 0
	BEGIN
		BEGIN TRAN
		IF ISNULL(@i_NewSessionId, '') = ''
			SET @i_NewSessionId = LOWER(NEWID())
		insert into DMUserSession (IP,SessionID,UserGUID,CommCellNumber,UserName,CreateTime,Attribute,LastAccessTime,TimeOutInMin,ConsoleType)
		SELECT IP,@i_NewSessionId,UserGUID,CommCellNumber,UserName,GETUTCDATE(),@i_Attribute,GETUTCDATE(),TimeOutInMin,ConsoleType FROM DMUserSession
		WHERE SessionID = @i_CurSessionId
		SELECT @i_errorCode = @@Error
		IF @i_errorCode = 0
		BEGIN
			INSERT INTO DMUserSessionDetail(SessionID, SiteMode, DeviceID, SpecialProperties,LinkSessionID)
			SELECT @i_NewSessionId, SiteMode, DeviceId, SpecialProperties, @i_CurSessionId FROM DMUserSessionDetail
			WHERE SessionID = @i_CurSessionId
			SELECT @i_errorCode = @@Error
		END
		IF @i_errorCode = 0
			COMMIT TRAN
		ELSE
			ROLLBACK TRAN
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_RenewUserSession')
	delete from GxQscripts where name = 'sp_dm2_RenewUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RenewUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_RenewUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_RenewUserSession',  '00010002000000000000', 'sp_dm2_RenewUserSession', '00010002000000000000')
GO

