

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneReviewSets.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneReviewSets.sp,v $ $Id: sp_dm2_PruneReviewSets.sp,v 1.4 2014/01/28 02:56:28 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneReviewSets <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneReviewSets')
	drop procedure sp_dm2_PruneReviewSets
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneReviewSets')
	delete from GxQscripts where name = 'sp_dm2_PruneReviewSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneReviewSets')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneReviewSets'
GO
print '... Creating Procedure: sp_dm2_PruneReviewSets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneReviewSets
  @i_ContainerGuid VARCHAR(MAX)
AS
SET NOCOUNT ON
BEGIN
	/*
		This Stored procedure prunes list of review set that is passed as input.
		Prune Inteval is based on Key setting "PRUNE_REVIEWSET_INTERVAL_InHrs". Default = 720 hrs (30 days)
		For each container,
			Get top 10000 resultSetIds, which matches the prune time criteria in that reviewset
			Pass those list to existing SP [sp_dm2_PruneResultSetItemsBulk] with that contaierGuid
			Continue till we have items to prune
	*/
	DECLARE @i_pruneCriteriaInHrs INT = 720
	SELECT @i_pruneCriteriaInHrs = ISNULL(SettingValue, 720) FROM DMSetting WHERE SettingName = 'PRUNE_REVIEWSET_INTERVAL_InHrs'
	--IF(LEN(LTRIM(RTRIM(ISNULL(@tempSettingVal,'')))) > 0)
	--	SELECT @i_pruneCriteriaInHrs = CONVERT(INT,@tempSettingVal)
	--if less than an hour, fall back to default 7 days
	if( @i_pruneCriteriaInHrs < 1 )
		SET @i_pruneCriteriaInHrs = 720
	DECLARE @containerGuidTbl table(id INT IDENTITY(1,1) , containerGuid varchar(36))
	INSERT INTO @containerGuidTbl
	SELECT  LTRIM(RTRIM(ID))
	FROM dbo.splitStringToTable(@i_ContainerGuid)
	WHERE LEN(ISNULL(ID,'')) > 0
	IF OBJECT_ID('tempdb.dbo.#tmpResultSetId1') IS NOT NULL
		DROP TABLE #tmpResultSetId1
	CREATE TABLE #tmpResultSetId1
	(
		ResultSetId VARCHAR(36)
	) ;
	DECLARE @totalCount INT = 0
	DECLARE @incrVal INT = 0
	DECLARE @localContainerGuid VARCHAR(36) = ''
	DECLARE @resulSetIdList VARCHAR(MAX) = ''
	SELECT @totalCount = MAX(ID) FROM @containerGuidTbl
	WHILE(@incrVal < @totalCount )
	BEGIN
		SET @localContainerGuid = ''
		SELECT @localContainerGuid = containerGuid FROM @containerGuidTbl WHERE id = (@incrVal+1)
		INSERT INTO #tmpResultSetId1
		SELECT TOP 10000 ResultSetID FROM DMContainerItem WITH (NOLOCK)
		WHERE ContainerID = @localContainerGuid AND DATEDIFF(HH,CreateTime,GETDATE()) >= @i_pruneCriteriaInHrs
		WHILE EXISTS ( SELECT TOP 1 * FROM #tmpResultSetId1)
		BEGIN
				SET @resulSetIdList		= ''
				SELECT @resulSetIdList = ISNULL(STUFF(
						(SELECT ';' "text()", tt.ResultSetId "text()" FROM #tmpResultSetId1 tt FOR XML PATH(''))
					,1,1,''),'')
				IF(LEN(ISNULL(@resulSetIdList,'')) > 0)
				BEGIN
					--Execute only if any restultsetIds exists.
					EXEC sp_dm2_PruneResultSetItemsBulk @resulSetIdList, @localContainerGuid
				END
				--clean up before processing
				DELETE #tmpResultSetId1;
				INSERT INTO #tmpResultSetId1
				SELECT TOP 10000 ResultSetID FROM DMContainerItem WITH (NOLOCK)
				WHERE ContainerID = @localContainerGuid AND DATEDIFF(HH,CreateTime,GETDATE()) >= @i_pruneCriteriaInHrs
		END
		DELETE #tmpResultSetId1;
		SET @incrVal = @incrVal + 1
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneReviewSets')
	delete from GxQscripts where name = 'sp_dm2_PruneReviewSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneReviewSets')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneReviewSets'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneReviewSets',  '00010004000000000000', 'sp_dm2_PruneReviewSets', '00010004000000000000')
GO

