

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneQuery.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneQuery()
--  | Description:  Prune Query
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneQuery.sp,v $ $Id: sp_dm2_PruneQuery.sp,v 1.3 2014/03/19 16:46:33 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneQuery <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneQuery')
	drop procedure sp_dm2_PruneQuery
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneQuery')
	delete from GxQscripts where name = 'sp_dm2_PruneQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneQuery'
GO
print '... Creating Procedure: sp_dm2_PruneQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneQuery
  @i_UserGUID varchar(36) = '',
  @i_QueryID varchar(36) = ''
AS
	IF LEN(@i_QueryID) > 0
	BEGIN
		DELETE FROM DMQuery
		WHERE QueryID = @i_QueryID
	END
	ELSE
	BEGIN
		DECLARE @currentDate DATETIME = GETUTCDATE();
		DECLARE @pruneInterval INT = 90  -- default 90 days
		SELECT @pruneInterval = ISNULL(SettingValue, 90) FROM DMSetting
		WHERE SettingName = 'PRUNE_INTERVAL_FOR_QUERY_Days'
		IF(LEN(ISNULL(@i_UserGUID,'')) > 0)
		BEGIN
			DELETE FROM DMQuery WHERE
				UserGUID = @i_UserGUID
				AND Attribute & 1 <> 1  -- If Bit 1 is set on attribute, then that means it is user saved,
				AND datediff(d, CreateTime, @currentDate) > @pruneInterval	-- and dont prune records less tahn default 90 days.
		END
		ELSE
		BEGIN
			--case when we need to prune all records which matches the criteria.
			--
			DECLARE @batchCount INT = 10000  -- default
			SELECT @batchCount = ISNULL(SettingValue, 90) FROM DMSetting
			WHERE SettingName = 'DELETE_BATCH_COUNT_DMQUERY'
			--Create temp tbl for holding queryIds
			IF OBJECT_ID('tempdb.dbo.#tmpQueryIdsPrune') IS NOT NULL
				DROP TABLE #tmpQueryIdsPrune
			CREATE TABLE #tmpQueryIdsPrune( 	QueryId VARCHAR(36)		) ;
			INSERT INTO #tmpQueryIdsPrune
			SELECT TOP (@batchCount) Q.QueryID from DMQuery Q WITH (READUNCOMMITTED)
			WHERE Attribute & 1 <> 1 AND datediff(d, Q.CreateTime, @currentDate) > @pruneInterval
			WHILE EXISTS(SELECT TOP 1* FROM #tmpQueryIdsPrune)
			BEGIN
				DELETE DMQuery
				WHERE QueryID IN (SELECT T.QueryId FROM #tmpQueryIdsPrune AS T)
				--clean temp table
				DELETE #tmpQueryIdsPrune
				INSERT INTO #tmpQueryIdsPrune
				SELECT TOP (@batchCount) Q.QueryID from DMQuery Q WITH (READUNCOMMITTED)
				WHERE Attribute & 1 <> 1 AND datediff(d, Q.CreateTime, @currentDate) > @pruneInterval
			END
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneQuery')
	delete from GxQscripts where name = 'sp_dm2_PruneQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneQuery'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneQuery',  '00010003000000000000', 'sp_dm2_PruneQuery', '00010003000000000000')
GO

