

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneOrphanReviewSetsAndResultItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneOrphanReviewSetsAndResultItems.sp,v $ $Id: sp_dm2_PruneOrphanReviewSetsAndResultItems.sp,v 1.5.32.1 2017/01/09 18:47:03 njain Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneOrphanReviewSetsAndResultItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	drop procedure sp_dm2_PruneOrphanReviewSetsAndResultItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GxQscripts where name = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO
print '... Creating Procedure: sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneOrphanReviewSetsAndResultItems
  @i_ContainerGuids VARCHAR(MAX) = '',
  @o_OutputMessage NVARCHAR(MAX) OUTPUT --this needs to be last param
AS
SET NOCOUNT ON
BEGIN
	/*
		This Stored procedure prunes orphan review sets And orphan entries in DMResultSet table
		Reviewset Pruning
			Input is list of reviewSet available in CommServe (DM2Container table)
			If input containerGuids list is not empy
			{
				containerGuids in DMContainerItem table which doesnt match any of the input containers will be pruned.
			}
		Restored Item Pruning
			For items in DMResultSet whose RestoreTime and CreateTime is older than default 45 days., we will reset restore information
		DMResultSet Pruning
			For any entries in DMResultSet without mapping between DMContainerItem., and
				CreateTime is null Or CreateTime is greater then PRune interval AND
				Restore time is null OR Restoretime is greater then PRune interval
		DMSEtting keys used
			ENABLE_ORPHAN_REVIEWSET_PRUNING			--> To enable orphan review set pruning. [Default true]
			ENABLE_ORPHAN_ITEM_PRUNING				-->	To enable DMResultSet orphan items pruning. (ie., when there is no mapping between DMContainerItem exits). [Default true]
			PRUNE_INTERVAL_FOR_ORPHAN_ITEMS_InHrs	-->	Time interval to compare with RestoreTime and CreateTime while pruning items. [Default- 168 hrs]
			ENABLE_RESTORED_ITEM_PRUNING			-->	To enable restored items pruning. [Default false]
			RESET_INTERVAL_FOR_RESTORED_ITEMS_InHrs	-->	Time interval to compare with RestoreTime and CreateTime for resetting restore status of restored items. [Default- 1 hrs]
	*/
	DECLARE @enableOrphanRSPruning		VARCHAR(10) = 'TRUE'
	DECLARE @enableOrphanItemPruning	VARCHAR(10) = 'TRUE'
	DECLARE @enableRestoredItemPruning	VARCHAR(10) = 'FALSE'
	DECLARE @outputMessage				NVARCHAR(MAX) = ''
	SELECT @enableOrphanRSPruning = ISNULL(SettingValue,'TRUE')
	FROM DMSetting WHERE SettingName = 'ENABLE_ORPHAN_REVIEWSET_PRUNING'
	SELECT @enableOrphanItemPruning = ISNULL(SettingValue,'TRUE')
	FROM DMSetting WHERE SettingName = 'ENABLE_ORPHAN_ITEM_PRUNING'
	SELECT @enableRestoredItemPruning = ISNULL(SettingValue,'FALSE')
	FROM DMSetting 	WHERE SettingName = 'ENABLE_RESTORED_ITEM_PRUNING'
	SET @outputMessage = @outputMessage + ' Flags ENABLE_ORPHAN_REVIEWSET_PRUNING: [ ' + @enableOrphanRSPruning + ' ] '
	SET @outputMessage = @outputMessage + ' , ENABLE_ORPHAN_ITEM_PRUNING : [' + @enableOrphanItemPruning + ' ] '
	SET @outputMessage = @outputMessage + ' , ENABLE_RESTORED_ITEM_PRUNING : [' + @enableRestoredItemPruning + ' ] '
	DECLARE @date DATETIME =  GETDATE();
	--check if enable orphan RS pruning is enabled, and also input containeGuid list is not empty
	--
	IF( @enableOrphanRSPruning = 'TRUE' AND LEN(ISNULL(@i_ContainerGuids,'')) > 0 )
	BEGIN
		DECLARE @containerGuidTbl table( containerGuid varchar(36))
		INSERT INTO @containerGuidTbl
		SELECT  LTRIM(RTRIM(ID))
		FROM dbo.splitStringToTable(@i_ContainerGuids)
		WHERE LEN(ISNULL(ID,'')) > 0
		IF OBJECT_ID('tempdb.dbo.#tmpPruneContainerGuids') IS NOT NULL
			DROP TABLE #tmpPruneContainerGuids
		CREATE TABLE #tmpPruneContainerGuids
		(
			id INT IDENTITY(1,1) ,
			containerGuid VARCHAR(36)
		) ;
		--Insert containerGuid which doesnt match the input list
		--
		INSERT INTO #tmpPruneContainerGuids
		SELECT DISTINCT ContainerID FROM
		DMContainerItem WITH (NOLOCK)
		WHERE ContainerID NOT IN (SELECT distinct containerGuid FROM @containerGuidTbl)
		IF EXISTS (SELECT TOP 1 * FROM #tmpPruneContainerGuids)
		BEGIN
			DECLARE @tempContainerList VARCHAR(MAX)
			SELECT @tempContainerList = ISNULL(STUFF(
							(SELECT  ';' "text()", containerGuid "text()"
								FROM 	#tmpPruneContainerGuids
								FOR XML PATH('')),1,1,''),'')
			SET @outputMessage = @outputMessage + ' \n Container list to be pruned [ '+@tempContainerList +' ]'
			-- Now start pruning for all the input containerGuid
			--
			DECLARE @totalCount INT = 0
			DECLARE @incrVal INT = 0
			DECLARE @localContainerGuid VARCHAR(36) = ''
			SELECT @totalCount = MAX(ID) FROM #tmpPruneContainerGuids
			WHILE(@incrVal < @totalCount )
			BEGIN
				SET @localContainerGuid = ''
				SELECT @localContainerGuid = containerGuid FROM #tmpPruneContainerGuids WHERE id = (@incrVal+1)
				EXEC sp_dm2_PruneResultSetItemsBulk '', @localContainerGuid
				SET @incrVal = @incrVal + 1
			END
		END
		ELSE
		BEGIN
			SET @outputMessage = @outputMessage + ' \n No Containers will be pruned'
		END
		IF OBJECT_ID('tempdb.dbo.#tmpPruneContainerGuids') IS NOT NULL
			DROP TABLE #tmpPruneContainerGuids
	END
	IF @enableRestoredItemPruning = 'TRUE'
	BEGIN
		DECLARE @maxid INT = 0,
				@doContinue BIT = 1,
				@batchCnt INT = 5000,
				@totalUpdated BIGINT = 0
		DECLARE	@IDTable TABLE ( id INT)
		DECLARE @pruneRestoredItemInterval INT = 1080  -- default 45 days
		SELECT @pruneRestoredItemInterval = ISNULL(SettingValue, 1080) FROM DMSetting
		WHERE SettingName = 'RESET_INTERVAL_FOR_RESTORED_ITEMS_InHrs'
		WHILE (@doContinue = 1)
		BEGIN
			INSERT INTO @IDTable
			SELECT TOP (@batchCnt) RS.ID FROM DMResultSet RS WITH (NOLOCK)
			WHERE RS.ID > @maxid AND
				RS.RestoreStatus = 4 AND
				ISNULL(RS.DestinationPath,'') <> '' AND
				(RS.CreateTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.CreateTime,@date), @date) > @pruneRestoredItemInterval ) AND
				(RS.RestoreTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.RestoreTime,@date), @date) > @pruneRestoredItemInterval )
			IF EXISTS( SELECT 1 FROM @IDTable)
			BEGIN
				IF (SELECT COUNT(*) FROM @IDTable) < @batchCnt
					SET @doContinue = 0
				SELECT @maxid = MAX(id) FROM @IDTable
				UPDATE RS
				SET RS.RestoreStatus = 0,
					RS.RestoreJobID = 0,
					RS.RestoreTime = NULL,
					RS.DestinationPath = ''
				FROM DMResultSet RS
					INNER JOIN
					@IDTable as T
				ON RS.ID = T.id
				SELECT @totalUpdated = @totalUpdated + @@ROWCOUNT
				DELETE FROM @IDTable
			END
			ELSE
				SET @doContinue = 0
		END
		SET @outputMessage = @outputMessage + '\n Number of restored items updated [' + CONVERT(VARCHAR(100), @totalUpdated) +  ' ] '
	END
	--check if enable orphan DMResultset item pruning is enabled
	--
	IF( @enableOrphanItemPruning = 'TRUE' )
	BEGIN
		DECLARE @pruneInterval INT = 168  -- default 7 days
		SELECT @pruneInterval = ISNULL(SettingValue, 168) FROM DMSetting
		WHERE SettingName = 'PRUNE_INTERVAL_FOR_ORPHAN_ITEMS_InHrs'
		IF OBJECT_ID('tempdb.dbo.#tmpResultSetIdsPrune') IS NOT NULL
			DROP TABLE #tmpResultSetIdsPrune
		--Create temp tbl for holding ResultSetId
		CREATE TABLE #tmpResultSetIdsPrune
		(
			ResultSetId VARCHAR(36)
		) ;
		--insert any resultsetId which doesnt have mapping with DMContainerItem and DMDownloadResultSet
		-- And DMResulSet's
		--			CreateTime is null Or CreateTime is greater then PRune interval
		--			AND Restore time is null OR Restoretime is greater then PRune interval
		--
		-- use date Filter at last .
		-- Since resultsetid column have index in all tables
		--	using date in the same query will make dmresultset to go for entire table clustered index	scan.
		--
		;with CTE as(
		SELECT DISTINCT RS.ResultSetID FROM
			DMResultSet RS WITH (READUNCOMMITTED)
				LEFT OUTER JOIN
			DMContainerITem CI WITH (READUNCOMMITTED)
		ON RS.ResultSetId = CI.ResultSetId
				LEFT OUTER JOIN
			DMDownloadResultSet DR WITH (READUNCOMMITTED)
		ON RS.ResultSetID = DR.ResultSetID
		WHERE CI.ResultSetId IS NULL AND DR.ResultSetID IS NULL
		)
		INSERT INTO #tmpResultSetIdsPrune
		SELECT DISTINCT RS.ResultSetID FROM
			DMResultSet AS RS WITH (READUNCOMMITTED)
				INNER JOIN
			CTE
		ON RS.ResultSetID = CTE.ResultSetID
		WHERE  (RS.Attribute & 128) = 0 AND		--skip files for edge
			(RS.CreateTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.CreateTime,@date), @date) > @pruneInterval ) AND
			(RS.RestoreTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.RestoreTime,@date), @date) > @pruneInterval )
		IF EXISTS (SELECT Top 1 * FROM #tmpResultSetIdsPrune)
		BEGIN
			SET @outputMessage = @outputMessage + '\n Number of resultSet eligible to prune [' +
				 CONVERT(VARCHAR(100),(SELECT COUNT(*) FROM #tmpResultSetIdsPrune)) +  ' ] '
			DECLARE @numRowsAffected BIGINT = 0
			DECLARE @deleteNumber INT = 1000
			SELECT @deleteNumber = ISNULL(SettingValue, 1000) FROM DMSetting
				WHERE SettingName = 'DELETE_BATCH_COUNT_FOR_RESULTSET'
			WHILE(EXISTS (SELECT Top 1 * FROM #tmpResultSetIdsPrune))
			BEGIN
				--prune DMACtion tables.no
				--
				DECLARE @ResultSetIds VARCHAR(MAX)
				SELECT @ResultSetIds = ISNULL(STUFF(
								(SELECT TOP (@deleteNumber) ';' "text()", ResultSetId "text()"
									FROM 	#tmpResultSetIdsPrune
									FOR XML PATH('')),1,1,''),'')
				EXEC sp_dm2_PruneActionInfo @i_resultSetIds = @ResultSetIds
				--Pruning of other tables may not be requred. since all other have delete cascase option enabled in is foreign key, it will automatically delete those entries
				--Anyway keep look on this statement
				--
				DELETE FROM DMResultSet
				WHERE ResultSetID IN (SELECT TOP (@deleteNumber) ResultSetId FROM #tmpResultSetIdsPrune)
				SET @numRowsAffected += @@ROWCOUNT
				DELETE TOP (@deleteNumber) FROM #tmpResultSetIdsPrune
			END
			SET @outputMessage = @outputMessage + '\n Total number rows affected in DMResultSet [' +
					 CONVERT(NVARCHAR(100),@numRowsAffected) + ' ] '
		END
		ELSE
		BEGIN
			SET @outputMessage = @outputMessage + '\n No ResultSet items are eligible for pruning'
		END
	END
	SET @o_OutputMessage = @outputMessage
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GxQscripts where name = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneOrphanReviewSetsAndResultItems',  '00010005003200010000', 'sp_dm2_PruneOrphanReviewSetsAndResultItems', '00010005003200010000')
GO

