

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneDownloadBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneDownload()
--  | Description:  Prune Downloads
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneDownloadBulk.sp,v $ $Id: sp_dm2_PruneDownloadBulk.sp,v 1.1 2010/05/04 04:54:29 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneDownloadBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneDownloadBulk')
	drop procedure sp_dm2_PruneDownloadBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneDownloadBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneDownloadBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDownloadBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDownloadBulk'
GO
print '... Creating Procedure: sp_dm2_PruneDownloadBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneDownloadBulk
  @i_downloadXML XML,
  @i_dummy INT = 0
AS
	IF OBJECT_ID('tempdb.dbo.#tblDownload') IS NOT NULL DROP TABLE #tblDownload
  CREATE TABLE #tblDownload
  (
  	downloadId 			CHAR(36),
  	destinationPath	NVARCHAR(MAX),
  	cabFilePath			NVARCHAR(MAX)
  )
  INSERT INTO #tblDownload
	SELECT CAST(T.c.query('data(downloadId)') AS CHAR(36)),
	   CAST(T.c.query('data(destinationPath)') AS NVARCHAR(MAX)),
	   CAST(T.c.query('data(cabFilePath)') AS NVARCHAR(MAX))
	FROM @i_downloadXML.nodes('/DownloadItems/DownloadItem') T(c)
	--Delete the entries that are successfully deleted from cache
	DELETE DMDownloadResultSet
	FROM DMDownloadResultSet D, #tblDownload T
	WHERE D.downloadId = T.downloadId
	AND		(T.destinationPath IS NULL OR LEN(T.destinationPath) = 0)
	AND		(T.cabFilePath IS NULL OR LEN(T.cabFilePath) = 0)
	--Delete the entries that are successfully deleted from cache
	DELETE DMDownload
	FROM DMDownload D, #tblDownload T
	WHERE D.downloadId = T.downloadId
	AND		(T.destinationPath IS NULL OR LEN(T.destinationPath) = 0)
	AND		(T.cabFilePath IS NULL OR LEN(T.cabFilePath) = 0)
	--Update PruneStatus if it failed to delete from cache
	UPDATE DMDownload
	SET PruneUpdateTime = GETUTCDATE(), PruneStatus = 1
	FROM DMDownload D, #tblDownload T
	WHERE D.downloadId = T.downloadId
	AND		(
					(T.destinationPath IS NOT NULL AND LEN(T.destinationPath) > 0)
					OR
					(T.cabFilePath IS NOT NULL AND LEN(T.cabFilePath) > 0)
				)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneDownloadBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneDownloadBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDownloadBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDownloadBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneDownloadBulk',  '00010001000000000000', 'sp_dm2_PruneDownloadBulk', '00010001000000000000')
GO

