

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneActionInfo.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneActionInfo.sp,v $ $Id: sp_dm2_PruneActionInfo.sp,v 1.2 2013/07/16 12:44:48 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneActionInfo <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneActionInfo')
	drop procedure sp_dm2_PruneActionInfo
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneActionInfo')
	delete from GxQscripts where name = 'sp_dm2_PruneActionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneActionInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneActionInfo'
GO
print '... Creating Procedure: sp_dm2_PruneActionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneActionInfo
  @i_resultSetIds VARCHAR(MAX) = '', --semi colon seperated list
  @i_eventId BIGINT = 0,
  @i_eventType INT = 0,	
  @i_userGuid VARCHAR(36) = ''
AS
SET NOCOUNT ON
BEGIN
	SELECT @i_resultSetIds = ISNULL(@i_resultSetIds,''),
			@i_userGuid = ISNULL(@i_userGuid,''),
			@i_eventId = ISNULL(@i_eventId ,0),
			@i_eventType = ISNULL(@i_eventType ,0)
	--If no valid inputs are provided, return
	IF (@i_eventId = 0 AND
		@i_eventType = 0 AND
		LEN(@i_resultSetIds) = 0 AND
		LEN(@i_userGuid) = 0 )
	BEGIN
		RETURN
	END
	IF object_id('tempdb.dbo.#zeroRefEventId') IS NOT NULL
		DROP TABLE #zeroRefEventId
	--temp table to prune all entries belonging to eventId
	CREATE TABLE #zeroRefEventId (refEventId BIGINT);
	IF(LEN(@i_resultSetIds) > 0)
	BEGIN
		IF object_id('tempdb.dbo.#deletedRows_PruneAction') IS NOT NULL
			DROP TABLE #deletedRows_PruneAction
		IF object_id('tempdb.dbo.#distinctDeletedRows_PruneAction') IS NOT NULL
			DROP TABLE #distinctDeletedRows_PruneAction
		CREATE TABLE #deletedRows_PruneAction (refEventId BIGINT);
		CREATE TABLE #distinctDeletedRows_PruneAction (refEventId BIGINT);
		IF object_id('tempdb.dbo.#inputResultSetId') IS NOT NULL
			DROP TABLE #inputResultSetId
		CREATE TABLE #inputResultSetId (resultSetId char(36) PRIMARY KEY);
		INSERT INTO #inputResultSetId
		SELECT DISTINCT  S.ID FROM dbo.splitStringToTable(@i_resultSetIds) AS S
		--Insert the deleted rows into the #tempTable, so if that eventId doesnt have any resultSetIds then entire event details can be pruned
		DELETE FROM DMActionItemMap
		OUTPUT	DELETED.refEventId
			INTO #deletedRows_PruneAction
		WHERE ResultSetId IN (SELECT IR.resultSetId FROM #inputResultSetId AS IR)
		INSERT INTO #distinctDeletedRows_PruneAction
		SELECT DISTINCT refEventId FROM #deletedRows_PruneAction
		INSERT INTO #zeroRefEventId
		SELECT distinct refEventId FROM #distinctDeletedRows_PruneAction AS T
		WHERE NOT EXISTS( SELECT refEventId FROM DMActionItemMap AS AIM WHERE AIM.refEventId = T.refEventId )
	END
	IF(@i_eventId > 0)
	BEGIN
		INSERT INTO #zeroRefEventId VALUES (@i_eventId)
	END
	IF( @i_eventType > 0 )
	BEGIN
		INSERT INTO #zeroRefEventId
		SELECT EventId FROM DMAction
		WHERE EventType = @i_eventType
	END
	IF( LEN(@i_userGuid) > 0)
	BEGIN
		INSERT INTO #zeroRefEventId
		SELECT EventId FROM DMAction
		WHERE UserGuid = @i_userGuid
	END
	IF EXISTS (SELECT refEventId FROM #zeroRefEventId)
	BEGIN
		-- Prune from DMActionItemMap
		DELETE FROM DMActionItemMap
		WHERE refEventId IN (SELECT DISTINCT T.refEventId FROM #zeroRefEventId AS T )
		--Prune FROM DMActionParam
		DELETE FROM DMActionParam
		WHERE refEventId IN (SELECT DISTINCT T.refEventId FROM #zeroRefEventId AS T )
		--prune from DMAction
		DELETE FROM DMAction
		WHERE EventId IN (SELECT DISTINCT T.refEventId FROM #zeroRefEventId AS T )
	END
	IF object_id('tempdb.dbo.#zeroRefEventId') IS NOT NULL
		DROP TABLE #zeroRefEventId
	IF object_id('tempdb.dbo.#deletedRows_PruneAction') IS NOT NULL
			DROP TABLE #deletedRows_PruneAction
	IF object_id('tempdb.dbo.#distinctDeletedRows_PruneAction') IS NOT NULL
			DROP TABLE #distinctDeletedRows_PruneAction
	IF object_id('tempdb.dbo.#inputResultSetId') IS NOT NULL
			DROP TABLE #inputResultSetId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneActionInfo')
	delete from GxQscripts where name = 'sp_dm2_PruneActionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneActionInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneActionInfo'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneActionInfo',  '00010002000000000000', 'sp_dm2_PruneActionInfo', '00010002000000000000')
GO

