

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetUserComment.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetUserComment()
--  | Description:  Get the User Comments
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetUserComment.sp,v $ $Id: sp_dm2_GetUserComment.sp,v 1.1.294.2 2017/04/27 07:32:14 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetUserComment <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetUserComment')
	drop procedure sp_dm2_GetUserComment
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetUserComment')
	delete from GxQscripts where name = 'sp_dm2_GetUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserComment'
GO
print '... Creating Procedure: sp_dm2_GetUserComment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetUserComment
  @i_CommentID varchar(36) = '',
  @i_UserGUID nvarchar(256) = '',
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_ParentCommentID varchar(36) = '',
  @Items AS DMItemsToSyncWithIndexingTypeV2 READONLY
AS
IF EXISTS (SELECT TOP 1 * FROM @Items)
BEGIN
	SELECT A.Comment, A.UserGUID,
	I.OriginalFullPath as documentId, -- OriginalFullPath carries documentid for now, need to fix once it is added in DMItemsToSyncWithIndexingTypeV2 for later SP
	ISNULL(A.ModifiedTime, A.CreateTime) AS CommentSaveTime, res.IndexGUID
	FROM @Items I
		INNER JOIN DMResultSet res WITH (NOLOCK) ON (i.IndexGUID IS NOT NULL AND i.IndexGUID = res.IndexGUID) OR (i.IndexGUID IS NULL AND I.CommCellNumber = res.CommCellNumber AND I.aFileID = res.aFileID AND I.aFileOffset = res.aFileOffset)
		INNER JOIN DMUserComment A WITH (NOLOCK) ON res.ResultSetID = A.ResultSetID AND A.ContainerID = @i_ContainerID
	ORDER BY I.OriginalFullPath, CommentSaveTime DESC;
END
ELSE
BEGIN
  select * from [DMUserComment] WITH (READUNCOMMITTED)
  where (len(@i_CommentID) = 0 or CommentID = @i_CommentID)
  and (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
  and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID)
  and (len(@i_ResultSetID) = 0 or ResultSetID = @i_ResultSetID)
  and (len(@i_ParentCommentID) = 0 or ParentCommentID = @i_ParentCommentID)
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetUserComment')
	delete from GxQscripts where name = 'sp_dm2_GetUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserComment'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetUserComment',  '00010001029400020000', 'sp_dm2_GetUserComment', '00010001029400020000')
GO

