

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetWithGrouping.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetWithGrouping.sp,v $ $Id: sp_dm2_GetResultSetWithGrouping.sp,v 1.15 2015/04/16 18:52:07 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSetWithGrouping <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSetWithGrouping')
	drop procedure sp_dm2_GetResultSetWithGrouping
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSetWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetWithGrouping'
GO
print '... Creating Procedure: sp_dm2_GetResultSetWithGrouping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSetWithGrouping
  @i_xml XML ,
  @o_resultItemsCount BIGINT OUTPUT,
  @o_groupingCount BIGINT OUTPUT,
  @o_localGroupingXml NVARCHAR(MAX) OUTPUT,
  @o_groupingXml NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	/*
	This sp would return ResultItems in the container along with grouping info. This can be invoked under below cases
		1. Get ResultItems only
		2. ResultItems + LocalGrouping Only
		3. Grouping Only
		4. ResultItems + LocalGrouping + Grouping Tables.
	Seperate paging config can be provided for both the ResultItems and Grouping table. However the localGrouping table will not honor any paging config
	Input:
	1.@i_XML
		Sample XML --
		<GetItems containerId="08D07D0D-7E9C-4981-892F-FBCC7ACC0D5B" ignoreResultItems="0" ignoreGrouping="0"
				whereCondition=" (  OwnerField  IN (''Kamal Hasan'',''Sruthi Hasan'') ) ">
			<Grouping groupByClause="OwnerField" orderByClause="" pageSize="200" startIndex="0" fetchEmails="1" fetchFiles="1" />
			<ResultItems orderByClause="" pageSize="220" startIndex="0" fetchEmails="1" fetchFiles="1" />
		</GetItems>
	2. @o_resultItemsCount
		Output variable which have total count of ResultItem for that criteria
	3. @o_groupingCount
		Output variable holding total count of Grouping for input criteria
	4. @o_localGroupingXml
		Output variable. This contain the XML blob of the local grouping info
	5. @o_groupingXml
		Output variable. This contain the XML blob of the grouping info
	Output:
	this would return ResultItem table and the XML(formatted table) blob.
	1. ResultItems table
		if (ignoreResultItems=0) then
			Return ResultItems
		else
			Return empty table
	2. localGrouing (Grouping details for the ResultItems table that is returned)   --XML
		if (ignoreResultItems=0 and LEN(groupByClause) > 0) then
			return o_localGroupingXml
		Else
			return empty XML
	3. Grouping table (Groupind details for the entire criteria NOT specific to ResultItem table)  --XML
		if(ignoreGrouping = 0 and LEN(groupByClause) > 0) then
			return o_groupingXml
		Else
			return empty XML
	Sample XML format of output variable:
		<GetItems_Grouping>
			<Items value="Administrator" countVal="5"/>
			<Items value="Arun P. Amarendran" countVal="8"/>
			<Items value="Shivaji Rao" countVal="4"/>
			<Items value="Sruthi Hasan" countVal="4"/>
		  </GetItems_Grouping>
	*
	*
	****/
	--reset Output variables
	SELECT @o_groupingCount = 0, @o_resultItemsCount = 0,
			@o_localGroupingXml = '',@o_groupingXml = ''
	--local variables
	DECLARE @i_ignoreResultItems BIT = 0,
			@i_ignoreGrouping BIT = 0,
			@i_containerId VARCHAR(36),
			@i_whereClause	NVARCHAR(MAX),
			@i_groupByclause VARCHAR(50),
			@i_orderByClause VARCHAR(50),
			@sqlCmd NVARCHAR(MAX) = '',
			@fetchEmail CHAR(1) = '1',
			@fetchFiles	CHAR(1)	= '1',
			@StartRN	INTEGER = 0,
			@pageCount	INTEGER = 0,
			@EndRN	INTEGER = -1,
			@i_debug	BIT = 0,
			@returnEmptyResultItemTable BIT = 1,
			@ParmDefinition		NVARCHAR(MAX),
			@i_ForRestoreFlag	INT = 0,
			@idxSyncInterval int = 1,
			@CaseStmtForGrouping nvarchar(max),
			@UserTagIDs varchar(max) = '',
			@whereClauseTags varchar(max) = '',
			@whereClauseTagsForGrouping varchar(max) = ''
	--parse the input XML to get required field only
	SELECT	@i_containerId = ISNULL(T.col.value('@containerId','VARCHAR(36)'),''),
			@i_ignoreResultItems = ISNULL(T.col.value('@ignoreResultItems','BIT'),0),
			@i_ignoreGrouping = ISNULL(T.col.value('@ignoreGrouping','BIT'),0),
			@i_whereClause = ISNULL(T.col.value('@whereCondition','NVARCHAR(MAX)'),''),
			@i_groupByclause = ISNULL(T.col.value('Grouping[1]/@groupByClause','VARCHAR(50)'),''),
			@i_debug = ISNULL(T.col.value('@debug','BIT'),0),
			@i_ForRestoreFlag = ISNULL(T.col.value('@forRestore', 'INT'), 0),
			@UserTagIDs = ISNULL(T.col.value('@allUserTagIdList', 'varchar(max)'),''),
			@whereClauseTags = ISNULL(T.col.value('@tagIdWhereClause', 'varchar(max)'),''),
			@whereClauseTagsForGrouping = ISNULL(T.col.value('@tagIdWhereClauseForGrouping', 'varchar(max)'),'')
	FROM @i_xml.nodes('/GetItems')  T(col)
	-------++++++++++Case when GResultItems will be returned++++++++-------
	IF(@i_ignoreResultItems = 0)
	BEGIN
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'DMContainerItem.CreateTime DESC'
										ELSE T.col.value('@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems/ResultItems[1]')  T(col)
		--Get the total count
		--since the query is common to get the total count and the retrival on pagination.
		-- create string accordingly
		DECLARE @middleWhereClause NVARCHAR(MAX)= '';
		--DECLARE @tempAppTypeTable NVARCHAR(MAX) = '';
		DECLARE @totalCount INT = 0;
		DECLARE @dynamicparamdec AS NVARCHAR(1000);
		IF NOT(@fetchEmail = '1' AND @fetchFiles = '1')
		BEGIN
			CREATE TABLE #tblAppType (AppType INT );
			CREATE UNIQUE CLUSTERED INDEX IDX_tempTblAppType ON #tblAppType (AppType)
			INSERT INTO #tblAppType
			 SELECT distinct AppTypeId
							FROM DMUIAppTypeMap AS AT
				 WHERE AT.IsEmailAppType = @fetchEmail
					OR AT.IsFileAppType = @fetchFiles
		END
		DECLARE @extraJoin nvarchar(max) = ''
		IF (@fetchEmail = '1' AND @fetchFiles = '0')--email view special join for sorting..
		BEGIN
			SET @extraJoin = ' LEFT JOIN DMEmailResult ON DMResultSet.ResultSetID = DMEmailResult.ResultSetID '
		END
		SET @middleWhereClause = 'FROM DMResultSet AS DMResultSet WITH (READUNCOMMITTED)
						INNER JOIN DMContainerItem AS DMContainerItem WITH (READUNCOMMITTED)
						ON	DMResultSet.ResultSetID = DMContainerItem.ResultSetID AND (DMContainerItem.Attribute & 4) = 0 '
		--if both email and files are enabled, AppType check is unnecessary
		--Also this check must be inline with inner join so that left join may not cause issue
		IF NOT(@fetchEmail = '1' AND @fetchFiles = '1')
			SET @middleWhereClause = @middleWhereClause + '  AND DMResultSet.AppType IN (SELECT AT.AppType
													FROM #tblAppType AS AT) '
		--check if the value is empty or has empty space only
		--Filter condition was becoming unuseful because of left join, so filter condition is being made to go inline with inner join
		IF(LEN(LTRIM(ISNULL(@i_whereClause,'')))>0 )
		BEGIN
			SET @middleWhereClause = @middleWhereClause + ' AND ' + @i_whereClause
		END
		IF (LEN(LTRIM(ISNULL(@extraJoin,'')))>0 )
		BEGIN
			SET @middleWhereClause = @middleWhereClause + @extraJoin
		END
		SET @middleWhereClause = @middleWhereClause + ' WHERE (LEN(''' + @i_ContainerID + ''') = 0
									or (DMContainerItem.ContainerID = ''' + @i_ContainerID + '''))'
		IF LTRIM(RTRIM(ISNULL(@whereClauseTags, ''))) <> ''
		BEGIN
			SET @middleWhereClause = @middleWhereClause + ' AND ' + @whereClauseTags
		END
		SET @sqlCmd = ' SELECT  @totalCount = COUNT(DMContainerItem.ResultSetID) ' + @middleWhereClause
		SET @dynamicparamdec = ' @totalCount INT OUTPUT '
		IF(@i_debug = 1)
			SELECT @sqlCmd 'totalCountSQLCMD'
		EXECUTE sp_executesql  @sqlCmd
                               ,@dynamicparamdec
                               ,@totalCount output
		--Now reset the @sqlCmd, so that it can be used for retrieving the resultItems..
		--aling with total count.
		SELECT @sqlCmd = '',@o_resultItemsCount = @totalCount
		IF(@o_resultItemsCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_resultItemsCount
									ELSE (@pageCount+ @StartRN -1)
								END
		IF object_id('tempdb.dbo.#tblGetContainerItem') is not null
			DROP TABLE #tblGetContainerItem
		CREATE TABLE #tblGetContainerItem
		(
			rowId INT,
			ResultSetID VARCHAR(36),
			--UserComments NVARCHAR(MAX),
			Attribute INT,
			CreateTime DATETIME,
			ContainerItemID INT,
		)
		-- Construct the select query.
		SET @sqlCmd = N';WITH AllResults AS
						(	SELECT TOP (@EndRN)
							ROW_NUMBER() OVER (ORDER BY ' + @i_OrderByClause +') AS row ,
								DMContainerItem.ResultSetID,DMContainerItem.Attribute,DMContainerItem.CreateTime, DMContainerItem.ID AS ContainerItemID '
		--Since we have constructed the where clause already we reuse it.
		SET @sqlCmd = @sqlCmd + @middleWhereClause
		-- output from the CTE.
		SET @sqlCmd = @sqlCmd + ')INSERT INTO #tblGetContainerItem
							SELECT  V.row,V.ResultSetID,V.Attribute,V.CreateTime,V.ContainerItemID
								FROM AllResults AS V
								where V.row >= @StartRN '
		SET @ParmDefinition = N'@EndRN INTEGER,@StartRN INTEGER'
		IF(@i_debug = 1)
			SELECT @sqlCmd 'ResultItemSQLCMD'
		EXEC sp_executesql @sqlCmd,@ParmDefinition,@EndRN,@StartRN
		IF(@i_debug = 1)
			SELECT * FROM #tblGetContainerItem
		/*@karthik
		  Usercomments will be returned in the metadata response or in the retrieved via seperate call
		  **/
		--IF len(@i_ContainerID) > 0
--		BEGIN
--			UPDATE #tblGetContainerItem
--			SET UserComments =
--				(SELECT TOP 1 ISNULL(UC.Comment, '')
--				FROM DMUserComment UC
--					 WHERE  UC.ResultSetID = #tblGetContainerItem.ResultSetID
--						AND UC.ContainerID = @i_ContainerID
--				ORDER BY UC.CreateTime desc)
--		END
			SELECT	RS.ResultSetID,RS.CommCellNumber,RS.aFileID,RS.aFileOffset,
					RS.aFileLength,RS.AppType,RS.FileSizeKB,RS.ModifiedTime,
					RS.JobId,RS.OriginalFullPath,RS.DestinationPath,RS.CreateTime,
					RS.RestoreUserGUID,RS.RestoreJobID,RS.RestoreStatus,
					RS.RestoreTime,RS.Attribute,
					RS.documentID,RS.ClientID,
					RSI.ResultSet, '' AS "UserComments",
					T.Attribute AS ItemAttribute, T.CreateTime AS ItemAdded, T.ContainerItemID
			FROM #tblGetContainerItem AS T
					INNER JOIN
				DMResultSet AS RS WITH (NOLOCK)
				ON RS.ResultSetID = T.ResultSetID
					INNER JOIN
				DMResultSetInfo AS RSI  WITH (NOLOCK)
				ON RS.ResultSetID = RSI.ResultSetID
			ORDER BY T.rowId
			DROP TABLE #tblGetContainerItem
			--reset empty table as false
			SET @returnEmptyResultItemTable = 0
			----+++++ localGrouping table WILL NOT BE RETURNED..+++++------
			-- NO PROCESSING IS REQUIRED FOR LOCAL GROUPING --
		END
	END
	---------+++++++++++++If empty table has to be returned for ResultItems+++++++++++++-------------
	IF(@returnEmptyResultItemTable = 1)
	BEGIN
		SELECT RS.*, ''  AS "ResultSet"
		FROM DMResultSet AS RS WITH (READUNCOMMITTED)
		 WHERE 1= 2
	END
	---------++++++++++++Case when GroupingItems to be returned+++++++++++++++------------------
	IF(@i_ignoreGrouping = 0 AND LEN(@i_groupByclause) > 0)
	BEGIN
		--Grouping on aFileID is only done by restore code to determine invalid aFileIDs. No point in returning the ones already existing in DMPrunedArchFile
		IF charindex('aFileID', @i_groupByclause) > 0 AND LEN(ISNULL(@i_whereClause, '')) > 0
		BEGIN
			SET @i_whereClause = @i_whereClause + ' AND aFileID NOT IN (SELECT ArchFileId FROM DMPrunedArchFile) '
		END
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('Grouping[1]/@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('Grouping[1]/@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('Grouping[1]/@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('Grouping[1]/@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'countVal DESC'
										ELSE T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems')  T(col)
		IF object_id('tempdb.dbo.#tblGetGroupingItem') is not null
			DROP TABLE #tblGetGroupingItem
		CREATE TABLE #tblGetGroupingItem (rowId INT IDENTITY(1,1), value NVARCHAR(max), countVal BIGINT )
		IF @i_groupByclause IS NOT NULL AND CHARINDEX('RestoreStatus', @i_groupByclause) > 0
		BEGIN
			SET @CaseStmtForGrouping = '
				 CASE RestoreStatus WHEN 7 THEN 5 ELSE RestoreStatus END '
		END
		ELSE
		BEGIN
			SET @CaseStmtForGrouping = '
				  CASE LEN(ISNULL(' + @i_groupByclause +',''''))
					WHEN 0 THEN ''N/A''
					ELSE '+ @i_groupByclause +'
				END'
		END
		SET @sqlCmd = 'INSERT INTO #tblGetGroupingItem
						SELECT ' + @CaseStmtForGrouping + ' AS "value",
						COUNT_BIG(*) AS "countVal"
					 FROM DMContainerItem AS DMContainerItem WITH (READUNCOMMITTED) INNER JOIN
						DMResultSet AS DMResultSet WITH (READUNCOMMITTED)
					ON	DMResultSet.ResultSetID = DMContainerItem.ResultSetID AND
						DMResultSet.AppType
						IN (SELECT AT.AppTypeId
							FROM DMUIAppTypeMap AS AT
							WHERE AT.IsEmailAppType = '+ @fetchEmail +
							' OR AT.IsFileAppType = '+  @fetchFiles +')'
		IF @i_groupByclause IS NOT NULL AND CHARINDEX('TagID', @i_groupByclause) > 0
		BEGIN
			SET @sqlCmd += '
				JOIN DMContainerItemStates WITH (READUNCOMMITTED) ON DMContainerItem.ContainerID = DMContainerItemStates.ContainerID AND DMContainerItem.ResultSetID = DMContainerItemStates.ResultSetID AND DMContainerItemStates.Attribute & 4 = 0
				JOIN DMContainerItemTags WITH (READUNCOMMITTED) ON DMContainerItemTags.AssignID = DMContainerItemStates.AssignID'
			IF ISNULL(@UserTagIDs, '') <> ''
			BEGIN
				SET @sqlCmd += '
					JOIN dbo.splitStringToTable(''' + @UserTagIDs + ''') TagsTemp ON TagsTemp.ID = DMContainerItemTags.TagID'
			END
		END
		SET @sqlCmd += ' WHERE (LEN(''' + @i_ContainerID + ''') = 0 or (DMContainerItem.ContainerID = ''' + @i_ContainerID + '''))
							AND (DMContainerItem.Attribute & 4) = 0 '
		IF LTRIM(RTRIM(ISNULL(@whereClauseTagsForGrouping, ''))) <> ''
		BEGIN
			SET @sqlCmd = @sqlCmd + ' AND ' + @whereClauseTagsForGrouping
		END
		IF(LEN(ISNULL(@i_whereClause,''))>0)
		BEGIN
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_whereClause
		END
		--	set grouping Clause
			SET @sqlCmd = @sqlCmd + ' GROUP BY ' + @CaseStmtForGrouping + ' ORDER BY '+@i_orderByClause
		IF(@i_debug = 1)
			SELECT @sqlCmd
		EXECUTE (@sqlCmd)
		SELECT @o_groupingCount = MAX(T.rowId)
		FROM #tblGetGroupingItem AS T
		IF(@o_groupingCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_groupingCount
									ELSE (@pageCount+ @StartRN -1)
								END
			SET @o_groupingXml =
					(SELECT T.value,T.countVal
			FROM #tblGetGroupingItem AS T
			WHERE T.rowId BETWEEN @StartRN AND @EndRN
			ORDER BY T.rowId
					For XML RAW('Items'),ROOT('GetItems_Grouping'))
		END
		DROP TABLE #tblGetGroupingItem
	END
	--If empty XML to be returned
	IF(LEN(ISNULL(@o_groupingXml,'')) = 0)
	BEGIN
		SET @o_groupingXml =
				(SELECT '<GetItems_Grouping />')
END
	IF(LEN(ISNULL(@o_localGroupingXml,'')) = 0)
	BEGIN
		SET @o_localGroupingXml =
				(SELECT '<GetItems_Grouping />')
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSetWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetWithGrouping'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSetWithGrouping',  '00010015000000000000', 'sp_dm2_GetResultSetWithGrouping', '00010015000000000000')
GO

