

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetResultSet()
--  | Description:  Get the ResultSet Info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSet.sp,v $ $Id: sp_dm2_GetResultSet.sp,v 1.15 2015/04/16 18:51:46 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSet')
	drop procedure sp_dm2_GetResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSet'
GO
print '... Creating Procedure: sp_dm2_GetResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSet
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_CommCellNumber int = 0,
  @i_aFileID bigint = 0,
  @i_aFileOffset bigint = 0,
  @i_AppType int = 0,
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_UserGUID varchar(36) = '',
  @i_RestoreStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'DMContainerItem.CreateTime DESC',
  @i_GetEmailsFlag bit = 1,
  @i_GetFilesFlag bit = 1,
  @i_offset int = 0
AS
SET NOCOUNT ON
  DECLARE @StartRN					INTEGER
  DECLARE @EndRN 						INTEGER
	DECLARE @sqlCmd 					NVARCHAR(max)
	DECLARE @curResultSetId		VARCHAR(36)
	DECLARE @tmpTagStr				NVARCHAR(MAX)
	DECLARE @ParmDefinition		NVARCHAR(MAX);
  IF @i_GetEmailsFlag IS null
	SET @i_GetEmailsFlag = 1
  IF @i_GetFilesFlag IS NULL
	SET @i_GetFilesFlag = 1
	--Changes to support both the pagination retrieval
	-- through the pagenumber and offset
  IF(@i_offset <= 0)
	BEGIN
	  IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
	  BEGIN
			SET @StartRN = 1
			SET @EndRN = -1
	  END
	  ELSE
	  BEGIN
			SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
			SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
	  END
	END
	ELSE
	BEGIN
		IF(@i_ItemsOnPage) <= 0
		BEGIN
			SET @StartRN = @i_Offset
			SET @EndRN = -1
		END
		ELSE
		BEGIN
			SET @StartRN = @i_Offset
			SET @EndRN = @i_offset + @i_ItemsOnPage - 1
		END
	END
	--check if the orderbyclause is empty
	IF(LEN(ISNULL(@i_OrderByClause,'')) = 0 )
		SET @i_OrderByClause = 'DMContainerItem.CreateTime DESC'
	IF object_id('tempdb.dbo.#tblGetContainerItem') is not null
	DROP TABLE #tblGetContainerItem
	IF object_id('tempdb.dbo.#tblAppType') is not null
		DROP TABLE #tblAppType
	CREATE TABLE #tblGetContainerItem (rowId INT, ResultSetID VARCHAR(36))--,UserComments NVARCHAR(MAX))
	CREATE UNIQUE CLUSTERED INDEX IDX_tempTblGetContainerItem_1 ON #tblGetContainerItem(rowId);
	CREATE NONCLUSTERED INDEX IDX_tempTblGetContainerItem_2 ON #tblGetContainerItem(ResultSetID);
	IF NOT(@i_GetEmailsFlag = 1 AND @i_GetFilesFlag = 1)
	BEGIN
	CREATE TABLE #tblAppType (AppType INT );
	CREATE UNIQUE CLUSTERED INDEX IDX_tempTblAppType ON #tblAppType (AppType)
					 INSERT INTO #tblAppType
					 SELECT distinct AppTypeId
						 FROM DMUIAppTypeMap AS AT
						 WHERE AT.IsEmailAppType = @i_GetEmailsFlag OR AT.IsFileAppType = @i_GetFilesFlag
	END
	SET @sqlCmd = '
					;WITH AllResults AS
					(	SELECT '
	IF(@EndRN > 0)
		SET @sqlCmd  = @sqlCmd  + ' TOP (@EndRN) '
	SET @sqlCmd = @sqlCmd + ' ROW_NUMBER() OVER (ORDER BY ' + @i_OrderByClause +') AS row ,
								DMContainerItem.ResultSetID
						 FROM DMResultSet AS DMResultSet WITH (READUNCOMMITTED) INNER JOIN
							DMContainerItem AS DMContainerItem WITH (READUNCOMMITTED)
						ON	DMResultSet.ResultSetID = DMContainerItem.ResultSetID   AND	(DMContainerItem.Attribute & 4) = 0 '
	IF NOT(@i_GetEmailsFlag = 1 AND @i_GetFilesFlag = 1)
		SET @sqlCmd = @sqlCmd + ' AND DMResultSet.AppType IN (SELECT AT.AppType
													FROM #tblAppType AS AT) '
	SET @sqlCmd = @sqlCmd + 'where (len('''+ (@i_ContainerID)+''') = 0 or (DMContainerItem.ContainerID = '''+(@i_ContainerID)+''')))
							 INSERT INTO #tblGetContainerItem
							SELECT  V.row,V.ResultSetID
								FROM AllResults AS V
								where V.row >= @StartRN '
	SET @ParmDefinition = N'@EndRN INTEGER,@StartRN INTEGER,@i_GetEmailsFlag BIT, @i_GetFilesFlag BIT'
	EXEC sp_executesql @sqlCmd,@ParmDefinition,@EndRN,@StartRN,@i_GetEmailsFlag,@i_GetFilesFlag
	--IF len(@i_ContainerID) > 0
	--BEGIN
	--	UPDATE #tblGetContainerItem
	--	SET UserComments = ISNULL(UC.Comment, '')
	--	FROM  #tblGetContainerItem T
	--			INNER JOIN
	--		DMUserComment UC
	--		ON UC.ResultSetID = T.ResultSetID
	--			AND UC.ContainerID = @i_ContainerID
	--END
	SELECT t.ResultSetID,RS.RestoreStatus, RSI.ResultSet, '' AS UserComments,
			RS.CommCellNumber,RS.aFileID,RS.aFileOffset,RS.aFileLength,
			RS.AppType,RS.FileSizeKB,RS.ModifiedTime,RS.JobId,RS.OriginalFullPath,
			RS.DestinationPath,RS.CreateTime,RS.RestoreUserGUID,RS.RestoreJobID,
			RS.RestoreStatus,RS.RestoreTime,RS.Attribute,
			RS.documentID,RS.ClientID
	FROM #tblGetContainerItem as t
			INNER JOIN
		DMResultSet AS RS WITH (READUNCOMMITTED)
		ON t.ResultSetID = RS.ResultSetID
			INNER JOIN
		DMResultSetInfo AS RSI WITH (READUNCOMMITTED)
		ON t.ResultSetID = RSI.ResultSetID
	ORDER BY t.rowId
  DROP TABLE #tblGetContainerItem
IF object_id('tempdb.dbo.#tblAppType') is not null
	DROP TABLE #tblAppType
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSet',  '00010015000000000000', 'sp_dm2_GetResultSet', '00010015000000000000')
GO

