

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemStatus.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemStatus.sp,v $ $Id: sp_dm2_GetResultItemStatus.sp,v 1.2.34.2 2019/03/15 16:57:12 anguyen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultItemStatus')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_GetResultItemStatus <<<'
	drop procedure sp_dm2_GetResultItemStatus
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultItemStatus')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemStatus'
GO
print '... Creating Procedure: sp_dm2_GetResultItemStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultItemStatus
  @i_aFileId BIGINT ,
  @i_aFileOffset BIGINT ,
  @i_CommCellNumber INT ,
  @i_ContainerID VARCHAR(36) = '',
  @i_IndexGUID VARCHAR(128) = ''
AS
SET NOCOUNT ON
	/*
	            Input: CommcellId, AFileId, AFileOffset,ContainerId
	            Output: DestinationPath, RestoreStatus, ResultSetId, Attribute, restoreJobID
	                        (Attribute field will be read from DMContainerItem, rest of the fields will be read from DMResultSet table)
	                        (If item doesnt exists in DMcontainerItem table, -1 is returned)
	      *
	      **/
		DECLARE @ItemID BIGINT
		DECLARE @Mark_Email_Restore_To_Xml  INTEGER = 1024 -- this is use to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format
		IF ISNULL(@i_IndexGUID, '') <> ''
		BEGIN
			SELECT @ItemID = ID FROM DMResultSet AS D WITH(NOLOCK)
			WHERE D.IndexGUID = @i_IndexGUID
		END
		IF ISNULL(@ItemID, 0) = 0 AND @i_aFileId > 0
		BEGIN
			SELECT @ItemID = ID FROM DMResultSet AS D WITH(NOLOCK)
			WHERE D.aFileID = @i_aFileId AND D.aFileOffset = @i_aFileOffset AND D.CommCellNumber = @i_CommCellNumber AND D.Attribute <> @Mark_Email_Restore_To_Xml -- -- D.Attribute <> @Mark_Email_Restore_To_Xml is used to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format. Recall is not required for that specific type of preview so this change won't affect it.
		END
		SELECT D.ResultSetID, D.DestinationPath, D.RestoreStatus,D.RestoreJobID,
		ISNULL((SELECT C.Attribute FROM DMContainerItem AS C WHERE C.ContainerID = @i_ContainerID AND C.ResultSetID = D.ResultSetID), -1) AS "Attribute"
		FROM DMResultSet D WITH(NOLOCK)
		WHERE ID = @ItemID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultItemStatus')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultItemStatus',  '00010002003400020000', 'sp_dm2_GetResultItemStatus', '00010002003400020000')
GO

