

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemDetail.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemDetail.sp,v $ $Id: sp_dm2_GetResultItemDetail.sp,v 1.18.12.9 2020/02/06 03:12:43 nramalingam Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultItemDetail')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_GetResultItemDetail <<<'
	drop procedure sp_dm2_GetResultItemDetail
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemDetail'
GO
print '... Creating Procedure: sp_dm2_GetResultItemDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultItemDetail
  @i_ItemsXML XML,
  @i_DUMMY NVARCHAR(MAX) = ''
AS
BEGIN
	DECLARE @RestoreAsXML varchar(10) = 'emailxml'
	DECLARE @curResultSetId			VARCHAR(36)
	DECLARE @curCommentId				VARCHAR(36)
	DECLARE @curComment					NVARCHAR(MAX)
	DECLARE @curTagsXML					XML
	DECLARE @curCommCellNumber 	INTEGER
	DECLARE @curAFileId 		BIGINT
	DECLARE @curAFileOffSet 		BIGINT
	DECLARE @tmpContainerStr		VARCHAR(MAX)
	DECLARE @tmpDBTagStr				VARCHAR(MAX)
	DECLARE @tmpTagStr					VARCHAR(MAX)
	DECLARE @tmpLHGUIDStr				VARCHAR(MAX)
	DECLARE @debug							BIT
	DECLARE @i_UserGUID					VARCHAR(36)
	DECLARE @i_ContainerGUID		VARCHAR(36)
	DECLARE @i_xmlText				XML
	--below 3 bits will be useful to avoid any unnecessay query on tables.
	DECLARE @isContainerListEmpty	BIT = 1
	DECLARE @isTagListEmpty			BIT = 1
	DECLARE @isLHListEmpty			BIT = 1
	DECLARE @Mark_Email_Restore_To_Xml	INTEGER = 1024
	--change @debug to 1 helps trace outputs of stored proc, but should be 0 in test / production env..
	SET @debug = 0
	--drop temptable iff any exists
	IF object_id('tempdb.dbo.#tmpContainerGUIDList') IS NOT NULL
		DROP TABLE #tmpContainerGUIDList
	IF object_id('tempdb.dbo.#tmpTagGUIDList') IS NOT NULL
		DROP TABLE #tmpTagGUIDList
	IF object_id('tempdb.dbo.#tmpLHGUIDList') IS NOT NULL
		DROP TABLE #tmpLHGUIDList
	IF object_id('tempdb.dbo.#tmpViewTagList') IS NOT NULL
		DROP TABLE #tmpViewTagList
	IF object_id('tempdb.dbo.#tmpResultSet') IS NOT NULL
		DROP TABLE #tmpResultSet
	--created non-clustered index on temp table for fast access..
	CREATE TABLE #tmpContainerGUIDList ( ContainerId VARCHAR(36) )
	CREATE NONCLUSTERED INDEX tmpContainerGUIDList_idx1 ON #tmpContainerGUIDList(containerId)
	CREATE TABLE #tmpTagGUIDList ( TagID VARCHAR(36) )
	CREATE NONCLUSTERED INDEX tmpTagGUIDList_idx1 ON #tmpTagGUIDList(TagID)
	CREATE TABLE #tmpLHGUIDList ( CompPolicyID VARCHAR(36) )
	CREATE NONCLUSTERED INDEX tmpLHGUIDList_idx1 ON #tmpLHGUIDList(CompPolicyID)
	CREATE TABLE #tmpViewTagList ( TagID VARCHAR(36) )
	--LegalHoldStatus = 1 (Success), 3 (Unknown), 2 (Failed), 0 (Submitted)
	CREATE Table #tmpResultSet
	(
		DocumentId 			char(256),
		ResultSetId 		VARCHAR(36),
		CommCellNumber 	INTEGER,
		aFileId 				BIGINT,
		aFileOffSet 		BIGINT,
		restoreStatus 	INTEGER,
		ContainerList 	VARCHAR(MAX),
		DBTagGUIDList 	VARCHAR(MAX),
		TagGUIDList 		VARCHAR(MAX),
		LegalHoldStatus INTEGER,
		DestinationPath NVARCHAR(MAX),
		Comment 				NVARCHAR(MAX),
		CommentID 			CHAR(36),
		LHGUIDList 			VARCHAR(MAX),
		TagsXML					XML,
		isExistsInDMResultSet		bit default 0,
		IndexGUID			varchar(128),
		NewCCN				INT,
		NewAFID				BIGINT,
		NewAFOF				BIGINT,
		UseNewRestoreIndex  BIT default 0,
		filePath			NVARCHAR(MAX),
		appId				INT,
		appType				INT,
		jobId				BIGINT default 0,
		modifiedTime		INT DEFAULT 0
	)
	CREATE NONCLUSTERED INDEX tmpResultSet_idx1 ON #tmpResultSet(ResultSetId)
	CREATE NONCLUSTERED INDEX tmpResultSet_idx2 ON #tmpResultSet(aFileId,aFileOffSet)
			INCLUDE (CommCellNumber)
	CREATE NONCLUSTERED INDEX tmpResultSet_idx3 ON #tmpResultSet(IndexGUID)
	SELECT @i_UserGUID = T.c.value('@userGuid', 'VARCHAR(36)')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq') T(c)
	IF @i_UserGUID IS null
		SET @i_UserGUID = ''
	SELECT @i_ContainerGUID = T.c.value('@containerGuid', 'VARCHAR(36)')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/currentContainer') T(c)
	IF @i_ContainerGUID IS null
		SET @i_ContainerGUID = ''
	--Check if the sharedEntities node exists
	IF( (SELECT @i_ItemsXML.exist('DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities')) = 1)
	BEGIN
	-- Populate containerGUID that current user can view
	INSERT INTO #tmpContainerGUIDList
	SELECT ID FROM dbo.splitStringToTable((SELECT T.c.value('@containerIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities') T(c)))
		--Reset the bit, if count(temp table) > 0
		IF((SELECT COUNT(ContainerId) FROM #tmpContainerGUIDList) > 0)
			SET @isContainerListEmpty = 0
	-- Populate TagGUIDs that current user can view
	INSERT INTO #tmpTagGUIDList
	SELECT ID FROM dbo.splitStringToTable((SELECT T.c.value('@tagIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities') T(c)))
		--Reset the bit, if count(temp table) > 0
		IF((SELECT COUNT(TagID) FROM #tmpTagGUIDList) > 0)
			SET @isTagListEmpty = 0
	-- Populate LegalHoldGUIDs that current user can view
	INSERT INTO #tmpLHGUIDList
	SELECT ID FROM dbo.splitStringToTable((SELECT T.c.value('@legalHoldList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities') T(c)))
		--Reset the bit, if count(temp table) > 0
		IF((SELECT COUNT(CompPolicyID) FROM #tmpLHGUIDList) > 0)
			SET @isLHListEmpty = 0
	END
	IF @debug = 1
	BEGIN
		SELECT '#tmpContainerGUIDList' AS TableName, * FROM #tmpContainerGUIDList
		SELECT '#tmpTagGUIDList' AS TableName, * FROM #tmpTagGUIDList
		SELECT '#tmpLHGUIDList' AS TableName, * FROM #tmpLHGUIDList
	END
	--
	-- There won't be any valid GUIDs for 137 app-type, so even if input has it, it must be copy of ContentId/DocumentId value which we don't want to use it
	-- we will fallback on commcellnumber,afileid,afileoffset
	-- Fix for TR 190129-527
	-- Exception: when restoring as xml, there is a prefix that can tell it is fabricated GUID and such value is needed for that feature to work
	-- For other operations that involve power restore, GUIDs are dropped for 137 app-type on purpose - Sreekanth, Ahn.
	--
	INSERT INTO #tmpResultSet(DocumentId, CommCellNumber, aFileId, aFileOffSet,
														restoreStatus, ContainerList, TagGUIDList, LegalHoldStatus,
														TagsXML, IndexGUID, filePath, appId, appType, jobId, modifiedTime)
	SELECT T.c.value('@documentId', 'varchar(256)'), T.c.value('@commcellNo', 'integer'),
					T.c.value('@aFileId', 'bigint'), 	T.c.value('@aFileOffset', 'bigint'),
					0 AS RestoreStatus, '' AS ContainerList, '' AS TagGUIDList,	3 AS LegalHoldStatus,
					CAST(T.c.query('./tags') AS XML) AS TagsXML,
(CASE WHEN ISNULL(T.c.value('@appType', 'INT'), 0) = 137
					AND CHARINDEX(@RestoreAsXML, ISNULL(T.c.value('@turboGuid', 'varchar(128)'), ''), 1) = 0 THEN ''
					ELSE T.c.value('@turboGuid', 'varchar(128)') END) AS IndexGUID,
					T.c.value('@filePath', 'nvarchar(MAX)'),
					T.c.value('@appId', 'INT'),
					T.c.value('@appType', 'INT'),
					T.c.value('@jobId', 'BIGINT'),
					T.c.value('@modifiedTime', 'INT')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/input/resultItem') T(c);
	/*** logic to be kept in sync with sp_dm2_AddResultSetBulk ***/
	--
	-- When data is Restored from legal hold, due to old bug of pushing wrong (source item's) turboguid to review set core
	-- first check if we can match item based on afileid, afileoffset and attribute = 16 (Legal_Restored_Item)
	-- This change is made to prevent returning wrong ResultSetID (for legal hold backed up items restored from LH to review set)
	-- We do not want to return ResultSetID of item that was added to legal hold instead of returning ID of item from it's corresponding
	-- legal hold backup
	--
	UPDATE tt
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3,
	isExistsInDMResultSet = 1,
	tt.UseNewRestoreIndex = CASE WHEN tt.aFileId < RS.aFileID THEN 1 ELSE 0 END,
	tt.NewAFID = RS.aFileID,
	tt.NewAFOF = RS.aFileOffset,
	tt.NewCCN = RS.CommCellNumber
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
	WHERE tt.aFileID > 0 AND tt.CommCellNumber = RS.CommCellNumber
						AND tt.aFileId = RS.aFileId
						AND tt.aFileOffset = RS.aFileOffSet
						AND RS.Attribute = 16
AND tt.AppType NOT IN (106,200, 201)
	--
	UPDATE tt
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3,
	isExistsInDMResultSet = 1,
	tt.UseNewRestoreIndex = CASE WHEN tt.aFileId < RS.aFileID THEN 1 ELSE 0 END,
	tt.NewAFID = RS.aFileID,
	tt.NewAFOF = RS.aFileOffset,
	tt.NewCCN = RS.CommCellNumber
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
WHERE isExistsInDMResultSet = 0 AND tt.appType <> 106 AND tt.aFileId <> 0 AND ISNULL(TT.IndexGUID, '') <> '' AND  RS.IndexGUID = TT.IndexGUID
	--Update the resultitem specific information
	-- Adding code (RS.Attribute & @Mark_Email_Restore_To_Xml) = 0 (RS.Attribute <> @Mark_Email_Restore_To_Xml) so that restore to xml items can be differentiated with restore to any other format when a same email is restored with different format option
	--
	UPDATE #tmpResultSet
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3,
	isExistsInDMResultSet = 1
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
WHERE tt.appType <> 106 AND tt.aFileId <> 0 AND isExistsInDMResultSet = 0 AND RS.CommCellNumber = tt.CommCellNumber AND RS.aFileId = tt.aFileId AND RS.aFileOffSet = tt.aFileOffSet AND RS.Attribute <> @Mark_Email_Restore_To_Xml
	UPDATE tt
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3,
	isExistsInDMResultSet = 1,
	tt.NewAFID = RS.aFileID,
	tt.NewAFOF = RS.aFileOffset,
	tt.NewCCN = RS.CommCellNumber
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
WHERE tt.appType = 106 AND tt.appType = RS.AppType AND tt.filePath = RS.OriginalFullPath AND tt.aFileId = RS.aFileID AND (tt.jobId = RS.RestoreJobID OR tt.jobId = 0) AND (tt.modifiedTime IS NULL OR dbo.GetDateTime(tt.modifiedTime) = RS.ModifiedTime)
	--Below case is used for edge drive where in request doesnt have afileid/offset , turboguid. So we compare wrt documentId..
    --
    IF EXISTS( SELECT TOP 1 * FROM #tmpResultSet tt WHERE tt.aFileId = 0)
    BEGIN
            UPDATE #tmpResultSet
            SET ResultSetId = RS.ResultSetId,
                    restoreStatus = RS.RestoreStatus,
                    DestinationPath = RS.DestinationPath
            FROM #tmpResultSet tt INNER JOIN
                    DMResultSet RS WITH (READUNCOMMITTED)
            ON tt.aFileId = 0 AND
               ISNULL(tt.DocumentId,'') <> '' AND tt.DocumentId = RS.DocumentId
    END
	IF @debug = 1
	BEGIN
		SELECT '#tmpResultSet' AS TableName, * FROM #tmpResultSet
	END
	DECLARE ResultSetCur CURSOR STATIC FOR
	SELECT ResultSetId, TagsXML,CommCellNumber, aFileId, aFileOffSet FROM #tmpResultSet
	OPEN ResultSetCur
	FETCH NEXT FROM ResultSetCur INTO @curResultSetId, @curTagsXML, @curCommCellNumber,@curAFileId, @curAFileOffSet
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE #tmpViewTagList
		SET @tmpContainerStr = null
		SET @tmpDBTagStr = null
		SET @tmpTagStr = null
		SET @tmpLHGUIDStr = null
		SET @curCommentId = ''
		SET @curComment = ''
		--Get the last Modified Comment on items (if any)
		SELECT TOP 1 @curCommentId = UC.CommentId, @curComment = UC.Comment
		FROM DMUserComment UC WITH (NOLOCK), DMContainerItem CI WITH (NOLOCK)
		WHERE UC.ResultSetId = CI.ResultSetId
		AND		UC.ContainerId = CI.ContainerId
		AND		UC.ResultSetId = @curResultSetId
		AND 	UC.ContainerId = @i_ContainerGUID
		AND 	UC.Comment IS NOT null
		AND		LEN(UC.Comment) > 0
		ORDER BY modifiedTime DESC
		--check if containerlist exists
		IF( @isContainerListEmpty = 0)
		BEGIN
			----Capture ContainerId List of those in which current ResultItemId exists and current user can view it
			SELECT @tmpContainerStr = ISNULL(STUFF(
					(SELECT  ', ' "text()", tt.ContainerId "text()"
		FROM 	#tmpContainerGUIDList tt, DMContainerItem CI  WITH (READUNCOMMITTED)
		WHERE	tt.ContainerId = CI.ContainerId
		AND		CI.ResultSetId = @curResultSetId
		AND		(len(@i_ContainerGUID) = 0 OR tt.ContainerId <> @i_ContainerGUID) -- If called from reviewset view then list other reviewsets except the current one
		AND	  (CI.Attribute & 4) = 0
						FOR XML PATH('')),1,1,''),'')
		END
		--check if taglist exists
		IF( @isTagListEmpty = 0)
		BEGIN
		--Get the Container specific (DB ONLY) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT CIT.TagId
		FROM 	#tmpTagGUIDList tt, DMContainerItemStates CIS WITH (READUNCOMMITTED), DMContainerItemTags CIT WITH (READUNCOMMITTED)
		WHERE	(len(@i_ContainerGUID) = 0 OR CIS.ContainerId = @i_ContainerGUID)
		AND		CIS.ResultSetId = @curResultSetId
		--AND		CIS.AssignedUserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		CIS.AssignId = CIT.AssignId
		AND		CIT.TagID = tt.TagID
		AND		(CIS.Attribute & 4) = 0
		AND		(CIT.Attribute & 4) = 0
		--Get complete list of DB TagIds that current user can view
			SELECT @tmpDBTagStr =
					ISNULL(STUFF((SELECT ',' "text()", tt.TagID "text()"
		FROM #tmpViewTagList tt
								FOR XML PATH('')),1,1,''),'')
		--Clean DB tags and get Fast Synced Tags
		DELETE FROM #tmpViewTagList
		--Get the Item specific (FAST SYNCed) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT UIT.TagID
		FROM 	#tmpTagGUIDList tt, DMUserItemTags UIT WITH (READUNCOMMITTED)
		WHERE	UIT.ResultSetId = @curResultSetId
		--AND		UIT.UserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		UIT.TagID = tt.TagID
		AND		(UIT.Attribute & 4) = 0
		UNION
		--Get the tags retrieved from FAST search results
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		--For now get tags from ResultSetXML when @i_ContainerGUID is empty for tags coming from FAST
		SELECT DISTINCT TAG.TagID
		FROM 	#tmpTagGUIDList tt, ( SELECT T.c.value('@id', 'char(36)') AS TagID
																FROM @curTagsXML.nodes('/tags/tag') T(c)) TAG
		WHERE	TAG.TagID = tt.TagID
		AND		len(@i_ContainerGUID) = 0
		--Get complete list of TagIds that current user can view
			SELECT @tmpTagStr =
				ISNULL(STUFF((SELECT ',' "text()", tt.TagID "text()"
		FROM #tmpViewTagList tt
								FOR XML PATH('')),1,1,''),'')
		END
		--check for Legalhold list is empty
		IF(@isLHListEmpty = 0)
		BEGIN
		--Get the LegalHold GUIDs to which this item is backed up and shared by current user
			SELECT @tmpLHGUIDStr =ISNULL(STUFF((
				SELECT ',' "text()", LH.CompPolicyID "text()"
					FROM 	#tmpLHGUIDList tt,
					(SELECT DISTINCT CompPolicyID
															FROM DMLegalHoldItemsToBackup WITH (READUNCOMMITTED)
															WHERE ResultSetId = @curResultSetId
															AND		(len(@i_ContainerGUID) = 0 OR ContainerId = @i_ContainerGUID)
															AND		BackupStatus = 1) LH
		WHERE	LH.CompPolicyID = tt.CompPolicyID
					FOR XML PATH('')),1,1,''),'')
		END
		IF(LEN(ISNULL(@curResultSetId,'')) > 0)
		BEGIN
		--Update List of ReviewSets, List of Tags and List of LegalHolds
			UPDATE #tmpResultSet
			SET commentId = ISNULL(@curCommentId, ''),
					comment = ISNULL(@curComment, ''),
					ContainerList = ISNULL(@tmpContainerStr, ''),
					DBTagGUIDList = ISNULL(@tmpDBTagStr, ''),
					TagGUIDList = ISNULL(@tmpTagStr, ''),
					LHGUIDList = ISNULL(@tmpLHGUIDStr, '')
			WHERE ResultSetId = @curResultSetId
		END
		--below case
		-- when request is from search page and tags are synced with CI
		-- but for some reason items doesnt exits in DM2 table, its ResultSetid wil be empty
		--[for better readability update has been moved as seperate stmt]
		ELSE
		BEGIN
			UPDATE #tmpResultSet
			SET commentId = ISNULL(@curCommentId, ''),
					comment = ISNULL(@curComment, ''),
					ContainerList = ISNULL(@tmpContainerStr, ''),
					DBTagGUIDList = ISNULL(@tmpDBTagStr, ''),
					TagGUIDList = ISNULL(@tmpTagStr, ''),
					LHGUIDList = ISNULL(@tmpLHGUIDStr, '')
			WHERE @curCommCellNumber = CommCellNumber  AND
				  @curAFileId = aFileId AND
				  @curAFileOffSet = aFileOffSet
		END
			FETCH NEXT FROM ResultSetCur INTO @curResultSetId, @curTagsXML, @curCommCellNumber,@curAFileId, @curAFileOffSet
		END
		SELECT
			DocumentId,
			ResultSetId,
			CommCellNumber,
			aFileId,
			aFileOffSet,
			restoreStatus,
			ContainerList,
			DBTagGUIDList,
			TagGUIDList,
			LegalHoldStatus,
			DestinationPath,
			Comment,
			CommentID,
			LHGUIDList,
			TagsXML,
			isExistsInDMResultSet,
			IndexGUID,
			NewCCN,
			NewAFID,
			NewAFOF,
			UseNewRestoreIndex,
			filePath,
			appId,
			appType,
			jobId,
			modifiedTime
		FROM #tmpResultSet
		DROP TABLE #tmpResultSet
		DROP TABLE #tmpContainerGUIDList
		DROP TABLE #tmpTagGUIDList
		DROP TABLE #tmpLHGUIDList
		DROP TABLE  #tmpViewTagList
		CLOSE ResultSetCur
		DEALLOCATE ResultSetCur
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemDetail'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultItemDetail',  '00010018001200090000', 'sp_dm2_GetResultItemDetail', '00010018001200090000')
GO

