

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetRestoreJob.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetRestoreJob()
--  | Description:  Get the Job Status Info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetRestoreJob.sp,v $ $Id: sp_dm2_GetRestoreJob.sp,v 1.5 2011/07/06 15:21:08 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetRestoreJob <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetRestoreJob')
	drop procedure sp_dm2_GetRestoreJob
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetRestoreJob')
	delete from GxQscripts where name = 'sp_dm2_GetRestoreJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetRestoreJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetRestoreJob'
GO
print '... Creating Procedure: sp_dm2_GetRestoreJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetRestoreJob
  @i_RestoreJobID int = 0,
  @i_UserGUID nvarchar(256) = '',
  @i_RestoreStatus int = -1,
  @i_withInHours int = 168,
  @i_containerIdList nvarchar(max) = '',
  @i_resultSetIDs varchar(max) = ''	
AS
/*
@karthiks
	Modifed the Sp not to honor the ContainerId as it was unnecessary join performed..
	Also the ResultSetId need not be retrieved bcoz, we are focused only in distinct RestoreJobId and
		no where concerned about the ResultSetId
*******/
--DECLARE @tblResultSet TABLE (ResultSetId varchar(36), RestoreJobId int PRIMARY KEY (ResultSetId))
--INSERT INTO @tblResultSet
SELECT DISTINCT RS.RestoreJobId  as RestoreJobID,
			'Retrieve' as JobType,
			'' as DestinationComputer,
			0 as Status,
			0 as Progress,
			0 as Errors,
			'' as StartTime,
			'' as EndTime
FROM DMResultSet as RS		 WITH (READUNCOMMITTED)
  WHERE (@i_RestoreJobID = 0 or RS.RestoreJobID = @i_RestoreJobID)
  AND (len(@i_UserGUID) = 0 or (RS.RestoreUserGUID = @i_UserGUID))
  AND RS.RestoreJobID > 0
  AND (
		-- completed/failed jobs within @withInHours hour and all other jobs
		(@i_RestoreStatus = -1
			AND ((RS.RestoreStatus in (4,5,7) AND (@i_withInHours <= 0 OR (@i_withInHours > 0 AND datediff(hh, RS.RestoreTime, getdate()) <= @i_withInHours)))
				OR  RS.RestoreStatus NOT IN (4,5,7))
		)
		OR
		RS.RestoreStatus = @i_RestoreStatus
	   )
	   AND (LEN(@i_resultSetIDs) = 0 OR RS.ResultSetID IN
			(SELECT ID FROM dbo.splitStringToTable(@i_resultSetIDs)))
		--SELECT	DISTINCT RS.RestoreJobID as RestoreJobID,
		--	'Retrieve' as JobType,
		--	'' as DestinationComputer,
		--	0 as Status,
		--	0 as Progress,
		--	0 as Errors,
		--	'' as StartTime,
		--	'' as EndTime
		--	  FROM @tblResultSet as RS,DMContainerItem as CI	WITH (READUNCOMMITTED)
		--				WHERE RS.ResultSetID = CI.ResultSetID
		--		AND (LEN(@i_containerIdList)=0 or
		--					CI.ContainerID in (select * from dbo.splitStringToTable(@i_containerIdList)))
		--		AND (CI.Attribute & 4) = 0
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetRestoreJob')
	delete from GxQscripts where name = 'sp_dm2_GetRestoreJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetRestoreJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetRestoreJob'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetRestoreJob',  '00010005000000000000', 'sp_dm2_GetRestoreJob', '00010005000000000000')
GO

