

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldXMLData.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetLegalHoldXMLData()
--  | Description:  Get the Data required to construct LegalHold MetaData XML
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldXMLData.sp,v $ $Id: sp_dm2_GetLegalHoldXMLData.sp,v 1.3 2010/05/12 21:27:43 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldXMLData <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldXMLData')
	drop procedure sp_dm2_GetLegalHoldXMLData
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldXMLData')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldXMLData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldXMLData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldXMLData'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldXMLData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldXMLData
  @i_ContainerID varchar(36),
  @i_ResultSetID varchar(36),
  @i_StateXML xml,
  @i_TagsXML xml
AS
	SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#tblStateInfo') IS NOT NULL
		DROP TABLE #tblStateInfo
	IF OBJECT_ID('tempdb.dbo.#tblTagInfo') IS NOT NULL
		DROP TABLE #tblTagInfo
	IF OBJECT_ID('tempdb.dbo.#tblLHDataInfo') IS NOT NULL
		DROP TABLE #tblLHDataInfo
  CREATE TABLE #tblStateInfo
  (
  	StateID 		VARCHAR(36),
  	StateValue 	NVARCHAR(256)
  )
  CREATE TABLE #tblTagInfo
  (
  	TagID 		VARCHAR(36),
  	TagValue 	NVARCHAR(256)
  )
	CREATE TABLE #tblLHDataInfo
	(
		DataType					INTEGER,
		AssignId					INTEGER,
		UserGUID					VARCHAR(36),
		UserName					NVARCHAR(256),
		StateId						VARCHAR(36),
		StateValue				NVARCHAR(256),
		StateNotes				NVARCHAR(MAX),
		TagType						INTEGER,
		TagId							VARCHAR(36),
		TagValue    			NVARCHAR(256),
		TagNotes    			NVARCHAR(MAX),
		TagAttr						INTEGER,
		UserComment				NVARCHAR(MAX),
		CreationTime			VARCHAR(25),
		LastModifiedTime	VARCHAR(25)
	)
	INSERT INTO #tblStateInfo
	SELECT  ref.value('@StateID', 'VARCHAR(36)'),
					ref.value('@StateValue', 'NVARCHAR(256)')
	FROM  @i_StateXML.nodes ('StateInfo') S(ref)
	INSERT INTO #tblTagInfo
	SELECT  ref.value('@TagID', 'VARCHAR(36)'),
					ref.value('@TagValue', 'NVARCHAR(256)')
	FROM  @i_TagsXML.nodes ('TagInfo') T(ref)
  -- TagType = 1 - DBOnly Tags
  -- TagType = 2 - CI Tags
  -- DataType = 1 - Tags
  -- DataType = 2 - User Comments
  INSERT INTO #tblLHDataInfo
  -- Get all DB ONLY tags
  SELECT DISTINCT 1, CIS.AssignID, CIS.AssignedUserGUID, US.UserName,
  								CIS.StateID, S.StateValue, CIS.Notes,
   								1, CIT.TagID, T.TagValue, CIT.Notes, CIT.attribute,
   								'', NULL, NULL
	FROM	DMContainerItemStates CIS WITH (NOLOCK)
				LEFT OUTER JOIN #tblStateInfo S
				ON CIS.StateID = S.StateID
				LEFT OUTER JOIN DMUserSession US WITH (NOLOCK)
				ON CIS.AssignedUserGUID = US.UserGUID
				LEFT OUTER JOIN DMContainerItemTags CIT WITH (NOLOCK)
				ON CIS.assignId = CIT.assignId
				LEFT OUTER JOIN #tblTagInfo T
				ON CIT.TagId = T.TagId
	WHERE	CIS.ContainerID = @i_ContainerID
	AND		CIS.ResultSetID = @i_ResultSetID
	AND		CIS.attribute & 4 = 0
	AND		CIT.attribute & 4 = 0
	UNION
  -- Get all CI tags
  SELECT DISTINCT 1, 0, UIT.UserGUID, US.UserName,
  								'', '', '',
   								2, UIT.TagID, T.TagValue, '', UIT.attribute,
   								'', NULL, NULL
	FROM	DMUserItemTags UIT WITH (NOLOCK)
				LEFT OUTER JOIN DMUserSession US WITH (NOLOCK)
				ON UIT.UserGUID = US.UserGUID
				LEFT OUTER JOIN #tblTagInfo T
				ON UIT.TagId = T.TagId
	WHERE	UIT.ResultSetID = @i_ResultSetID
	AND		UIT.attribute & 4 = 0
	UNION
  -- Get all User Comments
  SELECT DISTINCT 2, 0, UC.UserGUID, US.UserName,
  								'', '', '',
  								0, '', '', '', '',
  								UC.Comment,
  								CONVERT(VARCHAR(25), UC.CreateTime, 121),
  								CONVERT(VARCHAR(25), UC.ModifiedTime, 121)
	FROM	DMUserComment UC WITH (NOLOCK)
				LEFT OUTER JOIN DMUserSession US WITH (NOLOCK)
				ON UC.UserGUID = US.UserGUID
	WHERE	UC.ContainerID = @i_ContainerID
	AND		UC.ResultSetID = @i_ResultSetID
	AND		UC.attribute & 4 = 0
	SELECT *
	FROM #tblLHDataInfo
	ORDER BY DataType, UserGUID, TagType
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldXMLData')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldXMLData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldXMLData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldXMLData'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldXMLData',  '00010003000000000000', 'sp_dm2_GetLegalHoldXMLData', '00010003000000000000')
GO

