

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetItemsToSyncWithIndexing.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetItemsToSyncWithIndexing()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetItemsToSyncWithIndexing.sp,v $ $Id: sp_dm2_GetItemsToSyncWithIndexing.sp,v 1.8.14.2 2017/08/05 02:36:13 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetItemsToSyncWithIndexing <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetItemsToSyncWithIndexing')
	drop procedure sp_dm2_GetItemsToSyncWithIndexing
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemsToSyncWithIndexing'
GO
print '... Creating Procedure: sp_dm2_GetItemsToSyncWithIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetItemsToSyncWithIndexing
  @ItemsToSync AS DMItemsToSyncWithIndexingTypeV2 READONLY,
  @tblInvalidArchFiles ArchFileType READONLY
AS
BEGIN
	DECLARE @idxSyncInterval int = 1
	DECLARE @syncAll bit = 0
	DECLARE @SyncSettingVal varchar(50)
	DECLARE @IdxAFileId BIGINT
	DECLARE @IdxAFileOffset BIGINT
	DECLARE @IdxCommCellNumber INT
	DECLARE @ResultSetID varchar(36)
	SELECT @idxSyncInterval = ISNULL(SettingValue, 24) FROM DMSetting
	WHERE SettingName = 'INDEX_SYNC_INTERVAL'
	SELECT @SyncSettingVal = ISNULL(SettingValue, 'SYNC_NEVER')
	FROM DMSetting
	WHERE SettingName = 'RESTORE_OFFSET_SYNC_OPTION'
	-- NULL value with dummy variable needed so that web service code can understand correct data type of these columns..
	SELECT @IdxAFileId = NULL, @IdxAFileOffset = NULL, @IdxCommCellNumber = NULL, @ResultSetID = NULL
	-- we no more want to look at DMItemsToSyncWithIndexing table as this is cache table though success items are valid for only 24 hrs
	-- still there is possibility in some cases it points to stale/pruned archive file. so we always do real time lookup against AFCore and/or Indexing as needed.
	IF @SyncSettingVal = 'SYNC_NEVER'
	BEGIN
		SELECT TOP 1 * FROM @ItemsToSync
		WHERE 1 = 2
	END
	ELSE IF @SyncSettingVal = 'SYNC_FORCE_ALL'
	BEGIN
		SELECT A.aFileID, A.aFileOffset, A.CommCellNumber, A.OriginalFullPath, A.IndexGUID,
		0 AS SyncStatus, A.idxAFileId, A.idxAFileOffset, A.idxCommCellNumber, @ResultSetID AS ResultSetID
		FROM @ItemsToSync A
	END
	ELSE IF @SyncSettingVal = 'SYNC_ALL'
	BEGIN
		SELECT A.aFileID, A.aFileOffset, A.CommCellNumber, '' AS OriginalFullPath, A.IndexGUID, 0 AS SyncStatus,
		@IdxAFileId AS idxAFileId, @IdxAFileOffset AS idxAFileOffset, @IdxCommCellNumber AS idxCommCellNumber, @ResultSetID AS ResultSetID
		FROM @ItemsToSync A
	END
	ELSE
	BEGIN
		--Sync only if turboguid present in input row for SYNC_ONLY_TURBO option.
		--left join with @tblInvalidArchFiles, because now we want to restore stubs as data, so we return them for lookup even though it is not marked for pruning.
		--we are not using ResultSetID taken from DMResultSet table for any purpose and this join could slow down, so that is being removed
		SELECT A.aFileID, A.aFileOffset, A.CommCellNumber, '' AS OriginalFullPath, A.IndexGUID,
		0 AS SyncStatus, @IdxAFileId AS idxAFileId, @IdxAFileOffset AS idxAFileOffset, @IdxCommCellNumber AS idxCommCellNumber, @ResultSetID AS ResultSetID
		FROM @ItemsToSync A
		LEFT JOIN @tblInvalidArchFiles P ON A.AFileID = P.ArchFileID
		WHERE ISNULL(A.IndexGUID, '') <> '' AND (ISNULL(A.SyncStatus, 0) = 3 OR P.ArchFileId IS NOT NULL) --either item is marked for pruning or if it is stub, we want to sync using turboguid.
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemsToSyncWithIndexing'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetItemsToSyncWithIndexing',  '00010008001400020000', 'sp_dm2_GetItemsToSyncWithIndexing', '00010008001400020000')
GO

