

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetFilteredResultItemDetail.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetFilteredResultItemDetail.sp,v $ $Id: sp_dm2_GetFilteredResultItemDetail.sp,v 1.3 2015/04/16 18:53:20 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetFilteredResultItemDetail <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetFilteredResultItemDetail')
	drop procedure sp_dm2_GetFilteredResultItemDetail
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetFilteredResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetFilteredResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetFilteredResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetFilteredResultItemDetail'
GO
print '... Creating Procedure: sp_dm2_GetFilteredResultItemDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetFilteredResultItemDetail
  @i_ItemsXML XML,
  @i_DUMMY NVARCHAR(MAX) = ''
AS
BEGIN
	DECLARE @curResultSetId			VARCHAR(36)
	DECLARE @curContainerId			VARCHAR(36)
	DECLARE @curCommentId				VARCHAR(36)
	DECLARE @curComment					NVARCHAR(MAX)
	DECLARE @curTagsXML					XML
	DECLARE @tmpContainerStr		VARCHAR(MAX)
	DECLARE @tmpDBTagStr				VARCHAR(MAX)
	DECLARE @tmpTagStr					VARCHAR(MAX)
	DECLARE @tmpLHGUIDStr				VARCHAR(MAX)
	DECLARE @debug							BIT
	DECLARE @i_UserGUID					VARCHAR(36)
	DECLARE @i_xmlText				XML
	--change @debug to 1 helps trace outputs of stored proc, but should be 0 in test / production env..
	SET @debug = 0
	CREATE TABLE #tmpContainerGUIDList ( ContainerId VARCHAR(36) )
	CREATE TABLE #tmpTagGUIDList ( TagID VARCHAR(36) )
	CREATE TABLE #tmpLHGUIDList ( CompPolicyID VARCHAR(36) )
	CREATE TABLE #tmpViewTagList ( TagID VARCHAR(36) )
	--LegalHoldStatus = 1 (Success), 3 (Unknown), 2 (Failed), 0 (Submitted)
	CREATE Table #tmpResultSet
	(
		ContainerId			VARCHAR(36),
		DocumentId 			char(256),
		ResultSetId 		VARCHAR(36),
		CommCellNumber 	INTEGER,
		aFileId 				BIGINT,
		aFileOffSet 		BIGINT,
		restoreStatus 	INTEGER,
		ContainerList 	VARCHAR(MAX),
		DBTagGUIDList 	VARCHAR(MAX),
		TagGUIDList 		VARCHAR(MAX),
		LegalHoldStatus INTEGER,
		DestinationPath NVARCHAR(MAX),
		Comment 				NVARCHAR(MAX),
		CommentID 			CHAR(36),
		LHGUIDList 			VARCHAR(MAX),
		TagsXML					XML
	)
	SELECT @i_UserGUID = T.c.value('@userGuid', 'VARCHAR(36)')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/userInfo') T(c)
	IF @i_UserGUID IS null
		SET @i_UserGUID = ''
	-- Populate containerGUID that current user can view
	INSERT INTO #tmpContainerGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@containerIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/sharedEntities') T(c)))
	-- Populate TagGUIDs that current user can view
	INSERT INTO #tmpTagGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@tagIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/sharedEntities') T(c)))
	-- Populate LegalHoldGUIDs that current user can view
	INSERT INTO #tmpLHGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@legalHoldList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/sharedEntities') T(c)))
	IF @debug = 1
	BEGIN
		SELECT '#tmpContainerGUIDList' AS TableName, * FROM #tmpContainerGUIDList
		SELECT '#tmpTagGUIDList' AS TableName, * FROM #tmpTagGUIDList
		SELECT '#tmpLHGUIDList' AS TableName, * FROM #tmpLHGUIDList
	END
	INSERT INTO #tmpResultSet(ContainerId, DocumentId, CommCellNumber, aFileId, aFileOffSet,
														restoreStatus, ContainerList, TagGUIDList, LegalHoldStatus,
														TagsXML)
	SELECT 	ISNULL(T.c.value('containerInfo[1]/@containerGuid', 'varchar(36)'), ''),
					T.c.value('result[1]/@documentId', 'char(256)'),
					T.c.value('result[1]/@commcellNo', 'integer'),
					T.c.value('result[1]/@aFileId', 'bigint'),
					T.c.value('result[1]/@aFileOffset', 'bigint'),
					0 AS RestoreStatus,
					'' AS ContainerList,
					'' AS TagGUIDList,
					3 AS LegalHoldStatus,
					CAST(T.c.query('result[1]/tags') AS XML) AS TagsXML
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/input/containerItems') T(c);
	--Update the resultitem specific information
	UPDATE #tmpResultSet
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
	WHERE RS.CommCellNumber = tt.CommCellNumber
	AND 	RS.aFileId = tt.aFileId
	AND 	RS.aFileOffSet = tt.aFileOffSet
	IF @debug = 1
	BEGIN
		SELECT '#tmpResultSet' AS TableName, * FROM #tmpResultSet
	END
	DECLARE ResultSetCur CURSOR STATIC FOR
	SELECT ContainerId, ResultSetId, TagsXML FROM #tmpResultSet
	OPEN ResultSetCur
	FETCH NEXT FROM ResultSetCur INTO @curContainerId, @curResultSetId, @curTagsXML
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE #tmpViewTagList
		SET @tmpContainerStr = null
		SET @tmpDBTagStr = null
		SET @tmpTagStr = null
		SET @tmpLHGUIDStr = null
		SET @curCommentId = ''
		SET @curComment = ''
		--Get the last Modified Comment on items (if any)
		SELECT TOP 1 @curCommentId = UC.CommentId, @curComment = UC.Comment
		FROM DMUserComment UC WITH (NOLOCK), DMContainerItem CI WITH (NOLOCK)
		WHERE UC.ResultSetId = CI.ResultSetId
		AND		UC.ContainerId = CI.ContainerId
		AND		UC.ResultSetId = @curResultSetId
		AND 	UC.ContainerId = @curContainerId
		AND		(UC.attribute & 4) = 0
		AND	  (CI.Attribute & 4) = 0
		AND 	UC.Comment IS NOT NULL
		AND		LEN(UC.Comment) > 0
		ORDER BY modifiedTime DESC
		--Capture ContainerId List of those in which current ResultItemId exists and current user can view it
		SELECT @tmpContainerStr = COALESCE(@tmpContainerStr + ', ', '') + tt.ContainerId
		FROM 	#tmpContainerGUIDList tt, DMContainerItem CI  WITH (READUNCOMMITTED)
		WHERE	tt.ContainerId = CI.ContainerId
		AND		CI.ResultSetId = @curResultSetId
		AND		(len(@curContainerId) = 0 OR tt.ContainerId <> @curContainerId) -- If called from reviewset view then list other reviewsets except the current one
		AND	  (CI.Attribute & 4) = 0
		--Get the Container specific (DB ONLY) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT CIT.TagId
		FROM 	#tmpTagGUIDList tt, DMContainerItemStates CIS WITH (READUNCOMMITTED), DMContainerItemTags CIT WITH (READUNCOMMITTED)
		WHERE	(len(@curContainerId) = 0 OR CIS.ContainerId = @curContainerId)
		AND		CIS.ResultSetId = @curResultSetId
		--AND		CIS.AssignedUserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		CIS.AssignId = CIT.AssignId
		AND		CIT.TagID = tt.TagID
		AND		(CIS.Attribute & 4) = 0
		AND		(CIT.Attribute & 4) = 0
		--Get complete list of DB TagIds that current user can view
		SELECT @tmpDBTagStr = COALESCE(@tmpDBTagStr + ',', '') + tt.TagID
		FROM #tmpViewTagList tt
		--Clean DB tags and get Fast Synced Tags
		DELETE FROM #tmpViewTagList
		--Get the Item specific (FAST SYNCed) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT UIT.TagID
		FROM 	#tmpTagGUIDList tt, DMUserItemTags UIT WITH (READUNCOMMITTED)
		WHERE	UIT.ResultSetId = @curResultSetId
		--AND		UIT.UserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		UIT.TagID = tt.TagID
		AND		(UIT.Attribute & 4) = 0
		UNION
		--Get the tags retrieved from FAST search results
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		--For now get tags from ResultSetXML when @curContainerId is empty for tags coming from FAST
		SELECT DISTINCT TAG.TagID
		FROM 	#tmpTagGUIDList tt, ( SELECT T.c.value('@id', 'char(36)') AS TagID
																FROM @curTagsXML.nodes('/tags/tag') T(c)) TAG
		WHERE	TAG.TagID = tt.TagID
		AND		len(@curContainerId) = 0
		--Get complete list of TagIds that current user can view
		SELECT @tmpTagStr = COALESCE(@tmpTagStr + ',', '') + tt.TagID
		FROM #tmpViewTagList tt
		--Get the LegalHold GUIDs to which this item is backed up and shared by current user
		SELECT @tmpLHGUIDStr = COALESCE(@tmpLHGUIDStr + ',', '') + LH.CompPolicyID
		FROM 	#tmpLHGUIDList tt, (SELECT DISTINCT CompPolicyID
															FROM DMLegalHoldItemsToBackup WITH (READUNCOMMITTED)
															WHERE ResultSetId = @curResultSetId
															AND		(len(@curContainerId) = 0 OR ContainerId = @curContainerId)
															AND		BackupStatus = 1) LH
		WHERE	LH.CompPolicyID = tt.CompPolicyID
		--Update List of ReviewSets, List of Tags and List of LegalHolds
			UPDATE #tmpResultSet
			SET commentId = ISNULL(@curCommentId, ''),
					comment = ISNULL(@curComment, ''),
					ContainerList = ISNULL(@tmpContainerStr, ''),
					DBTagGUIDList = ISNULL(@tmpDBTagStr, ''),
					TagGUIDList = ISNULL(@tmpTagStr, ''),
					LHGUIDList = ISNULL(@tmpLHGUIDStr, '')
			WHERE ResultSetId = @curResultSetId
			AND		ContainerId = @curContainerId
			FETCH NEXT FROM ResultSetCur INTO @curContainerId, @curResultSetId, @curTagsXML
		END
		SELECT * FROM #tmpResultSet
		DROP TABLE #tmpResultSet
		DROP TABLE #tmpContainerGUIDList
		DROP TABLE #tmpTagGUIDList
		DROP TABLE #tmpLHGUIDList
		DROP TABLE  #tmpViewTagList
		CLOSE ResultSetCur
		DEALLOCATE ResultSetCur
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetFilteredResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetFilteredResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetFilteredResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetFilteredResultItemDetail'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetFilteredResultItemDetail',  '00010003000000000000', 'sp_dm2_GetFilteredResultItemDetail', '00010003000000000000')
GO

