

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDynamicDisplayColumns.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetDynamicDisplayColumns()
--  | Description:  Fetch the list of properties that get displayed dynamically in Compliance Search UI
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDynamicDisplayColumns.sp,v $ $Id: sp_dm2_GetDynamicDisplayColumns.sp,v 1.1.2.2 2016/02/22 18:30:37 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDynamicDisplayColumns <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDynamicDisplayColumns')
	drop procedure sp_dm2_GetDynamicDisplayColumns
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDynamicDisplayColumns')
	delete from GxQscripts where name = 'sp_dm2_GetDynamicDisplayColumns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDynamicDisplayColumns')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDynamicDisplayColumns'
GO
print '... Creating Procedure: sp_dm2_GetDynamicDisplayColumns'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDynamicDisplayColumns
  @i_SiteMode INT
AS
BEGIN
	WITH CTE
	AS
	(
	SELECT B.BitVisibility, A.PropertyName, CASE
	WHEN CHARINDEX('^', ResourceKey) > 1 AND
	ISNUMERIC(LEFT(A.ResourceKey, CHARINDEX('^', A.ResourceKey)-1)) = 1
	THEN
	LEFT(A.ResourceKey, CHARINDEX('^', A.ResourceKey)-1) ELSE '0' END AS ColumnBehavior
	FROM DMUIColumns A
	JOIN DMUIPanelColumns B ON A.ID = B.ColumnId
	)
	SELECT DISTINCT PropertyName FROM CTE
	WHERE ColumnBehavior & 1 = 1 AND BitVisibility & @i_SiteMode = @i_SiteMode
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDynamicDisplayColumns')
	delete from GxQscripts where name = 'sp_dm2_GetDynamicDisplayColumns'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDynamicDisplayColumns')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDynamicDisplayColumns'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDynamicDisplayColumns',  '00010001000200020000', 'sp_dm2_GetDynamicDisplayColumns', '00010001000200020000')
GO

