

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItemsByStatus.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItemsByStatus.sp,v $ $Id: sp_dm2_GetDownloadItemsByStatus.sp,v 1.6.42.5 2020/02/14 22:15:06 rkulkarni Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadItemsByStatus')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_GetDownloadItemsByStatus <<<'
	drop procedure sp_dm2_GetDownloadItemsByStatus
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadItemsByStatus')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItemsByStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItemsByStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItemsByStatus'
GO
print '... Creating Procedure: sp_dm2_GetDownloadItemsByStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadItemsByStatus
  @i_DownLoadID varchar(36) = '',
  @i_StartIndex int = 0,
  @i_ItemsOnPage int = 0,
  @i_DownloadStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'modifiedTime DESC',
  @i_UserGUID varchar(36) = '',
  @o_TotalCount int output
AS
  DECLARE @StartRN integer
  DECLARE @EndRN integer
  DECLARE @sqlCmd nvarchar(max)
  DECLARE @sqlCmdCount nvarchar(max)
  DECLARE @sqlCmdCommon nvarchar(max)
  DECLARE @ContainerId varchar(36)
  DECLARE @ParmDefinition nvarchar(1000)
  DECLARE @ParmDefinition2 nvarchar(1000)
	SET NOCOUNT ON
	SELECT @ContainerId = ContainerID FROM DMDownload WHERE DownLoadID = @i_DownLoadID
	SELECT @sqlCmdCommon = '', @sqlCmd = '', @sqlCmdCount = ''
	IF @i_StartIndex <= 0 OR @i_ItemsOnPage <= 0
	BEGIN
		SET @StartRN = 1
		SET @i_ItemsOnPage = 50
	END
	ELSE
	BEGIN
		SET @StartRN = @i_StartIndex
	END
	SET @EndRN = @StartRN + @i_ItemsOnPage - 1
	PRINT '@i_ItemsOnPage = ' + CONVERT(VARCHAR,@i_ItemsOnPage) + ' , @StartRN = ' + CONVERT(VARCHAR, @StartRN)
	IF object_id('tempdb.dbo.#tblGetAllDownLoadItem') is not null
	DROP TABLE #tblGetAllDownLoadItem
	IF object_id('tempdb.dbo.#tblGetDownLoadItem') is not null
	DROP TABLE #tblGetDownLoadItem
  create table #tblGetAllDownLoadItem (rowId INT IDENTITY(1,1), ResultID BIGINT, DownloadResultSetId BIGINT)
  create table #tblGetDownLoadItem (rowId INT, ResultID BIGINT, DownloadResultSetId BIGINT)
	BEGIN
		SET @sqlCmd = 'insert into #tblGetAllDownLoadItem '
		SET @sqlCmd = @sqlCmd + 'select DMResultSet.ID, a.ID '
		SET @sqlCmdCommon = @sqlCmdCommon + 'FROM DMDownloadResultSet a WITH (READUNCOMMITTED)'
		SET @sqlCmdCommon = @sqlCmdCommon + 'INNER JOIN DMResultSet  WITH (READUNCOMMITTED) ON DMResultSet.ResultSetID = a.ResultSetID '
		SET @sqlCmdCommon = @sqlCmdCommon + 'where a.DownloadID  = @DownloadId '
		--
		-- IF @i_RestoreStatus = 100, meaning client is looking to find all items that are successfully written into archive(pst/nsf/cab)
		IF @i_DownloadStatus <> -1
		BEGIN
			IF @i_DownloadStatus = 101
			BEGIN
				SET @sqlCmdCommon = @sqlCmdCommon + 'and a.Status <> 100 '
			END
			ELSE
			BEGIN
				SET @sqlCmdCommon = @sqlCmdCommon + 'and a.Status = ' + CONVERT(varchar(10), @i_DownloadStatus) + ' ' --extra space at end is  must so that subsequent concatenation will be fine.
			END
		END
	END
	SET @sqlCmd = @sqlCmd + @sqlCmdCommon
	--Earlier there was no check and this can cause error if client program explicitely sends empty order by clause..
	IF ISNULL(@i_OrderByClause, '') <> ''
	BEGIN
		SET @sqlCmd = @sqlCmd + ' order by ' + @i_OrderByClause
	END
	ELSE
	BEGIN
		SET @sqlCmd = @sqlCmd + ' order by modifiedTime DESC '
	END
	--
	SET @ParmDefinition = N' @DownloadId varchar(36) ,@TotalCount INT OUTPUT '
	SET @ParmDefinition2 = N' @DownloadId varchar(36) '
	SET @sqlCmdCount = 'SELECT @TotalCount = COUNT(*) ' + @sqlCmdCommon
	--
	exec sp_executesql @sqlCmdCount, @ParmDefinition, @DownloadId = @i_DownLoadID, @TotalCount = @o_TotalCount OUTPUT
	--
	PRINT @sqlCmd
	--
	exec sp_executesql @sqlCmd, @ParmDefinition2, @DownloadId = @i_DownLoadID
	--
	if @EndRN < 0 	select @EndRN = count(*) from #tblGetAllDownLoadItem
	--
	INSERT INTO #tblGetDownLoadItem
	SELECT rowId, ResultID, DownloadResultSetId
	FROM #tblGetAllDownLoadItem
	WHERE rowId BETWEEN @StartRN AND @EndRN
	--select * from #tblGetDownLoadItem
	SELECT
		RS.ResultSetID as ResultSetID, DRS.FileName,
		dbo.fn_dm2_GetLastComment(@i_UserGUID, @ContainerId, RS.ResultSetID) AS Comment,
		RS.RestoreStatus, D.ContainerID, RS.ClientID, D.CreateTime,
		RS.aFileID, RS.aFileOffset, RS.CommCellNumber, RS.IndexGUID, RS.documentID, RS.Title,
		RS.FolderPath, RS.OriginalFullPath, dbo.GetUnixTime(RS.ModifiedTime) as ModifiedTime,
		dbo.GetUnixTime(RS.CreateTime) as ItemAddedTime,
		RS.AppType, RS.OwnerField, RS.FileSizeKB, RS.AppId,
		E.EmailFROM, E.EmailTO, E.EmailCC, E.EmailBCC,DRS.Status
	FROM #tblGetDownLoadItem as t
	INNER JOIN
		DMResultSet AS RS WITH (READUNCOMMITTED)
	ON
		t.ResultID = RS.ID
	INNER JOIN
		DMDownloadResultSet AS DRS WITH (READUNCOMMITTED)
	ON
		t.DownloadResultSetId = DRS.ID
	INNER JOIN
		DMDownload D
	ON
		D.DownLoadID = DRS.DownloadID
	LEFT JOIN DMEmailResult E
	ON
		RS.ResultSetID = E.ResultSetID
	WHERE
		DRS.DownloadID = @i_DownLoadID
	ORDER BY
		t.rowId
	DROP TABLE #tblGetAllDownLoadItem
    DROP TABLE #tblGetDownLoadItem
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadItemsByStatus')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItemsByStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItemsByStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItemsByStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadItemsByStatus',  '00010006004200050000', 'sp_dm2_GetDownloadItemsByStatus', '00010006004200050000')
GO

