

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetCommands.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetCommands.sp,v $ $Id: sp_dm2_GetCommands.sp,v 1.1.2.6 2017/02/10 19:16:51 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetCommands <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetCommands')
	drop procedure sp_dm2_GetCommands
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetCommands')
	delete from GxQscripts where name = 'sp_dm2_GetCommands'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetCommands')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetCommands'
GO
print '... Creating Procedure: sp_dm2_GetCommands'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sp_dm2_GetCommands
  @i_commandId INT=0, -- if command id specified, all parameters are ignored
  @i_ownerId NVARCHAR(max)='',  -- semicolon separated user guid and all his group guids the user is part of 
  @i_modifiedTime INT=0,  -- this is used as transaction time. Commands whose runtime greater than this time are only returned to users
  @i_clientType INT = 0,  -- DM2ClientType ( 6 - OutlookProvider)
  @i_flatTable INT = 0,  -- output is table or XML
  @o_TotalCount INT OUTPUT ,
  @o_errorCode INT OUTPUT,
  @o_errorMessage nvarchar(max) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	BEGIN TRY
	SET @i_modifiedTime = ISNULL(@i_modifiedTime, '')
	create table #tblTempCommand (Id INT IDENTITY(1,1), CommandId INT)
	create table #tblTempCommandOrder (Id INT IDENTITY(1,1),  CommandId INT)
	IF @i_commandId > 0
	BEGIN
		IF ( NOT EXISTS ( SELECT CommandId from DMCmd where CommandId=@i_commandId  ) )
		BEGIN
			SELECT @o_errorCode=11703, @o_errorMessage='CommandId doesnt exists'
			GOTO _EXIT;
		END
		INSERT into #tblTempCommandOrder select CommandId FROM DMCmd WHERE CommandId = @i_commandId
	END
	ELSE
	BEGIN
		IF ISNULL(@i_ownerId, '') = '' OR @i_clientType = 0
		BEGIN
			SELECT @o_errorCode = 1001, @o_errorMessage='Either OwnerId OR ClientType is missing in input.'
			GOTO _EXIT;
		END
		--select all commands which are of particular clientType, targeted for the given user/his groups/everyone and runtime > user passed transaction time ( modifiedTime)
		INSERT into #tblTempCommand
		SELECT CommandId from DMCmd WHERE ClientType = @i_clientType
		INTERSECT
		select CommandId from DMCmdTarget WHERE
		EntityId in ( SELECT DATA FROM [dbo].[split](@i_ownerId , ';') ) OR EntityType =0
		INTERSECT
		Select CommandId from DMCmdRun where RunTime > @i_modifiedTime
		-- Sort the entries based on RunTime from lowest time to highest since clients should execute the commands in same order of command runtime
		INSERT INTO #tblTempCommandOrder
		SELECT T.CommandId --, C.Name, C.Description, C.CreateTime, C.ModifiedTime --,  MAX(CR.RunTime)
			from #tblTempCommand T
			INNER JOIN DMCmd C On C.CommandId = T.CommandId
			INNER JOIN DMCmdRun CR On CR.CommandId = T.CommandId
			GROUP BY T.CommandId --, C.Name, C.Description, C.CreateTime, C.ModifiedTime
			ORDER BY MAX(CR.RunTime)
	END
	SELECT @o_TotalCount = count(*) from #tblTempCommandOrder
	IF @i_flatTable = 1
	BEGIN
	SELECT C.CommandId, CT.EntityId, CT.EntityType, CP.ParamGuid, DG.Name as ActionName, DF.FieldLabel as ParamName, CP.ParamValue,
	CR.RunTime, CR.RunID  FROM #tblTempCommandOrder T
	INNER JOIN DMCmdTarget CT ON T.CommandId = CT.CommandId
	INNER JOIN DMCmdRun CR ON T.CommandId = CR.CommandId AND RunTime > @i_modifiedTime
	INNER JOIN DMCmdAction CA ON T.CommandId = CA.CommandId
	INNER JOIN DMSearchCriteriaGroup DG ON DG.Id = CA.ActionId
	LEFT JOIN DMCmdParams CP ON CP.CommandActionId = CA.CommandActionId
	LEFT JOIN DMSearchCriteriaField DF ON DF.Id = CP.ParamGuid
	INNER JOIN DMCmd C ON C.CommandId = T.CommandId
	ORDER BY T.Id, CR.RunTime desc, DF.FieldDisplayOrder
	END
	ELSE
	BEGIN
	select (select C.CommandId '@cmdid',
	C.Name '@name',
	C.Description '@desc',
	C.ClientType '@clientType',
	C.Attribute '@attribute',
	C.Status '@status',
	C.Retention '@retentionPeriod',
	dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
	dbo.GetUnixTime(C.CreateTime) '@createTime',
	C.CreatedBy '@createdByGuid',
	C.ModifiedBy '@modifiedByGuid',
	C.TaskId '@taskId'
	FOR XML PATH('basicInfo') , TYPE)
	,
	(select CT.TargetId '@targetid',
			CT.EntityId '@entityId',
			CT.EntityType '@entityType',
			CT.Attribute '@attribute'
	from DMCmdTarget CT
	where  CT.CommandId = C.CommandId
	FOR XML PATH('users'), TYPE
	),
	(select
		CA.CommandActionId '@aid',
		CA.ActionId '@actionId',
		CA.Attribute '@attribute',
		DG.Name '@actionName',
	 ( select
			CP.ParamGuid '@paramGuid',
			CP.ParamId '@paramid',
			dbo.GetUnixTime(CP.SavedTime) '@savedTime',
			( select CP.ParamValue '@value',
					DF.FieldLabel '@name'
			FOR XML PATH('valueMap'), TYPE
			)
			from DMCmdParams CP
			LEFT JOIN DMSearchCriteriaField DF ON DF.Id = CP.ParamGuid
			Where CP.CommandActionId = CA.CommandActionId AND CA.CommandId = C.CommandId
			ORDER BY DF.FieldDisplayOrder
			FOR XML PATH('paramValues'), TYPE
	 )
	 from DMCmdAction CA
	 INNER JOIN DMSearchCriteriaGroup as DG ON Id = CA.ActionId
	where CA.CommandId = C.CommandId
	FOR XML PATh ('actions'), TYPE
	) ,
	( select
		CR.RunId '@runid',
		CR.RunTime '@runtime',
		CR.jobId '@jobId',
		CR.Status '@status'
		from DMCmdRun CR where CR.CommandId = C.CommandId AND CR.RunTime > @i_modifiedTime
		ORDER BY CR.RunTime desc
		FOR XML PATH ('runs'), TYPE
	)
	from #tblTempCommandOrder T
	INNER JOIN DMCmd C ON T.CommandId = C.CommandId
	ORDER BY T.Id
	FOR XML PATH('cmds'), ROOT('DM2ContentIndexing_DM2CmdInfoList')
	END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @o_errorMessage = ERROR_MESSAGE(), @o_errorCode = ERROR_NUMBER()
	END CATCH
_EXIT:
	IF object_id('tempdb.dbo.#tblTempCommand') is not null
	DROP TABLE #tblTempCommand
	IF object_id('tempdb.dbo.#tblTempCommandOrder') is not null
	DROP TABLE #tblTempCommandOrder
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetCommands')
	delete from GxQscripts where name = 'sp_dm2_GetCommands'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetCommands')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetCommands'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetCommands',  '00010001000200060000', 'sp_dm2_GetCommands', '00010001000200060000')
GO

