

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetCacheFileListToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetCacheFileListToPrune()
--  | Description:  Get top x files from DM2TempCacheFileList table and delete the same from it
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetCacheFileListToPrune.sp,v $ $Id: sp_dm2_GetCacheFileListToPrune.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetCacheFileListToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetCacheFileListToPrune')
	drop procedure sp_dm2_GetCacheFileListToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetCacheFileListToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetCacheFileListToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetCacheFileListToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetCacheFileListToPrune'
GO
print '... Creating Procedure: sp_dm2_GetCacheFileListToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetCacheFileListToPrune
  @i_offset INT,
  @o_totalCount INT OUTPUT,
  @o_outputMessage NVARCHAR(MAX) OUTPUT
AS
BEGIN
	/*
		This SP will fetch top N(@i_offset) from cacheFileList table, and delete the same after retrieving
	*/
	if object_id('tempdb.dbo.#DM2TempCacheFileList') is not null
			DROP TABLE #DM2TempCacheFileList
		create table #DM2TempCacheFileList
		(	id				int ,
			FilePath		NVARCHAR(MAX))
	--if table is not created, return error.
	if (object_id('DM2TempCacheFileList') is null)
	BEGIN
		SELECT @o_totalCount = 0, @o_outputMessage = 'Table DM2TempCacheFileList is not created. '
	END
	ELSE
	BEGIN
		--check @i_offset > 0, else set default 1000
		--
		SELECT @o_totalCount = COUNT(t.id) FROM DM2TempCacheFileList as T
		IF( @o_totalCount > 0)
		BEGIN
			INSERT INTO #DM2TempCacheFileList(id,FilePath)
			SELECT TOP (@i_offset)t.id, t.cachePath 'FilePath' FROM DM2TempCacheFileList as t
			--delete the same
			DELETE FROM DM2TempCacheFileList WHERE id in (SELECT t.id FROM #DM2TempCacheFileList as t)
		END
	END
	SELECT T.FilePath FROM #DM2TempCacheFileList as T
	if object_id('tempdb.dbo.#DM2TempCacheFileList') is not null
			DROP TABLE #DM2TempCacheFileList
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetCacheFileListToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetCacheFileListToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetCacheFileListToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetCacheFileListToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetCacheFileListToPrune',  '00010002000000000000', 'sp_dm2_GetCacheFileListToPrune', '00010002000000000000')
GO

