

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_ContainerItemTagsBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_ContainerItemTagsBulk.sp,v $ $Id: sp_dm2_ContainerItemTagsBulk.sp,v 1.5 2008/08/21 17:31:24 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_ContainerItemTagsBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_ContainerItemTagsBulk')
	drop procedure sp_dm2_ContainerItemTagsBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_ContainerItemTagsBulk')
	delete from GxQscripts where name = 'sp_dm2_ContainerItemTagsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ContainerItemTagsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_ContainerItemTagsBulk'
GO
print '... Creating Procedure: sp_dm2_ContainerItemTagsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_ContainerItemTagsBulk
  @i_ContainerID varchar(36),
  @i_UserID varchar(36),
  @i_SelALLFlag INTEGER,
  @i_DataFilePath varchar(1024),
  @i_Operation INTEGER,
  @i_TagGUIDList XML
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
	/*
	-- @i_Operation = 1 --> ADD Tags
	-- @i_Operation = 2 --> DELETE Tags
	*/
	DECLARE @errorCode integer
	declare @l_delimiter	varchar(256)
	declare @SQL	varchar(2048)
	set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
	IF(len(@l_delimiter ) = 0)
		SET @l_delimiter = 'CV0X12'
	IF object_id('tempdb.dbo.#tmpDMResultSet') is not null
	DROP TABLE #tmpDMResultSet
	IF object_id('tempdb.dbo.#tmpDMTags') is not null
	DROP TABLE #tmpDMTags
	IF object_id('tempdb.dbo.#tmpDMResultSetTags') is not null
	DROP TABLE #tmpDMResultSetTags
	create table #tmpDMResultSet
	(
		[ResultSetID] [char](36) NOT null
	)
	create table #tmpDMTags
	(
		[TagID] [varchar](36) NOT null
	)
	create table #tmpDMResultSetTags
	(
		[ContainerID] [char](36) NOT null,
		[ResultSetID] [char](36) NOT null,
		[UserGUID]		[char](36) NOT null,
		[TagGUID]			[char](36) null
	)
	IF (@i_SelALLFlag = 0)
	BEGIN
		SET @SQL = 'BULK INSERT #tmpDMResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
		exec (@SQL)
	END
	ELSE
	BEGIN
		INSERT INTO #tmpDMResultSet
		SELECT DISTINCT ResultSetID
		FROM DMContainerItem CI
		WHERE CI.ContainerID = @i_ContainerID
		AND		CI.Attribute & 4 = 0
	END
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO #tmpDMTags
	SELECT	DISTINCT T.item.value('@TagGUID', 'VARCHAR(36)')
	FROM		@i_TagGUIDList.nodes('/TagList/TagInfo') T(item)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	IF (@i_Operation = 1) -- ADD Tags
	BEGIN
		-- Update the deleted flag if the entry already exists
		UPDATE DMContainerItemStates
		SET Attribute = Attribute & ~4
		FROM #tmpDMResultSet as tt, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
		WHERE CIS.ContainerId = @i_ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = @i_UserID
		AND		CIS.Attribute & 4 = 4
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Create the new entries
		INSERT INTO DMContainerItemStates
		SELECT @i_ContainerId, tt.ResultSetId, @i_UserID, '', getDate(), @i_UserID, '', 0
		FROM #tmpDMResultSet as tt
		WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemStates AS CIS WITH (READUNCOMMITTED)
											WHERE CIS.ContainerId = @i_ContainerId
											AND 	CIS.ResultSetId = tt.ResultSetId
											AND		CIS.AssignedUserGUID = @i_UserID)
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	INSERT INTO #tmpDMResultSetTags
	SELECT DISTINCT @i_ContainerId, TT.ResultSetId, @i_UserID, TAG.TagID
	FROM #tmpDMResultSet TT, #tmpDMTags TAG
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	CREATE INDEX IDX_tmpDMResultSetTags_CIT ON #tmpDMResultSetTags(ContainerID, ResultSetID, UserGUID, TagGUID)
	IF (@i_Operation = 1) -- ADD Tags
	BEGIN
		-- Update the deleted flag if the entry already exists
		UPDATE DMContainerItemTags
		SET 	Attribute = CIT.Attribute & ~4
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		AND		CIT.Attribute & 4 = 4
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Create the new entries
		INSERT INTO DMContainerItemTags
		SELECT CIS.AssignID, tt.TagGUID, getDate(), @i_UserID, '', 0 -- NOT Synced with FAST
		FROM 	DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND 	NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemTags AS CIT WITH (READUNCOMMITTED)
											WHERE CIS.AssignID = CIT.AssignID
											AND 	CIT.TagID = tt.TagGUID)
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Remove those Tags that are already SYNCed in FAST
		DELETE DMContainerItemTags
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), DMUserItemTags UIT WITH (READUNCOMMITTED)
		WHERE CIS.ResultSetId = UIT.ResultSetId
		AND		CIS.AssignedUserGUID = UIT.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = UIT.TagID
		AND		UIT.Attribute & 2 = 2
		AND		UIT.Attribute & 4 = 0
	END
	ELSE IF (@i_Operation = 2) -- DELETE Tags
	BEGIN
		-- DELETE the tag entries for this Container
		DELETE DMContainerItemTags
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		-- Mark Deleted
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute | 4
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 4 = 0
		-- Update the SYNC TO FAST flag
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute & ~2
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 2 = 2
/*
		-- This table will only contain the DB ONLY tags. Delete them with Remove Tag Request
		-- Update the deleted flag
		UPDATE DMContainerItemTags
		SET 	Attribute = CIT.Attribute | 4
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		AND		CIT.Attribute & 4 = 0
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Update the FAST Sync flag
		UPDATE DMContainerItemTags
		SET 	Attribute = CIT.Attribute & ~2
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		AND		CIT.Attribute & 2 = 2
*/
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	END
CX_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMTags
	DROP TABLE #tmpDMResultSetTags
	SELECT	0
	RETURN
CX_ERROR_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMTags
	DROP TABLE #tmpDMResultSetTags
	SELECT	-1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_ContainerItemTagsBulk')
	delete from GxQscripts where name = 'sp_dm2_ContainerItemTagsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ContainerItemTagsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_ContainerItemTagsBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_ContainerItemTagsBulk',  '00010005000000000000', 'sp_dm2_ContainerItemTagsBulk', '00010005000000000000')
GO

