

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AdminPreferenceOperation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AdminPreferenceOperation.sp,v $ $Id: sp_dm2_AdminPreferenceOperation.sp,v 1.8.272.2 2016/06/04 00:47:52 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AdminPreferenceOperation <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AdminPreferenceOperation')
	drop procedure sp_dm2_AdminPreferenceOperation
IF EXISTS (select * from GxQscripts where name='sp_dm2_AdminPreferenceOperation')
	delete from GxQscripts where name = 'sp_dm2_AdminPreferenceOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AdminPreferenceOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AdminPreferenceOperation'
GO
print '... Creating Procedure: sp_dm2_AdminPreferenceOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AdminPreferenceOperation
  @i_input as nvarchar(max) = ''
AS
SET NOCOUNT ON
IF ( LEN(@i_input) > 0)
BEGIN
	DECLARE 	@viewId			VARCHAR(MAX)
	DECLARE		@userPrefName	VARCHAR(MAX)
	DECLARE		@userPrefValue	VARCHAR(MAX)
	DECLARE		@modifiedBy		VARCHAR(MAX)
	DECLARE		@userGUID		VARCHAR(MAX)
	DECLARE		@UserType		INT
	DECLARE		@x XML
	DECLARE		@isAdminPref	BIT
	SET @x = @i_input
		------------------- Check whether operation is performed by Admin or User --------------
	SET @isAdminPref = ISNULL((SELECT T.a.value('@isAdminPref','BIT')
			FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq') AS T(a) ),1)
		-- ----------- Operation for insert and update --------------
	if ( (SELECT T.a.value('@operationType','INT')
		FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq') AS T(a) ) = 1)
	BEGIN
		--------------------Perform Insert on DMAdminPref table --------------------
		DECLARE adminCursor CURSOR FAST_FORWARD FOR
		SELECT
			T.list.value('@viewId','VARCHAR(MAX)'),
			T.list.value('@userPrefName','VARCHAR(MAX)') ,
			T.list.value('@userPrefValue','VARCHAR(MAX)') ,
			T.list.value('@modifiedBy','VARCHAR(MAX)')
		FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
		WHERE T.list.exist('./userInfoList') <> 1
		OPEN adminCursor
		FETCH NEXT FROM adminCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy
		WHILE @@FETCH_STATUS = 0
		BEGIN
		IF NOT EXISTS(SELECT Id FROM DMAdminPref WHERE ViewName = @viewId and
														PrefName = @userPrefName )
		BEGIN
			INSERT DMAdminPref (ViewName, PrefName,PrefValue,
				CreatedTime,CreatedBy,ModifiedTime,ModifiedBy)
			VALUES	(@viewId,@userPrefName,@userPrefValue,
				GETUTCDATE(),@modifiedBy,GETUTCDATE(),@modifiedBy)
		END
		ELSE
		BEGIN
			UPDATE DMAdminPref	SET
				PrefValue = @userPrefValue,
				ModifiedBy = @modifiedBy,
				ModifiedTime = GETUTCDATE()
			WHERE ViewName = @viewId and
				PrefName = @userPrefName
		END
		FETCH NEXT FROM adminCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy
		END
		CLOSE adminCursor
		DEALLOCATE adminCursor
		---------------------Perform Insert on DMUserPref table (Special Preferences)------------------
		DECLARE userCursor CURSOR FAST_FORWARD FOR
		SELECT
			T.list.value('@viewId','VARCHAR(MAX)') AS viewId,
			T.list.value('@userPrefName','VARCHAR(MAX)') AS userPrefName,
			T.list.value('@userPrefValue','VARCHAR(MAX)') AS userPrefValue,
			T.list.value('@modifiedBy','VARCHAR(MAX)') AS modifiedBy,
			T1.userList.value('@userGuid','VARCHAR(MAX)') AS userGUID,
			T1.userList.value('@entityType', 'VARCHAR(MAX)') as userType
		FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
		cross APPLY
			T.list.nodes('./userInfoList') AS T1(userList)
		OPEN userCursor
		FETCH NEXT FROM userCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy,@userGUID, @userType
		WHILE @@FETCH_STATUS = 0
		BEGIN
		IF NOT EXISTS(SELECT P_Id FROM DMUserPref U WHERE
				U.UserPrefName = @userPrefName AND	U.ViewId = @viewId AND
				U.UserGUID = @userGUID AND U.AdminFlag = @isAdminPref)
		BEGIN
			INSERT DMUserPref (UserPrefName,UserGUID,UserPrefValue,
				CreateTime,ViewId,AdminFlag,ModifiedBy,UserType, Attribute)
			VALUES (@userPrefName,@userGUID,@userPrefValue,
				GETUTCDATE(),@viewId,@isAdminPref,@modifiedBy,@userType, CASE WHEN @userType=0 THEN 1 ELSE 0 END)
		END
		ELSE
		BEGIN
			UPDATE DMUserPref SET
				UserPrefValue = @userPrefValue,
				CreateTime = GETUTCDATE(),
				ModifiedBy = @modifiedBy,
				UserType = @userType,
				Attribute = CASE WHEN @userType=0 THEN 1 ELSE 0 END
			WHERE UserPrefName = @userPrefName AND
				ViewId = @viewId AND
				UserGUID = @userGUID and AdminFlag = @isAdminPref
		END
		FETCH NEXT FROM userCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy,@userGUID,@userType
		END
		CLOSE userCursor
		DEALLOCATE userCursor
	END
		-- ----------- Perform Deletion Operation --------------
	ELSE
	BEGIN
		---------------- DELETE FROM DMAdminPref table ------------------------
		MERGE DMAdminPref AS A
		USING (
			SELECT T.list.value('@viewId','VARCHAR(MAX)'),
				T.list.value('@userPrefName','VARCHAR(MAX)')
			FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
			WHERE T.list.exist('./userInfoList') <> 1 ) AS TMP (ViewID,UserPrefName)
		ON ( A.ViewName = TMP.ViewID AND A.PrefName = TMP.UserPrefName )
		WHEN MATCHED THEN
			DELETE ;
		---------------- DELETE FROM DMUserPref table ------------------------
		MERGE DMUserPref AS U
		USING (
			SELECT	T.list.value('@viewId','VARCHAR(MAX)') AS viewId,
			T.list.value('@userPrefName','VARCHAR(MAX)') AS userPrefName,
			T1.userList.value('@userGuid','VARCHAR(MAX)') AS userGUID
			FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
			cross APPLY
			T.list.nodes('./userInfoList') AS T1(userList)
			) AS TMP (viewID,userPrefName,userGUID)
		ON ( U.UserPrefName = TMP.userPrefName AND U.ViewId = TMP.viewId AND U.UserGUID = TMP.userGUID AND U.AdminFlag = @isAdminPref)
		WHEN MATCHED THEN
			DELETE;
	END
END
IF(@isAdminPref = 1)
BEGIN
	SELECT PrefName,PrefValue,CreatedBy =
			CASE
				WHEN (SELECT TOP 1 UserName FROM DMUserSession WHERE UserGUID=CreatedBy) IS NOT NULL THEN
					(SELECT TOP 1 UserName FROM DMUserSession WHERE UserGUID=CreatedBy)
				ELSE 'N/A'
			END,
		CreatedTime, ModifiedBy =
			CASE
				WHEN (SELECT TOP 1 UserName from DMUserSession WHERE UserGUID=ModifiedBy) IS NOT NULL THEN
					(SELECT TOP 1 UserName from DMUserSession WHERE UserGUID=ModifiedBy)
				ELSE 'N/A'
			END,
		ModifiedTime,
		(SELECT TOP 1 ViewName FROM DMSearchView sv WHERE a.ViewName = sv.Id) AS ViewName
	FROM DMAdminPref a
	WHERE PrefName IN (SELECT DISTINCT FieldLabel FROM DMSearchCriteriaField WHERE GroupId = 9)
END
ELSE
BEGIN
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AdminPreferenceOperation')
	delete from GxQscripts where name = 'sp_dm2_AdminPreferenceOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AdminPreferenceOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AdminPreferenceOperation'
GO

insert into GXDBVersions values(2, 'sp_dm2_AdminPreferenceOperation',  '00010008027200020000', 'sp_dm2_AdminPreferenceOperation', '00010008027200020000')
GO

