

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddUserSession.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddUserSession.sp,v $ $Id: sp_dm2_AddUserSession.sp,v 1.11.2.2 2019/09/13 06:03:05 njudge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_AddUserSession')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_AddUserSession <<<'
	drop procedure sp_dm2_AddUserSession
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddUserSession')
	delete from GxQscripts where name = 'sp_dm2_AddUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserSession'
GO
print '... Creating Procedure: sp_dm2_AddUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddUserSession
  @i_IP varchar(255),
  @i_SessionID char(36),
  @i_UserGUID char(36) output,
  @i_CommCellNumber int,
  @i_UserName nvarchar(256),
  @i_CreateTime datetime,
  @i_Attribute int,
  @i_TimeOutInMin int = 30,
  @i_ConsoleType int = 0,
  @i_siteMode int = 0,
  @i_DeviceId nvarchar(max) = NULL,
  @i_SpecialProperties XML = NULL
AS
BEGIN
SET ANSI_NULLS ON
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @i_errorCode integer
	SELECT @i_DeviceId = (CASE WHEN LEN(ISNULL( @i_DeviceId , '')) = 0 THEN NULL ELSE @i_DeviceId END)
	SELECT @i_SpecialProperties = (CASE WHEN LEN(ISNULL( CONVERT(NVARCHAR(MAX), @i_SpecialProperties) , '')) = 0 THEN NULL ELSE @i_SpecialProperties END)
  if exists (
		select top 1 SessionId from DMUserSession WITH (READUNCOMMITTED)
		where CommCellNumber = @i_CommCellNumber and UserName = @i_UserName and ISNULL(UserGUID, '') <> '' and ISNULL(@i_UserGUID, '') = ''
	)
	BEGIN
		set @i_UserGUID = (select top 1 UserGUID from DMUserSession
			WITH (READUNCOMMITTED) where CommCellNumber = @i_CommCellNumber and UserName = @i_UserName and ISNULL(UserGUID, '') <> ''
		)
	END
	--In case of Service Commcell timeout due to inactivity, the same session Id that had expired can be reused from the Router commcell.Deleting the existing entry so that the below insert
	--statements don't throw exception.Deleting instead of preventing a reinsert because this operation should be treated as a new login into commcell.
	Delete from DMUserSession where SessionID = @i_SessionID and UserGUID = @i_UserGUID
  insert into DMUserSession (IP,SessionID,UserGUID,CommCellNumber,UserName,CreateTime,Attribute,LastAccessTime,TimeOutInMin,ConsoleType)
  values (@i_IP, @i_SessionID, @i_UserGUID, @i_CommCellNumber, @i_UserName, @i_CreateTime,@i_Attribute,@i_CreateTime,@i_TimeOutInMin,@i_ConsoleType)
SELECT @i_errorCode = @@Error
if @i_errorCode = 0
BEGIN
	INSERT INTO DMUserSessionDetail(SessionID, SiteMode, DeviceID, SpecialProperties)
	VALUES( @i_SessionID, @i_siteMode, @i_DeviceId, @i_SpecialProperties )
END
SELECT @i_errorCode = @@Error
SELECT @i_errorCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddUserSession')
	delete from GxQscripts where name = 'sp_dm2_AddUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddUserSession',  '00010011000200020000', 'sp_dm2_AddUserSession', '00010011000200020000')
GO

