

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSetBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSetBulk.sp,v $ $Id: sp_dm2_AddResultSetBulk.sp,v 1.48.12.25 2019/09/19 02:01:05 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_AddResultSetBulk')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_AddResultSetBulk <<<'
	drop procedure sp_dm2_AddResultSetBulk
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSetBulk'
GO
print '... Creating Procedure: sp_dm2_AddResultSetBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddResultSetBulk
  @i_DataFilePath varchar(1024),
  @i_ContainerID varchar(36),
  @i_QueryID varchar(36),
  @i_isCompliancePolicy integer,
  @i_UserGUID varchar(36)
AS
  DECLARE @o_errorCode integer;
DECLARE @Legal_Restored_Item integer = 16
SET NOCOUNT ON
		--
		-- This table will be used in place of output parameters
		-- only one row will be returned as a second table output from this SP
		-- The other (first) data table returned by this SP has following columns: ResultSetId varchar(36), ResultSet nvarchar(max)
		--
		DECLARE @TblOutParams TABLE (
			RowsInserted INT,
			OutputMessage NVARCHAR(MAX),
			MessageLogLevel INT)
		--
		-- This table is used to capture items that are dropped and skipped inserting to DMResultSet due to the fact they are duplicates
		-- Also collect all over-writes of CommCellNumber, AFileId, AFileOffset (this can happen more often depending upon number of duplicate
		-- items with respect to IndexGUID (turboguid) in the system and when those items come for add to RS or export as part of different jobs
		-- at different times
		--
		IF OBJECT_ID('tempdb.dbo.#IndexGuidDuplicateItemsMap') IS NOT NULL     DROP TABLE #IndexGuidDuplicateItemsMap
		create table #IndexGuidDuplicateItemsMap(
			aFileID					bigint not null,
			aFileOffset				bigint not null,
			CommCellNumber   		int not null,
			OriginalFullPath 		nvarchar(4000) null,
			IndexGUID				varchar(128) null,
			documentId				varchar(256) null,
			SyncStatus				int not null default 4,
			idxAFileId				bigint null,
			idxAFileOffset			bigint null,
			idxCommCellNumber		int null,
			ResultSetID				char(36) null,
			JobId					int null,
			AppType					int null,
            ModifiedTime            datetime null default 0,
			ClientID				int null
		)
		DECLARE @LOG_ERROR INT =  1
		DECLARE @LOG_INFO INT =  2
		DECLARE @LOG_TRACING INT =  3
		DECLARE @LOG_DETAILS INT = 4
		DECLARE @AtLeastOneError BIT = 0
		DECLARE @AtLeastOneInfo BIT = 0
		DECLARE @AtLeastOneTracing BIT = 0
		DECLARE @inputRowCount INTEGER
		DECLARE @uniqueInputRowCount INTEGER
		DECLARE @rowCount INTEGER
		DECLARE @errorCode	INTEGER
		SET		@errorCode	= 0
		declare @l_delimiter	varchar(256)
		declare @SQL	varchar(2048)
		DECLARE @distinctAFOFCount INT = 0
		DECLARE @o_RowsInserted integer = 0
		DECLARE @o_OutputMessage nvarchar(max) = ''
		DECLARE @o_MessageLogLevel INT = 4
		DECLARE @Mark_Email_Restore_To_Xml  INTEGER = 1024
		SELECT	@o_OutputMessage = '', @o_MessageLogLevel = 4 --LogLevel.LOG_DETAILS
		--
		INSERT INTO @TblOutParams (RowsInserted, OutputMessage, MessageLogLevel)
		SELECT @o_RowsInserted as RowsInserted, @o_OutputMessage as OutputMessage, @o_MessageLogLevel as MessageLogLevel
		--
		set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
		IF(len(@l_delimiter ) = 0)
			SET @l_delimiter = 'CV0X12'
		IF OBJECT_ID('tempdb.dbo.#tmpBulkResultSet') IS NULL
		BEGIN
create table #tmpBulkResultSet
(
	[ResultSetID] [char](36) NOT null,
	[CommCellNumber] [int] NOT null,
	[aFileID] [bigint] NOT null,
	[aFileOffset] [bigint] NOT null,
	[aFileLength] [bigint] NOT null,
	[AppType] [int] NOT null,
	[FileSizeKB] [float] NOT null,
	[ModifiedTime] [datetime] NOT null,
	[JobId] [int] NOT null,
	[ResultSet] [nvarchar](max) NOT null,
	[OriginalFullPath] [nvarchar](max) null,
	[documentId] [varchar](256) null,
	[ClientID] [int] NOT null,
	[tagGUIDList][varchar](max) null,
	[OwnerField]		[nvarchar](max) null,
	[FromField]		 	[nvarchar](max) null,
	[FolderPath]	 	[nvarchar](max) null,
	[IndexGUID]			[VARCHAR](128) null,
	[Title]				[nvarchar](1024) null,
	[IsStub]		NVARCHAR(10) null,
	[AppId]			[int] NOT NULL,
	[Attribute]     [int] NOT NULL,
	[EmailFrom]		[nvarchar](max) null,
	[EmailTo]		[nvarchar](max) null,
	[EmailCc]		[nvarchar](max) null,
	[EmailBcc]		[nvarchar](max) null,
    [ItemType]      [int] null
)
		END
		create table #tmpDMResultSet
		(
			[ResultSetID] [char](36) NOT null,
			[CommCellNumber] [int] NOT null,
			[aFileID] [bigint] NOT null,
			[aFileOffset] [bigint] NOT null,
			[aFileLength] [bigint],
			[AppType] [int],
			[FileSizeKB] [float],
			[ModifiedTime] [datetime],
			[JobId] [int],
			[ResultSet] [nvarchar](max),
			[OriginalFullPath] [nvarchar](max),
			[documentId] [varchar](256),
			[ClientID] [int],
			[tagGUIDList][varchar](max),
			[OwnerField]		[nvarchar](max) null,
			[FromField]		 	[nvarchar](max) null,
			[FolderPath]	 	[nvarchar](max) null,
			[IndexGUID]			[VARCHAR](128) null,
			[Title]				[nvarchar](1024) null,
			isExistsInDMResultSet	bit default 0,
			idInDMResultSetInfo	INT default 0,
			isStubFlag						bit,
			[AppId]	[int],
			[Attribute] [int], -- defined in EDMResultSetAttribute
			[EmailFrom]		[nvarchar](max) null,
			[EmailTo]		[nvarchar](max) null,
			[EmailCc]		[nvarchar](max) null,
			[EmailBcc]		[nvarchar](max) null,
			IsExistsInEmailResultSet bit default 0,
			IsEmailResultDataFound  bit default 0,
            ItemType        int default 0
		)
		CREATE INDEX tmpDMResultSet_idx_1 ON #tmpDMResultSet(ResultSetId);
		CREATE INDEX tmpDMResultSet_idx_2 ON #tmpDMResultSet(IndexGUID);
		CREATE INDEX tmpDMResultSet_idx_3 ON #tmpDMResultSet(isExistsInDMResultSet);
		-- Primary key is no more enforced on table #tmpDMResultSet and rather for speed lookup, we are having index on CommCellNumber, aFileId, aFileOffset
		CREATE INDEX tmpDMResultSet_idx_4 ON #tmpDMResultSet(CommCellNumber, aFileId, aFileOffset);
		create table #tmpDMUserItemTags
		(
			[ResultSetID] [char](36) NOT null,
			[UserGUID]		[char](36) NOT null,
			[TagGUID]			[char](36) null
		)
		create table #tmpDistinctRS(ResultSetId	[char](36) NOT null, isDMContainerItemExists BIT default 0)
		IF ISNULL(@i_DataFilePath, '') <> ''
		BEGIN
			SET @SQL = 'BULK INSERT #tmpBulkResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
			exec (@SQL)
			SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		END
		ELSE
		BEGIN
		        SELECT @rowCount = COUNT(*) FROM #tmpBulkResultSet
		END
		SELECT @inputRowCount = @rowCount
		IF @rowCount > 0
		BEGIN
			SELECT @o_OutputMessage = 'Number of input items: [' + convert(varchar, @rowCount) + ']. '
			SELECT @AtLeastOneTracing = 1
		END
		ELSE
		BEGIN
			SELECT @o_OutputMessage = 'No items found in input.'
			SELECT @AtLeastOneError = 1
		END
        UPDATE #tmpBulkResultSet
            -- Item Type
            -- 0 Backed up
            -- 1 online
            -- 2 Live
            -- 3 Virtual Server
        SET ItemType =
        CASE
WHEN AppType = 200 OR ( AppType = 134 AND aFileID <= 0 ) THEN 1
WHEN AppType = 201 THEN 2
WHEN AppType = 106 THEN 3
            ELSE 0
        END
		IF	@errorCode != 0 GOTO CX_EXIT
		--
		-- There won't be any valid GUIDs for 137 app-type, so even if input has it, it must be copy of ContentId/DocumentId value which we don't want to use it
		-- Exception: When restoring data as xml, the GUIDs are fabricated and are reliable - Sreekanth, Ahn.
		-- Fix for TR 190129-527
UPDATE #tmpBulkResultSet SET IndexGUID = NULL WHERE AppType = 137 -- 137
		AND ISNULL(Attribute, 0) <> @Mark_Email_Restore_To_Xml
		--
		--
		INSERT INTO #tmpDMResultSet (ResultSetID, CommCellNumber, aFileID, aFileOffset, aFileLength, JobId, OriginalFullPath, ModifiedTime, ClientID, ItemType)
		SELECT DISTINCT '', CommCellNumber, aFileId, aFileOffset, null, 0, null, null, 0, ItemType
		FROM #tmpBulkResultSet WHERE ItemType = 0
        UNION
		SELECT DISTINCT '', CommCellNumber, aFileId, aFileOffset, null, 0, OriginalFullPath, null, ISNULL(ClientID, 0), ItemType
		FROM #tmpBulkResultSet WHERE ItemType in (1, 2)
        UNION
		SELECT '', CommCellNumber, aFileID, aFileOffset, aFileOffset, JobId, OriginalFullPath, ModifiedTime, 0, ItemType
		FROM #tmpBulkResultSet WHERE ItemType = 3
        SELECT @distinctAFOFCount = @@ROWCOUNT,	@errorCode = @@ERROR
		--
		IF @inputRowCount <> @distinctAFOFCount
		BEGIN
			SET @AtLeastOneError = 1
			SELECT @o_OutputMessage += 'Ignored [' +
				CONVERT(VARCHAR, (@inputRowCount - @distinctAFOFCount)) +
				'] item(s) (duplicate with respect to CCN/AFileId/AFileOfffset) from the input. '
		END
		IF @errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpDMResultSet
		SET ResultSetId  = B.ResultSetId,
			aFileLength = B.aFileLength,
			AppType = B.AppType,
			FileSizeKB = B.FileSizeKB,
			ModifiedTime = B.ModifiedTime,
			JobId = B.JobId,
			ResultSet = B.ResultSet,
			OriginalFullPath = B.OriginalFullPath,
			documentId = B.documentId,
			ClientID = B.ClientID,
			tagGUIDList = B.tagGUIDList,
			OwnerField = B.OwnerField,
			FromField = B.FromField,
			FolderPath = B.FolderPath,
			IndexGUID = B.IndexGUID,
			Title = B.Title,
			isStubFlag = CASE WHEN ISNULL(B.IsStub, '') = 'True' THEN 1 ELSE 0 end,
			AppId = B.AppId,
			Attribute = B.Attribute,
			EmailFrom = B.EmailFrom,
			EmailTo = B.EmailTo,
			EmailCc = B.EmailCc,
			EmailBcc = B.EmailBcc
		FROM #tmpDMResultSet A, #tmpBulkResultSet B
		WHERE A.CommCellNumber = B.CommCellNumber
		AND A.aFileId = B.aFileId
		AND A.aFileOffset = B.aFileOffSet
		AND B.ItemType = 0 -- Only for backed up data
		--
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpDMResultSet
		SET ResultSetId  = B.ResultSetId,
			aFileLength = B.aFileLength,
			AppType = B.AppType,
			FileSizeKB = B.FileSizeKB,
			ModifiedTime = B.ModifiedTime,
			ResultSet = B.ResultSet,
			documentId = B.documentId,
			ClientID = B.ClientID,
			tagGUIDList = B.tagGUIDList,
			OwnerField = B.OwnerField,
			FromField = B.FromField,
			FolderPath = B.FolderPath,
			IndexGUID = B.IndexGUID,
			Title = B.Title,
			isStubFlag = CASE WHEN ISNULL(B.IsStub, '') = 'True' THEN 1 ELSE 0 end,
			AppId = B.AppId,
			Attribute = B.Attribute,
			EmailFrom = B.EmailFrom,
			EmailTo = B.EmailTo,
			EmailCc = B.EmailCc,
			EmailBcc = B.EmailBcc
		FROM #tmpDMResultSet A, #tmpBulkResultSet B
		WHERE A.CommCellNumber = B.CommCellNumber
		AND A.JobId = B.JobId
		AND A.OriginalFullPath = B.OriginalFullPath
        AND A.ModifiedTime = B.ModifiedTime
		AND B.ItemType = 3 -- VSA
	UPDATE #tmpDMResultSet
	SET ResultSetId  = B.ResultSetId,
		aFileID = B.aFileID,
		aFileOffset = B.aFileOffset,
		aFileLength = B.aFileLength,
		AppType = B.AppType,
		FileSizeKB = B.FileSizeKB,
		ModifiedTime = B.ModifiedTime,
		JobId = B.JobId,
		ResultSet = B.ResultSet,
		OriginalFullPath = B.OriginalFullPath,
		documentId = B.documentId,
		ClientID = B.ClientID,
		tagGUIDList = B.tagGUIDList,
		OwnerField = B.OwnerField,
		FromField = B.FromField,
		FolderPath = B.FolderPath,
		IndexGUID = B.IndexGUID,
		Title = B.Title,
		isStubFlag = CASE WHEN ISNULL(B.IsStub, '') = 'True' THEN 1 ELSE 0 end,
		AppId = B.AppId,
		Attribute = B.Attribute,
		EmailFrom = B.EmailFrom,
		EmailTo = B.EmailTo,
		EmailCc = B.EmailCc,
		EmailBcc = B.EmailBcc
	FROM #tmpDMResultSet A, #tmpBulkResultSet B
	WHERE A.OriginalFullPath = B.OriginalFullPath
	AND (B.ItemType = 1 OR (B.ItemType = 2 AND A.ClientID = B.ClientID)) -- Online OR Live with clientId
		--
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Also we want suppress duplicates w.r.t IndexGUID (turboguid) from 11.0
		;WITH CTE AS (
			SELECT ROW_NUMBER() OVER (PARTITION BY IndexGUID ORDER BY aFileID DESC) PT
			FROM #tmpDMResultSet
			WHERE ISNULL(IndexGUID, '')  <> ''
		)
		DELETE FROM CTE
		WHERE PT > 1
		SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		IF @rowCount > 0
		BEGIN
			-- what-ever duplicate items found and dropped while saving data to DMResultSet, collect them here..
			INSERT INTO #IndexGuidDuplicateItemsMap(aFileID, aFileOffset, CommCellNumber, IndexGUID, SyncStatus, documentId, OriginalFullPath, AppType, JobId, ModifiedTime)
			SELECT a.aFileID, a.aFileOffset, a.CommCellNumber, a.IndexGUID, 4 as SyncStatus, a.documentId, a.OriginalFullPath, A.AppType, A.JobId, A.ModifiedTime
			FROM #tmpBulkResultSet A
			LEFT JOIN #tmpDMResultSet T ON A.aFileID = T.aFileID AND A.aFileOffset = T.aFileOffset AND A.CommCellNumber = T.CommCellNumber
			WHERE T.ResultSetID IS NULL
			--
			-- Out of duplicates, we would have considered one item as original and left it in DMResultSet. Prepare mapping of such dropped items to the original item here
			-- Make sure we update input table exactly the way we have updated #tmpDMResultSet based on main (DMResultSet) table
			-- First, non VSA items having GUID, we map using GUID..
			UPDATE t
			SET t.idxAFileId = s.aFileID, t.idxaFileOffset = s.aFileOffset, t.idxCommCellNumber = s.CommCellNumber, t.ResultSetID = s.ResultSetID
			FROM #IndexGuidDuplicateItemsMap t
			JOIN #tmpDMResultSet S ON t.IndexGUID = s.IndexGUID
			WHERE ISNULL(T.IndexGUID, '') <> '' AND S.ItemType = 0 -- Backed Up
			-- Next map VSA data using JobId, CommCellNumber and Path..
			UPDATE a
			SET a.ResultSetID = b.ResultSetID
			FROM #IndexGuidDuplicateItemsMap A
			JOIN #tmpDMResultSet B ON a.JobId = B.JobId AND A.CommCellNumber = B.CommCellNumber AND A.OriginalFullPath = B.OriginalFullPath AND A.ModifiedTime = B.ModifiedTime
			WHERE B.ItemType = 3 -- VSA
			UPDATE a
			SET a.ResultSetID = b.ResultSetID
			FROM #IndexGuidDuplicateItemsMap A
			JOIN #tmpDMResultSet B ON A.OriginalFullPath = B.OriginalFullPath
			WHERE B.ItemType = 1 -- Online
				OR (B.ItemType = 2 AND A.ClientID = B.ClientID )  -- Live
			-- Rest of the data map using regular ccn,afid,afof..
			UPDATE t
			SET ResultSetID = s.ResultSetID
			FROM #IndexGuidDuplicateItemsMap t
			JOIN #tmpDMResultSet S ON t.aFileID = S.aFileID AND t.aFileOffset = S.aFileOffset AND t.CommCellNumber = S.CommCellNumber
			WHERE t.ResultSetID IS NULL AND S.ItemType = 0 -- Backed up
			SELECT @o_OutputMessage += 'Ignored [' + convert(varchar, @rowCount) + '] item(s) (duplicate with respect to turboguid) from the input. '
			SET @AtLeastOneError = 1
		END
		IF @errorCode != 0 GOTO CX_EXIT
		--
		---new change to hold lock during dmresultset insert
		--
		DECLARE @result INT
		DECLARE @outResult INT
		DECLARE @errMsg NVARCHAR(MAX)
		BEGIN TRY
		BEGIN TRAN
			--Add lock so that we dont insert duplicate entries in DMResultSet table (when parallel execution happens)
			 EXEC @result = sp_getapplock @Resource = 'sp_dm2_AddResultSetBulk', @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @result < 0
			BEGIN
                SET @errMsg = CASE @result
										when -1 then 'Explicit Raise Error: Applock request timed out.'
										when -2 then 'Applock request canceled.'
										when -3 then 'Explicit Raise Error: Applock involved in deadlock'
										else 'Parameter validation or other call error.'
									end
                RAISERROR (@errMsg,16,1)
				set @errorCode = 1001 -- validation error
				GOTO CX_EXIT
			END
			--
			--declare currentdate
			--
			DECLARE @currentdate DATETIME = GETDATE()
			--
			-- When data is Restored from legal hold, due to old bug of pushing wrong (source item's) turboguid to review set core
			-- first check if we can match item based on ccn, afileid, afileoffset and attribute = 16 (Legal_Restored_Item)
			-- This change is made to give preference to item in legal hold which is very unlikely to get dropped/aged compared to
			-- it's corresponding original source item in search engine or review set.
			-- Also its possible rows have duplicates because of wrong updates by means of turboguid, so in order to pick correct row,
			-- do this first.
			-- Fix for TR 190129-527
			--
			UPDATE tt
			SET ResultSetId = RS.ResultSetId, tt.isExistsInDMResultSet = 1
			FROM #tmpDMResultSet as tt, DMResultSet as RS WITH (READUNCOMMITTED)
			WHERE tt.aFileID > 0 AND tt.CommCellNumber = RS.CommCellNumber
								AND tt.aFileId = RS.aFileId
								AND tt.aFileOffset = RS.aFileOffSet
								AND RS.Attribute = @Legal_Restored_Item
			AND tt.ItemType = 0 -- backed Up
			SET	@errorCode	=	@@ERROR
			--
			--Get the resultSetId based on indexguid/turboguid next
			--
			IF @errorCode = 0
			BEGIN
				UPDATE tt
				SET ResultSetId = RS.ResultSetId, tt.isExistsInDMResultSet = 1
				FROM #tmpDMResultSet as tt, DMResultSet as RS WITH (READUNCOMMITTED)
				WHERE tt.isExistsInDMResultSet = 0 AND ISNULL(tt.IndexGUID, '') <> '' and tt.IndexGUID = RS.IndexGUID
				SET	@errorCode	=	@@ERROR
			END
			--
			-- Get the resultSetId based on ccn,filepath,apptype (for data from virtual server agent or any other agents who don't have fileid)
			--
			IF @errorCode = 0
			BEGIN
				UPDATE tt
				SET ResultSetId = RS.ResultSetId, isExistsInDMResultSet = 1
				FROM #tmpDMResultSet as tt, DMResultSet as RS WITH (READUNCOMMITTED)
				where tt.isExistsInDMResultSet = 0 AND tt.CommCellNumber = RS.CommCellNumber
									AND tt.OriginalFullPath = RS.OriginalFullPath
									AND tt.AppType = RS.AppType
                                    AND tt.ModifiedTime = RS.ModifiedTime
									AND tt.ItemType = 3 -- VSA
				SET	@errorCode	=	@@ERROR
				--IF	@errorCode != 0 GOTO CX_EXIT
			END
			--
			-- Get the resultSetId based on ccn,filepath,apptype (for data from virtual server agent or any other agents who don't have fileid)
			--
			IF @errorCode = 0
			BEGIN
				UPDATE tt
				SET ResultSetId = RS.ResultSetId, isExistsInDMResultSet = 1
				FROM #tmpDMResultSet as tt, DMResultSet as RS WITH (READUNCOMMITTED)
				where tt.isExistsInDMResultSet = 0 AND tt.CommCellNumber = RS.CommCellNumber
						AND tt.OriginalFullPath = RS.OriginalFullPath
						AND tt.AppType = RS.AppType
						AND (tt.ItemType = 1 OR (tt.ItemType = 2 AND tt.ClientID = RS.ClientID)) -- online or live with client id
				SET	@errorCode	=	@@ERROR
				--IF	@errorCode != 0 GOTO CX_EXIT
			END
			--
			-- Get the resultSetId based on ccn,afid,afof (backward compatibility for data from older agents or any other agents who don't generate turboguid)
			--
			IF @errorCode = 0
			BEGIN
				UPDATE tt
				SET ResultSetId = RS.ResultSetId, tt.isExistsInDMResultSet = 1
				FROM #tmpDMResultSet as tt, DMResultSet as RS WITH (READUNCOMMITTED)
				where tt.isExistsInDMResultSet = 0 AND tt.aFileID > 0
									AND tt.CommCellNumber = RS.CommCellNumber
									AND tt.aFileId = RS.aFileId
									AND tt.aFileOffset = RS.aFileOffSet
									AND tt.Attribute <> @Mark_Email_Restore_To_Xml
									AND RS.Attribute <> @Mark_Email_Restore_To_Xml -- - Adding code tt.Attribute <> @Mark_Email_Restore_To_Xml and RS.Attribute <> @Mark_Email_Restore_To_Xml so that restore to xml items can be differentiated with restore to any other format when a same email is restored with different format options
									AND tt.ItemType = 0 -- backed up
				SET	@errorCode	=	@@ERROR
				--IF	@errorCode != 0 GOTO CX_EXIT
			END
			IF @errorCode = 0
			BEGIN
				-- Fix for MR 130907
				-- we can allow duplicates to enter table during updation and afterwards delete / clean duplicate combination of CommCellNumber, aFileId, aFileOffset
				;WITH CTE AS (
						SELECT ROW_NUMBER() OVER (PARTITION BY CommCellNumber, aFileId, aFileOffset ORDER BY aFileID DESC) PT
						FROM #tmpDMResultSet
						WHERE aFileID > 0
						AND ItemType = 0 -- backed up
					)
				DELETE FROM CTE
				WHERE PT > 1
				SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
				IF @rowCount > 0
				BEGIN
					SELECT @o_OutputMessage += 'Ignored [' + convert(varchar, @rowCount) + '] item(s) (duplicate with respect to commcellnumber,afileid,afileoffset) from the input. '
					SET @AtLeastOneError = 1
				END
				--IF @errorCode != 0 GOTO CX_EXIT
			END
			IF @errorCode = 0
			BEGIN
				-- Fix for MR 130907
				-- we can allow duplicates to enter table during updation and afterwards delete / clean duplicate combination of CommCellNumber, aFileId, aFileOffset
				;WITH CTE AS (
						SELECT ROW_NUMBER() OVER (PARTITION BY CommCellNumber, aFileId, aFileOffset, OriginalFullPath ORDER BY OriginalFullPath DESC) PT
						FROM #tmpDMResultSet
						WHERE aFileID > 0
						AND ItemType = 3 -- VSA
					)
				DELETE FROM CTE
				WHERE PT > 1
				SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
				IF @rowCount > 0
				BEGIN
					SELECT @o_OutputMessage += 'Ignored [' + convert(varchar, @rowCount) + '] item(s) (duplicate with respect to commcellnumber,afileid,afileoffset) from the input. '
					SET @AtLeastOneError = 1
				END
				--IF @errorCode != 0 GOTO CX_EXIT
			END
			IF @errorCode = 0
			BEGIN
				SELECT @uniqueInputRowCount = COUNT(*) FROM #tmpDMResultSet
				-- If meta-data SP gave ResultSetId which is further sent back by client to DB indicating the item already exist, instead of raising assertion error,
				-- we will rather believe it is correct and update incoming values to DMResultSet by setting isExistsInDMResultSet = 1 in temp table #tmpDMResultSet
				-- for such items.
				IF EXISTS (SELECT * FROM #tmpDMResultSet WHERE isExistsInDMResultSet = 0 AND ResultSetID in (SELECT ResultSetID FROM DMResultSet EX WITH (READUNCOMMITTED)))
				BEGIN
					UPDATE T
					SET T.isExistsInDMResultSet = 1
					FROM #tmpDMResultSet T
					JOIN DMResultSet R WITH(NOLOCK) ON T.ResultSetId = R.ResultSetId AND T.isExistsInDMResultSet = 0
				END
			END
			--
			-- Insert only those rows that are needed to DMResultSet..
			--
			IF @errorCode = 0
			BEGIN
				INSERT INTO DMResultSet
					(ResultSetID,CommCellNumber,aFileID,aFileOffset,aFileLength,
					AppType,FileSizeKB,ModifiedTime,JobId,OriginalFullPath,
					DestinationPath,CreateTime,RestoreUserGUID,RestoreCommCellNumber,RestoreJobID,
					RestoreStatus,RestoreTime,Attribute,
					documentID,ClientID,ERMStatus,
					IndexGUID,Title,AppId,OwnerField,FolderPath,FromField)
				select
					tt.ResultSetID, tt.CommCellNumber, tt.aFileID, tt.aFileOffset, tt.aFileLength,
					tt.AppType, tt.FileSizeKB, tt.ModifiedTime, tt.JobId, ISNULL(tt.OriginalFullPath, ''),
					'', @currentdate, '', 0, 0,
					0, @currentdate, tt.Attribute,
					ISNULL(tt.documentId, ''), tt.ClientID, dbo.evaluateResultAttribute(0, isStubFlag),
					tt.IndexGUID,tt.Title, tt.AppId, tt.OwnerField, tt.FolderPath, tt.FromField
				from #tmpDMResultSet as tt
				where tt.isExistsInDMResultSet <> 1
				SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
			END
		--this releases the applock too
		IF @errorCode = 0
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        --IF @result IN (0, 1)
        --BEGIN
         --    EXEC @result = sp_releaseapplock	@Resource = 'sp_dm2_AddResultSetBulk'
        --END
		if @@TRANCOUNT > 0
			ROLLBACK TRANSACTION
        SELECT @errMsg = ERROR_MESSAGE(),@errorCode = ERROR_NUMBER()
        RAISERROR(@errMsg, 15, 50)
    END CATCH
		IF	@errorCode != 0 GOTO CX_EXIT
		SELECT @o_OutputMessage += 'Inserted [' + convert(varchar, @rowCount) + '] item(s) into DMResultSet. '
		IF @rowCount > 0
		BEGIN
			if @rowCount = @inputRowCount
				SET @AtLeastOneTracing = 1
			else
				SET @AtLeastOneInfo = 1
		END
		ELSE IF EXISTS (SELECT TOP 1 * FROM #tmpDMResultSet WHERE isExistsInDMResultSet <> 1)
		BEGIN
			SELECT @AtLeastOneError = 1	--Something in input to be inserted but we could not insert them
		END
		IF	@errorCode != 0 GOTO CX_EXIT
		--
		BEGIN TRY
			BEGIN TRAN
			--
			-- If at-least one email prop value found, then only we need to insert
			--
			UPDATE #tmpDMResultSet
			SET IsEmailResultDataFound = CASE WHEN ISNULL(EmailFrom, '') <> '' OR
				ISNULL(EmailTo, '') <> '' OR
				ISNULL(EmailCc, '') <> '' OR
				ISNULL(EmailBcc, '') <> '' THEN 1 ELSE 0
				END
			--
			--Add lock so that we dont attempt insert duplicate entries in DMEmailResult table (when parallel threads execution happen)
			--which eliminate chances of primary key violation exception
			EXEC @result = sp_getapplock @Resource = 'DMEmailResult', @LockMode = 'Exclusive', @LockTimeout = 60000
			--
			-- After all checks done for DMResultSet, now do presence check of DMEmailResult of only those
			-- records which have at-least some email property set
			--
			UPDATE T
			SET T.IsExistsInEmailResultSet = 1
			FROM #tmpDMResultSet T
			JOIN DMEmailResult R WITH(NOLOCK) ON T.ResultSetID = R.ResultSetID
			WHERE T.IsEmailResultDataFound = 1
			--
			INSERT INTO DMEmailResult (ResultSetID, EmailFROM, EmailTO, EmailCC, EmailBCC, EmailSubject, SavedTime)
			SELECT T.ResultSetID, ISNULL(T.EmailFrom, ''), ISNULL(T.EmailTo, ''), ISNULL(T.EmailCc, ''), ISNULL(T.EmailBcc, ''), ISNULL(T.Title, ''), GETUTCDATE()
			FROM #tmpDMResultSet T
			WHERE T.IsEmailResultDataFound = 1 AND T.IsExistsInEmailResultSet = 0
			SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
			--
			-- if error it will go to catch block and then we rollback
			-- this commit releases the applock too
			--
				COMMIT TRANSACTION
		END TRY
		BEGIN CATCH
			if @@TRANCOUNT > 0
			BEGIN
				ROLLBACK TRANSACTION
			END
			SELECT @errMsg = ERROR_MESSAGE(),@errorCode = ERROR_NUMBER()
			RAISERROR(@errMsg, 15, 50)
		END CATCH
		--
		-- Update DMEmailResult to fix in case if any half baked search response was recorded in DB in older attempts
		-- We may not really need this. But if we had indexing bug for any of these fields then subsequent update of any of these
		-- meta-data in index would require DB to be updated. Might be useful in future, keeping it commented as of now.
		--
		/*UPDATE RE
		SET RE.EmailFROM = CASE WHEN ISNULL(T.EmailFrom, '') <> '' THEN T.EmailFrom ELSE RE.EmailFROM END,
		RE.EmailTO = CASE WHEN ISNULL(T.EmailTO, '') <> '' THEN T.EmailTO ELSE RE.EmailTO END,
		RE.EmailCC = CASE WHEN ISNULL(T.EmailCC, '') <> '' THEN T.EmailCC ELSE RE.EmailCC END,
		RE.EmailBCC = CASE WHEN ISNULL(T.EmailBCC, '') <> '' THEN T.EmailBCC ELSE RE.EmailBCC END
		FROM DMEmailResult RE
		JOIN #tmpDMResultSet T ON T.ResultSetID = RE.ResultSetID
		SET @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO CX_EXIT
		*/
		--
		-- UPDATE DMResultSet table here
		UPDATE RS
		SET
		 --Update attribute as appropriate
			Attribute = dbo.EvaluateResultAttribute(RS.Attribute, tt.isStubFlag),
		--Update the documentId
			documentId = CASE WHEN (RS.documentId = '') THEN
							ISNULL(tt.documentId, '')
							ELSE RS.documentId END,
		--Update the ClientID
			ClientID = CASE WHEN (RS.ClientID = 0) THEN
							tt.ClientID
							ELSE RS.ClientID END,
		--Update the Size
			FileSizeKB =  tt.FileSizeKB,
		--Update TURBO/INDEX GUID if earlier it is null or empty in DB
		--Always force update IndexGUID in DMResultSet irrespective of an existing value present or not in this column for live/online data - Fix MR 232200
			IndexGUID = CASE WHEN ISNULL(RS.IndexGUID, '') = '' OR (tt.ItemType = 1 OR tt.ItemType = 2) THEN
						tt.IndexGUID
						ELSE RS.IndexGUID END,
		--Update modifiedtime if earlier it is null or empty in DB
			ModifiedTime = CASE WHEN (ISNULL(RS.ModifiedTime, '') = '' OR  RS.ModifiedTime = '1970-01-01 00:00:00.000') THEN
						tt.ModifiedTime
						ELSE RS.ModifiedTime END,
		--If we are updating XML blob, it is better we update flat table (Title) also, other-wise it will cause data disintegrated.
			Title = tt.Title,
			aFileID = tt.aFileID,
			aFileOffset = tt.aFileOffset,
			OriginalFullPath = ISNULL((CASE WHEN ISNULL(RS.OriginalFullPath, '') = '' THEN tt.OriginalFullPath ELSE RS.OriginalFullPath END), ''),
			FolderPath = CASE WHEN ISNULL(RS.FolderPath, '') = '' THEN tt.FolderPath ELSE RS.FolderPath END,
			OwnerField = CASE WHEN ISNULL(RS.OwnerField, '') = '' THEN tt.OwnerField ELSE RS.OwnerField END,
			AppType = CASE WHEN RS.AppType = 0 THEN tt.AppType ELSE RS.AppType END,
			FromField = CASE WHEN ISNULL(RS.FromField, '') = '' THEN tt.FromField ELSE RS.FromField END
		OUTPUT deleted.aFileId, deleted.aFileOffset, deleted.CommCellNumber, inserted.OriginalFullPath, inserted.IndexGUID, inserted.documentID,
		5 SyncStatus, inserted.aFileID idxAFileId, inserted.aFileOffset idxaFileOffset, inserted.CommCellNumber idxCommCellNumber,
		inserted.ResultSetID, 0 JobId, 0 AppType, inserted.ModifiedTime, null as ClientId into #IndexGuidDuplicateItemsMap
		FROM DMResultSet RS, #tmpDMResultSet tt
		WHERE RS.ResultSetID = tt.ResultSetID AND tt.isExistsInDMResultSet = 1
		--
		--check for error
		SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		if @rowCount > 0
		BEGIN
			SELECT @o_OutputMessage += 'Updated [' + convert(varchar, @rowCount) + '] item(s) in DMResultSet. '
			SET @AtLeastOneInfo = 1
		END
		IF @errorCode <> 0 GOTO CX_EXIT
		--
		-- we are interested in the items for which we have overwritten a modified value of aFileId and aFileOffset
		-- so delete rest of them from the collected rows with SyncStatus = 5
		--
		DELETE FROM #IndexGuidDuplicateItemsMap where idxAFileId = aFileID and idxAFileOffset = aFileOffset AND SyncStatus = 5
		--
		-- Also there may be lot of duplicates in the source data which we don't want to insert them into main table DMItemsToSyncWithIndexing
		-- so delete such rows..
		--
		;WITH CTE AS (
			SELECT ROW_NUMBER() OVER (PARTITION BY aFileID, aFileOffset, CommCellNumber ORDER BY aFileID, aFileOffset, CommCellNumber) BT
			FROM #IndexGuidDuplicateItemsMap
		)
		DELETE FROM CTE WHERE BT > 1
		--
		SELECT @errorCode =	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--
		-- When duplicates exist in system w.r.t IndexGUID (i.e., turboguid/versionguid) with different afileid, afileoffset, we end up
		-- updating newest incoming value into DMResultSet. These overwrites become an issue when restore of an item complete and we are trying to update
		-- restore status and the afileid,afileoffset combination does not match. To prevent this we save such entries in DMItemsToSyncWithIndexing table with SyncStatus 4
		-- and use them to map an item to it's corresponding ResultSetId easily
		--
		BEGIN TRY
			BEGIN TRAN
			--Add lock so that we dont insert duplicate entries in DMItemsToSyncWithIndexing table (when parallel threads execution happen)
			EXEC @result = sp_getapplock @Resource = 'DMItemsToSyncWithIndexingInsert', @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @result < 0
			BEGIN
                SET @errMsg = CASE @result
										when -1 then 'Explicit Raise Error: Applock request timed out.'
										when -2 then 'Applock request canceled.'
										when -3 then 'Explicit Raise Error: Applock involved in deadlock'
										else 'Parameter validation or other call error.'
									end
                RAISERROR (@errMsg,16,1)
				set @errorCode = 1001 -- validation error
				GOTO CX_EXIT
			END
			--Ideally there may be no row with invalid ResultSetID, but just in case if found delete them
			--so that we don't insert such data into table DMItemsToSyncWithIndexing
			DELETE T
			FROM #IndexGuidDuplicateItemsMap T
			LEFT JOIN DMResultSet R ON T.ResultSetId = R.ResultSetId
			WHERE R.ResultSetID IS NULL
			--Now it is time we persist data into DMItemsToSyncWithIndexing
			IF EXISTS (SELECT TOP 1 * FROM #IndexGuidDuplicateItemsMap)
			BEGIN
			INSERT INTO DMItemsToSyncWithIndexing (aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, IndexSyncTime, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber, documentId, ResultSetID)
				SELECT A.aFileID, A.aFileOffset, A.CommCellNumber, A.OriginalFullPath, A.IndexGUID, @currentdate, 4 SyncStatus, A.idxAFileId, A.idxAFileOffset, A.idxCommCellNumber, A.documentId, A.ResultSetID
				FROM #IndexGuidDuplicateItemsMap
				A LEFT JOIN DMItemsToSyncWithIndexing T ON T.aFileID = A.aFileID AND T.aFileOffset = A.aFileOffset AND T.CommCellNumber = A.CommCellNumber AND T.SyncStatus = 4
				WHERE T.itemId IS NULL
			END
			COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			if @@TRANCOUNT > 0
				ROLLBACK TRANSACTION
			SELECT @errMsg = ERROR_MESSAGE(),@errorCode = ERROR_NUMBER()
			RAISERROR(@errMsg, 15, 50)
		END CATCH
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the deleted flag if the entry already exists
		UPDATE DMContainerItemStates
		SET Attribute = tt.Attribute & ~4
		FROM #tmpDMResultSet as tt, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
		WHERE CIS.ContainerId = @i_ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = @i_UserGUID
		AND		CIS.Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		IF @i_isCompliancePolicy = 1
		BEGIN
			-- Update the Compliance Policy attribute if the entry already exists
			UPDATE DMContainerItem WITH (PAGLOCK)
			SET Attribute = tt.Attribute | 32
			FROM #tmpDMResultSet as tt, DMContainerItem as CI
			WHERE CI.ContainerId = @i_ContainerId
			AND 	CI.ResultSetId = tt.ResultSetId
			AND		CI.Attribute & 32 = 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Update the Compliance Policy attribute if the entry already exists
			UPDATE DMContainerItemStates
			SET Attribute = tt.Attribute | 32
			FROM #tmpDMResultSet as tt, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
			WHERE CIS.ContainerId = @i_ContainerId
			AND 	CIS.ResultSetId = tt.ResultSetId
			AND		CIS.AssignedUserGUID = @i_UserGUID
			AND		CIS.Attribute & 32 = 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
		DECLARE @MergeOutput1 table
		(
			ActionType nvarchar(10)
		);
		--
		;MERGE DMContainerItem AS TARGET
		USING (SELECT distinct tt.ResultSetId FROM #tmpDMResultSet  AS tt) AS SOURCE (ResultSetId)
		ON (target.ResultSetId = source.ResultSetId AND TARGET.ContainerId = @i_ContainerId)
		WHEN NOT MATCHED BY TARGET THEN
			INSERT (ContainerID,QueryID,ResultSetID,CreateTime,Attribute,UserGUID)
			VALUES (@i_ContainerId, @i_QueryID, source.ResultsetId, getUtcDate(), CASE WHEN @i_isCompliancePolicy = 1 THEN 32 ELSE 0 END, @i_UserGUID)
		WHEN MATCHED THEN
			UPDATE SET
					TARGET.Attribute = TARGET.Attribute & ~4,
					TARGET.CreateTime = getutcDate()
		OUTPUT   $action   INTO @MergeOutput1;
		SELECT	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SELECT @o_RowsInserted = COUNT(*) FROM @MergeOutput1 WHERE ActionType = 'INSERT'
		SELECT @rowCount = @o_RowsInserted + COUNT(*) FROM @MergeOutput1 WHERE ActionType = 'UPDATE'
		SELECT @o_OutputMessage += 'Saved [' + convert(varchar, @rowCount) + '] item(s) in DMContainerItem. '
		--Counts not matching, raise log level to error
		IF (@rowCount <> @uniqueInputRowCount) OR (@rowCount <> @inputRowCount)
		BEGIN
			-- Error only for logging purposes. not a real error in the system.
			SET @AtLeastOneError = 1
		END
		ELSE
		BEGIN
			SET @AtLeastOneInfo = 1
		END
		--
		INSERT INTO #tmpDMUserItemTags
		SELECT DISTINCT TT.ResultSetId, @i_UserGUID, TAG.ID
		FROM #tmpDMResultSet TT CROSS APPLY dbo.splitStringToTable(TT.tagGUIDList) TAG
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
 		CREATE INDEX IDX_tmpDMUserItemTags_CIT ON #tmpDMUserItemTags(TagGUID, ResultSetID, UserGUID)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the deleted flag if the entry already exists
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute & ~4
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMUserItemTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the SYNC TO FAST flag if the entry already exists
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute | 2
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMUserItemTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 2 = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Create the new entries
		INSERT INTO DMUserItemTags
		SELECT  tt.UserGUID, tt.ResultSetId, tt.TagGUID, getDate(), 2 -- Synced with FAST
		FROM 	#tmpDMUserItemTags as tt
		WHERE NOT EXISTS (SELECT TOP 1 * FROM DMUserItemTags AS UIT WITH (READUNCOMMITTED)
											WHERE UIT.ResultSetId = tt.ResultSetId
											AND		UIT.UserGUID = tt.UserGUID
											AND		UIT.TagID = tt.TagGUID)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Remove all Container specific rows once it is SYNCed in FAST
		DELETE DMContainerItemTags
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMUserItemTags as tt
		WHERE CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	CX_EXIT:
		IF @errorCode != 0
		BEGIN
			  SET @o_RowsInserted = 0
			  SELECT null ResultSetID, '' ResultSet
			  SET @o_MessageLogLevel = @LOG_ERROR
		END
		ELSE
		BEGIN
				SELECT R.ResultSetID, R.ResultSet FROM #tmpDMResultSet R
				IF @AtLeastOneError = 1
				BEGIN
					SET @o_MessageLogLevel = @LOG_ERROR
				END
				ELSE IF @AtLeastOneInfo = 1
				BEGIN
					SET @o_MessageLogLevel = @LOG_INFO
				END
				ELSE IF @AtLeastOneTracing = 1
				BEGIN
					SET @o_MessageLogLevel = @LOG_TRACING
				END
				ELSE
				BEGIN
					SET @o_MessageLogLevel = @LOG_DETAILS
				END
		END
		--
		-- Earlier these were output parameters, with new framework changes, output param support not yet exist, hence return them as another data table.
		-- It is possible to implement output param support in future but till then this is work around
		--
		UPDATE @TblOutParams SET RowsInserted = @o_RowsInserted, MessageLogLevel = @o_MessageLogLevel, OutputMessage = @o_OutputMessage
		--
		SELECT * FROM @TblOutParams
		--
		IF OBJECT_ID('tempdb.dbo.#tmpBulkResultSet') IS NOT NULL
		DROP TABLE #tmpBulkResultSet
		IF OBJECT_ID('tempdb.dbo.#tmpDMResultSet') IS NOT NULL
		DROP TABLE #tmpDMResultSet
		IF OBJECT_ID('tempdb.dbo.#tmpDistinctRS') IS NOT NULL
		DROP TABLE #tmpDistinctRS
		IF OBJECT_ID('tempdb.dbo.#tmpDMUserItemTags') IS NOT NULL
		DROP TABLE #tmpDMUserItemTags
		IF OBJECT_ID('tempdb.dbo.#tmpDMEmailFields') IS NOT NULL
		DROP TABLE #tmpDMEmailFields
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSetBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddResultSetBulk',  '00010048001200250000', 'sp_dm2_AddResultSetBulk', '00010048001200250000')
GO

